/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core;

import com.genuitec.eclipse.core.ViperCore;
import com.genuitec.eclipse.core.portability.wizard.ComboDialogField;
import com.genuitec.eclipse.core.portability.wizard.DialogField;
import com.genuitec.eclipse.core.portability.wizard.IDialogFieldListener;
import com.genuitec.eclipse.core.portability.wizard.LayoutUtil;
import com.genuitec.eclipse.core.portability.wizard.SimpleStringDialogField;
import com.genuitec.eclipse.core.portability.wizard.StatusInfo;
import com.genuitec.eclipse.core.ui.action.UpdateLicenseActionDelegate;
import com.genuitec.eclipse.core.util.PlatformUIUtil;
import com.genuitec.eclipse.core.util.PlatformUtil;
import com.genuitec.secure.delivery.accelerator.ui.widgets.DAPackageButton;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public abstract class GenuitecCoreLicenseDialog
extends Dialog
implements IDialogFieldListener {
    public static final int CONT_IDX = 16;
    public static final int QUIT_IDX = 18;
    public static final int BACK_IDX = 20;
    public static final int LATER_IDX = 22;
    protected static int PROCEED_CODE = 2;
    public static final int WIDTH = 650;
    public static final int HEIGHT = 600;
    public static final int VERTICAL_SPACING = 20;
    public static final int HORIZONTAL_INDENT = 10;
    public static final int MARGIN = 20;
    private static final int A = 500;
    public static Font linkFont;
    private static final String B = "com.genuitec.eclipse.core.dialogColor";
    protected LicenseDialogMode mode;
    protected DAPackageButton primaryButton;
    protected String shellTitle;
    protected String title;
    protected int titleWidth;
    protected LocalResourceManager resourceManager;

    public GenuitecCoreLicenseDialog(Shell shell) {
        super(shell);
    }

    public GenuitecCoreLicenseDialog(Shell shell, LicenseDialogMode licenseDialogMode) {
        super(shell);
        this.mode = licenseDialogMode;
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)composite2);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 1;
        gridLayout.marginWidth = 1;
        gridLayout.verticalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(768));
        composite2.setBackgroundMode(2);
        this.setDialogStyle((Control)composite2);
        GenuitecCoreLicenseDialog.applyDialogFont((Control)composite2);
        this.initializeDialogUnits((Control)composite2);
        this.dialogArea = this.createDialogArea(composite2);
        this.createLinkBar(composite2);
        return composite2;
    }

    protected Control createDialogArea(Composite composite) {
        boolean bl = !PlatformUtil.isWebclipse();
        this.setShellTitleMessage();
        Composite composite2 = this.createGridLayoutComposite(composite, 1);
        GridData gridData = new GridData(768);
        GridLayout gridLayout = (GridLayout)composite2.getLayout();
        gridLayout.marginHeight = 20;
        gridLayout.marginWidth = 20;
        gridLayout.verticalSpacing = 20;
        composite2.setLayoutData((Object)gridData);
        Composite composite3 = this.createGridLayoutComposite(composite2, 3);
        gridData = new GridData(768);
        composite3.setLayoutData((Object)gridData);
        LayoutUtil.setHorizontalGrabbing((Control)composite3);
        Label label = new Label(composite3, 0);
        Image image = ViperCore.getDefault().getImage(bl ? "icons/myeclipse-48.png" : "icons/webclipse-48.png");
        label.setImage(image);
        gridData = new GridData();
        gridData.heightHint = image.getImageData().height;
        gridData.widthHint = image.getImageData().width;
        label.setLayoutData((Object)gridData);
        Label label2 = new Label(composite3, 0);
        label2.setText(this.title);
        this.setBannerLabelStyle((Control)label2);
        gridData = new GridData(768);
        gridData.horizontalIndent = 10;
        label2.setLayoutData((Object)gridData);
        label = new Label(composite3, 0);
        String string = null;
        string = bl ? "icons/myeclipse-text.png" : (this.mode == LicenseDialogMode.DAYS_LIMIT_EXCEEDED || this.mode == LicenseDialogMode.DELAYED_ACTION || this.mode == LicenseDialogMode.PRO_CODER_ACHIEVED ? "icons/pro-badge.png" : "icons/webclipse-text.png");
        image = ViperCore.getDefault().getImage(string);
        label.setImage(image);
        gridData = new GridData();
        gridData.heightHint = image.getImageData().height;
        gridData.widthHint = image.getImageData().width;
        label.setLayoutData((Object)gridData);
        this.setLabelStyle((Control)label);
        this.titleWidth = Math.max(composite2.computeSize((int)-1, (int)-1).x, 500);
        this.createDetailsArea(composite2);
        return composite2;
    }

    protected SimpleStringDialogField createStringDF(String string, Composite composite, int n) {
        SimpleStringDialogField simpleStringDialogField = new SimpleStringDialogField();
        simpleStringDialogField.setLabelText(string);
        simpleStringDialogField.doFillIntoGrid(composite, 2);
        simpleStringDialogField.setDialogFieldListener((IDialogFieldListener)this);
        this.setLabelStyleBold((Control)simpleStringDialogField.getLabelControl(composite));
        this.setLabelStyleBlack((Control)simpleStringDialogField.getTextControl(composite));
        GridData gridData = new GridData(768);
        if (n != -1) {
            gridData.horizontalIndent = n;
        }
        simpleStringDialogField.getTextControl(composite).setLayoutData((Object)gridData);
        return simpleStringDialogField;
    }

    protected SimpleStringDialogField createEmailDF(Composite composite, int n) {
        return this.createStringDF("Your email:", composite, n);
    }

    protected void createLinkBar(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(5, false);
        gridLayout.horizontalSpacing = 10;
        gridLayout.marginWidth = 20;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(256);
        composite2.setLayoutData((Object)gridData);
        this.setLinkBarStyle((Control)composite2);
        this.createLinks(composite2);
        this.createPrimaryButton(composite2);
    }

    protected Composite createGridLayoutComposite(Composite composite, int n) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(n, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        return composite2;
    }

    protected void addVerticalSpacing(Control control) {
        GridData gridData = (GridData)control.getLayoutData();
        if (gridData == null) {
            gridData = new GridData();
            control.setLayoutData((Object)gridData);
        }
        gridData.verticalIndent = 20;
    }

    protected Hyperlink createHyperlink(Composite composite, String string) {
        return this.createHyperlink(composite, string, null);
    }

    protected Hyperlink createHyperlink(Composite composite, String string, Object object) {
        Hyperlink hyperlink = new Hyperlink(composite, 0);
        hyperlink.setText(string);
        hyperlink.setUnderlined(true);
        hyperlink.setFont(this.getLinkFont());
        if (object instanceof String) {
            hyperlink.addHyperlinkListener((IHyperlinkListener)new _A((String)object));
        } else if (object instanceof Integer) {
            hyperlink.addHyperlinkListener((IHyperlinkListener)new _A((Integer)object));
        }
        this.setLinkStyle((Control)hyperlink);
        return hyperlink;
    }

    protected Label createWrappedLabel(Composite composite) {
        Label label = new Label(composite, 64);
        this.setLabelStyle((Control)label);
        GridData gridData = new GridData();
        gridData.widthHint = this.titleWidth;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        return label;
    }

    protected ComboDialogField createCombo(Composite composite, String string, String[] stringArray) {
        ComboDialogField comboDialogField = new ComboDialogField(0);
        comboDialogField.setLabelText(string);
        comboDialogField.setItems(stringArray);
        comboDialogField.doFillIntoGrid(composite, 2);
        comboDialogField.selectItem(0);
        this.setLabelStyleBold((Control)comboDialogField.getLabelControl(composite));
        this.setLabelStyleBlack((Control)comboDialogField.getComboControl(composite));
        return comboDialogField;
    }

    protected void createContinueLink(Composite composite) {
        this.createContinueLink(composite, "Continue");
    }

    protected void createContinueLink(Composite composite, String string) {
        Hyperlink hyperlink = this.createHyperlink(composite, string);
        hyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                GenuitecCoreLicenseDialog.this.close();
            }
        });
        GridData gridData = new GridData(32);
        hyperlink.setLayoutData((Object)gridData);
    }

    protected void createSpacer(Composite composite) {
        Label label = new Label(composite, 0);
        GridData gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
        this.setLinkBarStyle((Control)label);
    }

    protected void createUpdateLicenseLink(Composite composite) {
        Hyperlink hyperlink = this.createHyperlink(composite, "Enter License");
        hyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                UpdateLicenseActionDelegate.openLicenseDialog(GenuitecCoreLicenseDialog.this.getParentShell());
                if (GenuitecCoreLicenseDialog.this.isLicenseOK()) {
                    GenuitecCoreLicenseDialog.this.setReturnCode(PROCEED_CODE);
                    GenuitecCoreLicenseDialog.this.close();
                }
            }
        });
    }

    public static String getPreferenceLinkPrefix() {
        String string = "";
        if (PlatformUtil.isWebclipse()) {
            string = "webclipse.";
        }
        return string;
    }

    public static String getLearnMoreURL() {
        return ViperCore.getDefault().getResourceString(String.valueOf(GenuitecCoreLicenseDialog.getPreferenceLinkPrefix()) + "web.link.learnmore");
    }

    public static String getHowToActivateURL() {
        return ViperCore.getDefault().getResourceString(String.valueOf(GenuitecCoreLicenseDialog.getPreferenceLinkPrefix()) + "web.link.howtoactivate");
    }

    public static String getFindCodeURL() {
        return ViperCore.getDefault().getResourceString(String.valueOf(GenuitecCoreLicenseDialog.getPreferenceLinkPrefix()) + "web.link.access.code.faq");
    }

    public static String getBuyURL() {
        return ViperCore.getDefault().getResourceString(String.valueOf(GenuitecCoreLicenseDialog.getPreferenceLinkPrefix()) + "web.link.purchase");
    }

    public static String getRenewURL() {
        return ViperCore.getDefault().getResourceString(String.valueOf(GenuitecCoreLicenseDialog.getPreferenceLinkPrefix()) + "web.link.renew");
    }

    public static String getManualActivationURL() {
        return ViperCore.getDefault().getResourceString(String.valueOf(GenuitecCoreLicenseDialog.getPreferenceLinkPrefix()) + "web.link.manual.activation");
    }

    public static String getAutoActivationURL() {
        return ViperCore.getDefault().getResourceString(String.valueOf(GenuitecCoreLicenseDialog.getPreferenceLinkPrefix()) + "web.link.auto.activation");
    }

    public static String getRegistrationURL() {
        return ViperCore.getDefault().getResourceString(String.valueOf(GenuitecCoreLicenseDialog.getPreferenceLinkPrefix()) + "web.link.registration");
    }

    public static String getThanksURL() {
        return ViperCore.getDefault().getResourceString(String.valueOf(GenuitecCoreLicenseDialog.getPreferenceLinkPrefix()) + "web.link.thanks");
    }

    public static String getFeedbackURL() {
        return ViperCore.getDefault().getResourceString(String.valueOf(GenuitecCoreLicenseDialog.getPreferenceLinkPrefix()) + "web.link.feedback");
    }

    protected void createPrimaryButton(Composite composite) {
        Object[] objectArray = this.getPrimaryButtonDetails();
        this.primaryButton = new DAPackageButton(composite, this.getLinkFont(), (String)objectArray[0]);
        if (objectArray[1] instanceof Integer) {
            this.primaryButton.addSelectionListener((SelectionListener)new _A((Integer)objectArray[1]));
        } else {
            this.primaryButton.addSelectionListener((SelectionListener)new _A((String)objectArray[1]));
        }
    }

    protected Font getLinkFont() {
        if (linkFont == null) {
            FontData[] fontDataArray = JFaceResources.getDefaultFont().getFontData();
            fontDataArray[0].setHeight(14);
            linkFont = new Font((Device)Display.getCurrent(), fontDataArray);
        }
        return linkFont;
    }

    protected String getProductMessage(String string, boolean bl) {
        return MessageFormat.format(string, bl ? "MyEclipse" : "Webclipse");
    }

    protected String getProductMessage(String string, boolean bl, String string2, String string3) {
        return MessageFormat.format(string, bl ? string2 : string3);
    }

    protected String getFinalURL(String string) {
        return string;
    }

    protected boolean isLicenseOK() {
        return true;
    }

    public void dialogFieldChanged(DialogField dialogField) {
        this.primaryButton.setEnabled(this.validate(dialogField));
    }

    protected boolean validate(DialogField dialogField) {
        return true;
    }

    protected void setLabelStyle(Control control) {
        this.setTextStyle(0, 1, 12, control);
    }

    protected void setLabelStyleItalic(Control control) {
        this.setTextStyle(2, 1, 12, control);
    }

    protected void setLabelStyleBold(Control control) {
        this.setTextStyle(1, 1, 12, control);
    }

    protected void setLabelStyleError(Control control) {
        this.setTextStyle(0, 3, 12, control);
    }

    protected void setLabelStyleWarning(Control control) {
        this.setTextStyle(0, 7, 12, control);
    }

    protected void setLabelStyleOK(Control control) {
        this.setTextStyle(0, 5, 12, control);
    }

    protected void setLabelStyleBlack(Control control) {
        this.setTextStyle(0, 2, 1, 12, control);
    }

    protected void setBannerLabelStyle(Control control) {
        this.setTextStyle(1, 1, 16, control);
    }

    protected void setDialogStyle(Control control) {
        ColorRegistry colorRegistry = JFaceResources.getColorRegistry();
        if (colorRegistry.get(B) == null) {
            colorRegistry.put(B, PlatformUtil.isWebclipse() ? new RGB(20, 18, 51) : new RGB(9, 42, 71));
        }
        control.setBackground(JFaceResources.getColorRegistry().get(B));
    }

    protected void setLinkStyle(Control control) {
        Display display = control.getDisplay();
        JFaceColors.setColors((Control)control, (Color)display.getSystemColor(2), (Color)display.getSystemColor(1));
    }

    protected void setLinkBarStyle(Control control) {
        control.setBackground(control.getDisplay().getSystemColor(1));
    }

    protected void setTextStyle(int n, int n2, int n3, Control control) {
        this.setTextStyle(n, n2, -1, n3, control);
    }

    protected void setTextStyle(int n, int n2, int n3, int n4, Control control) {
        Display display = control.getDisplay();
        control.setForeground(display.getSystemColor(n2));
        if (n3 != -1) {
            control.setBackground(display.getSystemColor(n3));
        }
        Font font = this.resourceManager.createFont(FontDescriptor.createFrom((Font)control.getFont()).setStyle(n).setHeight(n4));
        control.setFont(font);
    }

    protected abstract void createLinks(Composite var1);

    protected abstract Object[] getPrimaryButtonDetails();

    protected abstract void setShellTitleMessage();

    protected abstract void createDetailsArea(Composite var1);

    protected void delayComplete() {
        PlatformUIUtil.postOnDisplayQueue((Runnable)new Runnable(){

            @Override
            public void run() {
                GenuitecCoreLicenseDialog.this.close();
            }
        });
    }

    public class DelayJob
    extends Job {
        protected int B;

        public DelayJob(int n) {
            super("Registration");
            this.setSystem(true);
            this.B = n;
        }

        protected IStatus run(IProgressMonitor iProgressMonitor) {
            try {
                Thread.sleep(this.B * 1000);
            }
            catch (InterruptedException interruptedException) {}
            if (!iProgressMonitor.isCanceled()) {
                GenuitecCoreLicenseDialog.this.delayComplete();
            }
            return StatusInfo.OK_STATUS;
        }
    }

    class _A
    extends SelectionAdapter
    implements IHyperlinkListener {
        private String B;
        private int C;

        public _A(String string) {
            this.B = string;
        }

        public _A(int n) {
            this.C = n;
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (this.B != null) {
                PlatformUIUtil.openLink((String)GenuitecCoreLicenseDialog.this.getFinalURL(this.B));
            } else {
                GenuitecCoreLicenseDialog.this.buttonPressed(this.C);
            }
        }

        public void linkActivated(HyperlinkEvent hyperlinkEvent) {
            this.widgetSelected(null);
        }

        public void linkEntered(HyperlinkEvent hyperlinkEvent) {
        }

        public void linkExited(HyperlinkEvent hyperlinkEvent) {
        }
    }

    public static enum LicenseDialogMode {
        UPGRADE_TRIAL_EXPIRED,
        UPGRADE_TRIAL_AVAILABLE,
        UPGRADE_TRIAL_NA,
        UPGRADE_TRIAL_REGISTRATION,
        LICENSE_EXPIRED,
        LICENSE_EXPIRING,
        TOO_MANY_IPS,
        INVALID_PRODUCT,
        NEW_TRIAL,
        NEW_TRIAL_REGISTRATION,
        NEW_TRIAL_REGISTRATION_MANDATORY,
        NEW_TRIAL_PREPARE,
        DAYS_LIMIT_EXCEEDED,
        PRO_CODER_ACHIEVED,
        DELAYED_ACTION;

    }
}

