/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core;

import com.genuitec.eclipse.core.E;
import com.genuitec.eclipse.core.GenuitecCoreLicenseDialog;
import com.genuitec.eclipse.core.GenuitecProductExpirationDialog2;
import com.genuitec.eclipse.core.URLMessageDialog;
import com.genuitec.eclipse.core.ViperCore;
import com.genuitec.eclipse.core.gsdc.GSDCController;
import com.genuitec.eclipse.core.ui.action.UpdateLicenseActionDelegate;
import com.genuitec.eclipse.core.util.PlatformUIUtil;
import java.text.MessageFormat;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class GenuitecPointsDialog
extends GenuitecProductExpirationDialog2 {
    public static final int BUYNOW_IDX = 10;
    private boolean g = GSDCController.getInstance().isActive();

    public GenuitecPointsDialog(Shell shell, GenuitecCoreLicenseDialog.LicenseDialogMode licenseDialogMode) {
        super(shell, licenseDialogMode);
    }

    @Override
    protected void createLinks(Composite composite) {
        int n = 0;
        if (!this.g) {
            if (this.mode == GenuitecCoreLicenseDialog.LicenseDialogMode.DAYS_LIMIT_EXCEEDED) {
                this.B(composite);
                ++n;
            }
            this.createSpacer(composite);
            ++n;
            this.createUpdateLicenseLink(composite);
            ++n;
            this.createHyperlink(composite, "Learn More", GenuitecPointsDialog.getLearnMoreURL());
            ++n;
        }
        GridLayout gridLayout = (GridLayout)composite.getLayout();
        gridLayout.numColumns = n + 1;
    }

    @Override
    protected Object[] getPrimaryButtonDetails() {
        if (!this.g) {
            if (this.mode == GenuitecCoreLicenseDialog.LicenseDialogMode.PRO_CODER_ACHIEVED) {
                return new Object[]{"Continue", 16};
            }
            return new Object[]{"Upgrade", 10};
        }
        return new Object[]{"Continue", 16};
    }

    @Override
    protected void setShellTitleMessage() {
        switch (this.mode) {
            case DAYS_LIMIT_EXCEEDED: {
                this.title = "Time to upgrade to Webclipse Pro!";
                this.Y = MessageFormat.format("You have used Webclipse Pro features for free for 8 days already this month. Why not upgrade now to a premium plan for as little as $29/year?", 8);
                this.X = "Not only does a Premium plan give you unlimited access all month, you get other benefits like exclusive forums, and a Slack channel to communicate to developers of Webclipse!";
                break;
            }
            case PRO_CODER_ACHIEVED: {
                this.title = "Pro Coder Achievement!";
                this.Y = MessageFormat.format("Congratulations!!! You have officially earned your lifetime Pro Coder badge by earning {0} lifetime pro points!  Keep up the good work!", 1000);
                this.X = MessageFormat.format("As part of your free usage of Webclipse, each month you can use for free, {0} days of professional features. If you need more than {1} days per month, or you want extra benefits like additional support options, jump to a paid license now! This month you have used {2} days of Pro features.", 8, 8, E.S().W());
                this.W = "Thanks for continuing to use Webclipse, we appreciate your loyalty!";
                break;
            }
        }
    }

    @Override
    protected void createDetailsArea(Composite composite) {
        Label label = this.createWrappedLabel(composite);
        label.setText(this.Y);
        Label label2 = this.createWrappedLabel(composite);
        label2.setText(this.X);
        if (this.W != null) {
            Label label3 = this.createWrappedLabel(composite);
            label3.setText(this.W);
        }
    }

    @Override
    protected void buttonPressed(int n) {
        this.setReturnCode(n);
        switch (n) {
            case 10: {
                if (PlatformUIUtil.openLink((String)GenuitecPointsDialog.getProductPurchaseLink())) break;
                new URLMessageDialog(this.getParentShell(), ViperCore.getDefault().getResourceString("LicenseValidator_dialog_buynowlink_title"), ViperCore.getDefault().getResourceString("LicenseValidator_dialog_subscriptionlink_message"), 4, GenuitecPointsDialog.getProductPurchaseLink()).open();
                break;
            }
            case 16: {
                this.close();
                break;
            }
            default: {
                this.close();
            }
        }
    }

    @Override
    protected void createUpdateLicenseLink(Composite composite) {
        Hyperlink hyperlink = this.createHyperlink(composite, "Enter License");
        hyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                GenuitecPointsDialog.this.close();
                UpdateLicenseActionDelegate.openLicenseDialog(GenuitecPointsDialog.this.getParentShell());
            }
        });
    }

    protected void B(Composite composite) {
        Hyperlink hyperlink = this.createHyperlink(composite, "Not Now", 16);
        GridData gridData = new GridData(32);
        hyperlink.setLayoutData((Object)gridData);
    }
}

