/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core.ui.wizard;

import com.genuitec.eclipse.core.ActivationValidator;
import com.genuitec.eclipse.core.GenuitecCoreLicenseDialog;
import com.genuitec.eclipse.core.LicenseUtil;
import com.genuitec.eclipse.core.ViperCore;
import com.genuitec.eclipse.core.activation.ProductActivator;
import com.genuitec.eclipse.core.activation.ProductRegistrar;
import com.genuitec.eclipse.core.gsdc.GSDCController;
import com.genuitec.eclipse.core.portability.wizard.DialogField;
import com.genuitec.eclipse.core.portability.wizard.IDialogFieldListener;
import com.genuitec.eclipse.core.portability.wizard.SimpleStringDialogField;
import com.genuitec.eclipse.core.ui.util.MultilineTextDialogField;
import com.genuitec.eclipse.core.ui.wizard.dialogfield.MESelectionButtonDialogFieldGroup;
import com.genuitec.eclipse.core.util.PlatformUIUtil;
import com.genuitec.eclipse.core.util.PlatformUtil;
import java.awt.Desktop;
import java.net.URI;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class ActivationDialog
extends GenuitecCoreLicenseDialog {
    private static final int \u00c3 = 24;
    private static final int \u00b5 = 26;
    private static final int \u00ca = 28;
    private static final int \u00c9 = 30;
    private static final int \u00c4 = 32;
    private static final int \u00d0 = 34;
    private static final int \u00ce = 36;
    private static final int \u00c8 = 38;
    private MESelectionButtonDialogFieldGroup \u00cc;
    private ActivationDialogMode \u00a5;
    private String \u00c1;
    private String \u00c0;
    private String \u00ba;
    private Label \u00c6;
    private MultilineTextDialogField \u00cd;
    private String \u00cf;
    private GenuitecCoreLicenseDialog.DelayJob \u00c5;
    private SimpleStringDialogField \u00c7;
    private ActivationDialog \u00d1;
    private int \u00aa;
    private int \u00d2;
    private boolean \u00c2;

    public ActivationDialog(Shell shell, ActivationDialogMode activationDialogMode) {
        super(shell);
        this.\u00a5 = activationDialogMode;
        this.setShellStyle(this.getShellStyle() | 8);
        this.\u00d2 = LicenseUtil.getActivationGracePeriodDaysLeft();
        this.\u00c2 = GSDCController.getInstance().isActive();
    }

    @Override
    protected void setShellTitleMessage() {
        boolean bl = !PlatformUtil.isWebclipse();
        switch (this.\u00a5) {
            case ACTIVATION_OPTIONS: {
                this.title = "Activate your license";
                this.\u00c1 = "Activation of your license is required within 5 days of enabling your license key. How would you like to activate your license?";
                break;
            }
            case ACTIVATION_REGISTRATION: {
                this.title = "Finalize license activation";
                this.\u00c1 = "Before we complete your activation, provide your Email address to complete your license registration at the same time.";
                this.\u00c0 = "Registering gives you access to discounts and important information. We will never share your details. You can unsubscribe at any time.";
                break;
            }
            case WEB_ACTIVATION: {
                this.title = "Retrieve your activation code";
                this.\u00c1 = !this.\u00c2 ? "To retrieve your activation code from a browser, click Open in Browser below or copy the URL below and paste manually into a browser." : "To manually activate this secure version of MyEclipse, you must access the following URL from a machine that has connectivity to the SDC server, with the following details:";
                this.\u00c0 = this.X();
                this.\u00ba = "After you have retrieved your activation code from your browser, click Enter Code to complete manual activation.";
                break;
            }
            case MANUAL_ACTIVATION: {
                this.title = "Enter your activation code";
                break;
            }
            case ACTIVATION_SUCCESS: {
                this.title = "Activation successful!";
                this.\u00c1 = this.getProductMessage("Congratulations, your license has been fully activated. You can now continue to take advantage of the many features that {0} provides.", bl);
                this.\u00c0 = "Looking for some inspiration on what to do next?";
                this.\u00ba = this.getProductMessage("Check out {0} where you can find tutorials and videos, and get involved in our community forums.", bl, "myeclipseide.com", "genuitec.com/products/webclipse");
                break;
            }
            case ACTIVATION_FAILED: {
                this.title = "Activation has failed";
                this.\u00c1 = "Oh no! Activation could not be completed at this time.";
                this.\u00c0 = "Do you have network issues perhaps disrupting activation of your license? If you need a proxy, click below to set up your network.";
                if (this.\u00d2 >= 0) {
                    String string = String.valueOf(this.\u00d2) + (this.\u00d2 == 1 ? " day" : " days");
                    this.\u00ba = MessageFormat.format("If you are unable to establish network connectivity, you have {0} remaining to complete activation, after which {1} will be unusable until completed.", string, bl ? "MyEclipse" : "Webclipse");
                    break;
                }
                this.\u00ba = this.getProductMessage("If you are unable to establish network connectivity at this time, you will no longer be able to use {0} as your 5 day activation window has elapsed", bl);
                break;
            }
            case ACTIVATION_FAILED_COUNTERFEIT: {
                this.title = "Activation has failed";
                this.\u00c1 = "Oh no! Activation could not be completed at this time.";
                this.\u00c0 = "The license details you have entered are either invalid or the key has been invalidated. Verify your license details and retry.";
                this.\u00ba = "If you are having issues entering valid license details, contact sales with information on your license, purchasing email, and any other details you believe relevant.";
                break;
            }
            case ACTIVATION_FAILED_TOOMANY: {
                this.title = "Activation not available";
                this.\u00c1 = "The activations for this license have reached the limit for excess usage.";
                this.\u00c0 = "If you need additional activations under this license, contact sales below. Alternatively, you can purchase additional licenses.";
                this.\u00ba = this.getProductMessage("We appreciate your support of Genuitec and are always available at {0} for any questions you may have.", bl, "myeclipseide.com", "genuitec.com/products/webclipse");
                break;
            }
            case ACTIVATION_IN_PROGRESS: {
                this.title = "Activating your license...";
                this.\u00c1 = bl ? "Thank you for being a valuable customer of MyEclipse! We're so proud that you and 16,000 other companies choose MyEclipse as their preferred IDE." : "Thank you for being a valuable Webclipse customer!";
                this.\u00c0 = "While waiting, have some feedback? Share it at http://feedback.genuitec.com";
            }
        }
    }

    @Override
    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        this.dialogFieldChanged(null);
        if (this.\u00a5 == ActivationDialogMode.ACTIVATION_IN_PROGRESS) {
            this.W();
        }
        return control;
    }

    @Override
    protected void createDetailsArea(Composite composite) {
        switch (this.\u00a5) {
            case ACTIVATION_OPTIONS: {
                this.D(composite);
                break;
            }
            case MANUAL_ACTIVATION: {
                this.J(composite);
                break;
            }
            case ACTIVATION_REGISTRATION: {
                this.I(composite);
                break;
            }
            case WEB_ACTIVATION: {
                this.H(composite);
                break;
            }
            case ACTIVATION_SUCCESS: 
            case ACTIVATION_FAILED: 
            case ACTIVATION_FAILED_COUNTERFEIT: 
            case ACTIVATION_FAILED_TOOMANY: {
                this.E(composite);
                break;
            }
            case ACTIVATION_IN_PROGRESS: {
                this.G(composite);
            }
        }
    }

    private void D(Composite composite) {
        String[] stringArray;
        Label label = this.createWrappedLabel(composite);
        label.setText(this.\u00c1);
        Composite composite2 = this.createGridLayoutComposite(composite, 3);
        GridData gridData = new GridData(768);
        composite2.setLayoutData((Object)gridData);
        GridLayout gridLayout = (GridLayout)composite2.getLayout();
        gridLayout.verticalSpacing = 20;
        Composite composite3 = this.createGridLayoutComposite(composite2, 2);
        Composite composite4 = this.createGridLayoutComposite(composite2, 1);
        if (this.\u00c2) {
            label = this.createWrappedLabel(composite4);
            label.setText("Automated activation using configured Secure Delivery Center server");
            if (GSDCController.getInstance().isManualActivationAllowed()) {
                label = this.createWrappedLabel(composite4);
                label.setText("Web activation (Information for your SDC server will be provided)");
                label = this.createWrappedLabel(composite4);
                label.setText("I already have an activation code - previously retrieved");
                stringArray = new String[]{"", "", ""};
            } else {
                stringArray = new String[]{""};
            }
        } else {
            label = this.createWrappedLabel(composite4);
            label.setText("Automated activation - requires an Internet connection");
            label = this.createWrappedLabel(composite4);
            label.setText("Web activation - retrieve an activation code from a web browser");
            label = this.createWrappedLabel(composite4);
            label.setText("I already have an activation code - previously retrieved");
            stringArray = new String[]{"", "", ""};
        }
        this.\u00cc = new MESelectionButtonDialogFieldGroup(16, stringArray, 1);
        this.\u00cc.setDialogFieldListener((IDialogFieldListener)this);
        this.\u00cc.doFillIntoGrid(composite3, 2);
        int n = 0;
        while (n < stringArray.length) {
            this.setLabelStyle((Control)this.\u00cc.getSelectionButton(n));
            ++n;
        }
    }

    private void E(Composite composite) {
        Label label = this.createWrappedLabel(composite);
        label.setText(this.\u00c1);
        Label label2 = this.createWrappedLabel(composite);
        label2.setText(this.\u00c0);
        Label label3 = this.createWrappedLabel(composite);
        label3.setText(this.\u00ba);
    }

    private void J(Composite composite) {
        Label label = this.createWrappedLabel(composite);
        label.setText("Enter the activation code you retrieved manually.");
        Composite composite2 = this.createGridLayoutComposite(composite, 2);
        GridData gridData = new GridData(768);
        composite2.setLayoutData((Object)gridData);
        GridLayout gridLayout = (GridLayout)composite2.getLayout();
        gridLayout.verticalSpacing = 20;
        this.\u00cd = new MultilineTextDialogField((IDialogFieldListener)this, 2370);
        this.\u00cd.setLabelText("Activation code:");
        this.\u00cd.doFillIntoGrid(composite2, 2);
        this.setLabelStyle((Control)this.\u00cd.getLabelControl(null));
        gridData = new GridData();
        gridData.verticalAlignment = 16;
        this.\u00cd.getLabelControl(null).setLayoutData((Object)gridData);
        this.A(this.\u00cd.getTextControl(null), 80, 6);
        label = this.createWrappedLabel(composite2);
        label.setText("Validation of code:");
        label.setLayoutData((Object)new GridData());
        this.\u00c6 = this.createWrappedLabel(composite2);
        gridData = new GridData(768);
        this.\u00c6.setLayoutData((Object)gridData);
    }

    private void I(Composite composite) {
        Label label = this.createWrappedLabel(composite);
        label.setText(this.\u00c1);
        Composite composite2 = this.createGridLayoutComposite(composite, 2);
        GridData gridData = new GridData(768);
        composite2.setLayoutData((Object)gridData);
        GridLayout gridLayout = (GridLayout)composite2.getLayout();
        gridLayout.verticalSpacing = 20;
        this.\u00c7 = this.createEmailDF(composite2, -1);
        String string = ProductRegistrar.getSavedEmail();
        if (string != null) {
            this.\u00c7.setTextWithoutUpdate(string);
        }
        Label label2 = this.createWrappedLabel(composite);
        label2.setText(this.\u00c0);
    }

    private void G(Composite composite) {
        Label label = this.createWrappedLabel(composite);
        label.setText(this.\u00c1);
        ProgressIndicator progressIndicator = new ProgressIndicator(composite, 0);
        progressIndicator.beginAnimatedTask();
        GridData gridData = new GridData(768);
        progressIndicator.setLayoutData((Object)gridData);
        Label label2 = this.createWrappedLabel(composite);
        label2.setText(this.\u00c0);
    }

    private void H(Composite composite) {
        Label label = this.createWrappedLabel(composite);
        label.setText(this.\u00c1);
        MultilineTextDialogField multilineTextDialogField = new MultilineTextDialogField((IDialogFieldListener)this, 2378);
        this.A(multilineTextDialogField.getTextControl(composite), 100, !this.\u00c2 ? 5 : 6);
        multilineTextDialogField.setTextWithoutUpdate(this.\u00c0);
        Label label2 = this.createWrappedLabel(composite);
        label2.setText(this.\u00ba);
    }

    private void A(Text text, int n, int n2) {
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 32;
        gridData.widthHint = this.convertWidthInCharsToPixels(n);
        gridData.heightHint = this.convertHeightInCharsToPixels(n2);
        text.setLayoutData((Object)gridData);
        text.setFont(JFaceResources.getFont((String)"org.eclipse.ui.workbench.texteditor.blockSelectionModeFont"));
        text.setBackground(Display.getCurrent().getSystemColor(1));
    }

    private String T() {
        if (!this.\u00c2) {
            return ProductActivator.createURL(GenuitecCoreLicenseDialog.getManualActivationURL(), LicenseUtil.getCurrentLicenseCode(), LicenseUtil.getSystemId(), 2);
        }
        return GSDCController.getInstance().getActivationServerManualURL();
    }

    @Override
    protected void createLinks(Composite composite) {
        int n = 0;
        if (this.\u00a5 == ActivationDialogMode.ACTIVATION_OPTIONS || this.\u00a5 == ActivationDialogMode.ACTIVATION_FAILED) {
            n = 3;
            this.F(composite);
            this.createSpacer(composite);
            if (!this.\u00c2) {
                this.createHyperlink(composite, "Get Help", ActivationDialog.getHowToActivateURL());
                ++n;
            }
            this.createHyperlink(composite, "Setup Network", 28);
        } else if (this.\u00a5 == ActivationDialogMode.ACTIVATION_REGISTRATION) {
            this.createHyperlink(composite, "Back", 20);
            this.createSpacer(composite);
            this.createHyperlink(composite, "Skip Email", 32);
            n = 3;
        } else if (this.\u00a5 == ActivationDialogMode.WEB_ACTIVATION) {
            this.createHyperlink(composite, "Restart", 34);
            this.createSpacer(composite);
            this.createHyperlink(composite, !this.\u00c2 ? "Copy URL" : "Copy", 38);
            this.createHyperlink(composite, "Open in Browser", this.T());
            n = 4;
        } else if (this.\u00a5 == ActivationDialogMode.MANUAL_ACTIVATION) {
            this.createHyperlink(composite, "Restart", 34);
            this.createSpacer(composite);
            this.createHyperlink(composite, "Retrieve Code", this.T());
            n = 3;
        } else if (this.\u00a5 == ActivationDialogMode.ACTIVATION_SUCCESS) {
            this.createSpacer(composite);
            this.createHyperlink(composite, "Open Browser", ActivationDialog.getLearnMoreURL());
            n = 2;
        } else if (this.\u00a5 == ActivationDialogMode.ACTIVATION_FAILED_TOOMANY || this.\u00a5 == ActivationDialogMode.ACTIVATION_FAILED_COUNTERFEIT) {
            this.F(composite);
            this.createSpacer(composite);
            this.createHyperlink(composite, "Contact Sales", 36);
            n = 3;
        } else if (this.\u00a5 == ActivationDialogMode.ACTIVATION_IN_PROGRESS) {
            this.createHyperlink(composite, "Cancel", 30);
            this.createSpacer(composite);
            this.createHyperlink(composite, "Give Feedback", ActivationDialog.getFeedbackURL());
            n = 3;
        }
        GridLayout gridLayout = (GridLayout)composite.getLayout();
        gridLayout.numColumns = n + 1;
    }

    private void F(Composite composite) {
        if (this.\u00d2 < 0 && !PlatformUtil.isWebclipse()) {
            this.createHyperlink(composite, "Quit", 18);
        } else {
            this.createHyperlink(composite, "Activate Later", 22);
        }
    }

    protected boolean canHandleShellCloseEvent() {
        return this.\u00d2 < 0 ? false : super.canHandleShellCloseEvent();
    }

    @Override
    protected Object[] getPrimaryButtonDetails() {
        switch (this.\u00a5) {
            case ACTIVATION_OPTIONS: 
            case ACTIVATION_REGISTRATION: 
            case MANUAL_ACTIVATION: {
                return new Object[]{"Activate Now", 24};
            }
            case ACTIVATION_SUCCESS: {
                return new Object[]{"Close", 16};
            }
            case ACTIVATION_FAILED: {
                return new Object[]{"Try Again", 34};
            }
            case WEB_ACTIVATION: {
                return new Object[]{"Enter Code", 26};
            }
            case ACTIVATION_IN_PROGRESS: {
                return new Object[]{"Working...", 0};
            }
        }
        return new Object[]{"Buy More", ActivationDialog.getBuyURL()};
    }

    private ActivationDialogMode B(int n) {
        switch (n) {
            case 0: {
                return ActivationDialogMode.ACTIVATION_IN_PROGRESS;
            }
            case 1: {
                return ActivationDialogMode.WEB_ACTIVATION;
            }
        }
        return ActivationDialogMode.MANUAL_ACTIVATION;
    }

    private ActivationDialogMode R() {
        switch (this.\u00a5) {
            case ACTIVATION_OPTIONS: {
                if (!this.\u00c2 && !ProductRegistrar.registrationValid(false)) {
                    return ActivationDialogMode.ACTIVATION_REGISTRATION;
                }
                return this.B(this.\u00cc.getSelectedIndex());
            }
            case WEB_ACTIVATION: {
                return ActivationDialogMode.MANUAL_ACTIVATION;
            }
            case MANUAL_ACTIVATION: {
                return ActivationDialogMode.ACTIVATION_IN_PROGRESS;
            }
            case ACTIVATION_REGISTRATION: {
                return this.B(this.\u00d1.\u00aa);
            }
            case ACTIVATION_FAILED: {
                return ActivationDialogMode.ACTIVATION_OPTIONS;
            }
        }
        return null;
    }

    private ActivationDialogMode O() {
        switch (this.\u00a5) {
            default: 
        }
        return ActivationDialogMode.ACTIVATION_OPTIONS;
    }

    private ActivationDialog S() {
        ActivationDialogMode activationDialogMode = this.R();
        ActivationDialog activationDialog = new ActivationDialog(this.getShell(), activationDialogMode);
        activationDialog.\u00d1 = this;
        return activationDialog;
    }

    private void Q() {
        this.S().open();
    }

    private void P() {
        ActivationDialogMode activationDialogMode = this.O();
        ActivationDialog activationDialog = new ActivationDialog(this.getShell(), activationDialogMode);
        activationDialog.open();
    }

    protected void buttonPressed(int n) {
        switch (n) {
            case 18: {
                this.close();
                ViperCore.getDefault().shutdownProductIfNeeded(true, this.getParentShell(), "Activation required to continue");
                break;
            }
            case 16: 
            case 22: {
                this.close();
                break;
            }
            case 32: {
                this.close();
                ProductRegistrar.saveRegistrationTime(14);
                this.Q();
                break;
            }
            case 28: {
                PreferencesUtil.createPreferenceDialogOn((Shell)PlatformUIUtil.getActiveShell(), (String)"org.eclipse.ui.net.NetPreferences", (String[])new String[]{"org.eclipse.ui.net.NetPreferences"}, null).open();
                break;
            }
            case 24: {
                this.close();
                if (this.\u00a5 == ActivationDialogMode.MANUAL_ACTIVATION) {
                    ActivationDialog activationDialog = this.S();
                    activationDialog.B(this.\u00cd.getText().trim());
                    activationDialog.open();
                    break;
                }
                if (this.\u00a5 == ActivationDialogMode.ACTIVATION_REGISTRATION) {
                    ProductRegistrar.doRegistration(LicenseUtil.getCurrentLicensee(), LicenseUtil.getCurrentLicenseCode(), this.\u00c7.getText().trim());
                    this.Q();
                    break;
                }
                this.Q();
                break;
            }
            case 26: {
                this.close();
                this.Q();
                break;
            }
            case 20: {
                this.close();
                this.P();
                break;
            }
            case 30: {
                this.close();
                if (this.\u00c5 != null) {
                    this.\u00c5.cancel();
                }
                this.P();
                break;
            }
            case 34: {
                this.close();
                this.P();
                break;
            }
            case 36: {
                try {
                    Desktop.getDesktop().mail(new URI("mailto:sales@genuitec.com?subject=Liense%20Activation%20Issue"));
                }
                catch (Exception exception) {
                    ViperCore.getDefault().log("Could not send email. Please mail: sales@genuitec.com", 4);
                }
                break;
            }
            case 38: {
                this.V();
            }
        }
    }

    private String X() {
        if (!this.\u00c2) {
            return this.T();
        }
        return String.valueOf(this.T()) + "\n\nSubscription Code: " + LicenseUtil.getCurrentLicenseCode() + "\n\nSystem ID: " + LicenseUtil.getSystemId();
    }

    private void V() {
        Clipboard clipboard = null;
        try {
            String string = this.X();
            clipboard = new Clipboard(this.getShell().getDisplay());
            clipboard.setContents(new Object[]{string}, new Transfer[]{TextTransfer.getInstance()});
        }
        finally {
            if (clipboard != null) {
                clipboard.dispose();
            }
        }
    }

    private void B(String string) {
        this.\u00cf = string;
    }

    @Override
    protected boolean validate(DialogField dialogField) {
        if (this.\u00a5 == ActivationDialogMode.MANUAL_ACTIVATION) {
            String string = this.\u00cd.getText().trim();
            if (string.length() >= 150) {
                ActivationValidator activationValidator = new ActivationValidator(string, LicenseUtil.getCurrentLicenseCode());
                IStatus iStatus = activationValidator.validate();
                if (!iStatus.isOK()) {
                    this.A(iStatus.getMessage(), 4);
                    return false;
                }
                this.A("Activation code valid", 0);
                return true;
            }
            if (PlatformUtil.isNullOrEmpty((String)string)) {
                this.A("Please enter an activation code", 1);
            } else {
                this.A("Activation code invalid", 4);
            }
            return false;
        }
        if (this.\u00a5 == ActivationDialogMode.ACTIVATION_IN_PROGRESS) {
            return false;
        }
        if (this.\u00a5 == ActivationDialogMode.ACTIVATION_OPTIONS) {
            this.\u00aa = this.\u00cc.getSelectedIndex();
        } else if (this.\u00a5 == ActivationDialogMode.ACTIVATION_REGISTRATION) {
            return PlatformUtil.isValidEmail((String)this.\u00c7.getText().trim());
        }
        return true;
    }

    private void A(String string, int n) {
        this.\u00c6.setText(string);
        if (n == 4) {
            this.setLabelStyleError((Control)this.\u00c6);
        } else if (n == 1) {
            this.setLabelStyle((Control)this.\u00c6);
        } else {
            this.setLabelStyleOK((Control)this.\u00c6);
        }
    }

    private void W() {
        int n = (int)(11L + Math.round(Math.random() * 4.0));
        if (this.\u00cf != null) {
            this.\u00c5 = new GenuitecCoreLicenseDialog.DelayJob(n);
            this.\u00c5.schedule();
        } else {
            this.\u00c5 = new GenuitecCoreLicenseDialog.DelayJob(this, n){

                @Override
                protected IStatus run(IProgressMonitor iProgressMonitor) {
                    long l = System.currentTimeMillis();
                    IStatus iStatus = ProductActivator.getDefault().doAutoActivation(LicenseUtil.getCurrentLicenseCode(), LicenseUtil.getSystemId());
                    long l2 = System.currentTimeMillis();
                    long l3 = (long)(this.B * 1000) - (l2 - l);
                    if (iStatus.isOK() && l3 > 1000L) {
                        try {
                            Thread.sleep(l3);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (!iProgressMonitor.isCanceled()) {
                        ActivationDialog.this.delayComplete();
                    }
                    return PlatformUtil.getOKStatus();
                }
            };
            this.\u00c5.schedule();
        }
    }

    @Override
    protected void delayComplete() {
        IStatus iStatus;
        Object object;
        if (this.\u00cf != null) {
            object = new ActivationValidator(this.\u00cf, LicenseUtil.getCurrentLicenseCode());
            ProductActivator.getDefault().setManuallyEnteredActivationCode(object.getActivationCode());
            iStatus = ProductActivator.getDefault().installActivationCode();
        } else {
            iStatus = ProductActivator.getDefault().getStatus();
            if (iStatus.isOK()) {
                iStatus = ProductActivator.getDefault().installActivationCode();
            }
        }
        super.delayComplete();
        if (iStatus.isOK()) {
            object = ActivationDialogMode.ACTIVATION_SUCCESS;
            if (!this.\u00c2) {
                LicenseUtil.openThanksPage(LicenseUtil.ThanksAction.ACTIVATION, null);
            }
        } else {
            switch (iStatus.getCode()) {
                case 5: {
                    object = ActivationDialogMode.ACTIVATION_FAILED_COUNTERFEIT;
                    break;
                }
                case 6: {
                    object = ActivationDialogMode.ACTIVATION_FAILED_TOOMANY;
                    break;
                }
                default: {
                    object = ActivationDialogMode.ACTIVATION_FAILED;
                }
            }
        }
        Object object2 = object;
        PlatformUIUtil.postOnDisplayQueue((Runnable)new Runnable((ActivationDialogMode)((Object)object2)){
            private final /* synthetic */ ActivationDialogMode B;
            {
                this.B = activationDialogMode;
            }

            @Override
            public void run() {
                ActivationDialog activationDialog = new ActivationDialog(ActivationDialog.this.getShell(), this.B);
                activationDialog.open();
            }
        });
    }

    public static enum ActivationDialogMode {
        ACTIVATION_OPTIONS,
        ACTIVATION_REGISTRATION,
        WEB_ACTIVATION,
        MANUAL_ACTIVATION,
        ACTIVATION_SUCCESS,
        ACTIVATION_FAILED,
        ACTIVATION_FAILED_COUNTERFEIT,
        ACTIVATION_FAILED_TOOMANY,
        ACTIVATION_IN_PROGRESS;

    }
}

