/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.appserver;

import com.genuitec.eclipse.appserver.AppServerInfoProviderFactory;
import com.genuitec.eclipse.appserver.IAppServerInfo;
import com.genuitec.eclipse.appserver.IAppServerInfoProvider;
import com.genuitec.eclipse.core.Messages;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class JarDeploymentFilteringDialog
extends Dialog {
    private CheckboxTableViewer viewer;
    private List initialSelection;
    private String jarLabel;
    private Object[] checkedServers;

    public JarDeploymentFilteringDialog(Shell parent, List initialSelection, String jarLabel) {
        super(parent);
        this.initialSelection = initialSelection;
        this.jarLabel = jarLabel;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.JarDeploymentFilteringDialog_title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Label label = new Label(composite, 16448);
        String string = this.jarLabel == null ? Messages.JarDeploymentFilteringDialog_no_jar : this.jarLabel;
        String labelText = MessageFormat.format(Messages.JarDeploymentFilteringDialog_jar_label, string);
        label.setText(labelText);
        label = new Label(composite, 258);
        label.setLayoutData((Object)new GridData(4, 1, true, false));
        label = new Label(composite, 16384);
        label.setText(Messages.JarDeploymentFilteringDialog_directions);
        this.viewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)68352);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 200;
        gd.heightHint = 300;
        this.viewer.getTable().setLayoutData((Object)gd);
        this.viewer.setContentProvider((IContentProvider)new ServerContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ServerLabelProvider());
        this.viewer.setSorter((ViewerSorter)new ServerSorter());
        this.viewer.setInput((Object)AppServerInfoProviderFactory.getAppServerInfoProvider());
        if (this.initialSelection != null) {
            this.viewer.setCheckedElements(this.initialSelection.toArray());
        }
        return composite;
    }

    protected void cancelPressed() {
        this.checkedServers = null;
        super.cancelPressed();
    }

    protected void okPressed() {
        this.checkedServers = this.viewer.getCheckedElements();
        super.okPressed();
    }

    public Object[] getCheckedServers() {
        return this.checkedServers;
    }

    private static class ServerContentProvider
    implements IStructuredContentProvider {
        private ServerContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return this.getAppServers((IAppServerInfoProvider)inputElement);
        }

        private Object[] getAppServers(IAppServerInfoProvider theAppServerInfoProvider) {
            IAppServerInfo[] servers = theAppServerInfoProvider.getAppServerInfos();
            ArrayList<IAppServerInfo> listedServers = new ArrayList<IAppServerInfo>(servers.length);
            int i = 0;
            while (i < servers.length) {
                IAppServerInfo server = servers[i];
                if (theAppServerInfoProvider.isStdAppServer(server)) {
                    listedServers.add(server);
                }
                ++i;
            }
            return listedServers.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class ServerLabelProvider
    extends LabelProvider {
        private ServerLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof IAppServerInfo) {
                IAppServerInfo server = (IAppServerInfo)element;
                return server.getSmallImage();
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof IAppServerInfo) {
                IAppServerInfo server = (IAppServerInfo)element;
                return server.getName();
            }
            return super.getText(element);
        }
    }

    private static class ServerSorter
    extends ViewerSorter {
        public ServerSorter() {
            if (this.collator != null) {
                String rules = ((RuleBasedCollator)this.collator).getRules();
                String newRules = "< '  ' < ' '";
                try {
                    this.collator = new RuleBasedCollator(String.valueOf(rules) + newRules);
                }
                catch (ParseException parseException) {}
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof IAppServerInfo && e2 instanceof IAppServerInfo) {
                IAppServerInfo server1 = (IAppServerInfo)e1;
                IAppServerInfo server2 = (IAppServerInfo)e2;
                String name1 = server1.getName();
                String name2 = server2.getName();
                return this.collator.compare(name1, name2);
            }
            return super.compare(viewer, e1, e2);
        }
    }
}

