/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core.ui.console;

import com.genuitec.eclipse.core.ui.console.CustomConsoleProcess;
import com.genuitec.eclipse.core.ui.console.CustomConsoleStreamMonitor;
import com.genuitec.eclipse.core.ui.console.ICustomConsoleStreamWriter;
import java.io.IOException;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.ui.console.ConsoleColorProvider;
import org.eclipse.debug.ui.console.IConsole;

public abstract class CustomConsoleColorProvider
extends ConsoleColorProvider {
    private IProcess fProcess;
    private IConsole fConsole;
    private StreamsProxy fStreamsProxy;
    private CustomConsoleStreamMonitor errStreamMonitor = new CustomConsoleStreamMonitor();
    private CustomConsoleStreamMonitor outStreamMonitor = new CustomConsoleStreamMonitor();

    public void connect(IProcess process, IConsole console) {
        this.fProcess = process;
        this.fConsole = console;
        IStreamsProxy streamsProxy = ((CustomConsoleProcess)this.fProcess).getCustomConsoleStreamsProxy();
        if (this.getProcessErrorStreamListener() != null) {
            streamsProxy.getErrorStreamMonitor().addListener(this.getProcessErrorStreamListener());
        }
        if (this.getProcessOutputStreamListener() != null) {
            streamsProxy.getOutputStreamMonitor().addListener(this.getProcessOutputStreamListener());
        }
        this.fStreamsProxy = new StreamsProxy(streamsProxy);
        if (streamsProxy != null) {
            this.fConsole.connect((IStreamsProxy)this.fStreamsProxy);
        }
    }

    public void connect(IStreamsProxy streamsProxy, IConsole console) {
        this.fConsole = console;
        if (this.getProcessErrorStreamListener() != null) {
            streamsProxy.getErrorStreamMonitor().addListener(this.getProcessErrorStreamListener());
        }
        if (this.getProcessOutputStreamListener() != null) {
            streamsProxy.getOutputStreamMonitor().addListener(this.getProcessOutputStreamListener());
        }
        this.fStreamsProxy = new StreamsProxy(streamsProxy);
        if (streamsProxy != null) {
            this.fConsole.connect((IStreamsProxy)this.fStreamsProxy);
        }
    }

    public void disconnect() {
        this.fConsole = null;
        this.fProcess = null;
    }

    protected ICustomConsoleStreamWriter getConsoleErrorStreamWriter() {
        return this.errStreamMonitor;
    }

    protected ICustomConsoleStreamWriter getConsoleOutputStreamWriter() {
        return this.outStreamMonitor;
    }

    protected abstract IStreamListener getProcessErrorStreamListener();

    protected abstract IStreamListener getProcessOutputStreamListener();

    private class StreamsProxy
    implements IStreamsProxy {
        private IStreamsProxy parent;

        public StreamsProxy(IStreamsProxy parent) {
            this.parent = parent;
        }

        public CustomConsoleStreamMonitor getErrorStreamMonitor() {
            return CustomConsoleColorProvider.this.errStreamMonitor;
        }

        public CustomConsoleStreamMonitor getOutputStreamMonitor() {
            return CustomConsoleColorProvider.this.outStreamMonitor;
        }

        public void write(String input) throws IOException {
            this.parent.write(input);
        }
    }
}

