/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core.ui.contentassist;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.PlatformUI;

public class PathCompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension {
    private static final Image FILE_IMAGE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
    private static final Image FOLDER_IMAGE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    private static final char[] triggers = new char[]{'/', '\\'};
    private String fAdditionalProposalInfo;
    private IContextInformation fContextInformation;
    private String fDisplayString;
    private Image fImage;
    private int fReplacementLength;
    private int fReplacementOffset;
    private String fReplacementString;
    private final boolean isFile;
    private int newCursorPosition;

    public PathCompletionProposal(String replacementString, int replacementOffset, int replacementLength, String displayString, IContextInformation contextInformation, String additionalProposalInfo, boolean isFile) {
        this.newCursorPosition = this.fReplacementOffset;
        this.isFile = isFile;
        Assert.isNotNull((Object)replacementString);
        Assert.isTrue((replacementOffset >= 0 ? 1 : 0) != 0);
        Assert.isTrue((replacementLength >= 0 ? 1 : 0) != 0);
        this.fReplacementString = replacementString;
        this.fReplacementOffset = replacementOffset;
        this.fReplacementLength = replacementLength;
        this.fImage = isFile ? FILE_IMAGE : FOLDER_IMAGE;
        this.fDisplayString = displayString;
        this.fContextInformation = contextInformation;
        this.fAdditionalProposalInfo = additionalProposalInfo;
    }

    public void apply(IDocument document) {
        this.apply(document, '\n', this.fReplacementOffset);
    }

    public void apply(IDocument document, char trigger, int offset) {
        String replacementString = !this.isFile && (trigger == '/' || trigger == '\\') ? String.valueOf(this.fReplacementString) + "/" : this.fReplacementString;
        int delta = offset - (this.fReplacementOffset + this.fReplacementLength);
        if (delta > 0) {
            this.fReplacementLength += delta;
        }
        try {
            document.replace(this.fReplacementOffset, this.fReplacementLength, replacementString);
            this.newCursorPosition = this.fReplacementOffset + replacementString.length();
        }
        catch (BadLocationException badLocationException) {}
    }

    public String getAdditionalProposalInfo() {
        return this.fAdditionalProposalInfo;
    }

    public IContextInformation getContextInformation() {
        return this.fContextInformation;
    }

    public int getContextInformationPosition() {
        return -1;
    }

    public String getDisplayString() {
        if (this.fDisplayString != null) {
            return this.fDisplayString;
        }
        return this.fReplacementString;
    }

    public Image getImage() {
        return this.fImage;
    }

    public Point getSelection(IDocument document) {
        return new Point(this.newCursorPosition, 0);
    }

    public char[] getTriggerCharacters() {
        return triggers;
    }

    public boolean isValidFor(IDocument document, int offset) {
        int replacementLength;
        if (offset < this.fReplacementOffset) {
            return false;
        }
        int n = replacementLength = this.fReplacementString == null ? 0 : this.fReplacementString.length();
        if (offset >= this.fReplacementOffset + replacementLength) {
            return false;
        }
        try {
            int length = offset - this.fReplacementOffset;
            String start = document.get(this.fReplacementOffset, length);
            if (!start.startsWith("/")) {
                start = "/" + start;
                ++length;
            }
            return this.fReplacementString.substring(0, length).equalsIgnoreCase(start);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }
}

