/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core.ui.wizard;

import com.genuitec.eclipse.core.Messages;
import com.genuitec.eclipse.core.portability.wizard.FolderSelectionDialog;
import com.genuitec.eclipse.core.portability.wizard.StatusInfo;
import com.genuitec.eclipse.core.portability.wizard.StringButtonDialogField;
import com.genuitec.eclipse.core.portability.wizard.StringDialogField;
import com.genuitec.eclipse.core.portability.wizard.TypedElementSelectionValidator;
import com.genuitec.eclipse.core.portability.wizard.TypedViewerFilter;
import com.genuitec.eclipse.core.ui.wizard.DialogFieldUtil;
import com.genuitec.eclipse.core.ui.wizard.NewCoreWizardPage;
import com.genuitec.eclipse.core.util.Util;
import org.eclipse.core.internal.resources.LocationValidator;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class FileFolderDialogFieldHelper {
    private static Path VAL_PATH = new Path("");
    private static LocationValidator locationValidator = new LocationValidator((Workspace)Util.getWorkspace());
    private NewCoreWizardPage.TypeFieldsAdapter typeFieldsAdapter;
    private boolean folderMode;
    private String labelText;
    private StringDialogField fileFolderDF;
    private String initLocation;
    private IProject project;
    private String selectionDialogTitle;
    private String selectionDialogMessage;
    private boolean allowNonExistingResource;
    private boolean showBrowse = true;

    public FileFolderDialogFieldHelper(NewCoreWizardPage.TypeFieldsAdapter adapter, boolean folderMode) {
        this.typeFieldsAdapter = adapter;
        this.folderMode = folderMode;
    }

    public void setLabelText(String text) {
        this.labelText = text;
    }

    public void setInitialText(String location) {
        this.initLocation = location;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public void setSelectionDialogTitleMessage(String title, String message) {
        this.selectionDialogTitle = title;
        this.selectionDialogMessage = message;
    }

    public void setAllowNonExistingResource(boolean value) {
        this.allowNonExistingResource = value;
    }

    public void setShowBrowse(boolean show) {
        this.showBrowse = show;
    }

    public void doFillIntoGrid(Composite parent) {
        if (this.showBrowse) {
            this.fileFolderDF = DialogFieldUtil.createTextFieldWithBrowseButton(parent, this.labelText, this.typeFieldsAdapter, this.typeFieldsAdapter, 0, this.initLocation);
            Button button = ((StringButtonDialogField)this.fileFolderDF).getChangeControl(parent);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (FileFolderDialogFieldHelper.this.folderMode) {
                        FileFolderDialogFieldHelper.this.selectFolder();
                    } else {
                        FileFolderDialogFieldHelper.this.selectFile();
                    }
                }
            });
        } else {
            this.fileFolderDF = DialogFieldUtil.createTextField(parent, this.typeFieldsAdapter, this.labelText, this.initLocation);
        }
    }

    public IContainer getFolder() {
        String path = this.fileFolderDF.getText();
        if (this.project != null) {
            return this.project.getFolder(path);
        }
        return Util.getWorkspaceRoot().getFolder((IPath)new Path(path));
    }

    public IFile getFile() {
        String path = this.fileFolderDF.getText();
        if (this.project != null) {
            return this.project.getFile(path);
        }
        return Util.getWorkspaceRoot().getFile((IPath)new Path(path));
    }

    public String getText() {
        return this.fileFolderDF.getText();
    }

    private Shell getShell() {
        return this.fileFolderDF.getLabelControl(null).getShell();
    }

    protected void selectFile() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setValidator((ISelectionStatusValidator)new TypedElementSelectionValidator(new Class[]{IFile.class}, false));
        dialog.addFilter((ViewerFilter)new TypedViewerFilter(new Class[]{IFolder.class, IFile.class}, null));
        if (this.project != null) {
            dialog.setInput((Object)this.project);
        } else {
            dialog.setInput((Object)Util.getWorkspaceRoot());
        }
        dialog.setTitle(this.selectionDialogTitle);
        dialog.setMessage(this.selectionDialogMessage);
        if (dialog.open() == 0) {
            IFile result = (IFile)dialog.getFirstResult();
            String text = this.project != null ? result.getProjectRelativePath().toString() : result.getFullPath().toString();
            this.fileFolderDF.setText(text);
        }
    }

    protected void selectFolder() {
        MEFolderSelectionDialog dialog = new MEFolderSelectionDialog(this.getShell(), (ILabelProvider)new JavaElementLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setProject(this.project);
        dialog.setInput(Util.getWorkspaceRoot());
        dialog.setTitle(this.selectionDialogTitle);
        dialog.setMessage(this.selectionDialogMessage);
        if (dialog.open() == 0) {
            IContainer result = (IContainer)dialog.getFirstResult();
            String text = this.project != null ? result.getProjectRelativePath().toString() : result.getFullPath().toString();
            this.fileFolderDF.setText(text);
        }
    }

    public IStatus validate() {
        IStatus status = Util.getOKStatus();
        String pathString = this.fileFolderDF.getText();
        if (this.folderMode) {
            IContainer folder;
            if (!VAL_PATH.isValidPath(pathString)) {
                return new StatusInfo(4, Messages.FileFolderDialogFieldHelper_error_folder_path_invalid);
            }
            Path path = new Path(pathString);
            String[] segments = path.segments();
            int i = 0;
            while (i < segments.length) {
                IStatus val = locationValidator.validateName(segments[i], 2);
                if (!val.isOK()) {
                    if (val.getSeverity() == 4) {
                        return val;
                    }
                    status = val;
                }
                ++i;
            }
            if (!(this.allowNonExistingResource || (folder = this.getFolder()) != null && folder.exists())) {
                return new StatusInfo(4, Messages.FileFolderDialogFieldHelper_error_folder_not_exist);
            }
        } else {
            IFile file;
            if (Util.isNullOrEmpty((String)pathString)) {
                return new StatusInfo(4, Messages.FileFolderDialogFieldHelper_error_file_name_blank);
            }
            if (!(this.allowNonExistingResource || (file = this.getFile()) != null && file.exists())) {
                return new StatusInfo(4, Messages.FileFolderDialogFieldHelper_error_file_not_exist);
            }
        }
        return status;
    }

    public static IStatus validateName(String name, int type) {
        return locationValidator.validateName(name, type);
    }

    public class MEFolderSelectionDialog
    extends FolderSelectionDialog {
        private IProject project;

        public MEFolderSelectionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
            super(parent, labelProvider, contentProvider);
        }

        public void setProject(IProject project) {
            this.project = project;
        }

        protected void setup() {
            this.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    if (element instanceof IFolder) {
                        return true;
                    }
                    if (element instanceof IProject) {
                        return MEFolderSelectionDialog.this.project == null ? true : element == MEFolderSelectionDialog.this.project;
                    }
                    return false;
                }
            });
        }

        public int open() {
            this.setup();
            return super.open();
        }
    }
}

