/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core.util;

import com.genuitec.eclipse.core.CommonUI;
import com.genuitec.eclipse.core.Messages;
import com.genuitec.eclipse.core.gsdc.GSDCController;
import com.genuitec.eclipse.core.ui.util.SWTUtil;
import com.genuitec.eclipse.core.util.DashboardAction;
import com.genuitec.eclipse.core.util.EditorUtil;
import com.genuitec.eclipse.core.util.PlatformUIUtil;
import com.genuitec.eclipse.core.util.Util;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivity;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IMutableActivityManager;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class UIUtil
extends PlatformUIUtil {
    public static final String PREF_PREV_ALLOW_INTERNET_ACCESS = "prev_allowInternetAccess";
    public static final String PREF_ALLOW_INTERNET_ACCESS = "allowInternetAccess";

    public static IFile pickFile(IContainer container, List selection, ViewerFilter filter) {
        IFile file;
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(UIUtil.getActiveShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        if (filter != null) {
            dialog.addFilter(filter);
        }
        dialog.setAllowMultiple(false);
        dialog.setDoubleClickSelects(true);
        dialog.setInput((Object)container);
        dialog.setValidator((ISelectionStatusValidator)new SingleFileSelectionValidator());
        dialog.setInitialElementSelections(selection);
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            file = (IFile)result[0];
        } else {
            file = null;
        }
        return file;
    }

    public static void openInExternalBrowser(String url) {
        try {
            URL theURL = new URL(url);
            IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
            support.getExternalBrowser().openURL(theURL);
        }
        catch (MalformedURLException e) {
            CommonUI.getDefault().log(e);
        }
        catch (PartInitException e) {
            CommonUI.getDefault().log(e);
        }
    }

    public static GridData gridDataForButton(Button button, int span) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = span;
        gd.widthHint = SWTUtil.getButtonWidthHint((Button)button);
        return gd;
    }

    public static void hideActionSet(String actionSetID) {
        IActionSetDescriptor actionSet = WorkbenchPlugin.getDefault().getActionSetRegistry().findActionSet(actionSetID);
        if (actionSet == null) {
            CommonUI.getDefault().log("Missing action set: " + actionSetID);
            return;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchWindow window = windows[i];
            IWorkbenchPage[] pages = window.getPages();
            int j = 0;
            while (j < pages.length) {
                IWorkbenchPage page = pages[j];
                if (page instanceof WorkbenchPage) {
                    WorkbenchPage p = (WorkbenchPage)page;
                    p.hideActionSet(actionSetID);
                }
                ++j;
            }
            if (window instanceof WorkbenchWindow) {
                WorkbenchWindow w = (WorkbenchWindow)window;
                w.updateActionSets();
            }
            ++i;
        }
    }

    public static void disableActivityCategory(String workingSetId) {
        IMutableActivityManager actManager = UIUtil.getWorkbench().getActivitySupport().createWorkingCopy();
        HashSet enabledActs = new HashSet(actManager.getEnabledActivityIds());
        enabledActs.remove(workingSetId);
        UIUtil.getWorkbench().getActivitySupport().setEnabledActivityIds(enabledActs);
    }

    public static void enableActivityCategory(String workingSetId) {
        IMutableActivityManager actManager = UIUtil.getWorkbench().getActivitySupport().createWorkingCopy();
        HashSet<String> enabledActs = new HashSet<String>(actManager.getEnabledActivityIds());
        enabledActs.add(workingSetId);
        UIUtil.getWorkbench().getActivitySupport().setEnabledActivityIds(enabledActs);
    }

    public static void showActionSet(String actionSetID) {
        IActionSetDescriptor actionSet = WorkbenchPlugin.getDefault().getActionSetRegistry().findActionSet(actionSetID);
        if (actionSet == null) {
            CommonUI.getDefault().log("Missing action set: " + actionSetID);
            return;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchWindow window = windows[i];
            IWorkbenchPage[] pages = window.getPages();
            int j = 0;
            while (j < pages.length) {
                IWorkbenchPage page = pages[j];
                if (page instanceof WorkbenchPage) {
                    WorkbenchPage p = (WorkbenchPage)page;
                    p.showActionSet(actionSetID);
                }
                ++j;
            }
            if (window instanceof WorkbenchWindow) {
                WorkbenchWindow w = (WorkbenchWindow)window;
                w.updateActionSets();
            }
            ++i;
        }
    }

    public static boolean checkInternetFeature(String activityCategoryID, final String actionSetId, IPreferenceStore store) {
        if (!store.getBoolean(PREF_ALLOW_INTERNET_ACCESS)) {
            UIUtil.disableActivityCategory(activityCategoryID);
            SWTUtil.postOnDisplayQueue((Runnable)new Runnable(){

                @Override
                public void run() {
                    UIUtil.hideActionSet(actionSetId);
                }
            });
            store.setValue(PREF_PREV_ALLOW_INTERNET_ACCESS, false);
            return false;
        }
        if (!store.getBoolean(PREF_PREV_ALLOW_INTERNET_ACCESS)) {
            UIUtil.enableActivityCategory(activityCategoryID);
            SWTUtil.postOnDisplayQueue((Runnable)new Runnable(){

                @Override
                public void run() {
                    UIUtil.showActionSet(actionSetId);
                }
            });
            store.setValue(PREF_PREV_ALLOW_INTERNET_ACCESS, true);
        }
        return true;
    }

    public static void openPluginsManagement() {
        if (!GSDCController.getInstance().isActive()) {
            try {
                new DashboardAction().execute(null);
            }
            catch (ExecutionException e) {
                CommonUI.getDefault().log(e);
            }
        } else {
            MessageDialog.openInformation(null, (String)com.genuitec.eclipse.core.util.Messages.DashboardAction_title_dashboard_na, (String)Messages.UIUtil_message_secure_dashboard_na);
        }
    }

    public static void promptWorkbenchRestart(final String title, final String message) {
        SWTUtil.postOnDisplayQueue((Runnable)new Runnable(){

            @Override
            public void run() {
                MessageDialog dialog = new MessageDialog(UIUtil.getActiveShell(), title, null, message, 4, new String[]{Messages.UIUtil_message_dialog_restart, Messages.UIUtil_message_dialog_cancel}, 1);
                if (dialog.open() == 0) {
                    PlatformUI.getWorkbench().restart();
                }
            }
        });
    }

    public static IEditorPart getActiveEditor() {
        return EditorUtil.getActiveEditor();
    }

    public static IProject getActiveProject() {
        IResource resource = UIUtil.getActiveResource();
        return resource != null ? resource.getProject() : null;
    }

    public static IResource getActiveResource() {
        ISelection selection = UIUtil.getCurrentSelection();
        return selection != null ? UIUtil.extractSelection((ISelection)selection) : null;
    }

    public static ISelection getCurrentSelection() {
        IWorkbenchPage page = UIUtil.getActivePage();
        return page != null ? page.getSelection() : null;
    }

    public static String getEditorId(IFile file) {
        return EditorUtil.getEditorId((IFile)file);
    }

    public static String getEditorId(IFile file, boolean refDefaultTextIfNoEditor) {
        return EditorUtil.getEditorId((IFile)file, (boolean)refDefaultTextIfNoEditor);
    }

    public static void openEditor(IFile theFile, String theEditorId) {
        EditorUtil.openEditor((IFile)theFile, (String)theEditorId);
    }

    public static void openDefaultEditor(IFile theFile) {
        EditorUtil.openDefaultEditor((IFile)theFile);
    }

    public static void openView(String theViewId) {
        PlatformUIUtil.openView((String)theViewId);
    }

    public static void openPropertiesView() {
        UIUtil.openView("org.eclipse.ui.views.PropertySheet");
    }

    public static IConsole getConsole(ILaunch theLaunch) {
        return DebugUITools.getConsole((IProcess)theLaunch.getProcesses()[0]);
    }

    public static void appendToConsole(ILaunch theDebugElement, final String theMessage) {
        IDocument consoleDoc;
        if (theMessage == null || theMessage.length() == 0) {
            return;
        }
        IConsole console = UIUtil.getConsole(theDebugElement);
        if (console != null && console instanceof TextConsole && (consoleDoc = ((TextConsole)console).getDocument()) != null) {
            final int length = consoleDoc.getLength();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        consoleDoc.replace(length, 0, theMessage);
                    }
                    catch (BadLocationException e) {
                        CommonUI.getDefault().log("Appending to console", e);
                    }
                }
            };
            SWTUtil.postOnDisplayQueue((Runnable)runnable);
        }
    }

    public static boolean isCapabilityEnabled(String id) {
        IActivityManager activityManager = PlatformUI.getWorkbench().getActivitySupport().getActivityManager();
        IActivity activity = activityManager.getActivity(id);
        if (activity == null) {
            CommonUI.getDefault().log("Activity " + id + " does not exist.");
            return false;
        }
        return activity.isEnabled();
    }

    public static final class SingleFileSelectionValidator
    implements ISelectionStatusValidator {
        public IStatus validate(Object[] selection) {
            if (selection.length > 1) {
                return new Status(4, "a", 1, Messages.UIUtil_error_only_one_element_selection, null);
            }
            if (selection.length == 0) {
                return Util.getOKStatus();
            }
            IAdaptable adaptable = (IAdaptable)selection[0];
            if (adaptable.getAdapter(IFile.class) == null) {
                return new Status(4, "a", 1, Messages.UIUtil_error_only_file_selection, null);
            }
            return Util.getOKStatus();
        }
    }
}

