/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.j2eedt.core;

import com.genuitec.eclipse.j2eedt.core.J2EECore;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.osgi.framework.Bundle;

public class MavenUtil {
    private static final String MAVEN_NATURE_ID = "org.eclipse.m2e.core.maven2Nature";
    private static final String MAVEN_PLUGIN_ID = "com.genuitec.eclipse.maven";
    private static final String MAVEN_DELEGATE_CLASS = "com.genuitec.eclipse.maven.core.M2EclipseDelegate";
    public static final String MAVEN_CONTAINER = "org.eclipse.m2e.MAVEN2_CLASSPATH_CONTAINER";
    public static final String HELP_CONTEXT = "https://www.genuitec.com/products/myeclipse/learning-center/maven/using-maven-in-myeclipse-maven4myeclipse/";
    private static MavenSupportDelegate delegate = null;

    private static MavenSupportDelegate getDelegate() {
        if (delegate == null && (delegate = MavenUtil.getMavenDelegate()) == null) {
            delegate = new DummyDelegate();
        }
        return delegate;
    }

    private static MavenSupportDelegate getMavenDelegate() {
        try {
            Bundle bundle = Platform.getBundle((String)MAVEN_PLUGIN_ID);
            if (bundle != null) {
                Class delegateClass = bundle.loadClass(MAVEN_DELEGATE_CLASS);
                return (MavenSupportDelegate)delegateClass.newInstance();
            }
        }
        catch (ClassNotFoundException e) {
            J2EECore.getDefault().log((Throwable)e);
        }
        catch (InstantiationException e) {
            J2EECore.getDefault().log((Throwable)e);
        }
        catch (IllegalAccessException e) {
            J2EECore.getDefault().log((Throwable)e);
        }
        return null;
    }

    public static boolean isMavenSupportAvailable() {
        return MavenUtil.getDelegate().isMaven4MyEclipseActive();
    }

    private MavenUtil() {
    }

    public static IMavenDependenciesWizardPage createMavenDependenciesWizardPage(IWizard wizard, IFacetedProjectWorkingCopy fpjwc) {
        return MavenUtil.getDelegate().createMavenDependenciesWizardPage(wizard, fpjwc);
    }

    public static boolean hasMavenNature(IProject project) {
        try {
            return project.hasNature(MAVEN_NATURE_ID);
        }
        catch (CoreException e) {
            J2EECore.getDefault().log(e);
            return false;
        }
    }

    private static class DummyDelegate
    implements MavenSupportDelegate {
        private DummyDelegate() {
        }

        @Override
        public boolean isMaven4MyEclipseActive() {
            return false;
        }

        @Override
        public IMavenDependenciesWizardPage createMavenDependenciesWizardPage(IWizard wizard, IFacetedProjectWorkingCopy fpjwc) {
            return null;
        }
    }

    public static interface IMavenDependenciesWizardPage
    extends IWizardPage {
        public boolean hasContents();

        public void setMavenNatureAware(boolean var1);

        public boolean isMavenNatureAware();

        public void addCustomCategories(Collection<String> var1);

        public void removeCustomCategories(Collection<String> var1);

        public void setCategoriesSelection(boolean var1, Collection<String> var2);
    }

    public static interface MavenSupportDelegate {
        public boolean isMaven4MyEclipseActive();

        public IMavenDependenciesWizardPage createMavenDependenciesWizardPage(IWizard var1, IFacetedProjectWorkingCopy var2);
    }
}

