/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.j2eedt.facet.ui;

import com.genuitec.eclipse.j2eedt.facet.ui.FacetConfigurationControl;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class FacetConfigurationCheckBox
extends FacetConfigurationControl {
    protected String checkBoxCaption;
    protected Button checkBox;
    protected IProjectFacetVersion facet;
    protected boolean lastSelected;

    public FacetConfigurationCheckBox(String dataModelFacetId, String checkBoxCaption, IProjectFacetVersion facet, boolean defaultSelected) {
        super(null, dataModelFacetId);
        this.checkBoxCaption = checkBoxCaption;
        this.facet = facet;
        this.lastSelected = defaultSelected;
    }

    @Override
    public void createControl(Composite parent) {
        this.createSelectionControl(parent);
        this.checkBox.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
    }

    @Override
    protected void createSelectionControl(Composite parent) {
        this.checkBox = new Button(parent, 32);
        this.checkBox.setText(this.checkBoxCaption);
        this.checkBox.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.checkBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FacetConfigurationCheckBox.this.lastSelected = FacetConfigurationCheckBox.this.checkBox.getSelection();
                FacetConfigurationCheckBox.this.modified();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    @Override
    public IProjectFacetVersion getSelectedFacetVersion() {
        return this.checkBox != null && this.checkBox.getSelection() ? this.facet : null;
    }

    @Override
    public void updateSelectionEnablement(Set<IProjectFacetVersion> configuredFacets) {
        if (this.checkBox != null) {
            boolean enable = true;
            Iterator<IProjectFacetVersion> it = configuredFacets.iterator();
            while (it.hasNext() && enable) {
                boolean bl = enable = !it.next().conflictsWith(this.facet);
            }
            this.checkBox.setEnabled(enable);
            this.checkBox.setSelection(this.lastSelected && enable);
        }
    }
}

