/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.j2eedt.xml;

import com.genuitec.eclipse.core.util.EditorUtil;
import com.genuitec.eclipse.core.util.UIUtil;
import com.genuitec.eclipse.j2eedt.ui.J2EEUICore;
import java.io.IOException;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.sse.core.internal.model.ModelManagerImpl;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLFile {
    protected IDOMModel xmlModel;
    protected IFile file;
    protected boolean needsRelease;
    protected boolean editMode;
    protected FileEditorInput editorInput;
    protected IEditorPart modelEditor;

    public XMLFile(IFile file, boolean open) {
        this(file, open, true);
    }

    public XMLFile(IFile file, boolean open, boolean editMode) {
        this.file = file;
        this.editMode = editMode;
        this.configureModel(open);
    }

    public IDOMModel getXMLModel() {
        return this.xmlModel;
    }

    protected void configureModel(boolean open) {
        this.editorInput = new FileEditorInput(this.file);
        this.xmlModel = this.getXMLModelFromOpenEditors((IEditorInput)this.editorInput);
        if (this.xmlModel == null) {
            if (!open) {
                try {
                    IModelManager modelManager = ModelManagerImpl.getInstance();
                    this.xmlModel = this.editMode ? (IDOMModel)modelManager.getModelForEdit(this.file) : (IDOMModel)modelManager.getModelForRead(this.file);
                    this.needsRelease = true;
                }
                catch (IOException e) {
                    J2EEUICore.getDefault().log(e);
                }
                catch (CoreException e) {
                    J2EEUICore.getDefault().log(e);
                }
            } else {
                try {
                    this.modelEditor = IDE.openEditor((IWorkbenchPage)((WorkbenchPage)UIUtil.getActivePage()), (IFile)this.file);
                    this.xmlModel = (IDOMModel)this.modelEditor.getAdapter(IDOMModel.class);
                }
                catch (PartInitException e) {
                    J2EEUICore.getDefault().log("Unable to open default editor", e);
                }
            }
        }
    }

    public void save() {
        try {
            if (this.modelEditor != null) {
                this.modelEditor.doSave((IProgressMonitor)new NullProgressMonitor());
            } else {
                this.xmlModel.save();
            }
        }
        catch (Exception e) {
            J2EEUICore.getDefault().log("Error saving model", e);
        }
    }

    public void release() {
        if (!this.needsRelease) {
            return;
        }
        if (this.editMode) {
            this.xmlModel.releaseFromEdit();
        } else {
            this.xmlModel.releaseFromRead();
        }
        this.xmlModel = null;
        this.needsRelease = false;
    }

    protected IDOMModel getXMLModelFromOpenEditors(IEditorInput editorInput) {
        IEditorPart[] parts = EditorUtil.getAllEditorsForInput((IEditorInput)editorInput);
        int i = 0;
        while (i < parts.length) {
            IEditorPart part = parts[i];
            if (part != null) {
                IDOMModel model = (IDOMModel)part.getAdapter(IDOMModel.class);
                this.modelEditor = part;
                if (model != null) {
                    return model;
                }
            }
            ++i;
        }
        return null;
    }

    public IFile getFile() {
        return this.file;
    }

    protected String getElementValue(String childName, Element parent) {
        Element element = (Element)parent.getElementsByTagName(childName).item(0);
        if (element != null) {
            return element.getFirstChild().getNodeValue().trim();
        }
        return null;
    }

    public static void format(Element element) {
        try {
            FormatProcessorXML formatProcessor = new FormatProcessorXML();
            formatProcessor.formatNode((Node)element);
        }
        catch (Exception e) {
            J2EEUICore.getDefault().log(e.getMessage(), e);
        }
    }

    public static class MENamespaceContext
    implements NamespaceContext {
        private String namespace;
        private String prefix;

        public MENamespaceContext(String namespace, String prefix) {
            this.namespace = namespace;
            this.prefix = prefix;
        }

        @Override
        public String getNamespaceURI(String pfx) {
            if (this.prefix.equals(pfx)) {
                return this.namespace;
            }
            return "";
        }

        @Override
        public String getPrefix(String arg0) {
            return null;
        }

        public Iterator getPrefixes(String arg0) {
            return null;
        }
    }
}

