/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.server.core;

import com.genuitec.eclipse.server.core.ServerCorePlugin;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.osgi.framework.Bundle;

public class CustomConsoleDelegation {
    private static Method uiCreateLaunch = null;
    private static Method uiSetupLaunchConfig = null;

    static {
        try {
            Bundle b = Platform.getBundle((String)"com.genuitec.eclipse.server.ui");
            Class utils = b.loadClass("com.genuitec.eclipse.server.ui.console.CustomConsoleDelegate");
            uiCreateLaunch = utils.getMethod("createLaunch", ILaunchConfiguration.class, String.class);
            uiSetupLaunchConfig = utils.getMethod("setupLaunchConfiguration", IServer.class, ILaunchConfigurationWorkingCopy.class);
        }
        catch (Exception e) {
            ServerCorePlugin.getDefault().log(e);
        }
    }

    public static ILaunch createLaunch(ILaunchConfiguration config, String mode) {
        try {
            if (uiCreateLaunch != null) {
                return (ILaunch)uiCreateLaunch.invoke(null, config, mode);
            }
        }
        catch (Exception e) {
            ServerCorePlugin.getDefault().log(e);
        }
        return null;
    }

    public static void setupLaunchConfiguration(IServer server, ILaunchConfigurationWorkingCopy workingCopy) {
        try {
            if (uiSetupLaunchConfig != null) {
                uiSetupLaunchConfig.invoke(null, server, workingCopy);
            }
        }
        catch (Exception e) {
            ServerCorePlugin.getDefault().log(e);
        }
    }
}

