/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.server.core.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class EnvVarsMerger {
    private final Map<String, String> savedEnvVars;
    private final Map<String, String> curEnvVars;
    private final Map<String, String> newEnvVars;

    public EnvVarsMerger(Map<String, String> savedEnvVars, Map<String, String> curEnvVars, Map<String, String> newEnvVars) {
        this.savedEnvVars = savedEnvVars == null ? Collections.emptyMap() : savedEnvVars;
        this.curEnvVars = curEnvVars == null ? Collections.emptyMap() : curEnvVars;
        this.newEnvVars = new HashMap<String, String>();
        if (newEnvVars != null) {
            this.newEnvVars.putAll(newEnvVars);
        }
    }

    public Map<String, String> merge() {
        if (this.savedEnvVars.isEmpty() && this.newEnvVars.isEmpty()) {
            return this.curEnvVars;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.curEnvVars.entrySet()) {
            String key = entry.getKey().toString();
            String curVal = entry.getValue().toString();
            String savedVal = this.savedEnvVars.get(key);
            if (savedVal != null && savedVal.toString().equals(curVal)) {
                String newVal = this.newEnvVars.get(key);
                if (newVal != null) {
                    result.put(key, newVal.toString());
                }
            } else {
                result.put(key, curVal);
            }
            this.newEnvVars.remove(key);
        }
        for (Map.Entry<String, String> entry : this.newEnvVars.entrySet()) {
            if (this.savedEnvVars.containsKey(entry.getKey())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }
}

