/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.server.core.legacy.migration.internal;

import com.genuitec.eclipse.core.GenuitecCoreException;
import com.genuitec.eclipse.migration.core.IMigratingObject;
import com.genuitec.eclipse.migration.core.IMigrationOperationEnablementDelegate;
import com.genuitec.eclipse.server.core.ServerCorePlugin;
import com.genuitec.eclipse.server.core.legacy.migration.IEASIEServer;
import com.genuitec.eclipse.server.core.legacy.migration.internal.EASIEServerDeployment;
import com.genuitec.eclipse.server.core.migration.AbstractServerMigrationDelegate;
import com.genuitec.eclipse.server.core.migration.ILegacyServer;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRootDeployment;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.model.DeployMode;

public class MigrateEASIEServerDeploymentsOperation
extends AbstractServerMigrationDelegate {
    public void perform(int stage, SubMonitor monitor) throws CoreException {
        IEASIEServer server = (IEASIEServer)this.object.getObject();
        IServerWorkingCopy swc = this.getMigratingServer().getServerWorkingCopy();
        MultiStatus multi = new MultiStatus("com.genuitec.eclipse.server.core", 0, MessageFormat.format("Some deployments of server {0} were not migrated", swc.getName()), null);
        List<EASIEServerDeployment> deployments = EASIEServerDeployment.getDeployments(server.getEASIEServerId());
        monitor.beginTask("", deployments.size() + 10);
        HashSet<IProject> deployed = new HashSet<IProject>();
        for (EASIEServerDeployment deployment : deployments) {
            try {
                IProject project = deployment.getProject();
                if (deployed.contains(project)) continue;
                deployed.add(project);
                IModule module = ServerUtil.getModule((IProject)project);
                assert (module != null) : String.valueOf(project.getName()) + " is not a JavaEE project.";
                IRootDeployment rd = swc.createDeployment(module);
                rd.setDeployMode(deployment.isPackaged() ? DeployMode.PACKAGED : DeployMode.EXPLODED);
                swc.modifyDeployments(new IRootDeployment[]{rd}, null, (IProgressMonitor)monitor.newChild(1));
            }
            catch (Exception e) {
                multi.add((IStatus)new Status(4, "com.genuitec.eclipse.server.core", MessageFormat.format("Cannot migrate deployment of project {0}", deployment.getProject().getName()), (Throwable)e));
            }
        }
        swc.saveAll(false, (IProgressMonitor)monitor.newChild(10));
        if (multi.getSeverity() >= 4) {
            ServerCorePlugin.getDefault().log(new CoreException((IStatus)multi));
        }
    }

    public static class EnablementDelegate
    implements IMigrationOperationEnablementDelegate<ILegacyServer> {
        public boolean isApplicable(IMigratingObject<ILegacyServer> object, String params) {
            if (object.getObject() instanceof IEASIEServer) {
                try {
                    return !EASIEServerDeployment.getDeployments(((IEASIEServer)object.getObject()).getEASIEServerId()).isEmpty();
                }
                catch (GenuitecCoreException e) {
                    e.log();
                    return false;
                }
            }
            return false;
        }
    }
}

