/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.server.core.util;

import com.genuitec.eclipse.core.GenuitecCoreException;
import com.genuitec.eclipse.server.core.ServerCorePlugin;
import java.io.File;
import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SafeRunner;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public class XMLConfigFile
extends EventManager {
    private File file;
    private long fileModified = -1L;
    protected Document document;
    private XPath xPath = XPathFactory.newInstance().newXPath();
    private DocumentBuilder docBuilder;
    private static final String PI_XML_TARGET = "xml";
    private static final String PI_XML_DATA = "version=\"1.0\" encoding=\"UTF-8\"";

    protected XMLConfigFile() throws GenuitecCoreException {
        try {
            this.docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new GenuitecCoreException((Plugin)ServerCorePlugin.getDefault(), (Throwable)e);
        }
    }

    public XMLConfigFile(File configFile) throws GenuitecCoreException {
        this();
        this.setConfigFile(configFile);
    }

    public File getFile() {
        return this.file;
    }

    protected void setConfigFile(File configFile) throws GenuitecCoreException {
        if (configFile != null && !configFile.exists()) {
            throw new GenuitecCoreException("File " + this.file + " does not exist", (Plugin)ServerCorePlugin.getDefault(), new String[0]);
        }
        try {
            if (configFile != null && configFile.equals(this.file) || configFile == null && this.file == null || this.file != null && configFile != null && configFile.getCanonicalPath().equals(this.file.getCanonicalPath())) {
                return;
            }
        }
        catch (IOException iOException) {}
        this.file = configFile;
        this.document = null;
        this.fileModified = this.file != null ? this.file.lastModified() : -1L;
        this.notifyChanged();
    }

    protected void loadDocIfNeeded() throws GenuitecCoreException {
        if (this.file != null) {
            if (this.document == null || this.file.lastModified() != this.fileModified) {
                try {
                    this.document = this.docBuilder.parse(this.file);
                    this.fileModified = this.file.lastModified();
                    this.notifyChanged();
                }
                catch (Exception e) {
                    this.fileModified = -1L;
                    throw new GenuitecCoreException((Plugin)ServerCorePlugin.getDefault(), (Throwable)e);
                }
            }
        } else {
            this.fileModified = -1L;
            throw new GenuitecCoreException("No config file specified", (Plugin)ServerCorePlugin.getDefault(), new String[0]);
        }
    }

    protected final Document getDocument() throws GenuitecCoreException {
        this.loadDocIfNeeded();
        return this.document;
    }

    public void addFileChangeListener(IFileChangedListener listener) {
        this.addListenerObject(listener);
    }

    public void removeFileChangeListener(IFileChangedListener listener) {
        this.removeListenerObject(listener);
    }

    public boolean loaded() {
        try {
            this.loadDocIfNeeded();
        }
        catch (GenuitecCoreException genuitecCoreException) {
            return false;
        }
        return this.file != null && this.document != null;
    }

    protected void notifyChanged() {
        Object[] objectArray = this.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            final IFileChangedListener lsnr = (IFileChangedListener)listener;
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    lsnr.fileChanged(XMLConfigFile.this);
                }

                public void handleException(Throwable ex) {
                    ServerCorePlugin.getDefault().log(ex);
                }
            });
            ++n2;
        }
    }

    public boolean checkForModifications() {
        if (this.file != null && this.file.lastModified() != this.fileModified) {
            this.document = null;
            this.fileModified = this.file.lastModified();
            this.notifyChanged();
            return true;
        }
        return false;
    }

    protected void save() throws GenuitecCoreException {
        if (this.document == null) {
            return;
        }
        NodeList nodes = this.document.getChildNodes();
        int i = 0;
        int n = nodes.getLength();
        while (i < n) {
            Node node = nodes.item(i);
            if (node == null || node.getNodeType() != 3 || node.getNodeValue().trim().length() != 0) break;
            this.document.removeChild(node);
            ++i;
        }
        this.addXmlProcessingInstruction();
        try {
            FileUtils.copyFile((File)this.file, (File)new File(this.file.getParentFile(), String.valueOf(this.file.getName()) + ".bak"));
        }
        catch (IOException ex) {
            throw new GenuitecCoreException("Error creating server.xml.bak", (Plugin)ServerCorePlugin.getDefault(), (Throwable)ex, new Object[0]);
        }
        StreamResult streamResult = new StreamResult(this.file.getAbsolutePath());
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new DOMSource(this.document), streamResult);
            this.fileModified = this.file.lastModified();
        }
        catch (TransformerException ex) {
            throw new GenuitecCoreException((Plugin)ServerCorePlugin.getDefault(), (Throwable)ex);
        }
    }

    protected Node getNode(String xPathExpr) throws GenuitecCoreException {
        return (Node)this.evaluateXPath(xPathExpr, XPathConstants.NODE);
    }

    protected NodeList getNodeList(String xPathExpr) throws GenuitecCoreException {
        return (NodeList)this.evaluateXPath(xPathExpr, XPathConstants.NODESET);
    }

    protected Boolean getBoolean(String xPathExpr) throws GenuitecCoreException {
        return (Boolean)this.evaluateXPath(xPathExpr, XPathConstants.BOOLEAN);
    }

    protected Double getDouble(String xPathExpr) throws GenuitecCoreException {
        return (Double)this.evaluateXPath(xPathExpr, XPathConstants.NUMBER);
    }

    protected String getString(String xPathExpr) throws GenuitecCoreException {
        return (String)this.evaluateXPath(xPathExpr, XPathConstants.STRING);
    }

    private Object evaluateXPath(String xPathExpr, QName type) throws GenuitecCoreException {
        this.loadDocIfNeeded();
        try {
            return this.xPath.evaluate(xPathExpr, this.document, type);
        }
        catch (XPathExpressionException ex) {
            throw new GenuitecCoreException((Plugin)ServerCorePlugin.getDefault(), (Throwable)ex);
        }
    }

    private void addXmlProcessingInstruction() {
        NodeList nodes = this.document.getChildNodes();
        int i = 0;
        int n = nodes.getLength();
        while (i < n) {
            ProcessingInstruction pi;
            Node node = nodes.item(i);
            if (node.getNodeType() == 7 && (pi = (ProcessingInstruction)node).getTarget().equals(PI_XML_TARGET)) {
                pi.setData(PI_XML_DATA);
                return;
            }
            ++i;
        }
        ProcessingInstruction pi = this.document.createProcessingInstruction(PI_XML_TARGET, PI_XML_DATA);
        this.document.insertBefore(pi, this.document.getFirstChild());
    }

    public static interface IFileChangedListener {
        public void fileChanged(XMLConfigFile var1);
    }
}

