/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.meexplorer.breadcrumb.e4;

import com.genuitec.eclipse.core.ui.util.SafeUIJob;
import com.genuitec.eclipse.meexplorer.MEExplorerPlugin;
import com.genuitec.eclipse.meexplorer.breadcrumb.ToggleBreadCrumbCommandHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.osgi.service.prefs.BackingStoreException;

public final class BreadCrumbModelManager {
    public static final String BREADCRUMB_TOOLCONTROL_ID = "breadcrumb.toolcontrol";
    private static final String TOOLBAR_CONTROL_CONTRIBUTIONURI = "bundleclass://com.genuitec.eclipse.meexplorer/com.genuitec.eclipse.meexplorer.breadcrumb.e4.BreadCrumbContainer";
    private static BreadCrumbModelManager instance = null;
    private static final String BREADCRUMB_VISIBLE_TAG = "breadcrumb_visible_tag";
    private static final String BC_SHOWDEFAULT_KEY = "breadcrumb.show.default";

    private BreadCrumbModelManager() {
        new SafeUIJob("Init breadcrumb"){
            {
                this.setSystem(true);
            }

            protected IStatus runSafelyInUIThread(IProgressMonitor monitor) {
                PlatformUI.getWorkbench().addWindowListener(new IWindowListener(){

                    public void windowOpened(IWorkbenchWindow window) {
                        BreadCrumbModelManager.this.initBreadcrumb((WorkbenchWindow)window);
                    }

                    public void windowDeactivated(IWorkbenchWindow window) {
                    }

                    public void windowClosed(IWorkbenchWindow window) {
                    }

                    public void windowActivated(IWorkbenchWindow window) {
                    }
                });
                IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
                int n = iWorkbenchWindowArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                    BreadCrumbModelManager.this.initBreadcrumb((WorkbenchWindow)window);
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public static synchronized BreadCrumbModelManager getInstance() {
        if (instance == null) {
            instance = new BreadCrumbModelManager();
        }
        return instance;
    }

    protected void initBreadcrumb(WorkbenchWindow window) {
        MWindow mWindow = window.getModel();
        if (!(mWindow instanceof MTrimmedWindow)) {
            return;
        }
        boolean wasVisible = false;
        for (MTrimBar mTrimBar : ((MTrimmedWindow)mWindow).getTrimBars()) {
            if (!"BreadCrumbTrim".equals(mTrimBar.getElementId())) continue;
            wasVisible = mTrimBar.getTags().contains(BREADCRUMB_VISIBLE_TAG);
            mTrimBar.getChildren().clear();
            ((MTrimmedWindow)mWindow).getTrimBars().remove(mTrimBar);
            break;
        }
        MToolControl breadcrumb = this.getBreadCrumbControlModel(window, true);
        if (wasVisible) {
            breadcrumb.getTags().add(BREADCRUMB_VISIBLE_TAG);
            ToggleBreadCrumbCommandHandler.refresh(window);
        }
    }

    public MToolControl getBreadCrumbControlModel(WorkbenchWindow activeWorkbenchWindow, boolean createIfNeeded) {
        MTrimBar topTrim = activeWorkbenchWindow.getTopTrim();
        EModelService modelService = (EModelService)activeWorkbenchWindow.getService(EModelService.class);
        MWindow trimwindow = modelService.getTopLevelWindowFor((MUIElement)topTrim);
        if (trimwindow instanceof MTrimmedWindow) {
            MTrimBar parent = null;
            for (MTrimBar mTrimBar : ((MTrimmedWindow)trimwindow).getTrimBars()) {
                if (!"org.eclipse.ui.main.toolbar".equals(mTrimBar.getElementId())) continue;
                parent = mTrimBar;
                break;
            }
            if (parent == null) {
                return null;
            }
            for (MTrimElement element : parent.getChildren()) {
                if (!(element instanceof MToolControl) || !BREADCRUMB_TOOLCONTROL_ID.equals(((MToolControl)element).getElementId())) continue;
                return (MToolControl)element;
            }
            if (createIfNeeded) {
                try {
                    MToolControl mToolControl = this.createBreadCrumbModel(parent, modelService);
                    return mToolControl;
                }
                finally {
                    ToggleBreadCrumbCommandHandler.refresh(activeWorkbenchWindow);
                }
            }
        }
        return null;
    }

    private MToolControl createBreadCrumbModel(MTrimBar parent, EModelService modelService) {
        MToolControl toolControlElement = (MToolControl)modelService.createModelElement(MToolControl.class);
        toolControlElement.setVisible(true);
        toolControlElement.setElementId(BREADCRUMB_TOOLCONTROL_ID);
        toolControlElement.setContributionURI(TOOLBAR_CONTROL_CONTRIBUTIONURI);
        toolControlElement.setToBeRendered(true);
        if (this.getMEExplorerPrefNode().getBoolean(BC_SHOWDEFAULT_KEY, true)) {
            toolControlElement.getTags().add(BREADCRUMB_VISIBLE_TAG);
        }
        parent.getChildren().add(toolControlElement);
        return toolControlElement;
    }

    public IEclipsePreferences getMEExplorerPrefNode() {
        return ConfigurationScope.INSTANCE.getNode("com.genuitec.eclipse.meexplorer");
    }

    public boolean getIsBreadcrumbVisible(WorkbenchWindow activeWorkbenchWindow) {
        MToolControl trimbar = this.getBreadCrumbControlModel(activeWorkbenchWindow, false);
        return this.getIsBreadcrumbVisible(trimbar);
    }

    public boolean getIsBreadcrumbVisible(MToolControl toolControl) {
        if (toolControl != null) {
            return toolControl.getTags().contains(BREADCRUMB_VISIBLE_TAG);
        }
        return false;
    }

    public void toggleBreadCrumbTagState(WorkbenchWindow activeWorkbenchWindow) {
        boolean hasBreadCrumbTag;
        boolean create;
        MToolControl breadcrumbCtrl = this.getBreadCrumbControlModel(activeWorkbenchWindow, false);
        boolean bl = create = breadcrumbCtrl == null;
        if (create) {
            breadcrumbCtrl = this.getBreadCrumbControlModel(activeWorkbenchWindow, true);
        }
        boolean bl2 = hasBreadCrumbTag = !create && this.getIsBreadcrumbVisible(breadcrumbCtrl);
        if (hasBreadCrumbTag) {
            breadcrumbCtrl.getTags().remove(BREADCRUMB_VISIBLE_TAG);
        } else {
            breadcrumbCtrl.getTags().add(BREADCRUMB_VISIBLE_TAG);
        }
        ((Control)breadcrumbCtrl.getWidget()).getParent().layout(true, true);
        IEclipsePreferences prefs = this.getMEExplorerPrefNode();
        prefs.putBoolean(BC_SHOWDEFAULT_KEY, !hasBreadCrumbTag);
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            MEExplorerPlugin.getDefault().log("Failed while storing preferences for breadcrumb initial visibility state", ex, 4);
        }
        ToggleBreadCrumbCommandHandler.refresh(activeWorkbenchWindow);
    }
}

