/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.meexplorer.navigator.filter;

import java.io.File;
import java.util.ArrayList;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.IWorkingSet;

public class MEFileNameFilter
extends ViewerFilter {
    private TreeSet<String> resultSet;
    private boolean isFolderExcludeFilter;

    public boolean select(Viewer paramViewer, Object parentElement, Object element) {
        if (this.resultSet == null) {
            return true;
        }
        if (element instanceof IWorkingSet) {
            IResource[] projects = this.getProjects(element);
            int i = 0;
            while (i < projects.length) {
                if (this.hasFilteredChildren(projects[i])) {
                    return true;
                }
                ++i;
            }
        } else {
            IResource resource = this.getResource(element);
            if (resource != null) {
                return this.hasFilteredChildren(resource);
            }
        }
        return false;
    }

    private IResource[] getProjects(Object element) {
        IAdaptable[] projects = ((IWorkingSet)element).getElements();
        ArrayList<IResource> resources = new ArrayList<IResource>(projects.length);
        int i = 0;
        while (i < projects.length) {
            IResource resource = (IResource)projects[i].getAdapter(IResource.class);
            if (resource != null) {
                resources.add(resource);
            }
            ++i;
        }
        return resources.toArray(new IResource[resources.size()]);
    }

    private IResource getResource(Object element) {
        if (this.accept(element)) {
            if (element instanceof IJavaElement) {
                return ((IJavaElement)element).getResource();
            }
            return (IResource)element;
        }
        return null;
    }

    private boolean accept(Object element) {
        return element instanceof IResource || element instanceof IJavaElement && (element instanceof IPackageFragmentRoot && !((IPackageFragmentRoot)element).isArchive() || element instanceof IPackageFragment || element instanceof ICompilationUnit);
    }

    private boolean hasFilteredChildren(IResource element) {
        String prevElement;
        String firstElement;
        String resourcePath = String.valueOf(element.getFullPath().toOSString()) + File.separatorChar;
        SortedSet<String> subSet = this.resultSet.tailSet(resourcePath);
        if (subSet.size() > 0 && (firstElement = subSet.first()).startsWith(resourcePath)) {
            return true;
        }
        return !this.isFolderExcludeFilter && (prevElement = this.resultSet.lower(resourcePath)) != null && resourcePath.startsWith(prevElement);
    }

    public void setResultSet(TreeSet<String> resultSet) {
        this.resultSet = resultSet;
    }

    public void setFolderExcludeFilterState(boolean isFolderExcludeFilter) {
        this.isFolderExcludeFilter = isFolderExcludeFilter;
    }
}

