/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class StringQuoteUtil {
    private static final char SQUO = '\'';
    private static final char DQUO = '\"';
    private static final char ESCC = '\\';
    private static final char NILL = '\u0000';
    protected static final String _winPathBugVal = "C:\\windows\\Documents, and, Stuff\\";
    protected static final String _winPathFixedVal = "C:\\windows\\Documents, and, Stuff";
    protected static final String _winPathQuotedBugVal = "\"C:\\windows\\Documents, and, Stuff\\\"";
    protected static final String[] _testCleanVal = new String[]{"C:\\windows\\Documents, and, Stuff", "C:\\windows\\Documents, and, Stuff\\jre.exe"};
    protected static final String[] _testCmdLine = new String[]{"-Dababa=2222", "-Dlala=C:\\windows\\Documents, and, Stuff", "-DresponseString.0=yes", "-DwinPath=c:\\windows\\Documents, and Stuff\\java.exe", "-DexecString=/bin/sh {1} {0} {2}"};
    protected static final String[] _testPropVal = new String[]{"C:\\windows\\Documents, and, Stuff", "-Dlala=C:\\windows\\Documents, and, Stuff", "C:\\windows\\Documents, and, Stuff\\jre.exe"};
    protected static final String[] _testPropValQuoted = new String[]{"\"C:\\windows\\Documents, and, Stuff\"", "\"-Dlala=C:\\windows\\Documents, and, Stuff\"", "\"C:\\windows\\Documents, and, Stuff\\jre.exe\""};
    protected static final String _testJvmArgs = "-DplatformVersion=1.5 -DresponseString.0=yes -Dverbose=true -DinstallerEntry=jre.dat \"-DexecString=/bin/sh {1} {0} {2}\" -DjavaPath=jre1.5.0_11/bin/java -DlicenseEntry=LICENSE \"-DwaitString.0=[yes or no]\" -DinstallerLocation=javaws-1_0_1-j2re-1_5_0_11-data-linux-i586.jar -DjavaVersion=1.5.0_11 -DisSolarisInstall=yes \"-DwinPath=c:\\windows\\Documents, and Stuff\\java.exe\"";
    protected static final String _testJvmArgsQuoted = "\"-DplatformVersion=1.5 -DresponseString.0=yes -Dverbose=true -DinstallerEntry=jre.dat \\\"-DexecString=/bin/sh {1} {0} {2}\\\" -DjavaPath=jre1.5.0_11/bin/java -DlicenseEntry=LICENSE \\\"-DwaitString.0=[yes or no]\\\" -DinstallerLocation=javaws-1_0_1-j2re-1_5_0_11-data-linux-i586.jar -DjavaVersion=1.5.0_11 -DisSolarisInstall=yes \\\"-DwinPath=c:\\windows\\Documents, and Stuff\\java.exe\\\"\"";
    protected static final String _testJvmArgsUnix = "-DplatformVersion=1.5 -DresponseString.0=yes -Dverbose=true -DinstallerEntry=jre.dat -DexecString=\"/bin/sh {1} {0} {2}\" -DjavaPath=jre1.5.0_11/bin/java -DlicenseEntry=LICENSE -DwaitString.0=\"[yes or no]\" -DinstallerLocation=javaws-1_0_1-j2re-1_5_0_11-data-linux-i586.jar -DjavaVersion=1.5.0_11 -DisSolarisInstall=yes -DwinPath=\"c:\\windows\\Documents, and Stuff\\java.exe\"";
    protected static final String _testJvmArgsUnixQuoted = "\"-DplatformVersion=1.5 -DresponseString.0=yes -Dverbose=true -DinstallerEntry=jre.dat -DexecString=\\\"/bin/sh {1} {0} {2}\\\" -DjavaPath=jre1.5.0_11/bin/java -DlicenseEntry=LICENSE -DwaitString.0=\\\"[yes or no]\\\" -DinstallerLocation=javaws-1_0_1-j2re-1_5_0_11-data-linux-i586.jar -DjavaVersion=1.5.0_11 -DisSolarisInstall=yes -DwinPath=\\\"c:\\windows\\Documents, and Stuff\\java.exe\\\"\"";

    public static List parseCommandLine(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = null;
        char c = '\u0000';
        boolean bl = false;
        boolean bl2 = false;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (bl2) {
                if (bl) {
                    stringBuffer.append(c2);
                    bl = false;
                } else if (c == '\u0000') {
                    if (StringQuoteUtil.isWhiteSpace(c2)) {
                        bl2 = false;
                    } else if (c2 == '\'' || c2 == '\"') {
                        c = c2;
                        stringBuffer.append(c2);
                    } else {
                        stringBuffer.append(c2);
                    }
                } else if (c2 == c && (i + 1 == n || StringQuoteUtil.isWhiteSpace(string.charAt(i + 1)))) {
                    stringBuffer.append(c2);
                    c = '\u0000';
                } else {
                    stringBuffer.append(c2);
                }
                if (!bl2 || i == n - 1) {
                    arrayList.add(StringQuoteUtil.unquoteIfNeeded(stringBuffer.toString()));
                    bl2 = false;
                    stringBuffer = null;
                    continue;
                }
                if (c2 != '\\') continue;
                bl = true;
                continue;
            }
            if (StringQuoteUtil.isWhiteSpace(c2)) continue;
            bl2 = true;
            stringBuffer = new StringBuffer();
            --i;
        }
        Trace.println(" --- parseCommandLine converted : " + string + "\ninto:\n" + arrayList, TraceLevel.SECURITY);
        return arrayList;
    }

    public static String getStringByCommandList(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (bl) {
                stringBuffer.append(" ");
            } else {
                bl = true;
            }
            String string = (String)iterator.next();
            stringBuffer.append(StringQuoteUtil.quoteIfNeeded(string));
        }
        return stringBuffer.toString();
    }

    public static String quoteIfNeeded(String string) {
        if (string == null) {
            return null;
        }
        if (StringQuoteUtil.containsWhiteSpace(string) && !StringQuoteUtil.isQuoted(string)) {
            if (StringQuoteUtil.containsUnescaped(string, '\"')) {
                return "\"" + StringQuoteUtil.escapeInstances(string, '\"') + "\"";
            }
            return "\"" + string + "\"";
        }
        return string;
    }

    public static String unquoteIfNeeded(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (StringQuoteUtil.isQuoted(string)) {
            return StringQuoteUtil.unescapeInstances(string.substring(1, n - 1), string.charAt(0));
        }
        return string;
    }

    private static boolean containsWhiteSpace(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (!StringQuoteUtil.isWhiteSpace(string.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean isQuoted(String string) {
        int n = string.length() - 1;
        if (n < 1) {
            return false;
        }
        return (string.charAt(0) == '\"' && string.charAt(n) == '\"' || string.charAt(0) == '\'' && string.charAt(n) == '\'') && !StringQuoteUtil.containsUnescaped(string.substring(1, n), string.charAt(0));
    }

    private static boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\f';
    }

    private static boolean containsUnescaped(String string, char c) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\\') {
                ++i;
                continue;
            }
            if (string.charAt(i) != c) continue;
            return true;
        }
        return false;
    }

    private static String escapeInstances(String string, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\\') {
                stringBuffer.append(string.charAt(i++));
                if (i >= string.length()) continue;
                stringBuffer.append(string.charAt(i));
                continue;
            }
            if (string.charAt(i) == c) {
                stringBuffer.append('\\');
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    private static String unescapeInstances(String string, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (i != n - 1 && string.charAt(i) == '\\' && string.charAt(i + 1) == c) continue;
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        System.exit(StringQuoteUtil.test() ? 0 : 1);
    }

    protected static boolean test() {
        String string;
        int n;
        int n2;
        List list;
        int n3;
        String string2 = "-Djnlpx.vmargs=-DplatformVersion=1.5 -DresponseString.0=yes -Dverbose=true -DinstallerEntry=jre.dat \"-DexecString=/bin/sh {1} {0} {2}\" -DjavaPath=jre1.5.0_11/bin/java -DlicenseEntry=LICENSE \"-DwaitString.0=[yes or no]\" -DinstallerLocation=javaws-1_0_1-j2re-1_5_0_11-data-linux-i586.jar -DjavaVersion=1.5.0_11 -DisSolarisInstall=yes \"-DwinPath=c:\\windows\\Documents, and Stuff\\java.exe\"";
        String string3 = StringQuoteUtil.quoteIfNeeded(string2) + " " + _testJvmArgs;
        boolean bl = true;
        String string4 = StringQuoteUtil.unquoteIfNeeded(StringQuoteUtil.quoteIfNeeded(_winPathBugVal));
        if (string4.equals(_winPathFixedVal)) {
            System.out.println("Test 0.0 passed");
        } else {
            System.out.println("Test 0.0 FAILED");
            System.out.println("\t orig     : <C:\\windows\\Documents, and, Stuff\\>");
            System.out.println("\t expected : <C:\\windows\\Documents, and, Stuff>");
            System.out.println("\t result   : <" + string4 + ">");
        }
        string4 = StringQuoteUtil.unquoteIfNeeded(_winPathBugVal);
        if (string4.equals(_winPathFixedVal)) {
            System.out.println("Test 0.1 passed");
        } else {
            System.out.println("Test 0.1 FAILED");
            System.out.println("\t orig     : <C:\\windows\\Documents, and, Stuff\\>");
            System.out.println("\t expected : <C:\\windows\\Documents, and, Stuff>");
            System.out.println("\t result   : <" + string4 + ">");
        }
        string4 = StringQuoteUtil.unquoteIfNeeded(_winPathQuotedBugVal);
        if (string4.equals(_winPathFixedVal)) {
            System.out.println("Test 0.2 passed");
        } else {
            System.out.println("Test 0.2 FAILED");
            System.out.println("\t orig     : <\"C:\\windows\\Documents, and, Stuff\\\">");
            System.out.println("\t expected : <C:\\windows\\Documents, and, Stuff>");
            System.out.println("\t result   : <" + string4 + ">");
        }
        for (n3 = 0; n3 < _testCleanVal.length; ++n3) {
            string4 = StringQuoteUtil.unquoteIfNeeded(_testCleanVal[n3]);
            if (string4.equals(_testCleanVal[n3])) {
                System.out.println("Test 1." + n3 + " passed");
                continue;
            }
            System.out.println("Test 1." + n3 + " FAILED");
            System.out.println("\t expected : <" + _testCleanVal[n3] + ">");
            System.out.println("\t result   : <" + string4 + ">");
            bl = false;
        }
        for (n3 = 0; n3 < _testPropVal.length; ++n3) {
            string4 = StringQuoteUtil.quoteIfNeeded(_testPropVal[n3]);
            if (string4.equals(_testPropValQuoted[n3])) {
                System.out.println("Test 2." + n3 + ".0 passed");
            } else {
                System.out.println("Test 2." + n3 + ".0 FAILED");
                System.out.println("\t orig     : <" + _testPropVal[n3] + ">");
                System.out.println("\t expected : <" + _testPropValQuoted[n3] + ">");
                System.out.println("\t result   : <" + string4 + ">");
                bl = false;
            }
            string4 = StringQuoteUtil.unquoteIfNeeded(_testPropValQuoted[n3]);
            if (string4.equals(_testPropVal[n3])) {
                System.out.println("Test 2." + n3 + ".1 passed");
                continue;
            }
            System.out.println("Test 2." + n3 + ".1 FAILED");
            System.out.println("\t orig     : <" + _testPropValQuoted[n3] + ">");
            System.out.println("\t expected : <" + _testPropVal[n3] + ">");
            System.out.println("\t result   : <" + string4 + ">");
            bl = false;
        }
        string4 = StringQuoteUtil.quoteIfNeeded(_testJvmArgs);
        if (string4.equals(_testJvmArgsQuoted)) {
            System.out.println("Test 3.1 passed");
        } else {
            System.out.println("Test 3.1 FAILED");
            System.out.println("\t orig     : <-DplatformVersion=1.5 -DresponseString.0=yes -Dverbose=true -DinstallerEntry=jre.dat \"-DexecString=/bin/sh {1} {0} {2}\" -DjavaPath=jre1.5.0_11/bin/java -DlicenseEntry=LICENSE \"-DwaitString.0=[yes or no]\" -DinstallerLocation=javaws-1_0_1-j2re-1_5_0_11-data-linux-i586.jar -DjavaVersion=1.5.0_11 -DisSolarisInstall=yes \"-DwinPath=c:\\windows\\Documents, and Stuff\\java.exe\">");
            System.out.println("\t expected : <\"-DplatformVersion=1.5 -DresponseString.0=yes -Dverbose=true -DinstallerEntry=jre.dat \\\"-DexecString=/bin/sh {1} {0} {2}\\\" -DjavaPath=jre1.5.0_11/bin/java -DlicenseEntry=LICENSE \\\"-DwaitString.0=[yes or no]\\\" -DinstallerLocation=javaws-1_0_1-j2re-1_5_0_11-data-linux-i586.jar -DjavaVersion=1.5.0_11 -DisSolarisInstall=yes \\\"-DwinPath=c:\\windows\\Documents, and Stuff\\java.exe\\\"\">");
            System.out.println("\t result   : <" + string4 + ">");
            bl = false;
        }
        string4 = StringQuoteUtil.unquoteIfNeeded(_testJvmArgsQuoted);
        if (string4.equals(_testJvmArgs)) {
            System.out.println("Test 3.2 passed");
        } else {
            System.out.println("Test 3.2 FAILED");
            System.out.println("\t orig     : <\"-DplatformVersion=1.5 -DresponseString.0=yes -Dverbose=true -DinstallerEntry=jre.dat \\\"-DexecString=/bin/sh {1} {0} {2}\\\" -DjavaPath=jre1.5.0_11/bin/java -DlicenseEntry=LICENSE \\\"-DwaitString.0=[yes or no]\\\" -DinstallerLocation=javaws-1_0_1-j2re-1_5_0_11-data-linux-i586.jar -DjavaVersion=1.5.0_11 -DisSolarisInstall=yes \\\"-DwinPath=c:\\windows\\Documents, and Stuff\\java.exe\\\"\">");
            System.out.println("\t expected : <-DplatformVersion=1.5 -DresponseString.0=yes -Dverbose=true -DinstallerEntry=jre.dat \"-DexecString=/bin/sh {1} {0} {2}\" -DjavaPath=jre1.5.0_11/bin/java -DlicenseEntry=LICENSE \"-DwaitString.0=[yes or no]\" -DinstallerLocation=javaws-1_0_1-j2re-1_5_0_11-data-linux-i586.jar -DjavaVersion=1.5.0_11 -DisSolarisInstall=yes \"-DwinPath=c:\\windows\\Documents, and Stuff\\java.exe\">");
            System.out.println("\t result   : <" + string4 + ">");
            bl = false;
        }
        string4 = StringQuoteUtil.quoteIfNeeded(_testJvmArgsUnix);
        if (string4.equals(_testJvmArgsUnixQuoted)) {
            System.out.println("Test 3.3 passed");
        } else {
            System.out.println("Test 3.3 FAILED");
            System.out.println("\t orig     : <-DplatformVersion=1.5 -DresponseString.0=yes -Dverbose=true -DinstallerEntry=jre.dat -DexecString=\"/bin/sh {1} {0} {2}\" -DjavaPath=jre1.5.0_11/bin/java -DlicenseEntry=LICENSE -DwaitString.0=\"[yes or no]\" -DinstallerLocation=javaws-1_0_1-j2re-1_5_0_11-data-linux-i586.jar -DjavaVersion=1.5.0_11 -DisSolarisInstall=yes -DwinPath=\"c:\\windows\\Documents, and Stuff\\java.exe\">");
            System.out.println("\t expected : <\"-DplatformVersion=1.5 -DresponseString.0=yes -Dverbose=true -DinstallerEntry=jre.dat -DexecString=\\\"/bin/sh {1} {0} {2}\\\" -DjavaPath=jre1.5.0_11/bin/java -DlicenseEntry=LICENSE -DwaitString.0=\\\"[yes or no]\\\" -DinstallerLocation=javaws-1_0_1-j2re-1_5_0_11-data-linux-i586.jar -DjavaVersion=1.5.0_11 -DisSolarisInstall=yes -DwinPath=\\\"c:\\windows\\Documents, and Stuff\\java.exe\\\"\">");
            System.out.println("\t result   : <" + string4 + ">");
            bl = false;
        }
        string4 = StringQuoteUtil.unquoteIfNeeded(_testJvmArgsUnixQuoted);
        if (string4.equals(_testJvmArgsUnix)) {
            System.out.println("Test 3.4 passed");
        } else {
            System.out.println("Test 3.4 FAILED");
            System.out.println("\t orig     : <\"-DplatformVersion=1.5 -DresponseString.0=yes -Dverbose=true -DinstallerEntry=jre.dat -DexecString=\\\"/bin/sh {1} {0} {2}\\\" -DjavaPath=jre1.5.0_11/bin/java -DlicenseEntry=LICENSE -DwaitString.0=\\\"[yes or no]\\\" -DinstallerLocation=javaws-1_0_1-j2re-1_5_0_11-data-linux-i586.jar -DjavaVersion=1.5.0_11 -DisSolarisInstall=yes -DwinPath=\\\"c:\\windows\\Documents, and Stuff\\java.exe\\\"\">");
            System.out.println("\t expected : <-DplatformVersion=1.5 -DresponseString.0=yes -Dverbose=true -DinstallerEntry=jre.dat -DexecString=\"/bin/sh {1} {0} {2}\" -DjavaPath=jre1.5.0_11/bin/java -DlicenseEntry=LICENSE -DwaitString.0=\"[yes or no]\" -DinstallerLocation=javaws-1_0_1-j2re-1_5_0_11-data-linux-i586.jar -DjavaVersion=1.5.0_11 -DisSolarisInstall=yes -DwinPath=\"c:\\windows\\Documents, and Stuff\\java.exe\">");
            System.out.println("\t result   : <" + string4 + ">");
            bl = false;
        }
        string4 = StringQuoteUtil.unquoteIfNeeded("\"-Dlala=li li\" -Dlulu=\"da da\"");
        if (string4.equals("\"-Dlala=li li\" -Dlulu=\"da da\"")) {
            System.out.println("Test 3.5 passed");
        } else {
            System.out.println("Test 3.5 FAILED");
            System.out.println("\t expected : <\"-Dlala=li li\" -Dlulu=\"da da\">");
            System.out.println("\t result   : <" + string4 + ">");
            bl = false;
        }
        for (int i = 0; i < _testCmdLine.length; ++i) {
            list = StringQuoteUtil.parseCommandLine(StringQuoteUtil.quoteIfNeeded(_testCmdLine[i]));
            if (list.size() == 1 && _testCmdLine[i].equals((String)list.get(0))) {
                System.out.println("Test 4.0." + i + " passed");
                continue;
            }
            System.out.println("Test 4.0." + i + " FAILED");
            if (list.size() != 1) {
                System.out.println("\t input : <" + _testCmdLine[i] + ">");
                System.out.println("\t cmdline number not 1, is " + list.size());
                for (n2 = 0; n2 < list.size(); ++n2) {
                    System.out.println("\t" + n2 + ": " + (String)list.get(n2));
                }
            } else {
                String string5 = (String)list.get(0);
                System.out.println("\t input : <" + _testCmdLine[i] + ">");
                System.out.println("\t result: <" + string5 + ">");
            }
            bl = false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n2 = 0; n2 < _testCmdLine.length; ++n2) {
            arrayList.add(_testCmdLine[n2]);
        }
        String string6 = StringQuoteUtil.getStringByCommandList(arrayList);
        list = StringQuoteUtil.parseCommandLine(string6);
        int n4 = list.size();
        if (list.size() == _testCmdLine.length) {
            System.out.println("Test 4.1._ passed");
        } else {
            System.out.println("Test 4.1._ failed");
            System.out.println("\t input        : " + string6);
            System.out.println("\t expected size: " + _testCmdLine.length);
            System.out.println("\t argList  size: " + list.size());
            if (_testCmdLine.length < n4) {
                n4 = _testCmdLine.length;
            }
        }
        for (n = 0; n < n4; ++n) {
            if (_testCmdLine[n].equals((String)list.get(n))) {
                System.out.println("Test 4.1." + n + " passed");
                continue;
            }
            System.out.println("Test 4.1." + n + " FAILED");
            string = (String)list.get(n);
            System.out.println("\t expected: <" + _testCmdLine[n] + ">");
            System.out.println("\t result  : <" + string + ">");
            bl = false;
        }
        list = StringQuoteUtil.parseCommandLine(_testJvmArgs);
        if (list.size() == 12) {
            System.out.println("Test 4.2.0 passed");
        } else {
            System.out.println("Test 4.2.0 FAILED");
            System.out.println("\t expected number : 12");
            System.out.println("\t result   number : " + list.size());
            bl = false;
        }
        for (n = 0; n < list.size(); ++n) {
            string = (String)list.get(n);
            System.out.println("Test 4.2." + (n + 1) + " result : <" + string + ">");
        }
        list = StringQuoteUtil.parseCommandLine(_testJvmArgsUnix);
        if (list.size() == 12) {
            System.out.println("Test 4.3.0 passed");
        } else {
            System.out.println("Test 4.3.0 FAILED");
            System.out.println("\t expected number : 12");
            System.out.println("\t result   number : " + list.size());
            bl = false;
        }
        for (n = 0; n < list.size(); ++n) {
            string = (String)list.get(n);
            System.out.println("Test 4.3." + (n + 1) + " result : <" + string + ">");
        }
        list = StringQuoteUtil.parseCommandLine(string3);
        if (list.size() == 13) {
            System.out.println("Test 4.4.0 passed");
        } else {
            System.out.println("Test 4.4.0 FAILED");
            System.out.println("\t expected number : 13");
            System.out.println("\t result   number : " + list.size());
            bl = false;
        }
        block11: for (n = 0; n < list.size(); ++n) {
            string = (String)list.get(n);
            switch (n) {
                case 0: {
                    if (string.equals(string2)) {
                        System.out.println("Test 4.4.1 passed");
                        continue block11;
                    }
                    System.out.println("Test 4.4.1 FAILED");
                    System.out.println("\t expected : <" + string2 + ">");
                    System.out.println("\t result   : <" + string + ">");
                    bl = false;
                    continue block11;
                }
                default: {
                    System.out.println("Test 4.4." + (n + 1) + " result : <" + string + ">");
                }
            }
        }
        return bl;
    }
}

