/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.fastinfoset.util;

import com.sun.xml.internal.fastinfoset.CommonResourceBundle;
import com.sun.xml.internal.fastinfoset.util.CharArray;
import com.sun.xml.internal.fastinfoset.util.KeyIntMap;

public class CharArrayIntMap
extends KeyIntMap {
    private CharArrayIntMap _readOnlyMap;
    protected int _totalCharacterCount;
    private Entry[] _table;

    public CharArrayIntMap(int n, float f) {
        super(n, f);
        this._table = new Entry[this._capacity];
    }

    public CharArrayIntMap(int n) {
        this(n, 0.75f);
    }

    public CharArrayIntMap() {
        this(16, 0.75f);
    }

    public final void clear() {
        for (int i = 0; i < this._table.length; ++i) {
            this._table[i] = null;
        }
        this._size = 0;
        this._totalCharacterCount = 0;
    }

    public final void setReadOnlyMap(KeyIntMap keyIntMap, boolean bl) {
        if (!(keyIntMap instanceof CharArrayIntMap)) {
            throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.illegalClass", new Object[]{keyIntMap}));
        }
        this.setReadOnlyMap((CharArrayIntMap)keyIntMap, bl);
    }

    public final void setReadOnlyMap(CharArrayIntMap charArrayIntMap, boolean bl) {
        this._readOnlyMap = charArrayIntMap;
        if (this._readOnlyMap != null) {
            this._readOnlyMapSize = this._readOnlyMap.size();
            if (bl) {
                this.clear();
            }
        } else {
            this._readOnlyMapSize = 0;
        }
    }

    public final int get(char[] cArray, int n, int n2) {
        int n3 = CharArrayIntMap.hashHash(CharArray.hashCode(cArray, n, n2));
        return this.get(cArray, n, n2, n3);
    }

    public final int obtainIndex(char[] object, int n, int n2, boolean bl) {
        int n3;
        int n4 = CharArrayIntMap.hashHash(CharArray.hashCode(object, n, n2));
        if (this._readOnlyMap != null && (n3 = this._readOnlyMap.get((char[])object, n, n2, n4)) != -1) {
            return n3;
        }
        n3 = CharArrayIntMap.indexFor(n4, this._table.length);
        Object object2 = this._table[n3];
        while (object2 != null) {
            if (((Entry)object2)._hash == n4 && ((Entry)object2).equalsCharArray((char[])object, n, n2)) {
                return ((Entry)object2)._value;
            }
            object2 = ((Entry)object2)._next;
        }
        if (bl) {
            object2 = new char[n2];
            System.arraycopy(object, n, object2, 0, n2);
            object = object2;
            n = 0;
        }
        this.addEntry((char[])object, n, n2, n4, this._size + this._readOnlyMapSize, n3);
        return -1;
    }

    public final int getTotalCharacterCount() {
        return this._totalCharacterCount;
    }

    private final int get(char[] cArray, int n, int n2, int n3) {
        int n4;
        if (this._readOnlyMap != null && (n4 = this._readOnlyMap.get(cArray, n, n2, n3)) != -1) {
            return n4;
        }
        n4 = CharArrayIntMap.indexFor(n3, this._table.length);
        Entry entry = this._table[n4];
        while (entry != null) {
            if (entry._hash == n3 && entry.equalsCharArray(cArray, n, n2)) {
                return entry._value;
            }
            entry = entry._next;
        }
        return -1;
    }

    private final void addEntry(char[] cArray, int n, int n2, int n3, int n4, int n5) {
        Entry entry = this._table[n5];
        this._table[n5] = new Entry(cArray, n, n2, n3, n4, entry);
        this._totalCharacterCount += n2;
        if (this._size++ >= this._threshold) {
            this.resize(2 * this._table.length);
        }
    }

    private final void resize(int n) {
        this._capacity = n;
        Entry[] entryArray = this._table;
        int n2 = entryArray.length;
        if (n2 == 0x100000) {
            this._threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] entryArray2 = new Entry[this._capacity];
        this.transfer(entryArray2);
        this._table = entryArray2;
        this._threshold = (int)((float)this._capacity * this._loadFactor);
    }

    private final void transfer(Entry[] entryArray) {
        Entry[] entryArray2 = this._table;
        int n = entryArray.length;
        for (int i = 0; i < entryArray2.length; ++i) {
            Entry entry;
            Entry entry2 = entryArray2[i];
            if (entry2 == null) continue;
            entryArray2[i] = null;
            do {
                entry = entry2._next;
                int n2 = CharArrayIntMap.indexFor(entry2._hash, n);
                entry2._next = entryArray[n2];
                entryArray[n2] = entry2;
            } while ((entry2 = entry) != null);
        }
    }

    static class Entry
    extends KeyIntMap.BaseEntry {
        final char[] _ch;
        final int _start;
        final int _length;
        Entry _next;

        public Entry(char[] cArray, int n, int n2, int n3, int n4, Entry entry) {
            super(n3, n4);
            this._ch = cArray;
            this._start = n;
            this._length = n2;
            this._next = entry;
        }

        public final boolean equalsCharArray(char[] cArray, int n, int n2) {
            if (this._length == n2) {
                int n3 = this._length;
                int n4 = this._start;
                int n5 = n;
                while (n3-- != 0) {
                    if (this._ch[n4++] == cArray[n5++]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

