/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.peer.TrayIconPeer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.EventListener;
import sun.awt.AWTAccessor;
import sun.awt.AppContext;
import sun.awt.SunToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrayIcon {
    private Image image;
    private String tooltip;
    private PopupMenu popup;
    private boolean autosize;
    private int id;
    private String actionCommand;
    private transient TrayIconPeer peer;
    transient MouseListener mouseListener;
    transient MouseMotionListener mouseMotionListener;
    transient ActionListener actionListener;
    private transient Object privateKey = new Object();
    private final AccessControlContext acc = AccessController.getContext();

    final AccessControlContext getAccessControlContext() {
        if (this.acc == null) {
            throw new SecurityException("TrayIcon is missing AccessControlContext");
        }
        return this.acc;
    }

    private TrayIcon() throws UnsupportedOperationException, HeadlessException, SecurityException {
        SystemTray.checkSystemTrayAllowed();
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        if (!SystemTray.isSupported()) {
            throw new UnsupportedOperationException();
        }
        SunToolkit.insertTargetMapping(this, AppContext.getAppContext());
    }

    public TrayIcon(Image image) {
        this();
        if (image == null) {
            throw new IllegalArgumentException("creating TrayIcon with null Image");
        }
        this.setImage(image);
    }

    public TrayIcon(Image image, String string) {
        this(image);
        this.setToolTip(string);
    }

    public TrayIcon(Image image, String string, PopupMenu popupMenu) {
        this(image, string);
        this.setPopupMenu(popupMenu);
    }

    public void setImage(Image image) {
        if (image == null) {
            throw new NullPointerException("setting null Image");
        }
        this.image = image;
        TrayIconPeer trayIconPeer = this.peer;
        if (trayIconPeer != null) {
            trayIconPeer.updateImage();
        }
    }

    public Image getImage() {
        return this.image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPopupMenu(PopupMenu popupMenu) {
        if (popupMenu == this.popup) {
            return;
        }
        Class<TrayIcon> clazz = TrayIcon.class;
        synchronized (TrayIcon.class) {
            if (popupMenu != null) {
                if (popupMenu.isTrayIconPopup) {
                    throw new IllegalArgumentException("the PopupMenu is already set for another TrayIcon");
                }
                popupMenu.isTrayIconPopup = true;
            }
            if (this.popup != null) {
                this.popup.isTrayIconPopup = false;
            }
            this.popup = popupMenu;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public PopupMenu getPopupMenu() {
        return this.popup;
    }

    public void setToolTip(String string) {
        this.tooltip = string;
        TrayIconPeer trayIconPeer = this.peer;
        if (trayIconPeer != null) {
            trayIconPeer.setToolTip(string);
        }
    }

    public String getToolTip() {
        return this.tooltip;
    }

    public void setImageAutoSize(boolean bl) {
        this.autosize = bl;
        TrayIconPeer trayIconPeer = this.peer;
        if (trayIconPeer != null) {
            trayIconPeer.updateImage();
        }
    }

    public boolean isImageAutoSize() {
        return this.autosize;
    }

    public synchronized void addMouseListener(MouseListener mouseListener) {
        if (mouseListener == null) {
            return;
        }
        this.mouseListener = AWTEventMulticaster.add(this.mouseListener, mouseListener);
    }

    public synchronized void removeMouseListener(MouseListener mouseListener) {
        if (mouseListener == null) {
            return;
        }
        this.mouseListener = AWTEventMulticaster.remove(this.mouseListener, mouseListener);
    }

    public synchronized MouseListener[] getMouseListeners() {
        return (MouseListener[])this.getListeners(MouseListener.class);
    }

    public synchronized void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        if (mouseMotionListener == null) {
            return;
        }
        this.mouseMotionListener = AWTEventMulticaster.add(this.mouseMotionListener, mouseMotionListener);
    }

    public synchronized void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        if (mouseMotionListener == null) {
            return;
        }
        this.mouseMotionListener = AWTEventMulticaster.remove(this.mouseMotionListener, mouseMotionListener);
    }

    public synchronized MouseMotionListener[] getMouseMotionListeners() {
        return (MouseMotionListener[])this.getListeners(MouseMotionListener.class);
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        if (actionListener == null) {
            return;
        }
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        if (actionListener == null) {
            return;
        }
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public synchronized ActionListener[] getActionListeners() {
        return (ActionListener[])this.getListeners(ActionListener.class);
    }

    public void displayMessage(String string, String string2, MessageType messageType) {
        if (string == null && string2 == null) {
            throw new NullPointerException("displaying the message with both caption and text being null");
        }
        TrayIconPeer trayIconPeer = this.peer;
        if (trayIconPeer != null) {
            trayIconPeer.displayMessage(string, string2, messageType.toString());
        }
    }

    public Dimension getSize() {
        return SystemTray.getSystemTray().getTrayIconSize();
    }

    <T extends EventListener> T[] getListeners(Class<T> clazz) {
        EventListener eventListener = null;
        if (clazz == MouseListener.class) {
            eventListener = this.mouseListener;
        } else if (clazz == MouseMotionListener.class) {
            eventListener = this.mouseMotionListener;
        } else if (clazz == ActionListener.class) {
            eventListener = this.actionListener;
        }
        return AWTEventMulticaster.getListeners((EventListener)eventListener, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addNotify() throws AWTException {
        TrayIcon trayIcon = this;
        synchronized (trayIcon) {
            if (this.peer == null) {
                this.peer = ((SunToolkit)Toolkit.getDefaultToolkit()).createTrayIcon(this);
            }
        }
        this.peer.setToolTip(this.tooltip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeNotify() {
        TrayIconPeer trayIconPeer = null;
        TrayIcon trayIcon = this;
        synchronized (trayIcon) {
            trayIconPeer = this.peer;
            this.peer = null;
        }
        if (trayIconPeer != null) {
            trayIconPeer.dispose();
        }
    }

    void setID(int n) {
        this.id = n;
    }

    int getID() {
        return this.id;
    }

    void dispatchEvent(AWTEvent aWTEvent) {
        EventQueue.setCurrentEventAndMostRecentTime(aWTEvent);
        Toolkit.getDefaultToolkit().notifyAWTEventListeners(aWTEvent);
        this.processEvent(aWTEvent);
    }

    void processEvent(AWTEvent aWTEvent) {
        block6: {
            block5: {
                if (!(aWTEvent instanceof MouseEvent)) break block5;
                switch (aWTEvent.getID()) {
                    case 500: 
                    case 501: 
                    case 502: {
                        this.processMouseEvent((MouseEvent)aWTEvent);
                        break block6;
                    }
                    case 503: {
                        this.processMouseMotionEvent((MouseEvent)aWTEvent);
                        break block6;
                    }
                    default: {
                        return;
                    }
                }
            }
            if (aWTEvent instanceof ActionEvent) {
                this.processActionEvent((ActionEvent)aWTEvent);
            }
        }
    }

    void processMouseEvent(MouseEvent mouseEvent) {
        MouseListener mouseListener = this.mouseListener;
        TrayIconPeer trayIconPeer = this.peer;
        if (mouseEvent.isPopupTrigger() && trayIconPeer != null) {
            trayIconPeer.showPopupMenu(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
        }
        if (mouseListener != null) {
            int n = mouseEvent.getID();
            switch (n) {
                case 501: {
                    mouseListener.mousePressed(mouseEvent);
                    break;
                }
                case 502: {
                    mouseListener.mouseReleased(mouseEvent);
                    break;
                }
                case 500: {
                    mouseListener.mouseClicked(mouseEvent);
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }

    void processMouseMotionEvent(MouseEvent mouseEvent) {
        MouseMotionListener mouseMotionListener = this.mouseMotionListener;
        if (mouseMotionListener != null && mouseEvent.getID() == 503) {
            mouseMotionListener.mouseMoved(mouseEvent);
        }
    }

    void processActionEvent(ActionEvent actionEvent) {
        ActionListener actionListener = this.actionListener;
        if (actionListener != null) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    private static native void initIDs();

    static {
        AWTAccessor.setTrayIconAccessor(new AWTAccessor.TrayIconAccessor(){

            public Object getPrivateKey(TrayIcon trayIcon) {
                return trayIcon.privateKey;
            }

            public void addNotify(TrayIcon trayIcon) throws AWTException {
                trayIcon.addNotify();
            }

            public void removeNotify(TrayIcon trayIcon) {
                trayIcon.removeNotify();
            }
        });
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            TrayIcon.initIDs();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MessageType {
        ERROR,
        WARNING,
        INFO,
        NONE;

    }
}

