/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.IOException;
import java.math.BigInteger;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Config;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbCryptoException;
import sun.security.krb5.internal.KdcErrException;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.crypto.CksumType;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class Checksum {
    private int cksumType;
    private byte[] checksum;
    public static final int CKSUMTYPE_NULL = 0;
    public static final int CKSUMTYPE_CRC32 = 1;
    public static final int CKSUMTYPE_RSA_MD4 = 2;
    public static final int CKSUMTYPE_RSA_MD4_DES = 3;
    public static final int CKSUMTYPE_DES_MAC = 4;
    public static final int CKSUMTYPE_DES_MAC_K = 5;
    public static final int CKSUMTYPE_RSA_MD4_DES_K = 6;
    public static final int CKSUMTYPE_RSA_MD5 = 7;
    public static final int CKSUMTYPE_RSA_MD5_DES = 8;
    public static final int CKSUMTYPE_HMAC_SHA1_DES3_KD = 12;
    public static final int CKSUMTYPE_HMAC_SHA1_96_AES128 = 15;
    public static final int CKSUMTYPE_HMAC_SHA1_96_AES256 = 16;
    public static final int CKSUMTYPE_HMAC_MD5_ARCFOUR = -138;
    static int CKSUMTYPE_DEFAULT;
    static int SAFECKSUMTYPE_DEFAULT;
    private static boolean DEBUG;

    public Checksum(byte[] byArray, int n) {
        this.cksumType = n;
        this.checksum = byArray;
    }

    public Checksum(int n, byte[] byArray) throws KdcErrException, KrbCryptoException {
        this.cksumType = n;
        CksumType cksumType = CksumType.getInstance(this.cksumType);
        if (cksumType.isSafe()) {
            throw new KdcErrException(50);
        }
        this.checksum = cksumType.calculateChecksum(byArray, byArray.length);
    }

    public Checksum(int n, byte[] byArray, EncryptionKey encryptionKey, int n2) throws KdcErrException, KrbApErrException, KrbCryptoException {
        this.cksumType = n;
        CksumType cksumType = CksumType.getInstance(this.cksumType);
        if (!cksumType.isSafe()) {
            throw new KrbApErrException(50);
        }
        this.checksum = cksumType.calculateKeyedChecksum(byArray, byArray.length, encryptionKey.getBytes(), n2);
    }

    public boolean verifyKeyedChecksum(byte[] byArray, EncryptionKey encryptionKey, int n) throws KdcErrException, KrbApErrException, KrbCryptoException {
        CksumType cksumType = CksumType.getInstance(this.cksumType);
        if (!cksumType.isSafe()) {
            throw new KrbApErrException(50);
        }
        return cksumType.verifyKeyedChecksum(byArray, byArray.length, encryptionKey.getBytes(), this.checksum, n);
    }

    boolean isEqual(Checksum checksum) throws KdcErrException {
        if (this.cksumType != checksum.cksumType) {
            return false;
        }
        CksumType cksumType = CksumType.getInstance(this.cksumType);
        return CksumType.isChecksumEqual(this.checksum, checksum.checksum);
    }

    private Checksum(DerValue derValue) throws Asn1Exception, IOException {
        if (derValue.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.cksumType = derValue2.getData().getBigInteger().intValue();
        derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 1) {
            throw new Asn1Exception(906);
        }
        this.checksum = derValue2.getData().getOctetString();
        if (derValue.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(BigInteger.valueOf(this.cksumType));
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOctetString(this.checksum);
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public static Checksum parse(DerInputStream derInputStream, byte by, boolean bl) throws Asn1Exception, IOException {
        if (bl && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new Checksum(derValue2);
    }

    public final byte[] getBytes() {
        return this.checksum;
    }

    public final int getType() {
        return this.cksumType;
    }

    static {
        DEBUG = Krb5.DEBUG;
        String string = null;
        Config config = null;
        try {
            config = Config.getInstance();
            string = config.getDefault("default_checksum", "libdefaults");
            CKSUMTYPE_DEFAULT = string != null ? config.getType(string) : 7;
        }
        catch (Exception exception) {
            if (DEBUG) {
                System.out.println("Exception in getting default checksum value from the configuration Setting default checksum to be RSA-MD5");
                exception.printStackTrace();
            }
            CKSUMTYPE_DEFAULT = 7;
        }
        try {
            string = config.getDefault("safe_checksum_type", "libdefaults");
            SAFECKSUMTYPE_DEFAULT = string != null ? config.getType(string) : 8;
        }
        catch (Exception exception) {
            if (DEBUG) {
                System.out.println("Exception in getting safe default checksum value from the configuration Setting  safe default checksum to be RSA-MD5");
                exception.printStackTrace();
            }
            SAFECKSUMTYPE_DEFAULT = 8;
        }
    }
}

