/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core.util;

import java.math.BigInteger;

public class Base58 {
    public static final String ALPHABET = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz";
    private static final BigInteger A = BigInteger.valueOf(58L);

    public static String encode(byte[] byArray) {
        BigInteger bigInteger = new BigInteger(1, byArray);
        StringBuffer stringBuffer = new StringBuffer();
        while (bigInteger.compareTo(A) >= 0) {
            BigInteger bigInteger2 = bigInteger.mod(A);
            stringBuffer.insert(0, ALPHABET.charAt(bigInteger2.intValue()));
            bigInteger = bigInteger.subtract(bigInteger2).divide(A);
        }
        stringBuffer.insert(0, ALPHABET.charAt(bigInteger.intValue()));
        byte[] byArray2 = byArray;
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte by = byArray2[n2];
            if (by != 0) break;
            stringBuffer.insert(0, ALPHABET.charAt(0));
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static byte[] decode(String string) {
        if (string.length() == 0) {
            return null;
        }
        BigInteger bigInteger = Base58.A(string);
        if (bigInteger == null) {
            return null;
        }
        byte[] byArray = bigInteger.toByteArray();
        boolean bl = byArray.length > 1 && byArray[0] == 0 && byArray[1] < 0;
        int n = 0;
        int n2 = 0;
        while (n2 < string.length() && string.charAt(n2) == ALPHABET.charAt(0)) {
            ++n;
            ++n2;
        }
        byte[] byArray2 = new byte[byArray.length - (bl ? 1 : 0) + n];
        System.arraycopy(byArray, bl ? 1 : 0, byArray2, n, byArray2.length - n);
        return byArray2;
    }

    private static BigInteger A(String string) {
        BigInteger bigInteger = BigInteger.valueOf(0L);
        int n = string.length() - 1;
        while (n >= 0) {
            int n2 = ALPHABET.indexOf(string.charAt(n));
            if (n2 == -1) {
                return null;
            }
            bigInteger = bigInteger.add(BigInteger.valueOf(n2).multiply(A.pow(string.length() - 1 - n)));
            --n;
        }
        return bigInteger;
    }
}

