/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core.util;

import com.genuitec.eclipse.core.util.CustomFileStoreEditorInput;
import com.genuitec.eclipse.core.util.EditorUtil;
import com.genuitec.eclipse.core.util.Messages;
import java.io.File;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.internal.texteditor.NLSUtility;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class TextEditorUtil {
    public static void saveAsExternalFile(TextEditor editor, IEditorInput input, IProgressMonitor progressMonitor) {
        boolean success;
        block18: {
            MessageDialog overwriteDialog;
            File externalFile;
            String MY_DOCUMENTS_GUID = "::{450D8FBA-AD25-11D0-98A8-0800361B1103}";
            Shell shell = editor.getSite().getShell();
            IPreferenceStore store = EditorsUI.getPreferenceStore();
            String key = String.valueOf(editor.getEditorSite().getId()) + ".internal.delegateSaveAs";
            store.setValue(key, true);
            IDocumentProvider provider = editor.getDocumentProvider();
            FileDialog dialog = new FileDialog(shell, 8192);
            dialog.setFileName(((FileStoreEditorInput)input).getName());
            dialog.setFilterPath(MY_DOCUMENTS_GUID);
            String path = dialog.open();
            if (path == null) {
                if (progressMonitor != null) {
                    progressMonitor.setCanceled(true);
                }
                return;
            }
            IContentType contentType = EditorUtil.getContentType(input);
            if (contentType != null) {
                String[] fileSpecs = contentType.getFileSpecs(8);
                boolean hasExtension = false;
                int i = 0;
                while (i < fileSpecs.length) {
                    String extension = fileSpecs[i];
                    if (path.toLowerCase().endsWith(extension.toLowerCase())) {
                        hasExtension = true;
                        break;
                    }
                    ++i;
                }
                if (!hasExtension && fileSpecs.length > 0) {
                    path = String.valueOf(path) + "." + fileSpecs[0];
                }
            }
            if ((externalFile = new File(path)).exists() && (overwriteDialog = new MessageDialog(shell, Messages.AbstractDecoratedTextEditor_saveAs_overwrite_title, null, NLSUtility.format((String)Messages.AbstractDecoratedTextEditor_saveAs_overwrite_message, (Object)path), 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1)).open() != 0 && progressMonitor != null) {
                progressMonitor.setCanceled(true);
                return;
            }
            IFileStore fileStore = EFS.getLocalFileSystem().getStore(externalFile.toURI());
            IFile file = TextEditorUtil.getWorkspaceFile(fileStore);
            Object newInput = file != null ? new FileEditorInput(file) : new CustomFileStoreEditorInput(fileStore);
            if (provider == null) {
                return;
            }
            success = false;
            try {
                try {
                    provider.aboutToChange(newInput);
                    provider.saveDocument(progressMonitor, newInput, provider.getDocument((Object)input), true);
                    success = true;
                }
                catch (CoreException x) {
                    IStatus status = x.getStatus();
                    if (status == null || status.getSeverity() != 8) {
                        String title = Messages.AbstractDecoratedTextEditor_error_saveAs_title;
                        String msg = NLSUtility.format((String)Messages.AbstractDecoratedTextEditor_error_saveAs_message, (Object)x.getMessage());
                        MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                    }
                    provider.changed(newInput);
                    if (success) {
                        editor.setInput((IEditorInput)newInput);
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                provider.changed(newInput);
                if (success) {
                    editor.setInput((IEditorInput)newInput);
                }
                throw throwable;
            }
            provider.changed(newInput);
            if (success) {
                editor.setInput((IEditorInput)newInput);
            }
        }
        if (progressMonitor != null) {
            progressMonitor.setCanceled(!success);
        }
    }

    private static IFile getWorkspaceFile(IFileStore fileStore) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IFile[] files = workspaceRoot.findFilesForLocation((IPath)new Path(fileStore.toURI().getPath()));
        if (files != null && files.length == 1) {
            return files[0];
        }
        return null;
    }
}

