/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.server.core.deployment;

import com.genuitec.eclipse.core.GenuitecCoreException;
import com.genuitec.eclipse.j2eedt.core.IJEEProject;
import com.genuitec.eclipse.j2eedt.core.IJEEProjectModule;
import com.genuitec.eclipse.j2eedt.core.IWebProject;
import com.genuitec.eclipse.j2eedt.core.JEEProjectManager;
import com.genuitec.eclipse.jee.common.core.LivePreviewEnablementUtil;
import com.genuitec.eclipse.server.core.ServerCorePlugin;
import com.genuitec.eclipse.server.core.deployment.AbstractDeploymentProcessor;
import com.genuitec.eclipse.server.core.deployment.IDeploymentProcessorFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jst.j2ee.internal.archive.operations.FlatComponentArchiver;
import org.eclipse.jst.jee.archive.ArchiveSaveFailureException;
import org.eclipse.jst.jee.archive.internal.ArchiveUtil;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.model.DeployMode;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IPublishedModuleDeployment;
import org.eclipse.wst.server.core.model.ModuleDeltaKind;
import org.eclipse.wst.server.core.model.ModulePublishState;

public class ModuleArchiver
extends AbstractDeploymentProcessor {
    private static final String DEPLOY_MODE_PROP = "deployMode";
    private OutputStream destinationStream;
    private ZipOutputStream zipOutputStream;
    private List<IPath> zipEntries = new ArrayList<IPath>();

    public ModuleArchiver(IDeploymentProcessorFactory factory, IPublishedModuleDeployment deployment, OutputStream out, MultiStatus status) throws GenuitecCoreException {
        super(factory, deployment, status);
        this.destinationStream = out;
        this.zipOutputStream = new ZipOutputStream(out);
        this.updateLocationForBrowse();
    }

    public void finish() throws IOException {
        this.getZipOutputStream().finish();
        if (!(this.getDestinationStream() instanceof ZipOutputStream)) {
            this.getDestinationStream().close();
        }
    }

    @Override
    protected void internalProcess(SubMonitor monitor) throws Exception {
        Exception caughtException = null;
        monitor.beginTask("", 500);
        boolean lpPackagedMode = LivePreviewEnablementUtil.isEnabled((IServer)this.server.getServer()) && this.deployment.getRootDeployment().getDeployMode() == DeployMode.PACKAGED;
        try {
            try {
                if (lpPackagedMode) {
                    this.setCustomFlatteningProperty(DEPLOY_MODE_PROP, DeployMode.PACKAGED.name());
                }
                IModuleResource[] resources = this.deployment.getResources();
                this.saveManifest(Arrays.asList(resources), true);
                this.saveChildDeployments(this.deployment.getChildDeployments(), monitor.newChild(250));
                this.saveModuleResources(resources, (IPath)new Path(""));
            }
            catch (Exception e) {
                caughtException = e;
                if (lpPackagedMode) {
                    this.setCustomFlatteningProperty(DEPLOY_MODE_PROP, null);
                }
                try {
                    try {
                        this.finish();
                    }
                    catch (IOException e2) {
                        throw new ArchiveSaveFailureException((Throwable)e2);
                    }
                }
                finally {
                    if (caughtException != null) {
                        throw new ArchiveSaveFailureException((Throwable)caughtException);
                    }
                }
            }
        }
        finally {
            if (lpPackagedMode) {
                this.setCustomFlatteningProperty(DEPLOY_MODE_PROP, null);
            }
            try {
                try {
                    this.finish();
                }
                catch (IOException e) {
                    throw new ArchiveSaveFailureException((Throwable)e);
                }
            }
            finally {
                if (caughtException != null) {
                    throw new ArchiveSaveFailureException((Throwable)caughtException);
                }
            }
        }
    }

    protected ModuleArchiver saveNestedArchive(IPublishedModuleDeployment deployment, IPath entry) throws IOException, CoreException {
        ZipEntry nest = new ZipEntry(entry.toString());
        deployment.setLocation(entry.toString());
        this.getZipOutputStream().putNextEntry(nest);
        return this.factory.createModuleArchiver(deployment, this.getZipOutputStream(), this.status);
    }

    protected void saveModuleResources(IModuleResource[] resources, IPath root) throws ArchiveSaveFailureException {
        int i = 0;
        while (i < resources.length) {
            IModuleResource resource = resources[i];
            IPath entryPath = root.append(resource.getModuleRelativePath()).append(resource.getName());
            if (resource instanceof IModuleFile) {
                if (this.shouldInclude(entryPath, true)) {
                    this.addZipEntry(resource, entryPath);
                }
            } else if (resource instanceof IModuleFolder && this.shouldInclude(entryPath, false)) {
                this.addZipEntry(resource, entryPath);
                this.saveModuleResources(((IModuleFolder)resource).members(), root);
            }
            ++i;
        }
    }

    protected boolean shouldInclude(IPath entryPath, boolean isFile) {
        if (isFile) {
            return !entryPath.equals((Object)new Path("META-INF/MANIFEST.MF"));
        }
        return !entryPath.equals((Object)new Path(".settings"));
    }

    protected String getChildDeploymentLocation(IPublishedModuleDeployment childDeployment, IJEEProject childProject, boolean isMergedUtilityModule) {
        return this.deployable.getURI(childDeployment.getModule());
    }

    protected boolean supportsMergedDeployment() {
        return false;
    }

    protected boolean deployExploded(IPublishedModuleDeployment childDeployment, IJEEProject child, boolean isMergedUtilityModule, IPath entryPath) {
        return false;
    }

    protected void saveChildDeployments(List<IPublishedModuleDeployment> childDeployments, SubMonitor monitor) throws ArchiveSaveFailureException, IOException, CoreException {
        this.componentsArchived.add(this.component);
        monitor.beginTask("", childDeployments.size() * 110);
        boolean hasMergeUtilityModules = this.supportsMergedDeployment() && this.project instanceof IWebProject && ((IWebProject)this.project).isMergeUtilityModules();
        for (IPublishedModuleDeployment childDeployment : childDeployments) {
            ModuleArchiver saver;
            IVirtualComponent moduleComponent;
            IJEEProjectModule module;
            if (childDeployment.getModuleDeltaKind() == ModuleDeltaKind.REMOVED) {
                childDeployment.setModulePublishState(ModulePublishState.PUBLISH_STATE_NONE);
                childDeployment.setModuleStatus(null);
                continue;
            }
            if (!this.acceptChild(childDeployment, monitor.newChild(10))) continue;
            IJEEProject child = JEEProjectManager.create((IProject)childDeployment.getModule().getProject());
            boolean isMergedUtilityModule = hasMergeUtilityModules && (module = this.project.getProjectModule(child)) != null && module.deployMerged();
            String location = this.getChildDeploymentLocation(childDeployment, child, isMergedUtilityModule);
            childDeployment.setLocation(location);
            Path entryPath = new Path(location);
            if (!isMergedUtilityModule) {
                this.zipEntries.add((IPath)entryPath);
            }
            if ((moduleComponent = this.getComponent(childDeployment)) == null) {
                this.status.add(ServerCorePlugin.createErrorStatus("Cannnot acquire IVirtualComponent for module {0}", childDeployment));
                continue;
            }
            if (this.componentsArchived.contains(moduleComponent)) continue;
            if (this.deployExploded(childDeployment, child, isMergedUtilityModule, (IPath)entryPath)) {
                saver = this.factory.createModuleArchiver(childDeployment, this.getZipOutputStream(), this.status);
                saver.zipOutputStream = this.getZipOutputStream();
                saver.destinationStream = this.getDestinationStream();
                saver.zipEntries = this.zipEntries;
                saver.saveModuleResources(childDeployment.getResources(), (IPath)entryPath);
                saver.saveChildDeployments(childDeployment.getChildDeployments(), monitor.newChild(100));
                childDeployment.setModulePublishState(ModulePublishState.PUBLISH_STATE_NONE);
                childDeployment.setModuleStatus(null);
                continue;
            }
            saver = this.saveNestedArchive(childDeployment, (IPath)entryPath);
            saver.setArchivedComponents(this.componentsArchived);
            saver.processDeployment(monitor.newChild(100));
        }
    }

    protected void addZipEntry(IModuleResource f, IPath entryPath) throws ArchiveSaveFailureException {
        if (this.zipEntries.contains(entryPath)) {
            return;
        }
        this.zipEntries.add(entryPath);
        try {
            IPath path = entryPath;
            boolean isFolder = false;
            if (f instanceof IModuleFolder) {
                isFolder = true;
                if (!path.hasTrailingSeparator()) {
                    path = path.addTrailingSeparator();
                }
            }
            ZipEntry entry = new ZipEntry(path.toString());
            this.getZipOutputStream().putNextEntry(entry);
            if (!isFolder) {
                InputStream is = (InputStream)f.getAdapter(InputStream.class);
                if (is == null) {
                    File file = (File)f.getAdapter(File.class);
                    if (file != null && file.exists()) {
                        is = new FileInputStream(file);
                    } else {
                        String name = null;
                        name = file != null ? file.getAbsolutePath() : f.getModuleRelativePath().append(f.getName()).toString();
                        throw new FlatComponentArchiver.UnderlyingFileNotFoundException(MessageFormat.format("Cannot find the file {0} in the file system. Make sure the file exists and try deployment again", name));
                    }
                }
                ArchiveUtil.copy((InputStream)is, (OutputStream)this.getZipOutputStream());
            }
            this.getZipOutputStream().closeEntry();
        }
        catch (IOException e) {
            throw new ArchiveSaveFailureException((Throwable)e);
        }
    }

    protected ZipOutputStream getZipOutputStream() {
        return this.zipOutputStream;
    }

    private void saveManifest(List<IModuleResource> resources, boolean createManifest) throws ArchiveSaveFailureException {
        IModuleFolder metainf = null;
        IModuleFile manifest = null;
        for (IModuleResource mr : resources) {
            if (!(mr instanceof IModuleFolder) || !mr.getName().equals("META-INF")) continue;
            metainf = (IModuleFolder)mr;
            break;
        }
        if (metainf != null) {
            IModuleResource[] children = metainf.members();
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof IModuleFile && children[i].getName().equals("MANIFEST.MF")) {
                    manifest = (IModuleFile)children[i];
                    IPath entryPath = manifest.getModuleRelativePath().append(manifest.getName());
                    this.addZipEntry((IModuleResource)manifest, entryPath);
                    break;
                }
                ++i;
            }
        }
        if (createManifest && manifest == null) {
            this.createManifest();
        }
    }

    @Override
    protected void handleJarModule(IPublishedModuleDeployment childDeployment, IModuleFile file, SubMonitor monitor) throws GenuitecCoreException {
        try {
            this.addZipEntry((IModuleResource)file, file.getModuleRelativePath().append(file.getName()));
        }
        catch (ArchiveSaveFailureException e) {
            throw new GenuitecCoreException((Plugin)ServerCorePlugin.getDefault(), (Throwable)e);
        }
    }

    private void createManifest() throws ArchiveSaveFailureException {
        String manifestContents = "Manifest-Version: 1.0\r\n\r\n";
        try {
            ZipEntry entry = new ZipEntry("META-INF/MANIFEST.MF");
            this.getZipOutputStream().putNextEntry(entry);
            ArchiveUtil.copy((InputStream)new ByteArrayInputStream(manifestContents.getBytes()), (OutputStream)this.getZipOutputStream());
        }
        catch (IOException e) {
            throw new ArchiveSaveFailureException((Throwable)e);
        }
    }

    public OutputStream getDestinationStream() {
        return this.destinationStream;
    }
}

