/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.j2eedt.facet.ui.command;

import com.genuitec.eclipse.j2eedt.facet.ui.internal.GenericFacetInstallationManagerImpl;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.ui.internal.ProjectFacetsUiManagerImpl;

public class FacetMenuContribution
extends CompoundContributionItem
implements IWorkbenchContribution {
    private static final IContributionItem[] EMPTY = new IContributionItem[0];
    private IServiceLocator serviceLocator;

    protected IContributionItem[] getContributionItems() {
        IHandlerService handlerService = (IHandlerService)this.serviceLocator.getService(IHandlerService.class);
        Object selObj = handlerService.getCurrentState().getVariable("selection");
        if (!(selObj instanceof IStructuredSelection)) {
            return EMPTY;
        }
        IStructuredSelection currentSelection = (IStructuredSelection)selObj;
        if (currentSelection.size() != 1) {
            return EMPTY;
        }
        if (!(currentSelection.getFirstElement() instanceof IAdaptable)) {
            return EMPTY;
        }
        IProject project = (IProject)((IAdaptable)currentSelection.getFirstElement()).getAdapter(IProject.class);
        if (project == null) {
            return EMPTY;
        }
        MenuManager menu = new MenuManager();
        List<IProjectFacet> facets = GenericFacetInstallationManagerImpl.getInstallableFacets(project);
        if (facets.size() > 0) {
            Separator sep = new Separator();
            sep.setVisible(true);
            menu.add((IContributionItem)sep);
        }
        for (IProjectFacet facet : facets) {
            CommandContributionItemParameter item = new CommandContributionItemParameter(this.serviceLocator, null, "com.genuitec.installFacets.install", 8);
            item.parameters = new HashMap();
            item.parameters.put("facet", facet.getId());
            item.label = MessageFormat.format("Install {0} Facet", facet.getLabel());
            item.icon = ProjectFacetsUiManagerImpl.getIcon((Object)facet);
            menu.add((IContributionItem)new CommandContributionItem(item));
        }
        return menu.getItems();
    }

    public void initialize(IServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }
}

