local Action = GLOBAL.Action
local ACTIONS = GLOBAL.ACTIONS
local ActionHandler = GLOBAL.ActionHandler
local STRINGS = GLOBAL.STRINGS
local TUNING = GLOBAL.TUNING

local fueledprefab = {
	"lantern",
	"minerhat",
	"molehat",
	"pumpkin_lantern"
}

function SetupActionNFuel(inst,doer,target,actions,right)
	if not inst.prefab == "nightmarefuel" then return end
	if doer.prefab == "miotan" and inst.prefab == "nightmarefuel" then
		for k,v in pairs(fueledprefab) do
			if target and target.prefab == v then
				if not inst:GetIsWet() then
					table.insert(actions,ACTIONS.ADDFUEL)
				else
					table.insert(actions,ACTIONS.ADDWETFUEL)
				end
			end
		end
	end
end

ACTIONS.ADDFUEL.fn = function(act)
    if act.doer.components.inventory then
        local fuel = act.doer.components.inventory:RemoveItem(act.invobject)
        if fuel then
			if fuel.prefab == "nightmarefuel" and act.doer.prefab == "miotan" and (act.target.prefab == "lantern" or act.target.prefab == "minerhat" or act.target.prefab == "molehat") then
				act.target.components.fueled:DoDelta(fuel.components.fuel.fuelvalue * act.target.components.fueled.bonusmult)
				act.doer.SoundEmitter:PlaySound("dontstarve/common/nightmareAddFuel")
				if act.target.components.fueled.ontakefuelfn ~= nil then
        		    act.target.components.fueled.ontakefuelfn(act.target)
        		end
				return true
			elseif fuel.prefab == "nightmarefuel" and act.doer.prefab == "miotan" and act.target.prefab == "pumpkin_lantern" then
				act.target.components.perishable:SetPercent( act.target.components.perishable:GetPercent() + fuel.components.fuel.fuelvalue/GLOBAL.TUNING.LANTERN_LIGHTTIME )
				act.doer.SoundEmitter:PlaySound("dontstarve/common/nightmareAddFuel")
				return true
			elseif act.target.components.fueled and act.target.components.fueled:TakeFuelItem(fuel) then
                return true
            else
                --print("False")
                act.doer.components.inventory:GiveItem(fuel)
            end
        end
    end
end

ACTIONS.ADDWETFUEL.fn = function(act)
    if act.doer.components.inventory then
        local fuel = act.doer.components.inventory:RemoveItem(act.invobject)
        if fuel then
			if fuel.prefab == "nightmarefuel" and act.doer.prefab == "miotan" and (act.target.prefab == "lantern" or act.target.prefab == "minerhat" or act.target.prefab == "molehat") then
				act.target.components.fueled:DoDelta(fuel.components.fuel.fuelvalue * act.target.components.fueled.bonusmult * 0.7 )
				act.doer.SoundEmitter:PlaySound("dontstarve/common/nightmareAddFuel")
				if act.target.components.fueled.ontakefuelfn ~= nil then
        		    act.target.components.fueled.ontakefuelfn(act.target)
        		end
				return true
			elseif fuel.prefab == "nightmarefuel" and act.doer.prefab == "miotan" and act.target.prefab == "pumpkin_lantern" then
				act.target.components.perishable:SetPercent( act.target.components.perishable:GetPercent() + fuel.components.fuel.fuelvalue/GLOBAL.TUNING.LANTERN_LIGHTTIME * 0.7 )
				act.doer.SoundEmitter:PlaySound("dontstarve/common/nightmareAddFuel")
				return true
			elseif act.target.components.fueled and act.target.components.fueled:TakeFuelItem(fuel) then
                return true
            else
                -- print("False")
                act.doer.components.inventory:GiveItem(fuel)
            end
        end
    end
end

AddComponentAction("USEITEM", "fuel", SetupActionNFuel)
