AddPrefabPostInit("pigking", function(inst)
	--for i = 1, NUM_HALLOWEENCANDY do
	--	table.insert(prefabs, "halloweencandy_"..i)
	--end

	local function launchitem(item, angle)
	    local speed = math.random() * 4 + 2
	    angle = (angle + math.random() * 60 - 30) * GLOBAL.DEGREES
	    item.Physics:SetVel(speed * math.cos(angle), math.random() * 2 + 8, speed * math.sin(angle))
	end

	local function ontradeforgold(inst, item, giver)
		inst.SoundEmitter:PlaySound("dontstarve/pig/PigKingThrowGold")

    	local x, y, z = inst.Transform:GetWorldPosition()
    	y = 4.5

    	local angle
    	if giver ~= nil and giver:IsValid() then
    	    angle = 180 - giver:GetAngleToPoint(x, 0, z)
    	else
    	    local down = TheCamera:GetDownVec()
    	    angle = math.atan2(down.z, down.x) / GLOBAL.DEGREES
    	    giver = nil
    	end

	    for k = 1, item.components.tradable.goldvalue do
			if giver.prefab == "miotan" then
			    local nug = GLOBAL.SpawnPrefab("nightmarefuel")
	    	    nug.Transform:SetPosition(x, y, z)
	    	    launchitem(nug, angle)
			else
	    	    local nug = GLOBAL.SpawnPrefab("goldnugget")
	    	    nug.Transform:SetPosition(x, y, z)
	    	    launchitem(nug, angle)
			end
	    end


    	if item.components.tradable.tradefor ~= nil then
    	    for _, v in pairs(item.components.tradable.tradefor) do
    	        local item = GLOBAL.SpawnPrefab(v)
    	        if item ~= nil then
    	            item.Transform:SetPosition(x, y, z)
    	            launchitem(item, angle)
    	        end
    	    end
    	end

    	if GLOBAL.IsSpecialEventActive(GLOBAL.SPECIAL_EVENTS.HALLOWED_NIGHTS) then
    	    -- pick out up to 3 types of candies to throw out
    	    local candytypes = { math.random(GLOBAL.NUM_HALLOWEENCANDY), math.random(GLOBAL.NUM_HALLOWEENCANDY), math.random(GLOBAL.NUM_HALLOWEENCANDY) }
    	    local numcandies = (item.components.tradable.halloweencandyvalue or 1) + math.random(2) + 2

    	    -- only people in costumes get a good amount of candy!      
    	    if giver ~= nil and giver.components.skinner ~= nil then
    	        local costume = giver.components.skinner:GetClothing().base
    	        if costume ~= nil and costume ~= "" and Prefabs[costume] ~= nil and table.contains(Prefabs[costume].tags, "COSTUME") then
    	            numcandies = numcandies + math.random(4) + 2
    	        end
    	    end

    	    for k = 1, numcandies do
    	        local candy = GLOBAL.SpawnPrefab("halloweencandy_"..GLOBAL.GetRandomItem(candytypes))
    	        candy.Transform:SetPosition(x, y, z)
    	        launchitem(candy, angle)
			end
		end    
	end

	local function onplayhappysound(inst)
	    inst.SoundEmitter:PlaySound("dontstarve/pig/PigKingHappy")
	end

	local function onendhappytask(inst)
		inst.happy = false
		inst.endhappytask = nil
	end

	local function NewOnGetItemFromPlayer(inst, giver, item)
	    local is_event_item = GLOBAL.IsSpecialEventActive(GLOBAL.SPECIAL_EVENTS.HALLOWED_NIGHTS) and item.components.tradable.halloweencandyvalue and item.components.tradable.halloweencandyvalue > 0
	
	    if item.components.tradable.goldvalue > 0 or is_event_item then
	        inst.AnimState:PlayAnimation("cointoss")
	        inst.AnimState:PushAnimation("happy")
	        inst.AnimState:PushAnimation("idle", true)
	        inst:DoTaskInTime(20/30, ontradeforgold, item, giver)
	        inst:DoTaskInTime(1.5, onplayhappysound)
	        inst.happy = true
	        if inst.endhappytask ~= nil then
	            inst.endhappytask:Cancel()
	        end
	        inst.endhappytask = inst:DoTaskInTime(5, onendhappytask)
	    end
	end

	if inst.components.trader then
		inst.components.trader.onaccept = NewOnGetItemFromPlayer
	end
end)
