/* 
* OCAD Internet Map for OpenLayers
* OCAD AG, Baar, Switzerland 2012-2013
* Author: Markus Fuchs-Winkler
*/

var
	timerID; 

function XMLLoad(dname)
{
	var xmlDoc;
	if (window.XMLHttpRequest) {
	  xmlDoc=new window.XMLHttpRequest();
	  xmlDoc.open("GET",dname,false);
	  xmlDoc.send("");
	  return xmlDoc.responseXML;
	}
	// IE 5 and IE 6
	else if (ActiveXObject("Microsoft.XMLDOM"))	{
	  xmlDoc=new ActiveXObject("Microsoft.XMLDOM");
	  xmlDoc.async=false;
	  xmlDoc.load(dname);
	  return xmlDoc;
	}
	alert('error loading XML Document');
	return null;
}

function UrlDecode(url)
{
    return unescape(url).replace("+", " ");
}

function XMLLoadPoiGroups(dname){			

		
	var xmlDocument = XMLLoad(dname);
	var xdoc = xmlDocument.getElementsByTagName("poigroup"); //Group of POIS combined together
	
	for(var i=0; i < xdoc.length; i++) {
		_mapPoi[i] = new Object();
		_mapPoi[i].id = xdoc[i].attributes.getNamedItem("id").value;
		_mapPoi[i].layerName = xdoc[i].getElementsByTagName("layerName")[0].childNodes[0].nodeValue;
		_mapPoi[i].geometry = xdoc[i].getElementsByTagName("geometry")[0].childNodes[0].nodeValue;
		try { _mapPoi[i].urltarget = xdoc[i].getElementsByTagName("urltarget")[0].childNodes[0].nodeValue;
			} catch (e) { _mapPoi[i].urltarget = "_blank";	}
		try { _mapPoi[i].hover = xdoc[i].getElementsByTagName("hover")[0].childNodes[0].nodeValue == "true" ? true : false;
			} catch (e) { _mapPoi[i].hover = true;	}
		try { _mapPoi[i].highlightPOI = xdoc[i].getElementsByTagName("highlight")[0].childNodes[0].nodeValue == "true" ? true : false;
			} catch (e) { _mapPoi[i].highlightPOI = true;	}			
		try { _mapPoi[i].visiblezoom = xdoc[i].getElementsByTagName("visiblezoom")[0].childNodes[0].nodeValue;
			} catch (e) { _mapPoi[i].visiblezoom = 3;	}	
		if (_mapPoi[i].geometry == "Icon") {
			_mapPoi[i].iconurl = xdoc[i].getElementsByTagName("iconurl")[0].childNodes[0].nodeValue;
			_mapPoi[i].iconsize = new Object();
			_mapPoi[i].iconsize.x = xdoc[i].getElementsByTagName("iconsize")[0].getElementsByTagName("x")[0].childNodes[0].nodeValue;
			_mapPoi[i].iconsize.y = xdoc[i].getElementsByTagName("iconsize")[0].getElementsByTagName("y")[0].childNodes[0].nodeValue;
			_mapPoi[i].iconoffset = new Object();
			_mapPoi[i].iconoffset.x = xdoc[i].getElementsByTagName("iconoffset")[0].getElementsByTagName("x")[0].childNodes[0].nodeValue;
			_mapPoi[i].iconoffset.y = xdoc[i].getElementsByTagName("iconoffset")[0].getElementsByTagName("y")[0].childNodes[0].nodeValue;

		}
		if (_mapPoi[i].geometry == "Point") {
			try { _mapPoi[i].fillColor = '#' +  xdoc[i].getElementsByTagName("fillcolor")[0].childNodes[0].nodeValue;
				} catch (e) { _mapPoi[i].fillColor = "#EE9900";	}
			try { _mapPoi[i].strokeColor = '#' + xdoc[i].getElementsByTagName("strokecolor")[0].childNodes[0].nodeValue;
				} catch (e) { _mapPoi[i].strokeColor = "#EE9900";	}
			try { _mapPoi[i].pointRadius = parseInt(xdoc[i].getElementsByTagName("pointradius")[0].childNodes[0].nodeValue);
				} catch (e) { _mapPoi[i].pointRadius = 6;	}		
			try { _mapPoi[i].fillOpacity = parseFloat(xdoc[i].getElementsByTagName("opacity")[0].childNodes[0].nodeValue);
				} catch (e) { _mapPoi[i].fillOpacity = 0.4;	}		
			try { _mapPoi[i].strokeOpacity = parseFloat(xdoc[i].getElementsByTagName("strokeopacity")[0].childNodes[0].nodeValue);
				} catch (e) { _mapPoi[i].strokeOpacity = 1.0;	}
		}
	}
}

function XMLLoadPoiLocations(dname) {
	
	var xmlDocument = XMLLoad(dname);
	var xdoc = xmlDocument.getElementsByTagName("poigroup");
	var tmp;
	
	for(var i=0; i < xdoc.length; i++) {
		
		_mapPoi[i].locs = new Array();
		tmp = xdoc[i].getElementsByTagName("loc");
		
		for(var j=0; j< tmp.length; j++) {
		
			_mapPoi[i].locs[j] = new Object();
			try { _mapPoi[i].locs[j].location = tmp[j].getElementsByTagName("location")[0].childNodes[0].nodeValue.replace(/^\s/, "");
			} catch (e) { _mapPoi[i].locs[j].location = "";	}
			try { _mapPoi[i].locs[j].x = tmp[j].getElementsByTagName("x")[0].childNodes[0].nodeValue;
			}	catch (e) { _mapPoi[i].locs[j].x = 0;	}
			try { _mapPoi[i].locs[j].y = tmp[j].getElementsByTagName("y")[0].childNodes[0].nodeValue;
			} catch (e) { _mapPoi[i].locs[j].y = 0;	}
			try { _mapPoi[i].locs[j].linkname = tmp[j].getElementsByTagName("linkname")[0].childNodes[0].nodeValue; 
			} catch (e) { _mapPoi[i].locs[j].linkname = ""; }
			try {	_mapPoi[i].locs[j].url = UrlDecode(tmp[j].getElementsByTagName("url")[0].childNodes[0].nodeValue);
			} catch (e) { _mapPoi[i].locs[j].url = ""; }
			try { _mapPoi[i].locs[j].description = tmp[j].getElementsByTagName("description")[0].childNodes[0].nodeValue;
			}	catch (e) {	 _mapPoi[i].locs[j].description = ""; }
		}
	}
	
}

function GeneratePois() {
	
    var PointPOILayerCount = 0;
    var	PointPOILayerArray = new Array();
	
	for(var i = 0; i < _mapPoi.length; i++) {
		if(_mapPoi[i].geometry == "Point") {
			//Generate the Layers from the previous imported data
			_poiLayers[i] = new OpenLayers.Layer.Vector(_mapPoi[i].layerName);	
			
			for (var j = 0; j < _mapPoi[i].locs.length; j++) {
				
				var feature_point = null;

				feature_point = new OpenLayers.Feature.Vector(
							new OpenLayers.Geometry.Point(parseInt(_mapPoi[i].locs[j].x), parseInt(_mapPoi[i].locs[j].y)), 
							{
								'id': _mapPoi[i].locs[j].id,
								'location': _mapPoi[i].locs[j].location,
								'description':  _mapPoi[i].locs[j].description,
								'linkname' : _mapPoi[i].locs[j].linkname,
								'url':  _mapPoi[i].locs[j].url,
								'urltarget': _mapPoi[i].urltarget,
								'featureType': 'POINT'
							},
							{
								'fillColor' : _mapPoi[i].fillColor,
								'strokeColor' : _mapPoi[i].strokeColor,
								'pointRadius' : _mapPoi[i].pointRadius,
								'fillOpacity' : _mapPoi[i].fillOpacity,
								'strokeOpacity': _mapPoi[i].strokeOpacity
							}
					);
				_poiLayers[i].addFeatures([feature_point]);
				PointPOILayerArray[PointPOILayerCount++] = _poiLayers[i];
			}
		}
		else {
			//ICON
		  _poiLayers[i] = new OpenLayers.Layer.Vector(_mapPoi[i].layerName,{
		
			styleMap : new OpenLayers.StyleMap({
				externalGraphic: _mapPoi[i].iconurl,
				graphicOpacity : 1.0,
				graphicWidth : parseInt(_mapPoi[i].iconsize.x),
				graphicHeight: parseInt(_mapPoi[i].iconsize.y),
				graphicXOffset : parseInt(_mapPoi[i].iconoffset.x),
				graphicYOffset : parseInt(_mapPoi[i].iconoffset.y)
				})
		  });
			
			var features_Array = new Array();
			
			for (var j = 0; j < _mapPoi[i].locs.length; j++) {
			
				 features_Array[j] ={
					'type': 'Feature',
					'geometry' : {'type': 'Point', 'coordinates' : [parseInt(_mapPoi[i].locs[j].x),  parseInt(_mapPoi[i].locs[j].y)]},
					'properties': {'featureType': 'ICON','location': _mapPoi[i].locs[j].location, 'description': _mapPoi[i].locs[j].description, 'linkname': _mapPoi[i].locs[j].linkname, 'url':_mapPoi[i].locs[j].url}
				 };
				
			
			}
			var features = {
				'type' : 'FeatureCollection',
				'features' : features_Array
			};
			
			var reader = new OpenLayers.Format.GeoJSON();
			
			_poiLayers[i].addFeatures(reader.read(features));
		}
	}


	map.addLayers(_poiLayers);
	
	var poiLayerOptions = new Array();
	
	for (var z = 0; z < _mapPoi.length; z++) {
		if (_mapPoi[z].hover == true) {
			poiLayerOptions[z] =
			[
				_poiLayers[z],
				{templates: {
				hover: '${.location}',
				single: '${.location}<br><hr>' +
						'${.description}<br>' +
						'<a href="${.url}" target="'+_mapPoi[z].target+'">${.linkname}</a><br>',
				item: '<li><a href=\"#\" ${showPopup()}></a></li>'
			}}];
		}
		else
		{
			poiLayerOptions[z] =
			[
				_poiLayers[z],
				{templates: {
				single: '${.location}<br><hr>' +
						'${.description}<br>' +
						'<a href="${.url}" target="'+_mapPoi[z].target+'">${.linkname}</a><br>',
				item: '<li><a href=\"#\" ${showPopup()}></a></li>'
			}}];
		
		}

	}
	
	var fpControl = new OpenLayers.Control.FeaturePopups({
	// External div for list popups
		popupListOptions: {popupClass: 'mapdata'},
		boxSelectionOptions: {},
		layers: poiLayerOptions
	});
	
	map.addControl(fpControl);
}

function XMLInitPois(generalInfoXML, LocationInfoXML) {
	XMLLoadPoiGroups(generalInfoXML);
	XMLLoadPoiLocations(LocationInfoXML);	
	GeneratePois();
	
}


function  MapPoiGoToLocation() {
	var sPoiToGo =  document.getElementById("searchVal").value;

	if (sPoiToGo == "" ) {
		return;
	}
	
	for(var i = 0; i < _mapPoi.length; i++) {
		for(var j=0; j < _mapPoi[i].locs.length; j++) {
			if(_mapPoi[i].locs[j].location == sPoiToGo) {
	    		map.zoomTo(map.numZoomLevels-1);
	    		map.panTo(new OpenLayers.LonLat(_mapPoi[i].locs[j].x,_mapPoi[i].locs[j].y));
    		}
		}
	}
}

function CreateSelect() {
	var SelectorList = new Array();
	var SelectorField = document.getElementById("mapselect");
  
	SelectorList.push('<select id = "poigroupSelector" onchange = "CreatePoiList(this.value, \'\');" style="margin-top: 4px; margin-left: 2px; width: 99%;">');
	for(var i = 0; i < _mapPoi.length; i++) {
		SelectorList.push('<option value="'+ _mapPoi[i].id + '">' + _mapPoi[i].layerName + '</option>');
	}
	SelectorList.push('</select>');
	SelectorList.push('<input onkeyup="CreatePoiList(document.getElementById(\'poigroupSelector\').value, this.value);" style="width: 96%; margin-top: 7px; margin-left: 2px;" type="text" id="searchValPoi" />');
	SelectorList.push('<div id="POISelect"></div>');
	
	
	SelectorField.innerHTML = _TR_SWSH + SelectorList.join(' ');
	CreatePoiList(0, '');
}


if (typeof String.prototype.startsWith != 'function') {
  String.prototype.startsWith = function (str){
    return this.indexOf(str) == 0;
  };
}

if (typeof String.prototype.unescapeHtml != 'function') {
	String.prototype.unescapeHtml = function () {
	    var temp = document.createElement("div");
	    temp.innerHTML = this;
	    var result = temp.childNodes[0].nodeValue;
	    temp.removeChild(temp.firstChild);
	    return result;
	};
}


function dynamicSort(property) {
    return function (a,b) {
        /*
		 * Natural Sort algorithm for Javascript - Version 0.5 - Released under MIT license
         * Author: Jim Palmer (based on chunking idea from Dave Koelle)
		 * Contributors: Mike Grier (mgrier.com), Clint Priest, Kyle Adams, guillermo
		*/
		// setup temp-scope variables for comparison evauluation
        var re = /(^-?[0-9]+(\.?[0-9]*)[df]?e?[0-9]?$|^0x[0-9a-f]+$|-?[0-9]+)/gi,
                sre = /(^[ ]*|[ ]*$)/g,
                hre = /^0x[0-9a-f]+$/i,
                dre = /(^[0-9\-\.\/]{5,}$)|[0-9]+:[0-9]+|( [0-9]{4})/i,
                ore = /^0/,
                // convert all to strings and trim()
                x = a.toString().replace(sre, '') || '',
                y = b.toString().replace(sre, '') || '',
                // chunk/tokenize
                xN = x.replace(re, '\0$1\0').replace(/\0$/,'').replace(/^\0/,'').split('\0'),
                yN = y.replace(re, '\0$1\0').replace(/\0$/,'').replace(/^\0/,'').split('\0'),
                // numeric, hex or date detection
                xD = parseInt(x.match(hre)) || (xN.length != 1 && x.match(dre) && (new Date(x)).getTime()),
                yD = parseInt(y.match(hre)) || xD && (new Date(y)).getTime() || null;
        // natural sorting of hex or dates - prevent '1.2.3' valid date
        if (yD)
                if ( xD < yD ) return -1;
                else if ( xD > yD )     return 1;
        // natural sorting through split numeric strings and default strings
        for(var cLoc=0, numS=Math.max(xN.length, yN.length); cLoc < numS; cLoc++) {
                // find floats not starting with '0', string or 0 if not defined (Clint Priest)
                oFxNcL = !(xN[cLoc] || '').match(ore) && parseFloat(xN[cLoc]) || xN[cLoc] || 0;
                oFyNcL = !(yN[cLoc] || '').match(ore) && parseFloat(yN[cLoc]) || yN[cLoc] || 0;
                // handle numeric vs string comparison - number < string - (Kyle Adams)
                if (isNaN(oFxNcL) !== isNaN(oFyNcL)) return (isNaN(oFxNcL)) ? 1 : -1; 
                // rely on string comparison if different types - i.e. '02' < 2 != '02' < '2'
                else if (typeof oFxNcL !== typeof oFyNcL) {
                        oFxNcL += ''; 
                        oFyNcL += ''; 
                }
                if (oFxNcL < oFyNcL) return -1;
                if (oFxNcL > oFyNcL) return 1;
        }
        return 0;
    };
}


function CreatePoiList(PoiGroupId, limit) {
	var iPoiGroup =  parseInt(PoiGroupId);
	var aPoiList = new Array();
	var dPOISelect = document.getElementById("POISelect");
	var aToSortPoiList = new Array();
	var aToSortCount = 0;
	limit = limit.replace(/^\s/, "");
	
	
	if (limit == '') document.getElementById("searchValPoi").value = ''; 

	for (var i = 0; i < _mapPoi[iPoiGroup].locs.length; i++) {
		if (limit != "") {
			if (_mapPoi[iPoiGroup].locs[i].location.toLowerCase().unescapeHtml().startsWith(limit.toLowerCase()) == true) {
				aToSortPoiList[aToSortCount] = new Object();
				aToSortPoiList[aToSortCount].id = i;
				aToSortPoiList[aToSortCount++].location = new String(_mapPoi[iPoiGroup].locs[i].location).replace(/^\s/, "");
			}
		}
		else
		{
			aToSortPoiList[i] = new Object();
			aToSortPoiList[i].id = i;
			aToSortPoiList[i].location = new String(_mapPoi[iPoiGroup].locs[i].location).replace(/^\s/, "");
		}
	}

		
	aPoiList.push('<select onchange = "MapPoiGoToPoi(this.value, document.getElementById(\'poigroupSelector\').value);" size="6" style="width: 99%; margin-top: 4px; margin-left: 2px;">');
	for(var i = 0; i < aToSortPoiList.length; i++ ) {
		aPoiList.push('<option value="'+ aToSortPoiList[i].id+ '">'+aToSortPoiList[i].location + '</option>');
	}
	aPoiList.push('</select>');
	
	aToSortPoiList.sort(dynamicSort("location"));	

	dPOISelect.innerHTML = aPoiList.join('');
}

function MapPoiGoToPoi(PoiLocationId, PoiGroupId) {
	var iPoiGroupId = parseInt(PoiGroupId);
	var iPoiLocationId = parseInt(PoiLocationId);
	var foundLayer = false;
	var layerID = -1;
	var markers;

	if (_mapPoi[iPoiGroupId].highlightPOI == true) {
		for (var la = 0; la < map.layers.length; la++) {
			if (map.layers[la].name == "Highlight POIs") { foundLayer = true; layerID = la;}
		};
		if (foundLayer == true) {	
			markers = map.layers[layerID]; 
			markers.clearMarkers(); 
		}  
		else {
			markers = new OpenLayers.Layer.Markers( "Highlight POIs" );
			map.addLayer(markers);
		};
		var size = new OpenLayers.Size(33,42);
		var offset = new OpenLayers.Pixel(-(size.w/2), -size.h);
		var icon = new OpenLayers.Icon('./css/img/pointer.gif',size,offset);
		markers.addMarker(new OpenLayers.Marker(new OpenLayers.LonLat(_mapPoi[iPoiGroupId].locs[iPoiLocationId].x,_mapPoi[iPoiGroupId].locs[iPoiLocationId].y),icon));
	}

	map.zoomTo(map.numZoomLevels-1);
	map.panTo(new OpenLayers.LonLat(_mapPoi[iPoiGroupId].locs[iPoiLocationId].x,_mapPoi[iPoiGroupId].locs[iPoiLocationId].y));
	
	if (_mapPoi[iPoiGroupId].highlightPOI == true) {
		timerID = setTimeout(function() {
			var foundLayer = false;
			var layerID = -1;
			var markers;
			for (var la = 0; la < map.layers.length; la++) {
				if (map.layers[la].name == "Highlight POIs") { foundLayer = true; layerID = la;}
			};
			if (foundLayer == true) {	
				map.removeLayer(map.layers[layerID]);
			}  	
		},6000);
	}
}

function zoomChanged() {
	var zoom = map.getZoom();
	for(var zl = 0; zl < _mapPoi.length; zl++) {

		if (zoom >= parseInt(_mapPoi[zl].visiblezoom)) {
				map.layers[zl+1].setVisibility(true);
		}
		else
		{
				map.layers[zl+1].setVisibility(false);
		}
	}
}
