// OCConvTemp.cpp

#include "StdAfx.h"
#include "MOCAMain.h"
#include "OCConvTemp.h"


#define CELSIUS_TO_FAHRENHEIT(dCelsius)		((double)(dCelsius) * 1.8) + 32
#define FAHRENHEIT_TO_CELSIUS(dFahrenheit)	((double)(dFahrenheit) - 32) / 1.8


MOCA_IMPLEMENT_DYNAMIC(OCConvertTemperature, CScriptMocaObject)

//--------------------------------------------------------------------------
// The following table is used for mapping Origin C member functions and
// data members to their Visual C++ handler functions.
//--------------------------------------------------------------------------
BEGIN_MEMBERS_TABLE(OCConvertTemperature, CScriptMocaObject)
	MEMBER_METHOD(CelsiusToFahrenheit, "CelsiusToFahrenheit")
	MEMBER_METHOD(FahrenheitToCelsius, "FahrenheitToCelsius")
	MEMBER_PROPERTY(GetCelsius, SetCelsius, "m_dCelsius")
	MEMBER_PROPERTY(GetFahrenheit, SetFahrenheit, "m_dFahrenheit")
END_MEMBERS_TABLE

//--------------------------------------------------------------------------
// OCConvertTemperature::OCConvertTemperature
//
// Constructor member.  Do class initialization here.
//--------------------------------------------------------------------------
OCConvertTemperature::OCConvertTemperature(COCall *pCall)
{
	InitTypeIDs(LTT_ID_UD_CLASS);

	m_dCelsius = 0.0;
	m_dFahrenheit = FAHRENHEIT_TO_CELSIUS(m_dCelsius);
}

//--------------------------------------------------------------------------
// OCConvertTemperature::~OCConvertTemperature
//
// Destructor member.  Do class cleanup here.
//--------------------------------------------------------------------------
OCConvertTemperature::~OCConvertTemperature()
{
}

//--------------------------------------------------------------------------
// OCConvertTemperature::GetCelsius
//
// Handle the getting of the Celsius data member.
//--------------------------------------------------------------------------
int OCConvertTemperature::GetCelsius(COCall *pCall)
{
	return pCall->SetReturnDouble(m_dCelsius);
}

//--------------------------------------------------------------------------
// OCConvertTemperature::SetCelsius
//
// Handle the setting of the Celsius data member.
//--------------------------------------------------------------------------
int OCConvertTemperature::SetCelsius(COCall *pCall)
{
	int iRet;

	double dCelsius;
	if( iRet = pCall->GetDouble(0, dCelsius) )
		return iRet;

	m_dCelsius = dCelsius;
	m_dFahrenheit = CELSIUS_TO_FAHRENHEIT(dCelsius);

	return 0; // Success
}

//--------------------------------------------------------------------------
// OCConvertTemperature::GetFahrenheit
//
// Handle the getting of the Fahrenheit data member.
//--------------------------------------------------------------------------
int OCConvertTemperature::GetFahrenheit(COCall *pCall)
{
	return pCall->SetReturnDouble(m_dFahrenheit);
}

//--------------------------------------------------------------------------
// OCConvertTemperature::SetFahrenheit
//
// Handle the setting of the Fahrenheit data member.
//--------------------------------------------------------------------------
int OCConvertTemperature::SetFahrenheit(COCall *pCall)
{
	int iRet;

	double dFahrenheit;
	if( iRet = pCall->GetDouble(0, dFahrenheit) )
		return iRet;

	m_dFahrenheit = dFahrenheit;
	m_dCelsius = FAHRENHEIT_TO_CELSIUS(dFahrenheit);

	return 0; // Success
}

//--------------------------------------------------------------------------
// OCConvertTemperature::CelsiusToFahrenheit
//
// Handle the CelsiusToFahrenheit member function.
//
// Origin C declaration:
//	 double CelsiusToFahrenheit(double dCelsius)
//--------------------------------------------------------------------------
int OCConvertTemperature::CelsiusToFahrenheit(COCall *pCall)
{
	int iRet;

	double dCelsius;
	if( iRet = pCall->GetDouble(0, dCelsius) )
		return iRet;

	double dFahrenheit = CELSIUS_TO_FAHRENHEIT(dCelsius);

	return pCall->SetReturnDouble(dFahrenheit);
}

//--------------------------------------------------------------------------
// OCConvertTemperature::FahrenheitToCelsius
//
// Handle the FahrenheitToCelsius member function.
//
// Origin C declaration:
//	double FahrenheitToCelsius(double dFahrenheit)
//--------------------------------------------------------------------------
int OCConvertTemperature::FahrenheitToCelsius(COCall *pCall)
{
	int iRet;

	double dFahrenheit;
	if( iRet = pCall->GetDouble(0, dFahrenheit) )
		return iRet;

	double dCelsius = FAHRENHEIT_TO_CELSIUS(dFahrenheit);

	return pCall->SetReturnDouble(dCelsius);
}
