/*--------------------------------------------------------------------------*
 * File Name:	SweepObj.h													*
 * Purpose:		Demostrate realtime update on a graph						*
 * Creation:	April 04, 2000												*
 * Copyright (c) 2000 Microcal Software, Inc.								*
 *																			*
 * Modification Log:														*
 *--------------------------------------------------------------------------*/      

#ifndef _SWEEPOBJ_H
#define _SWEEPOBJ_H  
//---------------------------------------------------------------------------
//								top of file
//---------------------------------------------------------------------------

#include "mocamain.h" // Required header file
#include "ThreadSubObj.h"


//---------------------------------------------------------------------------
// CSweepObj (main object class)
//
//---------------------------------------------------------------------------
class CSweepObj : public CMOCAObjBase
{
	// Declare Property Map if object has LabTalk properties
	MOCA_DECLARE_PROP_MAP(CSweepObj);

	// Declare Method Map if object has LabTalk methods
	MOCA_DECLARE_METH_MAP(CSweepObj)

	// Declare SubObject Map if object has LabTalk methods
	MOCA_DECLARE_SUBOBJ_MAP(CSweepObj)

public: // constructors and deconstructors
	CSweepObj();
	~CSweepObj();

private: // data members for LabTalk Properties

public: // member functions for LabTalk Properties
	BOOL GetNumPoints(int &iValue);
	BOOL SetNumPoints(int iValue);

	BOOL GetMaxNumPoints(int &iValue);
	BOOL SetMaxNumPoints(int iValue);

	BOOL GetWksName(LPSTR lpstr);
	BOOL SetWksName(LPCSTR lpcstr);

private: // member functions for LabTalk Methods

public: // data members for LabTalk subobjects
	CThreadSubObj m_ThreadSubObj;
};

//---------------------------------------------------------------------------
//								end of file
//---------------------------------------------------------------------------
#endif //_SWEEPOBJ_H
