/*--------------------------------------------------------------------------*
 * File Name:	dlgobj.cpp													*
 * Purpose:		Demonstrate how to access a resource dialog					*
 * Creation:	May 19, 2000												*
 * Copyright Microcal Software Inc. 2000									*
 *																			*
 * Modification Log:														*
 *--------------------------------------------------------------------------*/      

#include "dlgobj.h"
#include "modal.h"
#include "modeless.h"
#include "resource.h"

//---------------------------------------------------------------------------
// MOCA_ENTRY_POINT( <main object class> )
//
// The MOCA_ENTRY_POINT macro is used to define the exported function that
// Origin will use to communicate with your DLL.  The macro takes a single
// argument, the class name of your main object.
//---------------------------------------------------------------------------
MOCA_ENTRY_POINT(CDlgObj)


//---------------------------------------------------------------------------
// Property Map:
//
// The Property Map is for declaring the properties of your LabTalk object.
//
// A property is mapped to Get and Set function.  These functions allow
// you to do error checking or any necessary conversions.  A read-only
// property can be declared by using the _GET macro.
//
// MOCA_PROP_INT( <GetFunction>,<SetFunction>,<PropertyNameStr> )
// MOCA_PROP_REAL( <GetFunction>,<SetFunction>,<PropertyNameStr> )
// MOCA_PROP_STR( <GetFunction>,<SetFunction>,<PropertyNameStr> )
// MOCA_PROP_INT_GET( <GetFunction>,<PropertyNameStr> )
// MOCA_PROP_REAL_GET( <GetFunction>,<PropertyNameStr> )
// MOCA_PROP_STR_GET( <GetFunction>,<PropertyNameStr> )
//
// A Simple Property is mapped to a data member.  There are no Get/Set
// functions for a Simple Property.  MOCA will take care of the assignment.
// A simple read-only property can be declared by using the _GET macro.
//
// MOCA_SIMPLE_PROP_INT( <DataMember>,<PropertyNameStr> )
// MOCA_SIMPLE_PROP_REAL( <DataMember>,<PropertyNameStr> )
// MOCA_SIMPLE_PROP_STR( <DataMember>,<PropertyNameStr> )
// MOCA_SIMPLE_PROP_INT_GET( <DataMember>,<PropertyNameStr> )
// MOCA_SIMPLE_PROP_REAL_GET( <DataMember>,<PropertyNameStr> )
// MOCA_SIMPLE_PROP_STR_GET( <DataMember>,<PropertyNameStr> )
//---------------------------------------------------------------------------
MOCA_BEGIN_PROP_MAP(CDlgObj, CMOCAObjBase)
	MOCA_SIMPLE_PROP_STR(m_strColName, "ColName")
	MOCA_SIMPLE_PROP_STR(m_strWksName, "WksName")
	MOCA_PROP_INT_GET(GetPropIsModelessOpen, "IsModelessOpen")
MOCA_END_PROP_MAP(CDlgObj, CMOCAObjBase)


//---------------------------------------------------------------------------
// Method Map:
//
// INPORTANT: To have a Method Map or a SubObject Map, you must
// have a property map.  A property map can be empty.
//
// MOCA_METH_ENTRY( <MemberFunction>,<MethodNameStr> )
//
// <MemberFunction> must be declared as "BOOL foo(double &, CStringArray &);"
// The double is used for storing LabTalk's return value.
// The CStringArray contains the arguments passed from LabTalk.
//---------------------------------------------------------------------------
MOCA_BEGIN_METH_MAP(CDlgObj, CMOCAObjBase)
	MOCA_METH_ENTRY(MethodOpenModal, "OpenModal")
	MOCA_METH_ENTRY(MethodOpenModeless, "OpenModeless")
	MOCA_METH_ENTRY(MethodCloseModeless, "CloseModeless")
MOCA_END_METH_MAP(CDlgObj, CMOCAObjBase)


//---------------------------------------------------------------------------
// SubObject Map:
//
// IMPORTANT: To have a Method Map or a SubObject Map, you must
// have a property map.  A property map can be empty.
//
// MOCA_SUBOBJ_ENTRY( <m_SubObject>,<SubObjectNameStr> )
//
//---------------------------------------------------------------------------
// This MOCA example has no subobjects.
// The following is an example of how a SubObject table is declared.
//MOCA_BEGIN_SUBOBJ_MAP(CLASSNAME, BASECLASSNAME)
//	MOCA_SUBOBJ_ENTRY(m_SubObject, "SUBOBJECT")
// 	MOCA_SUBOBJ_ENTRY(m_SubObject2, "SUBOBJECT2")
//MOCA_END_SUBOBJ_MAP(CLASSNAME, BASECLASSNAME)


//---------------------------------------------------------------------------
// CDataSetDemo::CDataSetDemo
//
//---------------------------------------------------------------------------
CDlgObj::CDlgObj()
{
	m_strColName = "A";
	m_strWksName = "Data1";

	m_pDlg = NULL;
}

CDlgObj::~CDlgObj()
{
	if( m_pDlg ) // If dialog is open then close it.
	{
		m_pDlg->DestroyWindow();
		m_pDlg = NULL;
	}
}

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
BOOL CDlgObj::IsModelessOpen()
{
//	return (m_pDlg && m_pDlg->m_hWnd ? TRUE : FALSE);
	return (m_pDlg && m_pDlg->GetSafeHwnd() ? TRUE : FALSE);
}

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
BOOL CDlgObj::GetPropIsModelessOpen(int &iValue)
{
	iValue = (IsModelessOpen() ? 1 : 0);
	return TRUE;
}

//---------------------------------------------------------------------------
// CDlgObj::MethodOpenModal
//
//---------------------------------------------------------------------------
BOOL CDlgObj::MethodOpenModal(double &dReturn, CStringArray &argarray)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState());

	//CDialog dlg(IDD_SAMPLE);
	CSampleModalDlg dlg;

	dlg.m_strColName = m_strColName;
	dlg.m_strWksName = m_strWksName;

	int i = dlg.DoModal();
	if( i == IDOK )
	{
		m_strColName = dlg.m_strColName;
		m_strWksName = dlg.m_strWksName;
	}

	return TRUE; // LabTalk command succeeded
}

//---------------------------------------------------------------------------
// CDlgObj::MethodOpenModeless
//
// LabTalk return value:
//		0 = failed to open dialog
//		1 = successfully opened dialog
//		2 = dialog already open
//---------------------------------------------------------------------------
BOOL CDlgObj::MethodOpenModeless(double &dReturn, CStringArray &argarray)
{
	if( IsModelessOpen() ) // If dialog is already open
	{
		dReturn = 2.0;
	}
	else // If dialog is NOT already open then open it
	{
		AFX_MANAGE_STATE(AfxGetStaticModuleState());

		BOOL b = FALSE;

		m_pDlg = new CSampleModelessDlg;

		if( m_pDlg )
		{
			m_pDlg->m_strColName = m_strColName;
			m_pDlg->m_strWksName = m_strWksName;

			b = m_pDlg->Create(IDD_SAMPLE);
		}

		dReturn = (b ? 1.0 : 0.0);
	}

	return TRUE; // LabTalk command succeeded
}

//---------------------------------------------------------------------------
// CDlgObj::MethodCloseModeless
//
// LabTalk return value:
//		0 = failed to close dialog
//		1 = successfully closed dialog
//		2 = dialog already closed
//---------------------------------------------------------------------------
BOOL CDlgObj::MethodCloseModeless(double &dReturn, CStringArray &argarray)
{
	if( IsModelessOpen() ) // If dialog is open
	{
		AFX_MANAGE_STATE(AfxGetStaticModuleState());

		BOOL b = m_pDlg->DestroyWindow();
		if( b )
		{
			m_pDlg = NULL;
			dReturn = 1.0;
		}
		else // Failed to close dialog
			dReturn = 0.0;
	}
	else // Dialog is already closed
		dReturn = 2.0;

	return TRUE; // LabTalk command succeeded
}
