/*--------------------------------------------------------------------------*
 * File Name:	dlgobj.h													*
 * Purpose:		Demonstrate how to access a resource dialog					*
 * Creation:	May 19, 2000												*
 * Copyright Microcal Software Inc. 2000									*
 *																			*
 * Modification Log:														*
 *--------------------------------------------------------------------------*/      

#ifndef _DLGOBJ_H
#define _DLGOBJ_H


#include "mocamain.h" // Required header file
#include "modal.h" // modal dialog class
#include "modeless.h" // modeless dialog class


//---------------------------------------------------------------------------
// Define main object class
//---------------------------------------------------------------------------
class CDlgObj : public CMOCAObjBase
{
	// Declare Property Map if object has LabTalk properties, methods or SubObjects
	MOCA_DECLARE_PROP_MAP(CDlgObj);

	// Declare Method Map if object has LabTalk methods
	MOCA_DECLARE_METH_MAP(CDlgObj)

	// Declare SubObject Map if object has LabTalk SubObjects
	//MOCA_DECLARE_SUBOBJ_MAP(CDataSetDemo)

public: // constructor and destructor
	CDlgObj();
	~CDlgObj();

	BOOL IsModelessOpen();

private: // data members for LabTalk Properties
	CString m_strColName;
	CString m_strWksName;

private: // data member for internal use
	CSampleModelessDlg *m_pDlg;

public: // member functions for LabTalk Properties
	BOOL GetPropIsModelessOpen(int &iValue);

private: // member functions for LabTalk Methods
	BOOL MethodOpenModal(double &dReturn, CStringArray &argarray);
	BOOL MethodOpenModeless(double &dReturn, CStringArray &argarray);
	BOOL MethodCloseModeless(double &dReturn, CStringArray &argarray);
};

#endif // _DLGOBJ_H
