/*------------------------------------------------------------------------------*
 *	File Name: 	MOCASCRIPT.H													*
 *	Purpose:	Header of script object class									*
 *																				*
 *																				*
 *	Author:		RVD																*
 *  Creation:	10/06/2000 														*
 *  	Copyright (c) Microcal Software Inc. 1996, 1997, 1998, 1999, 2000		*
 *																				*
 *	Modification log                                                        	*
 *	TD 12/18/2000 ALLOW_COMPILATION_OF_VAR_INITIALIZATION						*
 *	TD 01/17/2001 t8820 USE_NUMERIC_IDS_FOR_TYPE_NAMES							*
 *	ML 1/24/2000 EXPRESSION_HANDLING_USING_OBJECT								*
 *	1/25/2001 EXTEND_COMPILER_BEYOND_DOUBLES									*
 *	ML 1/26/2000 IMPLEMENTING_ARRAYS											*
 *	ML 1/29/2000 ARRAY_MORE_WORK												*
 *	ML 1/31/2000 MULTIDIMENSION_DEREFERENCING									*
 *	ML 2/1/2001 STRING_ARRAYS													*
 *	TD 2/12/2001 EFFICIENT_BASE_TYPES_HANDLING									*
 *	TD 2/15/2001 NEW_BASECLASS_FOR_TYPE_OBJECTS									*
 *	ML 2/19/2001 COMPILING_REFERENCES											*
 *	ML 2/21/2001 OPERATIONS_WITH_SIMPLE_UNARY									*
 *	ML 2/21/2001 POINTERS_FIRST_PHASE											*
 *	ML 2/22/2001 CLEANINING_UP_DEPRECATED_STUFF									*
 *	ML 2/23/2001 VECTOR_TYPING_ETC												*
 *	ML 2/22/2001 VECTOR_WORK													*
 *	ML 2/26/2001 MORE_DEREFERENCING_IMPROVEMENTS								*
 *	ML 2/27/2001 GETTING_EXPRESSION_TYPES										*
 *	CPY 2/27/01 v6.1096 ADD_TYPE_DEF											*
 *	ML 3/5/2001 POINTERS_POINTERS												*
 *	ML 3/7/2001 MORE_FRIENDLY_WAY_TO_GET_BUFFER									*
 *	TD 3/7/2001 SEPERATE_CREATION_OF_OBJECT_FROME_ADDING_THEM_TO_STACK			*
 *	EJP 03-12-2001 t8865 IMPLEMENT_IDE_VARIABLE_WINDOW							*
 *	TD 03/21/2001 IMPLEMENT_VOID												*
 *	ML 3/28/2001 OVECTOR_WORK													*
 *	EJP	03-30-2001 t9018 IMPLEMENT_FUNCTION_OVERLOAD							*
 *	CPY 03-31-2001 t9030 WORKSHEET_CLASS_IN_ORIGIN_C							*
 *	ML 4/3/2001 MORE_STRUCTURE_WORK												*
 *	CPY 4/4/01 ADD_ORGIIN_C_OBJECT_AS_BASE_CLASS								*
 *	TD 4-10-2001 t9050 ADD_FUNCTION_TO_ACCESS_UNDERLYING_DATA_STRUCTURE			*
 *	ML 4/12/2001 POINTERS_ASSIGNMENT											*
 *	ML 4/13/2001 POINTER_ARITHMETICS											*
 *	ML 4/15/2001 CALLING_EXTERNAL_FUNCTION_OF_ARBIRARY_PROTOTYPE				*
 *	TD 4-19-2001 t9054 MULTIMEMBER_ACCESS_TO_CLASS_N_STRUCT						*
 *	TD 4-23-01 ADD_COLUMN_TYPE_IN_ORIGIN_C										*
 *	TD 05-04-01 v6.9012 STRUCTS_WITH_SIMPLE_MEMBER_TYPE_CREATED_THE_C_WAY		*
 *	ML 5/8/2001 MEMORY_PTR_FURTHER_WORK											*
 *	TD 5-09-01 t9062 v6.9012 ADD_SUPPORT_FOR_ANSI_CONSATNTS_IN_ORIGIN_C			*
 *	ML 5/11/2001 PTR_COMPARISONS												*
 *	ML 5/11/2001 IT_HAS_TO_CALL_OperateMultiDim									*
 *	ML 5/11/2001 INITIALIZING_CHAR_ARRAY_FROM_ANOTHER_CHAR_ARRAY				*
 *	ML 5/11/2001 MEMORY_POINTER_RETURNING_FROM_FUNCTIONS						*
 *	ML 5/15/2001 MUST_CHECK_TARGET_TYPE_WHEN_CASTING_POINTER_TO_POINTER			*
 *	ML 5/15/2001 PASSING_SCRIPT_MOCA_OBJECTS_TO_EXTERNAL_FUNCTIONS				*
 *	TD 5-17-01 t9153 CREATE_A_TEMP_SERIES_WHEN_ANY_VETOR_ASSIGNED_TO_DATASET_UNATTACHED
 *	ML 5/22/2001 t9074 VECTOR_TO_SIMPLE_TYPE_FUNCTION_CALL_MORE_WORK			*
 *	ML 5/29/2001 t9168 ENUM_IMPLEMENTATION										*
 *	ML 6/1/2001 MATRIX_WORK														*
 *	ML 6/6/2001 SAFE_FLOATING_DIVIDE_FIX										*
 *	ML 6/6/2001 MATRIX_TYPES													*
 *	ML 6/8/2001 PASSING_PTR_DEREFERENCE_TO_REFERENCE							*
 *	ML 6/11/2001 CORRECT_TYPES_FOR_RELATIONAL_COMPARISONS						*
 *	ML 6/18/2001 t9260 MULTIPLE_POINTERS										*
 *	AW 6/21/2001 Array_Initialization											*
 *	ML 6/22/2001 VECTOR_OR_MATRIX_ASSIGNMENT_LHS_TEMPORARY_BUG					*
 *	ML 6/22/2001 t9264 MEMORY_PTRS_AS_STRUCTURE_MEMBERS_PASSED_TO_FUNCS			*
 *	AW 6/27/2001 t9137 VECTOR_DISPLAY											*
 *	AW 6/28/2001 t9137 VARIABLE_DISPLAY											*
 *	ML 6/27/2001 t9281 ORIGINC_EXPLICIT_CASTS									*
 *	TD 6-28-01 t9243 SUPPORT_USER_DEFINED_ORIGINC_CLASSES						*
 *	ML 7/3/2001 EXPLICITLY_CASTING_PTRS_TO_SIMPLE_NUMERIC_TYPES_AND_TO_STRUCTURES_TO_SIMPLE_NUMERIC_TYPES
 *	ML 7/5/2001 STRING_TO_CHARACTER_PTR											*
 *	ML 7/6/2001 t9283 COMPLEX_TYPES												*
 *	CPY v6.9037 6/25/01 t9247 ORIGIN_C_COMPILED_FUNC_RETURN_TEMP_SERIES			*
 *	AW 07/08/2001 t8989 complex_class											*
 *	TD 7-11-01 t9298 CALLBACK_FUNCTIONS_IN_ORIGINC								*
 *	ML 7/6/2001 t9283 COMPLEX_TYPES												*
 *	ML 7/11/2001 MUST_CHECK_FOR_ZERO_DENOMINATOR								*
 *	AW 7/16/2001 UPDATE_CVT_EXPRESSION_NUMERIC									*
 *	TD 7-23-01 ATTACH_2_SERIES_TO_A_CURVE										*
 *	TD 7-24-01 ALLOW_GETTING_UNDERLYING_CPP_ARRAY_OBJECT_FROM_ARG				*
 *	ML 8/3/2001 USE_ALWAYS_MEMORY_PTR_FOR_SIMPLE_TYPES							*
 *	ML 8/6/2001 t9309 COM_SUPPORT_IN_ORIGIN_C									*
 *	ML 8/8/2001 t9309 MORE_COM_ACCESS_WORK										*
 *	ML 8/9/2001 ORIGIN_C_VARIANT												*
 *	ML 8/13/2001 t9309 IMPLEMENTING_bool_FOR_COM								*
 *	ML 8/14/2001 t9309 COM_METHODS												*
 *	ML 8/21/2001 t9309 ASSIGNING_COM_VARIANT_ARRAYS_TO_VECTORS_OR_MATRICES		*
 *	TD 8-22-01 t9463 IMPLEMENT_BITFIELDS_SUPPORT								*
 *	TD t9407 CONSISTENT_CASTING_USE_CSTYLE_AND_CONCATENATE						*
 *	CPY v6.9084 9/7/01 GET_STR_NEED_SEPARATE_DISPLAY_AND_ASSIGNMENT				*
 *	TD 9-10-01 GETTING_TARGET_FROM_REFERNCE_OBJECT_INSIDE_METHODS				*
 *	TD 9-13-01 t9514 ORIGIN_C_COLLECTION										*
 *	ML 9/14/2001 GETTING_VECTOR_DATA_INTO_VARIANT_AS_ONEDIMENSIONAL_SAFEARRAY	*
 *	ML 9/17/2001 GETTING_SPCBLOB_INTO_WORKSHEET									*
 *	ML 9/25/2001 GROBJ_COLLECTION												*
 *	TD 9-28-01 t9553 GET_ACTIVE_PAGE											*
 *	ML 10/2/2001 MULTIPLE_MEMORY_PTR_DEREFERENCING_IMPROVEMENTS					*
 *	ML 10/11/2001 HANDLE_ASSIGNING_ARRAY_PTRS_TO_MULTIPLE_PTR					*
 *	ML 10/12/2001 MORE_WORK_SUBTRACTING_PTRS									*
 *	ML 10/16/2001 t9596 ORIGINC_ROI_ACCESS										*
 *	ML 10/23/2001 t9629 PROJECT_EXPLORER_ORIGINC_INTERFACE						*
 *	ML 10/26/2001 HANDLING_WRONG_ARGUMENT_VARIANT_TYPES_IN_COM_EVENT_HANDLERS	*
 *	TD 10-29-01	CATEGORICAL_DATA												*
 *	ML 11/2/2001 CANNOT_RESET_STRING_AS_RETURNVALUE_AFTER_EXTERNAL_FUNCTION_CALL*
 *	TD 11-07-01 t9619 v6.9119 USING_IN_OC										*
 *	TD 11-13-01 ADD_ATTACH_USING_WORKSHEET_AND_COLUMN_REF						*
 *	TD 11-14-01 ORGANIZE_ORIGINC_CLASSES										*
 *	TD 10-54-01 CONDITIONALLY_COMPILE_OUT_NON_DOUBLE_TEMPLATE_CREATION			*
 *	YuI 11/17/01 v6.9128 t9727 OCPOINT_AND_OCRECT_CLASSES_IMPLEMENTATION		*
 *	TD 11-26-01 CSHARP_STYLE_CONSIDERATION_OF_WRAPPER_OBJECTS_AS_BOOL			*
 *	ML 12/17/2001 t9814 CREATING_GRAPH_FROM_TEMPLATE_IN_ORIGINC					*
 *	TD	12-20-01 ADD_BASEPAGE_AS_BASE_OF_PAGE									*
 *	TD 1-4-02 t9809 MATRIX_OBJECT_BASED_ON_COLUMN_OBJECT						*
 *	TD 1-29-02 QA70-592 v6.9197 PROPER_HANDLING_OF_DATASET_RANGE_FROM_KERNEL	*
 *	TD 2-12-02 QA70-771 v6.9211 ORIGINC_DEBUG_MODE								*
 *	TD 2-15-02 INITIALIZE_OCDATA_TO_ZERO										*
 *	ML 2/21/2002 QA70-965 APPENDING_TO_VECTORS_AND_DATASETS						*
 *	TD 2-22-02 QA70-945 v7.0221 ASK_LABTALKMGR_IF_ORIGIN_CAN_CLOSE				*
 *	TD 3-5-02 QA70-696 v7.0235 NEW_SCALE_CLASS_IN_OC							*
 *	TD 3-7-02 BUFFER_SIZE_SET_GET_EXPOSED										*
 *	YuI 3/13/2 QA70-1043 v7.0233 GET_ROI_DATA									*
 *	TD 3-15-02 QA70-1145 NON_TEMPLATE_ABSTRACT_BASE_FOR_MATRICES_AND_VECTORS	*
 *	AW 03/18/02 QA70-1105 DEBUG_VARIABLE_DISPLAY_IMPROVEMENT					*
 *	YuI 3/25/2 QA70-1043 v7.0255 GET_ROI_DATA									*
 *	ML 4/9/2002 QA70-929 ORIGINC_FUNCTION_POINTERS								*
 *	AW 04/16/02 ADD_UPDATE_FLAG													*
 *	YuI 4/29/02 v.70295 QA70-1642 DISPLAY_ELEMET_FUNCTION_FOR_EACH_OC_CLASS		*
 *	AW 04/29/02 QA70-1636 DATASET_COPY_IN_ORIGINC								*
 *	TD 5-04-02 KEY_INFO_PROPERTY_OF_WRAPPERS_WITH_DYNAMIC_SUBPROPERTIES			*
 *	AW 05/05/02 v7.0302 QA70-1655 POINT_POINTF_POINTC_SUPPORT					*
 *	ML 5/20/2001 QA70-1851 GETTING_SELECTED_COLUMNS_ORIGIN_C					*
 *	TD 5-24-02 QA70-1882 v7.0310 TEMPLATE_DATA_ATTACHMENT_FAILURE_TREATED_AS_RUN_TIME_ERROR*
 *	RVD 6/13/2002 QA70-1955 v7.0318 ORIGIN_OBJECT_SHOW_METHOD					*
 *	AW 06/18/02 v7.0323 QA70-2055 MORE_WORK_ON_GETAS_VECTOR						*
 *	AW 06/26/02 v7.0328 QA70-2116 MOCABASETYPE_NAG_DLL_SUPPORT					*
 *	TD 7-01-02 QA70-2181 v7.0331 LABTALK_STRING_VECTORS_TO_OCVECTORS			*
 *	TD 7-5-02 QA70-2223 v7.0332	DIALOG_CLASS_FOR_DB_EVENT_CATCHING				*
 *	AW 07/19/02 v7.0345 QA70-2397 ADD_OCDATAOBJECTBASE_CLASS					*
 *	TD 7-26-02 QA70-2424 v7.0352 ORIGINC_WRAPPER_OBJECTS_CRASH_AFTER_CLOSING_PROJECT	*
 *	TD 7-29-02 QA70-1882 @BC_AND_@BCM_FOR_OC_MEM_EXCEPTION						*
 *  TCZ 07/6/02 QA70-2187  v7.0337 MATRIX_BASIC_OPERATION						*
 *	TD 8-17-02 QA70-2715 v7.0374 GETDATAOBJECTC_IN_APPLICATION	(Cleanup)		*
 *	TD 8-23-02 QA70-2780 v7.0381 WRITING_ACROSS_BDRY_PROTECTION_DEF_WITH_SIZE_10*
 *	ML 8/24/2002 QA70-2805 PASSING_DISPINTERFACES_AS_ARGUMENTS_OF_EVENT_HANDLERS*
 *	TD 8-26-02 QA70-2780 v7.0384 SEPERATE_VARS_FOR_DEBUG_AND_EXTRA_MEMORY		*
 *	TD 10-4-02 QA70-2177 v7.0408 ORIGIN_C_ACCESS_TO_STORAGE						*
 *	TD 10-21-02 QA70-3181 ORIGINC_CLASSES_FOR_DIALOG_MEMBERS					*
 *	CPY 10/28/02 v7.0423 MAKING_RELEASE_CONDITIONAL_ON_OC_CONTROLS_IN_DDK		*
 *	TD 10/29/02 QA70-3182 v7.0424 OCDIALOG_MSG_MAP_IMPLEMENT					*
 *	TD 11-12-02 QA70-1644 v7.0433 MULTIPLE_GRAPHS_WITH_DIALOG_BUILDER			*
 *	CPY 11/15/02 v7.0434 QA70-3212 BASIC_CWND_SUPPORT_SIMPLE					*
 *	CPY 11/5/02 v7.0428 QA70-3213  ADD_FONT_INIT_TO_TREE_EDITOR					*
 *	AW 12/03/02 QA70-2196 v7.0477 POINTER_OBJECT_VARIABLE_DISPLAY				*
 *	ML 12/5/2002 QA70-3458 CASTING_LPVOID_TO_DOUBLE_MEMORY_PTR					*
 *	TD 12-12-02 QA70-3133 v7.0452 NO_OC_BUILD_REQUEST_WHILE_EXECUTION			*
 *	DVT 12/18/02 QA70-3537 v7.0467 ADD_MATLAB_CLASS_FOR_COMMUNICATION			*
 *	ML 12/20/2002 QA760-3535 TEMPORARY_ACTIVEX_CONTROL_FIX_BETTER				*
 *	TD 12-23-02 TREE_CLASS_IN_EXTERNAL_DLL_SHARE_STRUCTURE_DETAILS				*
 *	AW 12/24/02 QA70-3477 v7.0473 CASTING_ORIGINCOBJECT_TO_DERIVED_CLASS		*
 *	TD 1-14-03 QA70-3671 v7.0487 LIMTED_ACCESS_TO_ACTIVEX_CONTROLS				*
 *	TD 1-27-02 TREE_CLASS_IN_EXTERNAL_DLL_SHARE_STRUCTURE_DETAOILS				*
 *	TD 2-3-03 QA70-3681 ALLOW_DOTTED_ACCESS_TO_OBJECT_FORMAT_AND_TREENODE		*
 *	DVT 2/11/03 QA70-3684 v7.0510 ORIGIN_AUTOMATION_SERVER						*
 *	JCG 03/10/03 QA70-4013 v7.0531 CLEAN_UP_OC_MTX_AND_RECT_COODINATES			*
 *	ML 3/14/2003 QA70-4067 PASSING_DATASETS_FROM_LABTALK_TO_STRING_VECTORS_AND_RETURNING_STRING_VECTORS
 *	ML 3/23/2003 QA70-4113 INITIALIZING_VECTOR_FROM_COLUMN_FOR_WRITEBACK		*
 *	DVT 3/26/03 QA70-4139 v7.0545 OC_CATEGORICAL_INFORMATION_METHOD				*
 *	YuI 3/31/03 v7.0550 QA70-4160 NEW_OC_OPERATION_HANDLING						*
 *	ML 4/14/2003 QA70-4264 GETTING_ARGUMENT_PTR_IF_NULL_AS_NULL					*
 *	DVT 4/14/03 QA70-4257 v7.0560 OC_ORIGINOBJECT_GETNAME_MATHOD				*
 *	DVT 4/21/03 ADD_DOTTED_OIDE_TOOLTIPS										*
 *	ML 5/6/2003 QA70-4373 BETTER_CURVE_ARITHMETICS								*
 *	YuI 5/05/03 v7.0578 QA70-4357 CURVE_AS_INPUT_OF_OPERATION					*
 *	CPY 5/28/03 QA70-3737 v7.0594 VEC_SET_SUB_VEC_MUST_CHECK_MIXED				*
 *	TD 5-30-03 QA70-4563 REFERNCES_TO_WRAPPER_DATA_NEEDS_DETACHMENT_AFTER_DETACHED_FROM_ALL_REFS*
 *	ML 5/29/2003 QA70-4562 CURVE_EXTENSION_WITH_RELATED_DATASETS				*
 *	RVD 6/13/2003 QA70-4650 v7.0601 OBJECT_PROPERTY_ACCESS						*
 *	AW 06/29/03 QA70-4733 v7.0612 SMART_COUNT_NUMBER_FOR_REF					*
 *	TD 7-30-03 EXPLICIT_DOWNCAST												*
 *	ML 10/15/2003 QA70-5361 UPDATING_WKS_FROM_EXCEL_FOR_GETTING_INTO_MATRIX		*
 *	TD 11-3-03 QA70-5067 MESSAGE_HANDLING_FROM_BASE_CLASS_OF_WINDOW				*
 *------------------------------------------------------------------------------*/

#ifndef _MOCASCRIPT_H
#define _MOCASCRIPT_H

//-------- CPY 10/28/02 v7.0423 MAKING_RELEASE_CONDITIONAL_ON_OC_CONTROLS_IN_DDK
//#include	"stdafx.h"
//--------
#include	"mocadef.h" // Required header file
#include	"LTtype.h"


////////////////////////////////////////////////////////////////////////////
////
////	THE Following constants are enumerated types
////	every string type must have a unique numeric type 0...32
////	the limitation on the range comes from our use of these
////	constatnts as a bit in DWORD
////

/// TD 10-54-01 CONDITIONALLY_COMPILE_OUT_NON_DOUBLE_TEMPLATE_CREATION
//#define  CONDITIONALLY_COMPILE_OUT_NON_DOUBLE_TEMPLATE_CREATION
/// end CONDITIONALLY_COMPILE_OUT_NON_DOUBLE_TEMPLATE_CREATION

/// TD 01/17/2001 t8820 USE_NUMERIC_IDS_FOR_TYPE_NAMES
/*
enum{
	LTT_ID_INT	=	1,
	LTT_ID_DOUBLE,
	LTT_ID_COMPLEX,
	LTT_ID_STRING,
	LTT_ID_VECTOR,
	LTT_ID_POINTER,
	LTT_ID_FUNCTION,
	LTT_ID_USER
};*/

#include "OClassIDs.h" //CPY 11/19/02 move all const into this separate file


/// TD 11-26-01 CSHARP_STYLE_CONSIDERATION_OF_WRAPPER_OBJECTS_AS_BOOL
#define		IS_WRAPPER_CLASS_ID(_nID)	   IsWrapperClassID((_nID))

BOOL IsWrapperClassID(UINT nId);   //Declaration in MOCascript.cpp shared by the dll
/// end CSHARP_STYLE_CONSIDERATION_OF_WRAPPER_OBJECTS_AS_BOOL


/// end USE_NUMERIC_IDS_FOR_TYPE_NAMES

/// AW 12/24/02 QA70-3477 v7.0473 CASTING_ORIGINCOBJECT_TO_DERIVED_CLASS
#define		IS_OKWRAPPER_CLASS_ID(_nID)	   IsOKWrapperClassID((_nID))
BOOL IsOKWrapperClassID( UINT nId );
/// END CASTING_ORIGINCOBJECT_TO_DERIVED_CLASS



/// TD 10-21-02 QA70-3181 ORIGINC_CLASSES_FOR_DIALOG_MEMBERS
#define MIN_CONTROL_ID  LTT_ID_CONTROL
//#define MAX_CONTROL_ID  LTT_ID_CONTROL_EDIT
#define MAX_CONTROL_ID  LTT_ID_CONTRO_END

#define IS_CONTROL_ID(_ID)		((_ID) >=  MIN_CONTROL_ID &&  MAX_CONTROL_ID >=  (_ID))	
	/// TD 1-10-03  There are two types of Window derived calsses, The ones that's derived from the control class, are in DDK
//#define IS_CWND_WRAPPER(_ID)	(LTT_ID_UD_CLASS == (_ID )|| LTT_ID_CWND == (_ID) || LTT_ID_WNDCTRL_ORIGIN_GRAPH == (_ID))
#define IS_CWND_WRAPPER(_ID)	(LTT_ID_UD_CLASS == (_ID )|| (LTT_ID_CWND_WRAPPER_BEGIN <(_ID) && LTT_ID_CWND_WRAPPER_END > (_ID)))
/// end ORIGINC_CLASSES_FOR_DIALOG_MEMBERS
/// TD 12-15-02 QA70-3183 v7.0464 TREE_IN_OC
/// RVD 6/13/2003 QA70-4650 v7.0601 OBJECT_PROPERTY_ACCESS
//#define IS_TREE_TYPE_ID(_ID)		((_ID) >=  LTT_ID_TREE_NODE &&  LTT_ID_TREE >=  (_ID))	
#define IS_TREE_TYPE_ID(_ID)		((_ID) >=  LTT_ID_PROPERTYNODE && LTT_ID_TYPEDTREE >= (_ID))
/// end OBJECT_PROPERTY_ACCESS
/// end TREE_IN_OC





//////////////////////////////////////////////////////////////////////////////
//
// Symbolic constatnts -- Flags for the exported function MOCA_XPORT_CREATEOBJ
//

#define MOCA_CREATE_FROM_LPCSTR						0x0000/// TD 12/18/2000 ALLOW_COMPILATION_OF_VAR_INITIALIZATION
#define MOCA_CREATE_SET_CALLBACK					0x0001
#define MOCA_CREATE_FROM_LPDOUBLE					0x0002/// TD 12/18/2000 ALLOW_COMPILATION_OF_VAR_INITIALIZATION
#define MOCA_CREATE_FROM_LPSCRPTOBJ					0x0003/// TD 12/18/2000 ALLOW_COMPILATION_OF_VAR_INITIALIZATION
#define MOCA_CREATE_UPDATE_DEBUGMODE				0x0004///	TD 2-12-02 QA70-771 v6.9211 ORIGINC_DEBUG_MODE
#define MOCA_SET_CREATION_ERROR_CALLBK				0x0005/// TD 5-24-02 QA70-1882 v7.0310 TEMPLATE_DATA_ATTACHMENT_FAILURE_TREATED_AS_RUN_TIME_ERROR

#define MOCA_SET_NAG_RELATED_CALLBACKS				0x0006   // AW 06/26/02 v7.0328 QA70-2116 MOCABASETYPE_NAG_DLL_SUPPORT
#define MOCA_SET_GET_LTVECTOR_CALLBK				0x0007   /// TD 7-01-02 QA70-2181 v7.0331 LABTALK_STRING_VECTORS_TO_OCVECTORS
/// TD 5-24-02 QA70-1882 v7.0310 TEMPLATE_DATA_ATTACHMENT_FAILURE_TREATED_AS_RUN_TIME_ERROR
//typedef  CArray<UINT, UINT>		Index;
typedef		int		MoCreateErr;
typedef void (*LPFNSetLtErr)(MoCreateErr&);
typedef int (CALLBACK * CBkLTVect)(CStringArray*, LPSTR, bool); /// TD 7-01-02 QA70-2181 v7.0331 LABTALK_STRING_VECTORS_TO_OCVECTORS
/// end TEMPLATE_DATA_ATTACHMENT_FAILURE_TREATED_AS_RUN_TIME_ERROR

/// YuI 3/25/2 QA70-1043 v7.0255 GET_ROI_DATA
///// YuI 3/13/2 QA70-1043 v7.0233 GET_ROI_DATA
//typedef enum tagGETROIDATACNTRL
//{
//	GET_ROI_DATA	=	0,
//	GET_ROI_I,
//	GET_ROI_J,
//}	GETROIDATACNTRL;
//
//typedef enum tagOCGRAPHOBJGETINFOMSG
//{
//	OCGIM_GetROIData	=	0,
//}	OCGRAPHOBJGETINFOMSG;
///// end GET_ROI_DATA
/// end GET_ROI_DATA
/// TD 2/29/2001 UNUSED_CODES
/*
////////////////////////////////////////////////////////////////////////////
//		COperationInfo header/body class
//
class COperationInfo : public CObject
{
	DECLARE_DYNAMIC(COperationInfo);
public:

   COperationInfo(char cOperator, DWORD dwValidBits, DWORD dwValidReturns);
   COperationInfo(COperationInfo& oOperationInfo);
   ~COperationInfo();


   BOOL	IsTypeBitValid(DWORD dwTypeBit);
   BOOL	IsOperator(char cOperator);

private:

	DWORD m_dwValidBits;
	char  m_cOperator;

public:

	DWORD m_dwValidReturns;
};





////////////////////////////////////////////////////////////////////////////
//		COPCompatTable header/body class
//
class COPCompatTable : public CObject
{
	DECLARE_DYNAMIC(COPCompatTable);
public:
	COPCompatTable();
	~COPCompatTable();

public:

	DWORD CanOperate(char cOperator, int nLType, int nRType);
private:

	CMap<DWORD, DWORD, COperationInfo*, COperationInfo*> m_GrpOIMap;
};
*/
/// end----------------TD 2/29/2001 UNUSED_CODES


/// ML 7/11/2001 MUST_CHECK_FOR_ZERO_DENOMINATOR
///// ML 6/6/2001 SAFE_FLOATING_DIVIDE_FIX
////#define		MOCA_SAFE_DOUBLE_DIVIDE(_rNum, _rDen)   ( (1. <= (_rDen) || fabs(_rNum) < (_rDen) * 1.7E+308) ? (_rNum) / (_rDen) : NANUM )
//#define		MOCA_SAFE_DOUBLE_DIVIDE(_rNum, _rDen)   ( (1. <= fabs(_rDen) || fabs(_rNum) < fabs(_rDen) * 1.7E+308) ? (_rNum) / (_rDen) : NANUM )
///// end SAFE_FLOATING_DIVIDE_FIX
///  end MUST_CHECK_FOR_ZERO_DENOMINATOR
/// TD 8-17-02 QA70-2715 v7.0374 GETDATAOBJECTC_IN_APPLICATION
#define		DISPL_INVALID_WRAPPER	_T("Invalid Object")
/// end GETDATAOBJECTC_IN_APPLICATION
/// ML 1/24/2000 EXPRESSION_HANDLING_USING_OBJECT
typedef	struct	tagSMOOPERATECTXT {
	DWORD			dwParam;
	/// ML 5/11/2001 PTR_COMPARISONS
	// Possible bits:
	#define			DWORDSMOOPERATECTXT_TRUE												0x00010000UL
	/// end PTR_COMPARISONS
	/// ML 6/22/2001 VECTOR_OR_MATRIX_ASSIGNMENT_LHS_TEMPORARY_BUG
	#define			DWORDSMOOPERATECTXT_KEEP_DEST_SOURCE_SIZE_IF_NO_SOURCE_VECTOR_OR_MATRIX	0x00020000UL
	/// end VECTOR_OR_MATRIX_ASSIGNMENT_LHS_TEMPORARY_BUG
	/// ML 10/2/2001 MULTIPLE_MEMORY_PTR_DEREFERENCING_IMPROVEMENTS
	#define			DWORDSMOOPERATECTXT_PTR_DEREF											0x00040000UL
	/// end MULTIPLE_MEMORY_PTR_DEREFERENCING_IMPROVEMENTS
	/// ML 2/21/2002 QA70-965 APPENDING_TO_VECTORS_AND_DATASETS
	#define			DWORDSMOOPERATECTXT_APPEND												0x00080000UL
	/// ML end QA70-965 APPENDING_TO_VECTORS_AND_DATASETS
	/// ML 5/6/2003 QA70-4373 BETTER_CURVE_ARITHMETICS
	#define			DWORDSMOOPERATECTXT_TEMP_FOR_FIRST_BINARY_OPERAND						0x00100000UL
	/// end QA70-4373 BETTER_CURVE_ARITHMETICS
	/// AW 06/25/03 QA70-4714 v7.0606 SUPPORT_REF_RETURN
	#define			DWORDSMOOPERATECTXT_CALLED_FROM_RETURN									0x00200000UL
	/// END SUPPORT_REF_RETURN
	/// ML 10/12/2001 MORE_WORK_SUBTRACTING_PTRS
	PUINT			pnPtrSubtractSizeOfOne;	// in:		double	*p1, *p2; ...; int nn = p2 - p1;
	/// TD 8-26-03 QA70-NEEDTRACKER POINTER_CREATION_AND_ASSIGNMENT_BUG
	#define			DWORDSMOOPERATECTXT_PTR_ACTUAL_TARGET									0x00400000UL
	/// end POINTER_CREATION_AND_ASSIGNMENT_BUG
											// pnPtrSubtractSizeOfOne will point at sizeof(double)
	/// end MORE_WORK_SUBTRACTING_PTRS
} SMOOPERATECTXT, FAR	*LPSMOOPERATECTXT;


/// ML 5/11/2001 PTR_COMPARISONS
#define			SET_DWORDSMOOPERATECTXT_TRUE(_lpOperctxt, _bSet)		((_bSet) ? ((_lpOperctxt)->dwParam |= DWORDSMOOPERATECTXT_TRUE) : ((_lpOperctxt)->dwParam &= ~DWORDSMOOPERATECTXT_TRUE))

#define			IS_DWORDSMOOPERATECTXT_TRUE(_lpOperctxt)				(((_lpOperctxt)->dwParam & DWORDSMOOPERATECTXT_TRUE) ? TRUE : FALSE)
/// end PTR_COMPARISONS


// dwOperator in 'OperateEx()'

#define		CSMOOPERATOR_MASK_NO_OTHER			0x00000080UL	// those that do not require the other term (pSMO)
/// ML 5/11/2001 PTR_COMPARISONS
/// ML 6/11/2001 CORRECT_TYPES_FOR_RELATIONAL_COMPARISONS
//#define		CSMOOPERATOR_RELATIONAL_MASK		0x00000100UL
#define		CSMOOPERATOR_RELATIONAL_MASK		0x00000040UL		// must be within CSMOOP_GET_BASIC_OPERATOR()
/// end CORRECT_TYPES_FOR_RELATIONAL_COMPARISONS
/// end PTR_COMPARISONS

/// ML 1/29/2000 ARRAY_MORE_WORK
#define		CSMOOPERATOR_APPLY_INDEX_TO_SOURCE	0x00010000UL	// the source should be indexed, rather than the destination
/// end ARRAY_MORE_WORK
/// ML 2/21/2001 OPERATIONS_WITH_SIMPLE_UNARY
#define		CSMOOPERATOR_CHANGE_SOURCE_SIGN		0x00020000UL	// unary "-"
#define		CSMOOPERATOR_NOT_SOURCE				0x00040000UL	// unary "!"
#define		CSMOOPERATOR_BINARY_NOT_SOURCE		0x00080000UL	// unary "~"
/// ML 5/11/2001 IT_HAS_TO_CALL_OperateMultiDim
#define		CSMOOPERATOR_ARRAY_TO_PTR			0x00100000UL
/// end IT_HAS_TO_CALL_OperateMultiDim
/// ML 5/11/2001 INITIALIZING_CHAR_ARRAY_FROM_ANOTHER_CHAR_ARRAY
#define		CSMOOPERATOR_INIT_VARIABLE_COMPILE	0x00200000UL	// not really used inside the types DLL, only in compiler
/// end INITIALIZING_CHAR_ARRAY_FROM_ANOTHER_CHAR_ARRAY
/// ML 5/11/2001 MEMORY_POINTER_RETURNING_FROM_FUNCTIONS
#define		CSMOOPERATOR_INIT_RETURN_TYPE		0x00400000UL	// not really used inside the types DLL
/// end MEMORY_POINTER_RETURNING_FROM_FUNCTIONS
/// ML 6/8/2001 PASSING_PTR_DEREFERENCE_TO_REFERENCE
#define		CSMOOPERATOR_SET_TO_MEM_POINTER_TARGET		0x00800000UL	// must be a bit, instead of a value
/// end PASSING_PTR_DEREFERENCE_TO_REFERENCE
/// ML 7/5/2001 STRING_TO_CHARACTER_PTR
#define		CSMOOPERATOR_STRING_TO_CHARMEM_POINTER		0x01000000UL
/// end STRING_TO_CHARACTER_PTR

#define		CSMOOPERATOR_SIMPLE_UNARY_MASK		(CSMOOPERATOR_CHANGE_SOURCE_SIGN | CSMOOPERATOR_NOT_SOURCE | CSMOOPERATOR_BINARY_NOT_SOURCE)

#define		CSMOOP_GET_SIMPLE_UNARY(_dwOperator)	(CSMOOPERATOR_SIMPLE_UNARY_MASK & (_dwOperator))
/// end OPERATIONS_WITH_SIMPLE_UNARY
/// TD 7-30-03 EXPLICIT_DOWNCAST
#define		CSMOOPERATOR_MASK_EC_PTR_DOWNCAST			0x02000000UL
/// end EXPLICIT_DOWNCAST



// Basic operators:
enum {
	CSMOOPERATOR_SET_VALUE = 1,
	CSMOOPERATOR_PLUS,					
	CSMOOPERATOR_MINUS,					
	CSMOOPERATOR_MULTIPLY,				
	CSMOOPERATOR_DIVIDE,				
	CSMOOPERATOR_REMAINDER,				// a % b
	CSMOOPERATOR_BIT_OR,				
	CSMOOPERATOR_BIT_XOR,				
	CSMOOPERATOR_BIT_AND,				
	CSMOOPERATOR_BIT_SHIFT_LEFT,			
	CSMOOPERATOR_BIT_SHIFT_RIGHT,			
	/// ML 2/21/2001 POINTERS_FIRST_PHASE
	CSMOOPERATOR_SET_POINTER_TARGET,	// it sets to the pointer object what it should point to
	/// end POINTERS_FIRST_PHASE
	/// ML 6/8/2001 PASSING_PTR_DEREFERENCE_TO_REFERENCE
	///// ML 5/8/2001 MEMORY_PTR_FURTHER_WORK
	//CSMOOPERATOR_SET_TO_MEM_POINTER_TARGET,
	///// end MEMORY_PTR_FURTHER_WORK
	/// end PASSING_PTR_DEREFERENCE_TO_REFERENCE
	/// ML 6/27/2001 t9281 ORIGINC_EXPLICIT_CASTS
	CSMOOPERATOR_EC_NUMERIC_TO_PTR,	// "EC" in the name stands for "explicit cast".
	/// end ORIGINC_EXPLICIT_CASTS
	/// ML 7/3/2001 EXPLICITLY_CASTING_PTRS_TO_SIMPLE_NUMERIC_TYPES_AND_TO_STRUCTURES_TO_SIMPLE_NUMERIC_TYPES
	CSMOOPERATOR_EC_STRUCT_PTR_TO_PTR,			// "EC" in the name stands for "explicit cast".
	CSMOOPERATOR_EC_SIMPLE_NUMERIC_PTR_TO_PTR,	// "EC" in the name stands for "explicit cast".
	/// end EXPLICITLY_CASTING_PTRS_TO_SIMPLE_NUMERIC_TYPES_AND_TO_STRUCTURES_TO_SIMPLE_NUMERIC_TYPES
	/// TD 11-20-01 ALLOW_EXPLICIT_CAST_OF_CATMAP_TO_VECTORSTRING
	CSMOOPERATOR_EC_CATMAP_TO_VECSTR,	// "EC" in the name stands for "explicit cast".
	/// end ALLOW_EXPLICIT_CAST_OF_CATMAP_TO_VECTORSTRING
	/// TD 7-1-03 QA70-4490 POINTER_TO_DWORD_TO_POINTER
	CSMOOPERATOR_EC_PTR_TO_NUMERIC,
	CSMOOPERATOR_EC_NUMERIC_TO_OCPTR,
	/// end POINTER_TO_DWORD_TO_POINTER
	/// TD 8-22-03 QA70-5050 FUNCTION_POINTERS_TO_DWORD
	CSMOOPERATOR_EC_PFN_TO_PINT,
	CSMOOPERATOR_EC_PINT_TO_PFN,
	/// end FUNCTION_POINTERS_TO_DWORD
	CSMOOPERATOR_EXPONENTIATION,//-------- CPY 3/27/01 t9012 OPTION_TO_SWITCH_EXPONENENT_XOR

	/// ML 12/5/2002 QA70-3458 CASTING_LPVOID_TO_DOUBLE_MEMORY_PTR
	CSMOOPERATOR_EC_VOIDPTR_TO_SIMPLE_NUMERIC_PTR_PTR,
	/// end CASTING_LPVOID_TO_DOUBLE_MEMORY_PTR
	
	CSMOOPERATOR_INCREMENT = CSMOOPERATOR_MASK_NO_OTHER,
	CSMOOPERATOR_DECREMENT,

	/// ML 5/11/2001 PTR_COMPARISONS
	CSMOOPERATOR_RELATIONAL_EQUAL = CSMOOPERATOR_RELATIONAL_MASK,
	CSMOOPERATOR_RELATIONAL_NOT_EQUAL,
	CSMOOPERATOR_RELATIONAL_LESS_THAN,
	CSMOOPERATOR_RELATIONAL_LESS_THAN_OR_EQUAL_TO,
	CSMOOPERATOR_RELATIONAL_GREATER_THAN,
	CSMOOPERATOR_RELATIONAL_GREATER_THAN_OR_EQUAL_TO,
	/// end PTR_COMPARISONS
};


/// ML 2/27/2001 GETTING_EXPRESSION_TYPES
#define		IS_INTEGER_ONLY_BASIC_OPERATOR(_nBasicOp)				(CSMOOPERATOR_REMAINDER == (_nBasicOp) || CSMOOPERATOR_BIT_OR == (_nBasicOp) || CSMOOPERATOR_BIT_XOR == (_nBasicOp)\
																	|| CSMOOPERATOR_BIT_AND == (_nBasicOp) || CSMOOPERATOR_BIT_SHIFT_LEFT == (_nBasicOp) || CSMOOPERATOR_BIT_SHIFT_RIGHT == (_nBasicOp)\
																	 || CSMOOPERATOR_INCREMENT == (_nBasicOp) || CSMOOPERATOR_DECREMENT == (_nBasicOp))
/// end GETTING_EXPRESSION_TYPES



#define			CSMOOP_GET_BASIC_OPERATOR(_dwOperator)							LOBYTE(LOWORD(_dwOperator))
#define			CSMOOP_MAKE_OPERATOR(_nBasicOper, _nExtendedOperator)			((DWORD)((WORD)(_nBasicOper) | (WORD)(_nExtendedOperator))
DWORD		CharOperatorToMSOOperator(char chOperator); /// ML -- TD 1/25/2001 EXTEND_COMPILER_BEYOND_DOUBLES

#define		CHAR_TO_MSO_OPER(_chOperator)				CharOperatorToMSOOperator(_chOperator)			/// ML -- TD 1/25/2001 EXTEND_COMPILER_BEYOND_DOUBLES
/// end EXTEND_COMPILER_BEYOND_DOUBLES

/// end EXPRESSION_HANDLING_USING_OBJECT

/// ML 1/26/2000 IMPLEMENTING_ARRAYS
class	CScriptMocaObject;


#define			_TEST_DIMENSIONS_FOR_EACH_GET_VALUE_


/*typedef	struct	tagMSOINDICES {
	INT		nIndexFirstDim;
	INT		nIndexSecondDim;
} MSOINDICES, FAR	*LPMSOINDICES;

typedef	struct	tagMSOOBJVECT {
	CScriptMocaObject	*pMSO;
	MSOINDICES			stMSOIndices;
} MSOOBJVECT, FAR	*LPMSOOBJVECT;
*/
#define		DECL_DEFAULT_INIT_MSOINDICES(_stName)								MSOINDICES		_stName = {0}
#define		DECL_DEFAULT_INIT_MSOOBJVECT(_stName)								MSOOBJVECT		_stName = {0}


/// ML 2/22/2001 VECTOR_WORK
//#define		DECL_INIT_MSOOBJVECT(_stName, _pMSO, _nIndexFirstDim)				MSOOBJVECT		_stName = {(_pMSO), {(_nIndexFirstDim), 0}}
#define		DECL_INIT_MSOOBJVECT(_stName, _pMSO, _nIndexFirstDim)				MSOOBJVECT		_stName = {(_pMSO), {0UL, (_nIndexFirstDim), 0, 0}}
/// end VECTOR_WORK

/// ML 2/26/2001 MORE_DEREFERENCING_IMPROVEMENTS
#define		DECL_INIT_MSOOBJVECT_ALL_INDICES(_stName, _pMSO, _dwDescr, _nIndexFirstDim, _nIndexSecondDim, _nIndexThirdDim)		MSOOBJVECT		_stName = {(_pMSO), {(_dwDescr), (_nIndexFirstDim), (_nIndexSecondDim), (_nIndexThirdDim)}}
/// end MORE_DEREFERENCING_IMPROVEMENTS


#define		MSO_DEFAULT_ARRAY_INDEX				0
#define		MSO_DEFAULT_ARRAY_SIZE				1
/// end IMPLEMENTING_ARRAYS

/// TD 3/7/2001 SEPERATE_CREATION_OF_OBJECT_FROME_ADDING_THEM_TO_STACK
#define SMOFLAG_DONOT_DELETE_ON_POP			0x0001
/// end SEPERATE_CREATION_OF_OBJECT_FROME_ADDING_THEM_TO_STACK
#define SMOFLAG_DATA_MEMORY_IS_EXTERNAL		0x0002 /// TD 5-14-01
#define SMOFLAG_DATA_VAR_FROM_OP_ENCRIPT	0x0004	/// TD 1-14-03 QA70-3671 v7.0487 LIMTED_ACCESS_TO_ACTIVEX_CONTROLS
/// ML 3/7/2001 MORE_FRIENDLY_WAY_TO_GET_BUFFER
int			MSGetBuffer(MSOOBJVECT &stPtrObj, LPVOID *plpVoid, INT nNumBytes = 0);
int			MSReleaseBuffer(MSOOBJVECT &stPtrObj);
/// end MORE_FRIENDLY_WAY_TO_GET_BUFFER
#define		BITFIELD_SIZE_MAX_BITS					32// TD 1-17-01 t9463 IMPLEMENT_BITFIELDS_SUPPORT

/// TD 12-23-02 TREE_CLASS_IN_EXTERNAL_DLL_SHARE_STRUCTURE_DETAILS

// The following class is a communicator between the compiler and MOCA dll, to transfer information about data types
#define IS_TYPE_TREENODE_OR_DERIVED(_ID)						IsTypeTreNodeOrDerived(_ID)		
BOOL IsTypeTreNodeOrDerived(int nTyepID);



class CSMOAlternateBase;
class CScriptMocaObject;

class CSMOAlternateBase
{
public:

	virtual int		GetMemberType(int indexMember, CString *pstrName){if(pstrName) pstrName->Empty(); return LTT_ID_INVALID;}

	virtual BOOL 	MemberValue(int nMemberIndex, int		&nVal, BOOL bGet = TRUE){return FALSE;}
	virtual BOOL 	MemberValue(int nMemberIndex, double	&dVal, BOOL bGet = TRUE){return FALSE;}
	virtual BOOL 	MemberValue(int nMemberIndex, CString   &strVal, BOOL bGet = TRUE){return FALSE;}

	virtual int		GetMember(INT nArrayIndex, INT nMemberIndex, CScriptMocaObject *&pMSOMember){ASSERT(FALSE);  return -1;}
	virtual	CSMOAlternateBase * GetMemberStruct(int indexMember){return NULL;}


protected:
	CSMOAlternateBase(){}

} ;


/// END TREE_CLASS_IN_EXTERNAL_DLL_SHARE_STRUCTURE_DETAILS
/// TD 3-4-03 QA70-3571  VCBASE_FOR_OCCLASS
#ifdef SUPPOR_OC_STUCT_CLASS
#define	IFOCC_INIT_PTR_NULL(_PTR)			_PTR = NULL;
#define	IFOCC_DELETE_PTR_SAFE(_PTR)			NICE_SAFE_REMOVAL(_PTR);
#endif// SUPPOR_OC_STUCT_CLASS
#ifndef SUPPOR_OC_STUCT_CLASS
#define	IFOCC_INIT_PTR_NULL(_PTR)			
#define	IFOCC_DELETE_PTR_SAFE(_PTR)			
#endif// SUPPOR_OC_STUCT_CLASS

////////////////////////////////////////////////////////////////////////////
//		CScriptMocaObject header/body class
//
/// TD 2/15/2001 NEW_BASECLASS_FOR_TYPE_OBJECTS	
//class	CScriptMocaObject		:	public	CMOCAObjBase

class CTypeBase;  //Forward declaration
class CStorageBase; /// TD 10-4-02 QA70-2177 v7.0408 ORIGIN_C_ACCESS_TO_STORAGE


class MOCA_EXP_CLASS CScriptMocaObject : public CTypeBase
/// end NEW_BASECLASS_FOR_TYPE_OBJECTS	
{
	MOCA_DECLARE_DYNAMIC(CScriptMocaObject);
public:
	CScriptMocaObject();
	 ~CScriptMocaObject();

public:
	virtual DWORD Execute(HWND hWnd, LPCALLBK lpfnCallBack, LPCSTR lpcszVar, LPCSTR lpcszArg, LPDOUBLE lpdValue, WORD msg);
	/// ML 5/15/2001 PASSING_SCRIPT_MOCA_OBJECTS_TO_EXTERNAL_FUNCTIONS
	virtual	BOOL	IsPassMSOToExternalFuncCallAsPtr();
	/// end PASSING_SCRIPT_MOCA_OBJECTS_TO_EXTERNAL_FUNCTIONS

	/// ML 11/2/2001 CANNOT_RESET_STRING_AS_RETURNVALUE_AFTER_EXTERNAL_FUNCTION_CALL
	virtual	int		ReturnValueAfterExternalFunctionCallCleanup(DWORD dwCtrl = 0UL);
	/// end CANNOT_RESET_STRING_AS_RETURNVALUE_AFTER_EXTERNAL_FUNCTION_CALL
	/// ML 4/9/2002 QA70-929 ORIGINC_FUNCTION_POINTERS
	#ifdef		__ORIGIN_C_FUNCTION_POINTERS__
	virtual	int		SetOneValueFrom_va_list(va_list &arg, DWORD dwCtrl = 0UL, LPMSOINDICES lpMSOIndices = NULL);

	virtual	int		GetValueToBuffer(LPVOID lpBuffer, LPMSOINDICES lpMSOIndices = NULL);
	#endif		// __ORIGIN_C_FUNCTION_POINTERS__
	/// end ORIGINC_FUNCTION_POINTERS

	// AW 04/29/02 QA70-1636 DATASET_COPY_IN_ORIGINC
	///	DVT 4/22/03 ANDREW_WILL_UPDATE_THE_KEYWORD
	//virtual void Update(int	nArrayIndex = 0, BOOL bFromOrigin = TRUE, int nReDrawMode = -1) { ASSERT(FALSE); } // must realized in derived class
	virtual void Update(int	nArrayIndex = 0, BOOL bFromOrigin = TRUE, int nReDrawMode = -1) {} // must realized in derived class
	///	end ANDREW_WILL_UPDATE_THE_KEYWORD
	// END DATASET_COPY_IN_ORIGINC

	/// ML 2/1/2001 STRING_ARRAYS
	virtual	int		GetString(CString &strValue, const MSOINDICES &stIndices);
	/// end STRING_ARRAYS
	virtual BOOL GetString(CString &strValue);
	virtual BOOL SetString(LPCTSTR lpcszValue);
	virtual BOOL GetString(CString &strValue, UINT index);
	virtual BOOL SetString(LPCTSTR lpcszValue, UINT index);
	virtual BOOL GetInt(int &nVal);
	virtual BOOL SetInt(int nVal);
	virtual BOOL GetInt(int &nVal, UINT index);
	virtual BOOL SetInt(int nVal, UINT index);
	virtual BOOL GetDouble(double &dVal);
	virtual BOOL SetDouble(double dVal);
	virtual BOOL GetDouble(double &dVal, UINT index);
	virtual BOOL SetDouble(double dVal, UINT index);
	// AW 08/09/02 QA70-2400 v7.0365 GET_INTERNALTYPE_OF_VECTORBASE
	/// AW 06/25/03 QA70-4714 v7.0606 SUPPORT_REF_RETURN
	//int GetInternalDataTypeID();
	int GetInternalDataTypeID(BOOL bGetInternalID = TRUE);
	/// END SUPPORT_REF_RETURN
	// END GET_INTERNALTYPE_OF_VECTORBASE

	/// AW 04/40/03 QA70-4359 v7.0574 SUPPORT_NULL_FOR_REFERENCE
	virtual BOOL RequiresMemoryPtr() { return FALSE; }
	/// END SUPPORT_NULL_FOR_REFERENCE


	virtual MODATAID GetDataID(int nArrayIndex = 0); // **TEMP** gets Dataset ID -- The seriesPtr for the interpreter
	/// TD 11-13-01 ADD_ATTACH_USING_WORKSHEET_AND_COLUMN_REF
	virtual MODATAID GetDataID(int nArrayIndex, int nSubDataIndex); // **TEMP** gets Dataset ID/FramePtr(nSubDataIndex = -1) -- The seriesPtr for the interpreter
	/// end ADD_ATTACH_USING_WORKSHEET_AND_COLUMN_REF
	/// ML 10/15/2003 QA70-5361 UPDATING_WKS_FROM_EXCEL_FOR_GETTING_INTO_MATRIX
	virtual	BOOL	UpdateFromExternalSource(int nArrayIndex, int nSubDataIndex = 0, DWORD dwCtrl = 0UL);
	/// end UPDATING_WKS_FROM_EXCEL_FOR_GETTING_INTO_MATRIX
	virtual	BOOL ShiftIndex(int nShift);//For Pointer arithmatics only
	virtual CScriptMocaObject* DeReference(int index); //Vectors and Higher order Matrices will create a lower dimentional matrix and return it
														//These pointers allocated /deleted by the matrix objects and should maintain copys
	/// JCG 03/04/03 QA70-4013 v7.0528 CLEAN_UP_OC_MTX_AND_RECT_COODINATES
	virtual BOOL SetDataRange( int nArrayIndex, int iR1, int iR2, int iC1 = 0, int iC2 = -1 );
	/// end CLEAN_UP_OC_MTX_AND_RECT_COODINATES

	/// ML 6/22/2001 t9264 MEMORY_PTRS_AS_STRUCTURE_MEMBERS_PASSED_TO_FUNCS
	virtual	int		SetMemberMemory(LPVOID lpData, UINT nSize = 0);
	virtual	int		SetExternalDataByPtr(LPVOID *plpData);
	/// end MEMORY_PTRS_AS_STRUCTURE_MEMBERS_PASSED_TO_FUNCS
	/// ML 6/18/2001 t9260 MULTIPLE_POINTERS
	virtual	int		CheckCreateMemoryPtrObjects(INT nMultiplicity, UINT nBaseTypeId, LPMSOINDICES lpMSOIndices, DWORD dwCtrl = 0UL);
	virtual	int		GetMemoryPtrAddress(LPVOID *plpVoid, const MSOINDICES &stMSOIndices);
	virtual	int		GetValueForPtrAsExternalFuncArg(LPVOID *plpVoid, LPMSOINDICES lpMSOIndices);
	virtual	int		SetMemoryPtrObjectCreationID(UINT nID);

	//AW 02/27/03 QA70-3984 v7.0522 SUPPORT_CLASS_BASE_CALSS
	virtual int	GetBaseClass(INT nArrayIndex, CScriptMocaObject *&pMSOBassClass) { ASSERT(FALSE); return 1; }
	// END SUPPORT_CLASS_BASE_CALSS

	/// AW 03/12/03 QA70-2336 v7.0534 SORT_METHODS_IN_WORKSHEET
	virtual int	GetBufferSize(const MSOINDICES &stMSOIndices, int &BufferSize) { ASSERT(FALSE); return 1; } 
	// END 	SORT_METHODS_IN_WORKSHEET

	/// ML 10/26/2001 HANDLING_WRONG_ARGUMENT_VARIANT_TYPES_IN_COM_EVENT_HANDLERS
	virtual	BOOL	SetPtrArgForCOMEventHandlingFromWrongVariantType(OCONEVARIANT &varArg, PLONG plBuffer, DWORD dwCtrl = 0UL);
	/// end HANDLING_WRONG_ARGUMENT_VARIANT_TYPES_IN_COM_EVENT_HANDLERS
	// 4 bits are more than plenty for, e.g.,  double***** (multiplicity corresponds to the number of asterisks - 1; so it is 0 for double*, it is 1 for double**, etc.)
/// ML 10/11/2001 HANDLE_ASSIGNING_ARRAY_PTRS_TO_MULTIPLE_PTR
//#define		SET_MEM_PTR_OBJ_CREATE_ID(_nVar, _baseType, _nPtrMultiplicity)			((_nVar) = (DWORD)((BYTE)(_nPtrMultiplicity) << 28) | LTT_BASE_ID(_baseType))				
#define		SET_MEM_PTR_OBJ_CREATE_ID(_nVar, _baseType, _nPtrMultiplicity, _nArrSize)	((_nVar) = (DWORD)((BYTE)(_nPtrMultiplicity) << 28) | (DWORD)((BYTE)(_nArrSize) << 24) | LTT_BASE_ID(_baseType))				
/// end HANDLE_ASSIGNING_ARRAY_PTRS_TO_MULTIPLE_PTR
#define		GET_MEM_PTR_OBJ_CREATE_BASE_ID(_nVar)									LTT_BASE_ID(_nVar)				
/// ML 10/11/2001 HANDLE_ASSIGNING_ARRAY_PTRS_TO_MULTIPLE_PTR
// The size of the (single) array of memory ptrs
#define		GET_MEM_PTR_OBJ_ARRAY_SIZE(_nVar)										(((_nVar) & 0x0F000000) >> 24)
/// end HANDLE_ASSIGNING_ARRAY_PTRS_TO_MULTIPLE_PTR
#define		GET_MEM_PTR_OBJ_CREATE_MULTIPLICITY(_nVar)								(((_nVar) >> 28) + (0 < GET_MEM_PTR_OBJ_ARRAY_SIZE(_nVar) ? 1 : 0))

	/// end MULTIPLE_POINTERS
	/// ML 6/22/2001 VECTOR_OR_MATRIX_ASSIGNMENT_LHS_TEMPORARY_BUG
	virtual	int		IsNoVectorOrMatrixSource(BOOL &bIsNoVectorOrMatrixSource, LPSMOOPERATECTXT lpctxt = NULL);
	/// end VECTOR_OR_MATRIX_ASSIGNMENT_LHS_TEMPORARY_BUG
	//---------- CPY 4/5/01 RENAME_GET_BUFFER_FOR_MULTI_DIM
	// we want to use GetBuffer for higher level calls in OriginCObject
	//	/// ML 3/5/2001 POINTERS_POINTERS
	//	virtual	int	GetBuffer(LPVOID *plpVoid, INT nNumBytes = 0, LPMSOINDICES lpMSOIndices = NULL);
	//	virtual	int	ReleaseBuffer(LPMSOINDICES lpMSOIndices = NULL);
	//	/// end POINTERS_POINTERS
	virtual	int	GetBufferMSO(LPVOID *plpVoid, INT nNumBytes = 0, LPMSOINDICES lpMSOIndices = NULL);
	virtual	int	ReleaseBufferMSO(LPMSOINDICES lpMSOIndices = NULL);
	/// TD 1-27-02 TREE_CLASS_IN_EXTERNAL_DLL_SHARE_STRUCTURE_DETAOILS
	// The following functions only applys to vector for now
	virtual int GetVariantArray(OCONEVARIANT &tVal, MSOINDICES *pstIndex = NULL);
	virtual int SetVariantArray(OCONEVARIANT &tVal, MSOINDICES *pstIndex = NULL);
	/// end TREE_CLASS_IN_EXTERNAL_DLL_SHARE_STRUCTURE_DETAOILS
	//---------- end CPY 4/5/01 RENAME_GET_BUFFER_FOR_MULTI_DIM
	/// TD 4-10-2001 t9050 ADD_FUNCTION_TO_ACCESS_UNDERLYING_DATA_STRUCTURE
	virtual LPVOID	GetArgObjectPtrMSO(int nTypeID, LPMSOINDICES lpMSOIndices = NULL);
	/// end ADD_FUNCTION_TO_ACCESS_UNDERLYING_DATA_STRUCTURE
	/// ML 8/8/2001 t9309 MORE_COM_ACCESS_WORK
	virtual	int	GetDispatchInterface(LPVOID &lpIDisp, const MSOINDICES &stMSOIndices);
	/// end t9309 MORE_COM_ACCESS_WORK
	/// ML 5/20/2001 QA70-1851 GETTING_SELECTED_COLUMNS_ORIGIN_C
	virtual	int	SetBufferSize(const MSOINDICES &stMSOIndices, int nBufferSize);
	/// end GETTING_SELECTED_COLUMNS_ORIGIN_C
	/// ML 4/9/2002 QA70-929 ORIGINC_FUNCTION_POINTERS
	#ifdef		__ORIGIN_C_FUNCTION_POINTERS__
	virtual	int	GetLTFunction(LPVOID &lpLTFuncPtr, LPMSOINDICES lpMSOIndices = NULL);
	#endif		// __ORIGIN_C_FUNCTION_POINTERS__
	/// end ORIGINC_FUNCTION_POINTERS

	/// TD 2/27/2001 SET_VALUES_WITH_INDECES
	virtual int SetInt(int nVal, const MSOINDICES &stIndices);
	virtual int SetDouble(double dVal, const MSOINDICES &stIndices);
	virtual int SetString(LPCSTR lpcszVal, const MSOINDICES &stIndices);
	/// end SET_VALUES_WITH_INDECES
	virtual int		GetTypeID();
	virtual int		GetUserTypeID();
	virtual DWORD	GetTypeBitID();
			BOOL	IsSameID(UINT nTypeID);// CPY 9/4/01 t9324 v6.9083 OC_LAYER_CLASS
	/// ML 2/22/2001 CLEANINING_UP_DEPRECATED_STUFF
	//virtual CScriptMocaObject* Operate(WORD wChars, CScriptMocaObject* pSMObj);
	/// end CLEANINING_UP_DEPRECATED_STUFF

	void SetName(LPCSTR lpszRealKey){ if(lpszRealKey) m_strName = lpszRealKey; ASSERT(lpszRealKey); } 
	/// ML 8/21/2001 t9309 ASSIGNING_COM_VARIANT_ARRAYS_TO_VECTORS_OR_MATRICES
	virtual	BOOL	IsVariantArraySource(OCONEVARIANT **ppvarArray, const MSOINDICES &stIndices, LPSMOOPERATECTXT lpctxt);
	/// end ASSIGNING_COM_VARIANT_ARRAYS_TO_VECTORS_OR_MATRICES
	/// ML 12/20/2002 QA760-3535 TEMPORARY_ACTIVEX_CONTROL_FIX_BETTER 
	virtual	int		AfterGetReturnValueFromMethod();
	/// end TEMPORARY_ACTIVEX_CONTROL_FIX_BETTER 

	/// ML 1/24/2000 EXPRESSION_HANDLING_USING_OBJECT
	virtual	int		ResetValue();
	/// TD 5-17-01 t9153 CREATE_A_TEMP_SERIES_WHEN_ANY_VETOR_ASSIGNED_TO_DATASET_UNATTACHED
	virtual int InitializeObjectForArguments(); //Do not rederect this for pointers and references
	//virtual int initFArg(); //Do not rederect this for pointers and references
	/// end CREATE_A_TEMP_SERIES_WHEN_ANY_VETOR_ASSIGNED_TO_DATASET_UNATTACHED
	/// ML 2/22/2001 CLEANINING_UP_DEPRECATED_STUFF
	//virtual	int		OperateEx(DWORD dwOperator, CScriptMocaObject *pSMO, LPSMOOPERATECTXT lpctxt = NULL);
	/// end CLEANINING_UP_DEPRECATED_STUFF
	/// end EXPRESSION_HANDLING_USING_OBJECT
	/// ML 1/31/2000 MULTIDIMENSION_DEREFERENCING
	int				CheckDimensions(const MSOINDICES &stIndices);
	
	/// ML 2/26/2001 MORE_DEREFERENCING_IMPROVEMENTS
	//virtual	int		GetIndicesForWholeVectorOperation(MSOINDICES &stMSOTempIndices, INT &nTo, const MSOINDICES &stMSOIndices, LPSMOOPERATECTXT lpctxt = NULL);
	virtual	int		GetIndicesForWholeVectorOperation(MSOINDICES &stMSOTempIndices, CScriptMocaObject *&pMSOActual, INT &nTo, const MSOINDICES &stMSOIndices, LPSMOOPERATECTXT lpctxt = NULL);
	/// end MORE_DEREFERENCING_IMPROVEMENTS
	/// ML 6/1/2001 MATRIX_WORK
	virtual	int		GetIndicesForWholeMatrixOperation(MSOINDICES &stMSOTempIndices,
													   CScriptMocaObject *&pMSOActual,
													   INT &nRowTo,
													   INT &nColTo,
													   const MSOINDICES &stMSOIndices,
													   LPSMOOPERATECTXT lpctxt);
	/// end MATRIX_WORK

	/// ML 10/2/2001 MULTIPLE_MEMORY_PTR_DEREFERENCING_IMPROVEMENTS
	///// ML 4/12/2001 POINTERS_ASSIGNMENT
	//virtual	int		GetTargetForPtrAssignment(MSOOBJVECT &stMSOTarget, const MSOINDICES &stMSOIndices);
	///// end POINTERS_ASSIGNMENT
	virtual	int		GetTargetForPtrAssignment(MSOOBJVECT &stMSOTarget, const MSOINDICES &stMSOIndices, CScriptMocaObject *pMSODest, LPMSOINDICES lpMSOIndDest = NULL);
	/// end MULTIPLE_MEMORY_PTR_DEREFERENCING_IMPROVEMENTS
	/// ML 5/8/2001 MEMORY_PTR_FURTHER_WORK
	virtual	int		CreateMemoryPtrTarget(MSOOBJVECT &stMSOTarget, const MSOINDICES &stMSOIndices);
	virtual	int		CreateCopy(CScriptMocaObject *&pNewObj);
	/// end MEMORY_PTR_FURTHER_WORK


	virtual	int		Operate2(LPMSOINDICES lpMSODestIndices, DWORD dwOperator, LPMSOOBJVECT lpMSOSource = NULL, LPSMOOPERATECTXT lpctxt = NULL);
	/// ML 6/8/2001 PASSING_PTR_DEREFERENCE_TO_REFERENCE
	virtual	int		GetActualObject(LPMSOINDICES lpMSODestIndices, LPMSOOBJVECT lpMSOResult, LPSMOOPERATECTXT lpctxt = NULL);
	/// end PASSING_PTR_DEREFERENCE_TO_REFERENCE

	/// AW 08/18/03 QA70-5026 v7.0667 MORE_ON_POINTER_DELETE
	virtual int		GetActualObjectEx(LPMSOINDICES lpMSODestIndices, LPMSOOBJVECT lpMSOResult, LPSMOOPERATECTXT lpctxt = NULL) { return 0; };
	/// END MORE_ON_POINTER_DELETE

	/// ML 4/14/2003 QA70-4264 GETTING_ARGUMENT_PTR_IF_NULL_AS_NULL
	virtual	BOOL	IsNULLPtr(LPMSOINDICES lpMSODestIndices = NULL);
	/// end GETTING_ARGUMENT_PTR_IF_NULL_AS_NULL
	virtual	INT		GetUpperBound(int nDimIndex);
	virtual	int		GetInt(INT &iResult, const MSOINDICES &stIndices);
	/// end MULTIDIMENSION_DEREFERENCING
	virtual int GetDouble(double &dVal, const MSOINDICES &stIndices) ; // TD 2/5/01
	/// ML 1/26/2000 IMPLEMENTING_ARRAYS
	/// ML 2/22/2001 CLEANINING_UP_DEPRECATED_STUFF
	//virtual	int		OperateIndexEx(DWORD dwOperator, CScriptMocaObject *pSMO, LONG lIndex = 0L, LPSMOOPERATECTXT lpctxt = NULL);
	/// end CLEANINING_UP_DEPRECATED_STUFF
	void			InitTypeIDs(int nTypeID);
	/// end IMPLEMENTING_ARRAYS

	virtual int	GetOneTarget(MSOOBJVECT &st, const MSOINDICES &stMSOIndices) { ASSERT(FALSE); return 1; }  /// AW 04/28/03 QA70-3850 v7.0572 MORE_ON_FUNCTION_POINTER

	/// TD 2/12/2001 EFFICIENT_BASE_TYPES_HANDLING
	virtual int GetIntegralValue(char & cVal, const MSOINDICES &stIndices);
	virtual int GetIntegralValue(BYTE & cVal, const MSOINDICES &stIndices);
	virtual int GetIntegralValue(short& nVal, const MSOINDICES &stIndices);
	virtual int GetIntegralValue(WORD & nVal, const MSOINDICES &stIndices);
	virtual int GetIntegralValue(int  & nVal, const MSOINDICES &stIndices);
	virtual int GetIntegralValue(UINT & nVal, const MSOINDICES &stIndices);				
	virtual int GetFloatingValue(double & dVal, const MSOINDICES &stIndices);
	virtual int GetFloatingValue(float  & fVal, const MSOINDICES &stIndices);
	
	/// ML 4/15/2001 CALLING_EXTERNAL_FUNCTION_OF_ARBIRARY_PROTOTYPE
	virtual	int	SetNumericValue(char  & tVal, const MSOINDICES &stIndices);
	virtual	int	SetNumericValue(BYTE  & tVal, const MSOINDICES &stIndices);
	virtual	int	SetNumericValue(short  & tVal, const MSOINDICES &stIndices);
	virtual	int	SetNumericValue(WORD  & tVal, const MSOINDICES &stIndices);
	virtual	int	SetNumericValue(int  & tVal, const MSOINDICES &stIndices);
	virtual	int	SetNumericValue(UINT  & tVal, const MSOINDICES &stIndices);
	virtual	int	SetNumericValue(double  & tVal, const MSOINDICES &stIndices);
	virtual	int	SetNumericValue(float  & tVal, const MSOINDICES &stIndices);
	virtual	int	SetValueFromDWORD(DWORD dwValue);
	virtual	int	BeginGetValueIntoBufferForExternalCall(LPBYTE *plpbyValueBuffer, DWORD dwCtrl, INT &nNumBytesUsed, UINT nTypeId);
	virtual	int	EndGetValueIntoBufferForExternalCall(UINT nTypeId);
	/// end CALLING_EXTERNAL_FUNCTION_OF_ARBIRARY_PROTOTYPE

	/// ML 7/6/2001 t9283 COMPLEX_TYPES
	virtual	int	GetNumericValue(char  & tVal, const MSOINDICES &stIndices);
	virtual	int	GetNumericValue(BYTE  & tVal, const MSOINDICES &stIndices);
	virtual	int	GetNumericValue(short  & tVal, const MSOINDICES &stIndices);
	virtual	int	GetNumericValue(WORD  & tVal, const MSOINDICES &stIndices);
	virtual	int	GetNumericValue(int  & tVal, const MSOINDICES &stIndices);
	virtual	int	GetNumericValue(UINT  & tVal, const MSOINDICES &stIndices);
	virtual	int	GetNumericValue(double  & tVal, const MSOINDICES &stIndices);
	virtual	int	GetNumericValue(float  & tVal, const MSOINDICES &stIndices);
	virtual	int	GetNumericValue(OneOCcomplex &vResult, const MSOINDICES &stIndices);
	/// end COMPLEX_TYPES

	/// TCZ 07/6/02 QA70-2187  v7.0337 MATRIX_BASIC_OPERATION
	virtual	int	SetNumericValue(OneOCcomplex &vResult, const MSOINDICES &stIndices);
	/// end MATRIX_BASIC_OPERATION
	
	//AW 05/05/02 v7.0302 QA70-1655 POINT_POINTF_POINTC_SUPPORT
	virtual	int	GetNumericValue(COKPointInt &vResult, const MSOINDICES &stIndices) { return OLTEXEERROR_BASECLASS_VIRTUAL_FUNCTION_NOT_OVERRIDDEN; }
	virtual	int	SetNumericValue(COKPointInt  &tVal, const MSOINDICES &stIndices) { return OLTEXEERROR_BASECLASS_VIRTUAL_FUNCTION_NOT_OVERRIDDEN; }
	virtual	int	GetNumericValue(COKPointDouble &vResult, const MSOINDICES &stIndices) { return OLTEXEERROR_BASECLASS_VIRTUAL_FUNCTION_NOT_OVERRIDDEN; }
	virtual	int	SetNumericValue(COKPointDouble  &tVal, const MSOINDICES &stIndices) { return OLTEXEERROR_BASECLASS_VIRTUAL_FUNCTION_NOT_OVERRIDDEN; }
	virtual	int	GetNumericValue(COKPoint3D &vResult, const MSOINDICES &stIndices) { return OLTEXEERROR_BASECLASS_VIRTUAL_FUNCTION_NOT_OVERRIDDEN; }
	virtual	int	SetNumericValue(COKPoint3D  &tVal, const MSOINDICES &stIndices) { return OLTEXEERROR_BASECLASS_VIRTUAL_FUNCTION_NOT_OVERRIDDEN; }

	//END POINT_POINTF_POINTC_SUPPORT
	/// ML 8/9/2001 ORIGIN_C_VARIANT
	virtual	int	GetNumericValue(OCONEVARIANT &tVal, const MSOINDICES &stIndices);
	virtual	int	SetNumericValue(const OCONEVARIANT &tVal, const MSOINDICES &stIndices);
	/// end ORIGIN_C_VARIANT
	///	DVT 12/18/02 QA70-3537 v7.0467 ADD_MATLAB_CLASS_FOR_COMMUNICATION
	virtual	int	GetVarArrayForMatlab(OCONEVARIANT &tVal, const MSOINDICES &stIndices){ return OLTEXEERROR_BASECLASS_VIRTUAL_FUNCTION_NOT_OVERRIDDEN; }
	virtual	int	SetVarArrayFromMatlab(OCONEVARIANT &tVal, const MSOINDICES &stIndices, INT nRows, INT nCols){ return OLTEXEERROR_BASECLASS_VIRTUAL_FUNCTION_NOT_OVERRIDDEN; }
	///	end ADD_MATLAB_CLASS_FOR_COMMUNICATION
	///	DVT 2/11/03 QA70-3684 v7.0510 ORIGIN_AUTOMATION_SERVER
#ifdef _VARIANT_AS_CLASS	
	virtual int SetFromVariant( OCONEVARIANT &tVal, LPMSOINDICES lpMSOIndices = NULL ) { return OLTEXEERROR_BASECLASS_VIRTUAL_FUNCTION_NOT_OVERRIDDEN; }
	virtual int GetIntoVariant( OCONEVARIANT &vaResult, INT format, LPMSOINDICES lpMSOIndices = NULL ) { return OLTEXEERROR_BASECLASS_VIRTUAL_FUNCTION_NOT_OVERRIDDEN; }
#endif	//_VARIANT_AS_CLASS	
	///	end ORIGIN_AUTOMATION_SERVER
	/// ML 8/14/2001 t9309 COM_METHODS
	virtual	int	GetOCONEVARIANTforCOMMethodArg(OCONEVARIANT &ocvar, const MSOINDICES &stIndices);
	/// end COM_METHODS
	/// ML 9/17/2001 GETTING_SPCBLOB_INTO_WORKSHEET
	///// ML 9/14/2001 GETTING_VECTOR_DATA_INTO_VARIANT_AS_ONEDIMENSIONAL_SAFEARRAY
	//virtual	int	GetVariantAddress(OCONEVARIANT *&pvarVal);
	///// end GETTING_VECTOR_DATA_INTO_VARIANT_AS_ONEDIMENSIONAL_SAFEARRAY
	virtual	int	GetVariantAddress(OCONEVARIANT *&pvarVal, LPMSOINDICES lpMSOIndices = NULL);
	/// end GETTING_SPCBLOB_INTO_WORKSHEET
	/// TD 5-04-02 KEY_INFO_PROPERTY_OF_WRAPPERS_WITH_DYNAMIC_SUBPROPERTIES
	virtual LPVOID GetOkClassObjFromOCWrappers(LPMSOINDICES lpMSOIndices = NULL);
	/// end KEY_INFO_PROPERTY_OF_WRAPPERS_WITH_DYNAMIC_SUBPROPERTIES
	/// TD 12-23-02 TREE_CLASS_IN_EXTERNAL_DLL_SHARE_STRUCTURE_DETAILS
	virtual LPVOID	GetObjectAltBaseClass(){return NULL;}
	virtual int		AssignStrucFromTreeNode(LPMSOOBJVECT lpMSOSourceStruct){ASSERT(FALSE); return  OLTEXEERROR_BASECLASS_VIRTUAL_FUNCTION_NOT_OVERRIDDEN;}
	/// END TREE_CLASS_IN_EXTERNAL_DLL_SHARE_STRUCTURE_DETAILS

	/// ML 3/14/2003 QA70-4067 PASSING_DATASETS_FROM_LABTALK_TO_STRING_VECTORS_AND_RETURNING_STRING_VECTORS
	virtual	int		GetAsStringVector(CScriptMocaObject *pObject) {ASSERT(FALSE); return  OLTEXEERROR_BASECLASS_VIRTUAL_FUNCTION_NOT_OVERRIDDEN;}
	virtual	int		SetFromDataset(LPVOID lpSeries, int nRow1, int nRow2) {ASSERT(FALSE); return  OLTEXEERROR_BASECLASS_VIRTUAL_FUNCTION_NOT_OVERRIDDEN;}
	virtual	int		PutStringVector(CScriptMocaObject *pObject) {ASSERT(FALSE); return  OLTEXEERROR_BASECLASS_VIRTUAL_FUNCTION_NOT_OVERRIDDEN;}
	/// end PASSING_DATASETS_FROM_LABTALK_TO_STRING_VECTORS_AND_RETURNING_STRING_VECTORS

	/// ML 3/23/2003 QA70-4113 INITIALIZING_VECTOR_FROM_COLUMN_FOR_WRITEBACK
	#ifdef	_POST_ORIGIN7_
	virtual	int		GetDatasetObject(MSOOBJVECT &stObjDataset, MSOINDICES &stIndices) {ASSERT(FALSE); return  OLTEXEERROR_BASECLASS_VIRTUAL_FUNCTION_NOT_OVERRIDDEN;}
	virtual	int		ExecuteOCDestructor(DWORD dwCtrl = 0UL) { return 0; }
	#endif	// _POST_ORIGIN7_
	/// end INITIALIZING_VECTOR_FROM_COLUMN_FOR_WRITEBACK


	/// ML 5/22/2001 t9074 VECTOR_TO_SIMPLE_TYPE_FUNCTION_CALL_MORE_WORK
	virtual	int	SetSizeForVectorToSimpleTypeFuncCall(INT nFrom, INT nTo, LPMSOINDICES lpMSOIndices = NULL);
	virtual	int	GetLimitsForVectorToSimpleTypeFuncCall(INT &nFrom, INT &nTo, LPMSOINDICES lpMSOIndices = NULL);
	/// end VECTOR_TO_SIMPLE_TYPE_FUNCTION_CALL_MORE_WORK

	/// TD 10-4-02 QA70-2177 v7.0408 ORIGIN_C_ACCESS_TO_STORAGE
	virtual int	StorageXVariable(LPCTSTR lpcszNodeIdentifier, CStorageBase* pStorage, MSOINDICES &stIndices, BOOL bSaveToStorage);
	/// end ORIGIN_C_ACCESS_TO_STORAGE

	/// TD 4-19-2001 t9054 MULTIMEMBER_ACCESS_TO_CLASS_N_STRUCT
	virtual int	GetMember(INT nArrayIndex, INT nMemberIndex, CScriptMocaObject *&pMSOMember);
	/// end MULTIMEMBER_ACCESS_TO_CLASS_N_STRUCT

	/// end EFFICIENT_BASE_TYPES_HANDLING
	virtual void* GetData(){ return NULL;} //Expert usage only -- returns the basic storage NOTE:: class restructuring changes storage hence may call for rewriting all functions using Getdata()

	/// EJP 03-09-2001 t8865 IMPLEMENT_IDE_VARIABLE_WINDOW, override from COKLTObj
	virtual int GetArraySize() {return 0;}
	// ------------ AW 03/18/02 QA70-1105 DEBUG_VARIABLE_DISPLAY_IMPROVEMENT
	virtual void GetDateTypeString( CString &strDataType ) { ASSERT(FALSE); }
	// ------------ END DEBUG_VARIABLE_DISPLAY_IMPROVEMENT
	virtual BOOL GetArrayElement(CString &strValue, int iIndex) {return FALSE;}
	/// end IMPLEMENT_IDE_VARIABLE_WINDOW
	/// TD 9-10-01 GETTING_TARGET_FROM_REFERNCE_OBJECT_INSIDE_METHODS
	virtual int GetReferenceTarget(MSOOBJVECT& stObjVect);
	/// end GETTING_TARGET_FROM_REFERNCE_OBJECT_INSIDE_METHODS
	/// TD 1-29-02 QA70-592 v6.9197 PROPER_HANDLING_OF_DATASET_RANGE_FROM_KERNEL
	enum
	{
		MSOINFO_Datast_Range = 1,
		MSOINFO_ChildNodeFromPath,/// TD 2-3-03 QA70-3681 ALLOW_DOTTED_ACCESS_TO_OBJECT_FORMAT_AND_TREENODE
		MSOINFO_SetStorageTable,/// TD 4-9-03 QA70-4171 ACCESSING_COMPACT_STORAGE_TABLES
		MSOINFO_ChildNodeTmpRemoveUpdate,/// TD 4-29-03 QA70-4343 REMOVE_CHILDREN_CREATED_BUT_NOT_USED_FOR_DOTTED_ACCESS
		MSOINFO_GetCurveSeries, /// YuI 5/05/03 v7.0578 QA70-4357 CURVE_AS_INPUT_OF_OPERATION
		MSOINFO_AskRefToCallRelease, /// TD 5-30-03 QA70-4563 REFERNCES_TO_WRAPPER_DATA_NEEDS_DETACHMENT_AFTER_DETACHED_FROM_ALL_REFS
	};
	/// ML 5/29/2003 QA70-4562 CURVE_EXTENSION_WITH_RELATED_DATASETS
	#ifdef		__EXTENDED_CURVE_CLASS_WITH_RELATED__
	// lpInfo points at this structure when the message is MSOINFO_GetCurveSeries.
	struct	MSOINFOCURVESERIES
	{
		DWORD							dwSeriesPtrY;
		DWORD							dwSeriesPtrX;
		CArray<OSERIESTAG, OSERIESTAG&> *parrRelated;
	};
	#endif		// __EXTENDED_CURVE_CLASS_WITH_RELATED__
	/// end CURVE_EXTENSION_WITH_RELATED_DATASETS
	virtual int	GetInfo(LPVOID lpInfo, DWORD dwMsg, DWORD dwMoreInfo = 0UL);
	/// end PROPER_HANDLING_OF_DATASET_RANGE_FROM_KERNEL

	// AW 06/18/02 v7.0323 QA70-2055 MORE_WORK_ON_GETAS_VECTOR
	virtual BOOL IsMixedTypeDataSet(INT nIndexOuter = 0) { return FALSE; } 
	// END 	MORE_WORK_ON_GETAS_VECTOR
	/// TD 3-4-03 QA70-3571  VCBASE_FOR_OCCLASS
#ifdef SUPPOR_OC_STUCT_CLASS
	virtual CScriptMocaObject*		GetBaseObj();
	virtual CScriptMocaObject*		GetDerivObj();
	virtual BOOL					SetBaseObj(CScriptMocaObject* pObj);
	virtual BOOL					SetDerivObj(CScriptMocaObject* pObj);
	
	/// YuI 3/31/03 v7.0550 QA70-4160 NEW_OC_OPERATION_HANDLING
	CScriptMocaObject*				GetLTBaseObj();
	/// end NEW_OC_OPERATION_HANDLING

	/// AW 06/29/03 QA70-4733 v7.0612 SMART_COUNT_NUMBER_FOR_REF
	int	AddRef(LPMSOINDICES lpMSOIndeces = NULL);
	int	Release(LPMSOINDICES lpMSOIndeces = NULL);
	int GetRefCount(LPMSOINDICES lpMSOIndeces = NULL) { return m_nRefCounts; }
protected:
	int	m_nRefCounts ;
	/// END SMART_COUNT_NUMBER_FOR_REF

protected:

	CScriptMocaObject*				m_pDerivObj;
#endif// SUPPOR_OC_STUCT_CLASS
	/// end  VCBASE_FOR_OCCLASS

public:
	/// TD 2/29/2001 UNUSED_CODES
	//static WORD	 GetWordFrom2Chars(char c1, char c2);
	//static void  Get2CharsFromWord(WORD wChars, char& c1, char& c2);
	//static COPCompatTable	m_OPCTable;
	//static DWORD CanOperate(WORD wChars, int nLType, int nRType);
	/// end----------------TD 2/29/2001 UNUSED_CODES

	/// ML 2/1/2001 STRING_ARRAYS
	virtual	void	SetCurrentIndices(INT nIndFirst, INT nIndSecond);
	static	MSOINDICES	&GetCurrentIndices();
	static	MSOINDICES	ms_stCurrentIndices;	// should be used from within methods and property set/get functions
	/// end STRING_ARRAYS

	//---------- CPY 2/5/01 t8865 ACCESS_TO_LOCAL_VARIABLES
	LPCTSTR	GetName();
	//----------

	/// -------------------- TD 3/7/2001 SEPERATE_CREATION_OF_OBJECT_FROME_ADDING_THEM_TO_STACK
	BOOL	IsFlagOn( DWORD nFlagBit );
	void	SetFlag( DWORD nFlagBit, BOOL bSetToOn = TRUE );
	/// end ----------------  SEPERATE_CREATION_OF_OBJECT_FROME_ADDING_THEM_TO_STACK
	/// TD 05-04-01 v6.9012 STRUCTS_WITH_SIMPLE_MEMBER_TYPE_CREATED_THE_C_WAY
	/// ML 10/2/2001 MULTIPLE_MEMORY_PTR_DEREFERENCING_IMPROVEMENTS
	virtual	int		SetExternalData(LPVOID lpData, LPMSOINDICES lpMSOIndDest);
	/// end MULTIPLE_MEMORY_PTR_DEREFERENCING_IMPROVEMENTS
	virtual int		SetExternalData(LPVOID lpData, UINT nSize = 0);	 //Only for simple numeric types
	virtual	int		ModifyExternalDataPtr(int nAmount);
	virtual int		GetExternalData(LPVOID *plpData);	 //Only for simple numeric types
	/// end STRUCTS_WITH_SIMPLE_MEMBER_TYPE_CREATED_THE_C_WAY
	/// ML 6/18/2001 t9260 MULTIPLE_POINTERS
	virtual	int		GetExternalData(LPVOID *plpData, const MSOINDICES &stMSOIndices);
	/// end MULTIPLE_POINTERS
	/// TD 5-09-01 t9062 v6.9012 ADD_SUPPORT_FOR_ANSI_CONSATNTS_IN_ORIGIN_C
	virtual int			CompareVals(LPMSOOBJVECT lpMSOSource, int& nRelation);
	//Results from CompareVals will be one of the following
	enum{
		CV_EQUAL = 0,
		CV_GREATER,
		CV_SMALLER,
		CV_INCOMPATIBLE
	};
	/// end ADD_SUPPORT_FOR_ANSI_CONSATNTS_IN_ORIGIN_C
	// TD 5-11-01 
	virtual int		WriteToMemory(UINT nArrayIndex, void* pVoid, UINT numOfBytes);
	virtual int		ReadFromMemory(UINT nArrayIndex, void* pVoidBuffer, UINT numOfBytes);
	//--- end TD
	//	AW 6/21/2001 Array_Initialization
	virtual int		InitalizeFromMemory(LPVOID lpMem, int nNumRows=1, int nNumColumns=1) { return 0;}
	//	end Array_Initialization
	// AW 08/07/02 QA70-1699 v7.0364 VECTORSTRING_INITIALIZATION
	virtual int		InitalizeFromMemory(CStringArray &stringArray, int nNumRows=1, int nNumColumns=1) { return 0;}
	// END VECTORSTRING_INITIALIZATION	
	// --------------AW 6/27/2001 t9137 VECTOR_DISPLAY
	virtual int	GetDisplaySize() { return GetArraySize(); }													// not suit for  vector and Matrix;
	//---------CPY v6.9084 9/7/01 GET_STR_NEED_SEPARATE_DISPLAY_AND_ASSIGNMENT
	//	virtual BOOL GetDisplayElement(CString &strValue, int iIndex) {return GetArrayElement(strValue, iIndex);}	// Need override in Vector and Matrix
	virtual BOOL GetDisplayElement(CString &strValue, int iIndex = -1);// -1 to indicate use whole instead of element
	///	DVT 4/21/03 ADD_DOTTED_OIDE_TOOLTIPS
#ifdef	DOTTED_OIDE_TOOLTIP
	virtual BOOL	GetMultipartDisplayElement( CString &strValue, CStringArray &arrArgs, int iIndex = -1 );
#endif	//	DOTTED_OIDE_TOOLTIP
	///	end ADD_DOTTED_OIDE_TOOLTIPS
	/// YuI 4/29/02 v.70295 QA70-1642 DISPLAY_ELEMET_FUNCTION_FOR_EACH_OC_CLASS
	virtual BOOL	IsDisplayHeaderAddType()			{return FALSE;}
	virtual BOOL	IsDisplayElementAddType()			{return TRUE;}
	virtual BOOL	IsDisplayElementExpandable();
	virtual BOOL	GetDisplayExpandableHeader(CString& strHeader);
	virtual BOOL	GetDisplayArrayElement(CString& strElement, int nIndex);
	/// end DISPLAY_ELEMET_FUNCTION_FOR_EACH_OC_CLASS
	//---------end CPY v6.9084
	// -------------- End VECTOR_DISPLAY
	/// YuI 4/29/02 v.70295 QA70-1642 DISPLAY_ELEMET_FUNCTION_FOR_EACH_OC_CLASS
	virtual BOOL	GetOCTypeName(CString& strName)		{return FALSE;}
	BOOL			AddOCTypeName(CString& strValue);
	BOOL			GetOCTypeNameShow(CString& strName);
	/// end DISPLAY_ELEMET_FUNCTION_FOR_EACH_OC_CLASS
	// ------------AW 6/28/2001 t9137 VARIABLE_DISPLAY	
	BOOL	m_isExpended;		// AW Specially set it as public
	// ----------- End AW VARIABLE_DISPLAY	
	/// TD 7-11-01 t9298 CALLBACK_FUNCTIONS_IN_ORIGINC
	virtual OCFunctionCall	*GetCallBack(int index = 0);
	virtual int				SetCallBack(OCFunctionCall* pFnCall, int index = 0);
	/// end CALLBACK_FUNCTIONS_IN_ORIGINC

	// AW 7/16/2001 UPDATE_CVT_EXPRESSION_NUMERIC
	virtual int		GetNumeric(LPINT lpnValue, double *lpdreal, double *lpdimage) { return 0; }
	// END 	UPDATE_CVT_EXPRESSION_NUMERIC
 	/// TD 7-24-01 t9298 CALLBACK_FUNCTIONS_IN_ORIGINC
	virtual int		SetMemoryPtr(LPVOID pAddress, LPMSOINDICES lpMSOIndeces = NULL, DWORD dwMsg = 0UL);
	/// end CALLBACK_FUNCTIONS_IN_ORIGINC
	/// TD 11-26-01 CSHARP_STYLE_CONSIDERATION_OF_WRAPPER_OBJECTS_AS_BOOL
	virtual		BOOL		IsValidElement(MSOINDICES& stIndex);
	/// end CSHARP_STYLE_CONSIDERATION_OF_WRAPPER_OBJECTS_AS_BOOL
	/// TD 2-22-02 QA70-945 v7.0221 ASK_LABTALKMGR_IF_ORIGIN_CAN_CLOSE
	/// TD 12-12-02 QA70-3133 v7.0452 NO_OC_BUILD_REQUEST_WHILE_EXECUTION
	enum
	{
		BIMNoInterrupt = 0,
		BIMOpenDialogs,
	};
	/// end NO_OC_BUILD_REQUEST_WHILE_EXECUTION
	virtual DWORD	IsObjReadyForOriginClose();  // 0 = Ready, Nonzero may mean different things, definitely not ready
	/// end ASK_LABTALKMGR_IF_ORIGIN_CAN_CLOSE
	
	// AW 04/16/02 ADD_UPDATE_FLAG
	virtual void SetModify(int nIndexFirstDim) { ASSERT(FALSE); } 
	// END ADD_UPDATE_FLAG
	/// TD 7-28-02 QA70-2441 v7.0357 OC_INFO_VAR_LINK_FOR_EFF_METH_CALLS
	virtual int InfoVariableValue(OCArgumentsAdaptor *pAdaptor, int index,  bool bSet = NULL, LPMSOINDICES lpMSOIndeces = NULL);
	/// end OC_INFO_VAR_LINK_FOR_EFF_METH_CALLS

	/// AW 12/03/02 QA70-2196 v7.0477 POINTER_OBJECT_VARIABLE_DISPLAY
	virtual BOOL GetDataTypeName( CString& sDataTypeName );
	/// END POINTER_OBJECT_VARIABLE_DISPLAY
	/// TD 5-30-03 QA70-4563 REFERNCES_TO_WRAPPER_DATA_NEEDS_DETACHMENT_AFTER_DETACHED_FROM_ALL_REFS
	// AddRef and Release will currently onl work with vectorbas/curvebase and matrixbase
	/// AW 06/29/03 QA70-4733 v7.0612 SMART_COUNT_NUMBER_FOR_REF
	/*
	virtual	void	AddRef(LPMSOINDICES lpMSOIndeces = NULL){}
	virtual	void	Release(LPMSOINDICES lpMSOIndeces = NULL){}
	*/
	/// END SMART_COUNT_NUMBER_FOR_REF
	/// end REFERNCES_TO_WRAPPER_DATA_NEEDS_DETACHMENT_AFTER_DETACHED_FROM_ALL_REFS

protected:

	BOOL	SetUserTypeID(int nTypeID);	//USE VERIFY TO ASSURE LEGAL TYPEID
	BOOL	SetTypeID(int nTypeID);	//USE VERIFY TO ASSURE LEGAL TYPEID
	BOOL	IsSameTypeAndMemoryModel(CScriptMocaObject* pMSO, INT nIndexOuter = 0, BOOL bMixedAllDiff = TRUE); //-------- CPY 5/28/03 QA70-3737 v7.0594 VEC_SET_SUB_VEC_MUST_CHECK_MIXED
private:

	int		m_nTypeID;
	int		m_nUserTypeID;
	CString	m_strName;
	/// -------------------- TD 3/7/2001 SEPERATE_CREATION_OF_OBJECT_FROME_ADDING_THEM_TO_STACK
	DWORD	m_nFlags;
	/// end ----------------  SEPERATE_CREATION_OF_OBJECT_FROME_ADDING_THEM_TO_STACK

public:
	//  -------AW 07/08/2001 t8989 complex_class 
	virtual BOOL SetComplex(OneOCcomplex *pcomplexValue) {ASSERT(FALSE); return FALSE;}
	virtual	int GetComplexValue(OneOCcomplex &iResult, const MSOINDICES &stIndices){ASSERT(FALSE); return 0;}
	virtual BOOL GetComplex(OneOCcomplex  & complexVal){ ASSERT(FALSE);return FALSE;}
	virtual int  GetComplex(OneOCcomplex  & complexVal, const MSOINDICES &stIndices) {ASSERT(FALSE);return 0;}
	virtual BOOL SetComplex(OneOCcomplex  & complexVal) { return FALSE; }
	/// TCZ 07/6/02 QA70-2187  v7.0337 MATRIX_BASIC_OPERATION
	virtual	int SetComplexValue(OneOCcomplex &iResult, const MSOINDICES &stIndices){ASSERT(FALSE); return 0;}
	/// end	MATRIX_BASIC_OPERATION
	// --------END COMPLEX_CLASS

	// AW 05/05/02 v7.0302 QA70-1655 POINT_POINTF_POINTC_SUPPORT
	virtual int	GetPointValue(COKPointInt  &PointVal, const MSOINDICES &stIndices) { ASSERT(FALSE); return 1; }
	virtual BOOL GetPoint(COKPointInt  &PointVal) { ASSERT(FALSE); return FALSE; }
	virtual int  GetPoint(COKPointInt  &PointVal, const MSOINDICES &stIndices) { ASSERT(FALSE); return 1; }
	virtual BOOL SetPoint(COKPointInt  &PointVal) { ASSERT(FALSE); return FALSE; }
	virtual BOOL SetPoint(COKPointInt  *lpPointVal) { ASSERT(FALSE); return FALSE; }

	virtual int	GetPointValue(COKPointDouble  &PointVal, const MSOINDICES &stIndices) { ASSERT(FALSE); return 1; }
	virtual BOOL GetPoint(COKPointDouble  &PointVal) { ASSERT(FALSE); return FALSE; }
	virtual int  GetPoint(COKPointDouble  &PointVal, const MSOINDICES &stIndices) { ASSERT(FALSE); return 1; }
	virtual BOOL SetPoint(COKPointDouble  &PointVal) { ASSERT(FALSE); return FALSE; }
	virtual BOOL SetPoint(COKPointDouble  *lpPointVal) { ASSERT(FALSE); return FALSE; }

	virtual int	GetPointValue(COKPoint3D  &PointVal, const MSOINDICES &stIndices) { ASSERT(FALSE); return 1; }
	virtual BOOL GetPoint(COKPoint3D  &PointVal) { ASSERT(FALSE); return FALSE; }
	virtual int  GetPoint(COKPoint3D  &PointVal, const MSOINDICES &stIndices) { ASSERT(FALSE); return 1; }
	virtual BOOL SetPoint(COKPoint3D  &PointVal) { ASSERT(FALSE); return FALSE; }
	virtual BOOL SetPoint(COKPoint3D  *lpPointVal) { ASSERT(FALSE); return FALSE; }
	// END POINT_POINTF_POINTC_SUPPORT

	/// TD 7-26-02 QA70-2424 v7.0352 ORIGINC_WRAPPER_OBJECTS_CRASH_AFTER_CLOSING_PROJECT
	virtual bool DetachAllOriginObjs() { return true; }
	/// end ORIGINC_WRAPPER_OBJECTS_CRASH_AFTER_CLOSING_PROJECT

	///	DVT 3/26/03 QA70-4139 v7.0545 OC_CATEGORICAL_INFORMATION_METHOD
	virtual int	SetMatrixDimension( int nRows, int nCols, MSOINDICES &stIndices) { ASSERT(FALSE); return 1; }
	virtual int	SetVectorDimension( int nSize, MSOINDICES &stIndices) { ASSERT(FALSE); return 1; }
	///	end OC_CATEGORICAL_INFORMATION_METHOD

	

	//Inlining
	static int RoundDouble(double dVal)
	{
		if( dVal >= INT_MAX) return(INT_MAX);  
		if( dVal <= INT_MIN) return(INT_MIN);
	
		/// TD t9407 CONSISTENT_CASTING_USE_CSTYLE_AND_CONCATENATE
		//return  (dVal >= 0.0 ? (int)ceil( dVal - 0.50 ) : (int)floor( dVal + 0.5 ) );
		//Use c-type casting
		return  (int)dVal;
		/// end CONSISTENT_CASTING_USE_CSTYLE_AND_CONCATENATE
	}
};



///////////////////////////////////////////////////////////////////////
CScriptMocaObject*	okNewMocaObject(CScriptMocaObject* pMocaObject);
void	okDeleteMocaObject(CScriptMocaObject* pMocaObject);




//////////////////////////////////////////////////////////////////////
DWORD BitIDFromID(int nID);



//////////////////////////////////////////////////////////////////////
///CPY 4/4/01 ADD_ORGIIN_C_OBJECT_AS_BASE_CLASS
//------- CPY 03-31-2001 t9030 WORKSHEET_CLASS_IN_ORIGIN_C
// we need a common base class for all Origin objects
//////////////////// class OriginCObject ////////////////////////
//////////////////// class OriginCObject ////////////////////////
//////////////////// class OriginCObject ////////////////////////
//////////////////// class OriginCObject ////////////////////////
//////////////////// class OriginCObject ////////////////////////
class  MOCA_EXP_CLASS OriginCObject : public	CScriptMocaObject
{
	MOCA_DECLARE_DYNAMIC(OriginCObject)
	//DECLARE_MEMBERS_TABLE(COriginObject)

	/// RVD 6/13/2002 QA70-1955 v7.0318 ORIGIN_OBJECT_SHOW_METHOD
	DECLARE_MEMBERS_TABLE(COriginObject)
	/// end ORIGIN_OBJECT_SHOW_METHOD

public:
	OriginCObject();
	~OriginCObject();

public:
	//virtual BOOL Attach(LPCTSTR lpcszName, int nOption=0);
	virtual BOOL Attach(LPCTSTR lpcszName, int nOption=0, int nIndex = 0);// TD 4-11-01 Array support
	virtual	BOOL Detach(int nIndex = 0, int nOption = 0); //TD 4-11-01
	virtual BOOL Attach(MODATAID dwID, int nIndex = 0) {return FALSE;}/// CPY 6/4/01 t9149 ORIGIN_C_SERIES_CALL_BACK
	/// TD 7-23-01 ATTACH_2_SERIES_TO_A_CURVE
	virtual BOOL Attach(MODATAID dwXID, MODATAID dwYID, int nIndex = 0) {return FALSE;}
	/// end ATTACH_2_SERIES_TO_A_CURVE
	/// ML 5/29/2003 QA70-4562 CURVE_EXTENSION_WITH_RELATED_DATASETS
	#ifdef		__EXTENDED_CURVE_CLASS_WITH_RELATED__
	virtual	BOOL	Attach(MODATAID dwXID, MODATAID dwYID, CArray<OSERIESTAG, OSERIESTAG&> &arrRelated, int nIndex = 0) {return FALSE;}

	#endif		// __EXTENDED_CURVE_CLASS_WITH_RELATED__
	/// end CURVE_EXTENSION_WITH_RELATED_DATASETS
	
	virtual int	 GetUpperBound(int nDimIndex);//CPY v6.9037 6/25/01 t9247 ORIGIN_C_COMPILED_FUNC_RETURN_TEMP_SERIES


	// OIDE varibale window display
	virtual BOOL GetString(CString &strValue);

	/// ML 12/17/2001 t9814 CREATING_GRAPH_FROM_TEMPLATE_IN_ORIGINC
	void	SetTemporary(BOOL bSet);
	BOOL	IsTemporary();
	/// end CREATING_GRAPH_FROM_TEMPLATE_IN_ORIGINC
	/// TD 4-9-03 QA70-4171 METHODS_TO_ACCESS_AND_ASSIGN_STORAGE_TO_TREE
	OC_DECL_METHOD(GetStorage)
	OC_DECL_METHOD(GetStorageNames)
	/// TD 7-28-03 QA70-4895 ADD_OPTIONAL_ARGUMENT_TO_ADD_STORAGE_IN_GETSTORAGE
	//virtual LPVOID GetObjStorage(LPCSTR lpcszName, LPMSOINDICES lpIndex){return NULL;}
	virtual LPVOID GetObjStorage(LPCSTR lpcszName, LPMSOINDICES lpIndex, BOOL bAdd = FALSE){return NULL;}
	/// end ADD_OPTIONAL_ARGUMENT_TO_ADD_STORAGE_IN_GETSTORAGE
	virtual BOOL GetObjStorageNames(CStringArray & strarrStorages, LPMSOINDICES lpIndex){return FALSE;}
	/// end METHODS_TO_ACCESS_AND_ASSIGN_STORAGE_TO_TREE
	/// TD 4-9-03 QA70-4171 ACCESSING_COMPACT_STORAGE_TABLES
	//virtual LPVOID GetCompressionTable(LPCTSTR lpcszKey, LPMSOINDICES lpIndex){return NULL;}
	/// end ACCESSING_COMPACT_STORAGE_TABLES

	///	DVT 4/14/03 QA70-4257 v7.0560 MORE_ON_OC_ORIGINOBJECT_GETNAME_MATHOD
	//OC_DECL_METHOD(GetName)							///	DVT 4/14/03 QA70-4257 v7.0560 OC_ORIGINOBJECT_GETNAME_MATHOD
	virtual	OC_DECL_METHOD(GetName)
	///	end MORE_ON_OC_ORIGINOBJECT_GETNAME_MATHOD

//----- CPY 11/5/02 v7.0428 QA70-3213  ADD_FONT_INIT_TO_TREE_EDITOR
public:
	virtual	BOOL CreatePrinterDC(CDC &dc, BOOL bIC=FALSE);
//----- end CPY 11/5/02 v7.0428 QA70-3213
	/////////////////////////////////////////
	//------------- OriginC methods
public:
	int		OCAttach(COCall * pCall);
	int		OCDetach(COCall * pCall); //TD 4-11-01
	/////////////////////////////////////////
	/// TD 3-7-02 BUFFER_SIZE_SET_GET_EXPOSED
	virtual int	SetBufferSize(int nArrayIndex, int BufferSize);
	virtual int	GetBufferSize(int nArrayIndex, int &BufferSize);
	/// end BUFFER_SIZE_SET_GET_EXPOSED

	/// RVD 6/13/2002 QA70-1955 v7.0318 ORIGIN_OBJECT_SHOW_METHOD
	int				OCShow(COCall* pCall);
	virtual BOOL	Show(BOOL bShow)		{ASSERT(FALSE); return FALSE;}
	/// end ORIGIN_OBJECT_SHOW_METHOD

protected:
	LPVOID	GetBuffer(COCall * pCall, UINT nArgIndex, UINT nSize = 0);
	void	ReleaseBuffer(COCall * pCall, int nArgIndex = -1);// -1 to indicate use default
	/// TD 4-10-2001 t9050 ADD_FUNCTION_TO_ACCESS_UNDERLYING_DATA_STRUCTURE
	/// TD 7-24-01 ALLOW_GETTING_UNDERLYING_CPP_ARRAY_OBJECT_FROM_ARG
	//LPVOID	 GetArgObjectPtr(COCall* pCall, int nArg, int nTypeID);	
	LPVOID	 GetArgObjectPtr(COCall* pCall, int nArg, int nTypeID, BOOL bGetWholeArrayObject = FALSE);	
	/// end ALLOW_GETTING_UNDERLYING_CPP_ARRAY_OBJECT_FROM_ARG
	/// end ADD_FUNCTION_TO_ACCESS_UNDERLYING_DATA_STRUCTURE

private: 
	MSOOBJVECT		m_stPtrObjTemp;
	int				m_nArgTemp;
	/// ML 12/17/2001 t9814 CREATING_GRAPH_FROM_TEMPLATE_IN_ORIGINC
	DWORD			m_dwInfo;
	enum {
		ORIGINCOBJDWINFO_TEMPORARY = 0x00010000UL,
	};
	/// end CREATING_GRAPH_FROM_TEMPLATE_IN_ORIGINC
};
//------- end CPY 03-31-2001 t9030 WORKSHEET_CLASS_IN_ORIGIN_C
///end CPY 4/4/01 ADD_ORGIIN_C_OBJECT_AS_BASE_CLASS

/// TD 9-13-01 t9514 ORIGIN_C_COLLECTION

typedef		LPVOID		OCCOLLECTIONPOSITION;

class	OCCollectionBase : public OriginCObject
{
	MOCA_DECLARE_DYNAMIC(OCCollectionBase)
public:
	OCCollectionBase();
	~OCCollectionBase();
	
	DECLARE_MEMBERS_TABLE(OCCollectionBase)

public:

	int								GetItem(COCall *pCall);
	
	int								GetCount(COCall *pCall);

	// Used for "foreach" support:
	virtual	OCCOLLECTIONPOSITION	_GetFirstPosition(LPMSOINDICES lpstIndices = NULL) = 0;
	virtual	int						_GetNext(OCCOLLECTIONPOSITION &ocpos, CScriptMocaObject *pMSO, LPMSOINDICES lpstIndices = NULL) = 0;
	
	
	virtual	int						_GetCountEx(INT &nCount, COCall *pCall) = 0;
	virtual	int						_GetItemEx(COCall *pCall) = 0;

	/// AW 09/16/03 QA70-5170 ADD_SELECT_IN_COLLECTION
	int						OCSelect(COCall *pCall); 
	/// END ADD_SELECT_IN_COLLECTION
protected:
	DWORD							m_wParam, m_lParam;

public:


};

/// end ORIGIN_C_COLLECTION

//-------- AW 08/20/02 QA70-2732 v7.0375 FIX_APPLY_FILTER_PROBLEM

void GetDataTypeRange(char &tMin, char &tMax);
void GetDataTypeRange(unsigned char &tMin, unsigned char &tMax);
void GetDataTypeRange(short &tMin, short &tMax);
void GetDataTypeRange(unsigned short &tMin, unsigned short &tMax);
void GetDataTypeRange(int &tMin, int &tMax);
void GetDataTypeRange(unsigned int &tMin, unsigned int &tMax);
void GetDataTypeRange(float &tMin, float &tMax);
void GetDataTypeRange(double &tMin, double &tMax);

//-----------------TD-------More overloads
//---------------AW 08/21/02 QA70-2762 v7.0377 CLEAN_MATRIXOBJECT_METHODS_MOVED_TO_MATRIX
/*
void GetDataTypeRange(tagOneOCcomplex &tMin, tagOneOCcomplex &tMax);
void GetDataTypeRange(COKPointInt &tMin, COKPointInt &tMax);
void GetDataTypeRange(COKPointDouble &tMin, COKPointDouble &tMax);
void GetDataTypeRange(ULONG &tMin, ULONG &tMax);
void GetDataTypeRange(LONG &tMin, LONG &tMax);
*/
//---------------AW 08/21/02 QA70-2762 v7.0377 CLEAN_MATRIXOBJECT_METHODS_MOVED_TO_MATRIX
// end -----------------TD-------More overloads
// -------- END FIX_APPLY_FILTER_PROBLEM


//-------- CPY v6.9084 9/7/01 GET_STR_NEED_SEPARATE_DISPLAY_AND_ASSIGNMENT
void make_str_from_char(INT iValue, CString& strValue, BOOL bForDisplay=TRUE);
void make_str_from_char_array(LPCTSTR lpcsz, int nSize, CString& strValue, BOOL bForDisplay=TRUE);
//-------- end CPY v6.9084 9/7/01 GET_STR_NEED_SEPARATE_DISPLAY_AND_ASSIGNMENT
/// TD 2-15-02 INITIALIZE_OCDATA_TO_ZERO
//#define		REGULAR_MEM_INIT(__ADDR, __SIZE__)		memset((__ADDR), 0,   (__SIZE__))
//#define		DEBUG_MEM_INIT(__ADDR, __SIZE__)		memset((__ADDR), 0xCC,(__SIZE__))

/// ML 8/24/2002 QA70-2805 PASSING_DISPINTERFACES_AS_ARGUMENTS_OF_EVENT_HANDLERS
///// TD 8-23-02 QA70-2780 v7.0381 WRITING_ACROSS_BDRY_PROTECTION_DEF_WITH_SIZE_10
////#define     DEBUG_SENSITIVE_INIT(__ADDR, __SIZE__)		memset((__ADDR), ((GetDebugMode() & 1) ? 0xCC : 0), (__SIZE__))				
/////// TD 7-29-02 QA70-1882 @BC_AND_@BCM_FOR_OC_MEM_EXCEPTION
//////#define     OK_DEBUG_SENSITIVE_INIT(__ADDR, __SIZE__)	memset((__ADDR), ((GetOCDebugMode() & 1) ? 0xCC : 0), (__SIZE__))				
////#define     OK_DEBUG_SENSITIVE_INIT(__ADDR, __SIZE__)	memset((__ADDR), ((GetOCDebugMode(0) & 1) ? 0xCC : 0), (__SIZE__))				
/////// end @BC_AND_@BCM_FOR_OC_MEM_EXCEPTION
//#define     DEBUG_SENSITIVE_INIT(__ADDR, __SIZE__)		memset((__ADDR), ((GetDebugMode() > 0) ? 0xCC : 0), (__SIZE__))				
//#define     OK_DEBUG_SENSITIVE_INIT(__ADDR, __SIZE__)	memset((__ADDR), ((GetOCDebugMode(0) > 0) ? 0xCC : 0), (__SIZE__))				
///// end WRITING_ACROSS_BDRY_PROTECTION_DEF_WITH_SIZE_10
///// end INITIALIZE_OCDATA_TO_ZERO

// I noticed this problem when working on QA70-2805. We are not allowed to set everything to 0xcc if
// in OCNumericBase<TYPE_NUMERIC> TYPE_NUMERIC is VARIANT (variants have their own type descriptors)!!! To set variants
// to all 0's is OK (although redundant here because the class OCONEVARIANT which we use for variant does all
// the initializations properly).
// The same problem may exist with some other types that use OCNumericBase template class. 
/// TD 8-26-02 QA70-2780 v7.0384 SEPERATE_VARS_FOR_DEBUG_AND_EXTRA_MEMORY
//#define     DEBUG_SENSITIVE_INIT(__ADDR, __SIZE__)		memset((__ADDR), 0, (__SIZE__))				
//#define     OK_DEBUG_SENSITIVE_INIT(__ADDR, __SIZE__)	memset((__ADDR), 0, (__SIZE__))				
#define     DEBUG_SENSITIVE_INIT(__ADDR, __SIZE__)		memset((__ADDR), IsDebugging() ? 0xCC : 0, (__SIZE__))			
#define     OK_DEBUG_SENSITIVE_INIT(__ADDR, __SIZE__)	memset((__ADDR), GetOCDebugMode(0) ? 0xCC : 0, (__SIZE__))				
/// end SEPERATE_VARS_FOR_DEBUG_AND_EXTRA_MEMORY
/// end PASSING_DISPINTERFACES_AS_ARGUMENTS_OF_EVENT_HANDLERS

/// TD 11-3-03 QA70-5067 MESSAGE_HANDLING_FROM_BASE_CLASS_OF_WINDOW
class OCMessageMapBase : public OriginCObject
{

public:
};
/// end MESSAGE_HANDLING_FROM_BASE_CLASS_OF_WINDOW


#endif //!_MOCASCRIPT_H
