/*------------------------------------------------------------------------------*
 *	File Name: 	OClassIDs.H														*
 *	Purpose:	Origin C class IDs												*
 *	This file was created to move all IDs out of MOCAScript.h so it is easier	*
 *	add new ids																	*
 *																				*
 *	Author:		CPY																*
 *  Creation:	11/19/02														*
 *  	Copyright (c) Originlab Corp. 2002, All Rights Reserved					*
 *																				*
 *	Modification log                                                        	*
 *	CPY 11/19/02 QA70-3212 ADD_MORE_CONTROLS									*
 *	TD 11-20-02 ALL_CONTROL_DERIVED_CLASSES_MUST_HAVE_ID_RANGE_LTT_ID_CONTROL_TO_LTT_ID_CONTRO_END
 *	YuI 11/22/02 v7.0440 QA70-3389 OC_CLASS_FOR_OPERATION						*
 *	YuI 12/16/02 QA70-3502 v7.0464 OC_SELECTION_IMPLEMENTATION					*
 *	DVT 12/18/02 QA70-3537 v7.0467 ADD_MATLAB_CLASS_FOR_COMMUNICATION			*
 *	YuI 12/19/02 QA70-3554 v7.0469 OC_COMBO_BOX									*
 *	YuI 12/20/02 QA70-3560 v7.0470 CONFIGURATION_OC_CLASS						*
 *	YuI 12/23/02 QA70-3575 v7.0472 INIFILE_OC_CLASS								*
 *	JCG 01/08/03 QA70-3159 v7.0482	ADD_OC_WORKSHEET_CONTROL					*
 *	TD 1-9-02 QA70-3636 v7.0483 CUSTOM_CONTROL_FOR_GRID_CONTROL					*
 *	CPY 1/10/03 remove __SUPPORT_ORIGIN_C_WORKSHEET_CTRL__						*
 *  SY 01-15-2003 QA70-3686 v7.0488 ADD_OC_DEVICE_CONTEXT_CALSS					*
 *	AW 01/22/03 QA70-3434 v7.0492 OC_LIST_BOX									*
 *	TD 1-31-03 QA70-3681 TEMPLATE_WITH_INTEGRAL_VALUES							*
 *	AW 02/20/03 QA70-3944 v7.0518 DESTRUCTOR_FOR_OC_CLASS						*
 *	TD 3-26-03 QA70-4126 v7.0544 COLLECTION_OF_TREENODES						*
 *  SY 03-28-2003 QA70-4165 v7.0548 ADD_ORIGINC_REGISTRY_ACCESS_FUNCTIONS		*
 *	TD 4-14-03 QA70-4256 NEW_OCCLASS_CURVEBASE									*
 *  SY 05-05-2003 QA70-3989 v7.0578 READ_WRITE_SPC_INFORMATION_FROM_ORIGINC		*
 *	TD 5-6-03 Qa70-4404 v7.0580 PROPERTY_PAGE_IN_OC								*
 *	YuI 5/28/03 v7.0594 QA70-4559 OC_ACCESS_TO_OPERATION_MANAGER				*
 *	TD 6-16-03 QA70-4655 NEW_PROPERTYNODE_CLASS									*
 *	RVD 6/13/2003 QA70-4650 v7.0601 OBJECT_PROPERTY_ACCESS						*
 *	TD 7-7-03 QA70-4767 MENU_CLASS_IN_ORIGINC									*
 *	TD 7-14-03 QA70-4817 N_STATE_BUTTON											*
 *	TD 10-21-03 QA70-5067 PROPERTY_SHEET_AND_WIZARD_CLASS_IN_OC					*
 *------------------------------------------------------------------------------*/
#ifndef _OCLASS_IDS_H
#define _OCLASS_IDS_H

enum{
	/// EJP	03-30-2001 t9018 IMPLEMENT_FUNCTION_OVERLOAD
	///LTT_ID_VOID = 1, /// TD 03/21/2001 IMPLEMENT_VOID
	LTT_ID_INVALID = 0, // use ID instead of 0 in code
	LTT_ID_VOID,
	/// end IMPLEMENT_FUNCTION_OVERLOAD
	/// ML 8/13/2001 t9309 IMPLEMENTING_bool_FOR_COM
	LTT_ID_bool,
	/// end IMPLEMENTING_bool_FOR_COM
	LTT_ID_CHAR,
	LTT_ID_BYTE,
	LTT_ID_SHORT,
	LTT_ID_WORD,
	/// ML 5/29/2001 t9168 ENUM_IMPLEMENTATION
	LTT_ID_ENUM,	// the same size as "int"
	/// end ENUM_IMPLEMENTATION
	LTT_ID_INT,
	LTT_ID_UINT,
	LTT_ID_FLOAT,
	LTT_ID_DOUBLE,
	/// ML 7/6/2001 t9283 COMPLEX_TYPES
	LTT_ID_complex,			// for "complex"	(as structure with real and imaginary)
	LTT_ID_Complex,			// for "Complex"	(separate real and imaginary arrays, used only for Vectors for now)	
	/// end COMPLEX_TYPES

	// AW 05/05/02 v7.0302 QA70-1655 POINT_POINTF_POINTC_SUPPORT
	LTT_ID_POINTINT,
	LTT_ID_POINTDOUBLE,
	LTT_ID_POINT3D,
	// END POINT_POINTF_POINTC_SUPPORT

	LTT_ID_VECTORBASE,	/// TD 3-15-02 QA70-1145 NON_TEMPLATE_ABSTRACT_BASE_FOR_MATRICES_AND_VECTORS
	LTT_ID_VECTOR,
	LTT_ID_OVECTOR,
	/// TD 10-29-01	CATEGORICAL_DATA
	LTT_ID_CATEGORICALDATA, 
	LTT_ID_MAP_STR_TO_INT, 
	/// end	CATEGORICAL_DATA
	LTT_ID_MATRIXBASE,	/// TD 3-15-02 QA70-1145 NON_TEMPLATE_ABSTRACT_BASE_FOR_MATRICES_AND_VECTORS
	LTT_ID_MATRIX,
	/// ML 6/6/2001 MATRIX_TYPES
	LTT_ID_OMATRIX,
	/// end MATRIX_TYPES
	LTT_ID_CURVEBASE, /// TD 4-14-03 QA70-4256 NEW_OCCLASS_CURVEBASE
	LTT_ID_CURVE,
	LTT_ID_CSTRING,
	LTT_ID_CFILE,
	LTT_ID_CSTDIOFILE, //TD 4-12-01
	LTT_ID_CWAITCURSOR,
	LTT_ID_CPROGRESSBAR,
	LTT_ID_REFERENCE,
	
	LTT_ID_POINTER,
	LTT_ID_FUNCTION,
	LTT_ID_FNCALLBK, /// TD 7-11-01 t9298 CALLBACK_FUNCTIONS_IN_ORIGINC
	//-------- CPY 2/27/01 v6.1096 ADD_TYPE_DEF
	//LTT_ID_USER,
	LTT_ID_TYPEDEF,
	//-------- end CPY 2/27/01 v6.1096 ADD_TYPE_DEF
	/// ML 4/3/2001 MORE_STRUCTURE_WORK
	LTT_ID_STRUCT,
	/// end MORE_STRUCTURE_WORK
	// AW 02/20/03 QA70-3944 v7.0518 DESTRUCTOR_FOR_OC_CLASS
	LTT_ID_OCCLASS,
	// END DESTRUCTOR_FOR_OC_CLASS

	/// ML 4/9/2002 QA70-929 ORIGINC_FUNCTION_POINTERS
	LTT_ID_FUNCTION_POINTER,
	/// end ORIGINC_FUNCTION_POINTERS
	/// ML 7/6/2001 t9283 COMPLEX_TYPES
	//LTT_ID_COMPLEX,
	/// end COMPLEX_TYPES
	/// ML 8/6/2001 t9309 COM_SUPPORT_IN_ORIGIN_C
	LTT_ID_COMOBJ,
	LTT_ID_GRIDOBJ,	/// TD 1-9-02 QA70-3636 v7.0483 CUSTOM_CONTROL_FOR_GRID_CONTROL
	LTT_ID_VARIANT,
	/// end COM_SUPPORT_IN_ORIGIN_C

	//------------ CPY 03-31-2001 t9030 WORKSHEET_CLASS_IN_ORIGIN_C
	LTT_ID_WINDOW,
	LTT_ID_LAYER,
	/// TD 11-14-01 ORGANIZE_ORIGINC_CLASSES
	LTT_ID_ORIGINOBJ,
	LTT_ID_GRAPHLAYER,
	LTT_ID_DATASHEET,
	// AW 07/19/02 v7.0345 QA70-2397 ADD_OCDATAOBJECTBASE_CLASS
	LTT_ID_DATAOBJBASE,
	// END ADD_OCDATAOBJECTBASE_CLASS
	LTT_ID_DATAOBJ,
	/// end ORGANIZE_ORIGINC_CLASSES
	LTT_ID_OKBASEPAGE,/// TD	12-20-01 ADD_BASEPAGE_AS_BASE_OF_PAGE
	LTT_ID_OKPAGE,/// TD 9-28-01 t9553 GET_ACTIVE_PAGE
	///------------------- TD 11-17-01
	LTT_ID_OKGRAPHPAGE,
	LTT_ID_OKWKSPAGE,
	LTT_ID_OKMATRIXPAGE,
	LTT_ID_OKLAYOUTPAGE,
	///------------------- TD 11-17-01 end
	/// TD 10-22-01
	LTT_ID_NOTE,
	LTT_ID_LAYOUT,
	LTT_ID_APPLICATION,
	/// end TD 10-22-01
	LTT_ID_WORKSHEET,	
	//------------ end CPY 03-31-2001 t9030 WORKSHEET_CLASS_IN_ORIGIN_C
	LTT_ID_MATRIXLAYER,/// TD 10-10-01 MATRIX_LAYER
	LTT_ID_COLUMN, // TD 4-23-01 ADD_COLUMN_TYPE_IN_ORIGIN_C 
	LTT_ID_MATRIXOBJECT, /// TD 1-4-02 t9809 MATRIX_OBJECT_BASED_ON_COLUMN_OBJECT
	LTT_ID_VARARGS, //------------ CPY 4/15/01 VARIABLE_NUM_ARGS
	//LTT_ID_UD_CLASS, /// TD 6-28-01 t9243 SUPPORT_USER_DEFINED_ORIGINC_CLASSES
	LTT_ID_COLLECTION,		///	TD 9-17-01 t9514 ORIGIN_C_COLLECTION
	LTT_ID_TEMPLATE_BASE,	///	TD 9-13-01 t9514 ORIGIN_C_COLLECTION
	
	//--------- CPY 9/4/01 t9324 v6.9083 OC_LAYER_CLASS
	LTT_ID_DATAPLOT,
	/// ML 9/25/2001 GROBJ_COLLECTION
	LTT_ID_GROBJ,
	/// end GROBJ_COLLECTION
	LTT_ID_PLOT_STYLE,
	//---------
	/// ML 10/16/2001 t9596 ORIGINC_ROI_ACCESS
	LTT_ID_ROI,
	/// end ORIGINC_ROI_ACCESS
	/// ML 10/23/2001 t9629 PROJECT_EXPLORER_ORIGINC_INTERFACE
	LTT_ID_PE_FOLDER,
	/// end PROJECT_EXPLORER_ORIGINC_INTERFACE
	LTT_ID_USING, /// TD 11-07-01 t9619 v6.9119 USING_IN_OC
	/// YuI 11/17/01 v6.9128 t9727 OCPOINT_AND_OCRECT_CLASSES_IMPLEMENTATION
	LTT_ID_CPOINT,//class OCPoint
	LTT_ID_CRECT,//class OCRect
	LTT_ID_CSIZE,//class OCSize
	LTT_ID_POINT,//structure POINT
	LTT_ID_RECT,//structure RECT
	LTT_ID_SIZE,//structure SIZE
	/// end OCPOINT_AND_OCRECT_CLASSES_IMPLEMENTATION
	LTT_ID_SCALE,	/// TD 3-5-02 QA70-696 v7.0235 NEW_SCALE_CLASS_IN_OC
	//LTT_ID_CWND,	//------- CPY 11/15/02 v7.0434 QA70-3212 BASIC_CWND_SUPPORT_SIMPLE	// Moved below
	/// TD 11-3-03 QA70-5067 MESSAGE_HANDLING_FROM_BASE_CLASS_OF_WINDOW
	LTT_ID_WNDCONTAINER,
	/// end MESSAGE_HANDLING_FROM_BASE_CLASS_OF_WINDOW
	LTT_ID_DIALOG,	/// TD 7-5-02 QA70-2223 v7.0332	DIALOG_CLASS_FOR_DB_EVENT_CATCHING
	LTT_ID_PROPERTY_PAGE, /// TD 5-6-03 Qa70-4404 v7.0580 PROPERTY_PAGE_IN_OC
	/// TD 10-21-03 QA70-5067 PROPERTY_SHEET_AND_WIZARD_CLASS_IN_OC
	LTT_ID_PROPERTY_SHEET,
	LTT_ID_WIZARD,
	/// end PROPERTY_SHEET_AND_WIZARD_CLASS_IN_OC
	LTT_ID_STORAGE, /// TD 10-4-02 QA70-2177 v7.0408 ORIGIN_C_ACCESS_TO_STORAGE
	LTT_ID_MSG_MAP, /// TD 10/29/02 QA70-3182 v7.0424 OCDIALOG_MSG_MAP_IMPLEMENT
	//------------------------
	LTT_ID_CONTROL,			/// TD 10-21-02 QA70-3181 ORIGINC_CLASSES_FOR_DIALOG_MEMBERS
	LTT_ID_CONTROL_EDIT,	/// TD 10-21-02 QA70-3181 ORIGINC_CLASSES_FOR_DIALOG_MEMBERS
	LTT_ID_CONTROL_RICHEDIT,/// TD 10-21-02 QA70-3181 ORIGINC_CLASSES_FOR_DIALOG_MEMBERS
	LTT_ID_CONTROL_SLIDER,	/// TD 10-21-02 QA70-3181 ORIGINC_CLASSES_FOR_DIALOG_MEMBERS
	LTT_ID_CONTROL_BUTTON, //CPY 11/19/02 QA70-3212 ADD_MORE_CONTROLS
	LTT_ID_CONTROL_BUTTON_CHECKBOX,	/// TD 7-14-03 QA70-4817 N_STATE_BUTTON 
	LTT_ID_CONTROL_COMBOBOX,/// YuI 12/19/02 QA70-3554 v7.0469 OC_COMBO_BOX
	LTT_ID_CONTROL_LISTBOX, ///AW 01/22/03 QA70-3434 v7.0492 OC_LIST_BOX
	LTT_ID_CONTRO_END,		// TD 11-20-02 ALL_CONTROL_DERIVED_CLASSES_MUST_HAVE_ID_RANGE_LTT_ID_CONTROL_TO_LTT_ID_CONTRO_END
							// TD will drop this requirement ASAP, but is still good to have some rules
	
	/// TD 11-3-03 QA70-5067 MESSAGE_HANDLING_FROM_BASE_CLASS_OF_WINDOW
	LTT_ID_CMDTARGET,
	/// end MESSAGE_HANDLING_FROM_BASE_CLASS_OF_WINDOW
	//	CPY 1/10/03 remove __SUPPORT_ORIGIN_C_WORKSHEET_CTRL__
	// I remove all conditional compiled on class ID, so that there is no difference in the ID incase we need to keep track
	// of IDs from earlier builds. I have also moved these two following ID from below	LTT_ID_CONTRO_END to here, not sure
	// if needed, but just in case.	
	/// TD 1-10-03  There are two types of Window derived calsses, The ones that's derived from the control class, are in DDK
	LTT_ID_CWND_WRAPPER_BEGIN, /// TD 1-10-03
	LTT_ID_CWND,	//------- CPY 11/15/02 v7.0434 QA70-3212 BASIC_CWND_SUPPORT_SIMPLE
	LTT_ID_WNDCTRL_ORIGIN_GRAPH, // TD 11-12-02 QA70-1644 v7.0433 MULTIPLE_GRAPHS_WITH_DIALOG_BUILDER (CWnd bases and no SAWnd based)
	LTT_ID_WNDCTRL_ORIGIN_WORKSHEET, 	/// JCG 01/08/03 QA70-3159 v7.0482	ADD_OC_WORKSHEET_CONTROL
	LTT_ID_CWND_WRAPPER_END, /// TD 1-10-03
	LTT_ID_MENU,/// TD 7-7-03 QA70-4767 MENU_CLASS_IN_ORIGINC 
	LTT_ID_CDC, /// SY 01-15-2003 QA70-3686 v7.0488 ADD_OC_DEVICE_CONTEXT_CALSS
	//------------------------------
	
	/// YuI 11/22/02 v7.0440 QA70-3389 OC_CLASS_FOR_OPERATION
	LTT_ID_OPERATION,
	LTT_ID_EXTERNAL_LINK,
	LTT_ID_FILE_LINK,
	/// end OC_CLASS_FOR_OPERATION
	
	/// TD 12-15-02 QA70-3183 v7.0464 TREE_IN_OC
	LTT_ID_PROPERTYNODE, /// TD 6-16-03 QA70-4655 NEW_PROPERTYNODE_CLASS
	LTT_ID_TREE_NODE,
	LTT_ID_TNDATA,
	LTT_ID_TNDATA_DBL,
	LTT_ID_TNDATA_INT,
	LTT_ID_TNDATA_VARIANT,
	LTT_ID_TNDISPINFO,
	LTT_ID_TREE,
	LTT_ID_TYPEDTREE, /// TD 1-31-03 QA70-3681 TEMPLATE_WITH_INTEGRAL_VALUES
	/// end TREE_IN_OC
	LTT_ID_TNCOLLECTION,/// TD 3-26-03 QA70-4126 v7.0544 COLLECTION_OF_TREENODES

	/// YuI 12/16/02 QA70-3502 v7.0464 OC_SELECTION_IMPLEMENTATION
	LTT_ID_SELECTION,
	/// end OC_SELECTION_IMPLEMENTATION
	LTT_ID_MATLAB,		///	----------------------------	DVT 12/18/02 QA70-3537 v7.0467 ADD_MATLAB_CLASS_FOR_COMMUNICATION
	LTT_ID_ORIGINSETTINGS,	/// YuI 12/20/02 QA70-3560 v7.0470 CONFIGURATION_OC_CLASS
	LTT_ID_INIFILE, /// YuI 12/23/02 QA70-3575 v7.0472 INIFILE_OC_CLASS
	LTT_ID_REGISTRY, /// SY 03-28-2003 QA70-4165 v7.0548 ADD_ORIGINC_REGISTRY_ACCESS_FUNCTIONS (TD 4-1-03) Add new ID's before LTT_ID_UD_CLASS
	LTT_ID_SPCDATA, /// SY 05-05-2003 QA70-3989 v7.0578 READ_WRITE_SPC_INFORMATION_FROM_ORIGINC
	LTT_ID_OPERATION_MANAGER, /// YuI 5/28/03 v7.0594 QA70-4559 OC_ACCESS_TO_OPERATION_MANAGER
	/// RVD 6/13/2003 QA70-4650 v7.0601 OBJECT_PROPERTY_ACCESS
	LTT_ID_AXIS,
	LTT_ID_AXISOBJ,
	LTT_ID_GROUPPLOT,
	/// end OBJECT_PROPERTY_ACCESS

	/////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////
	// new entries should be above these comments
	/////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////


	// LAST ENTRY
	LTT_ID_UD_CLASS, //TD 5-14-02 MUST_BE_LAST_ENTRY/// TD 6-28-01 t9243 SUPPORT_USER_DEFINED_ORIGINC_CLASSES
	LTT_ID_UPPER, ///// AW 12/03/02 QA70-2196 v7.0477 POINTER_OBJECT_VARIABLE_DISPLAY, for testing
};




///--------- CPY 2/24/01 CREATE_TYPE_FOM_TYPE
#define	LTT_BASE_ID(_nTypeID)					LOWORD(_nTypeID)
//----------

/// ML 8/13/2001 t9309 IMPLEMENTING_bool_FOR_COM
///// ML 4/13/2001 POINTER_ARITHMETICS
//#define		LTT_IS_INTEGRAL_SIMPLE_TYPE(_nTypeId)				(LTT_ID_CHAR <= (_nTypeId) && (_nTypeId) <= LTT_ID_UINT)
///// end POINTER_ARITHMETICS
#define		LTT_IS_INTEGRAL_SIMPLE_TYPE(_nTypeId)				(LTT_ID_bool <= (_nTypeId) && (_nTypeId) <= LTT_ID_UINT)
/// end IMPLEMENTING_bool_FOR_COM
/// ML 6/27/2001 t9281 ORIGINC_EXPLICIT_CASTS
#define		LTT_IS_FLOATING_SIMPLE_TYPE(_nTypeId)				(LTT_ID_FLOAT == (_nTypeId) || (_nTypeId) == LTT_ID_DOUBLE)

#define		LTT_IS_NUMERIC_SIMPLE_TYPE(_nTypeId)				(LTT_IS_INTEGRAL_SIMPLE_TYPE(_nTypeId) || LTT_IS_FLOATING_SIMPLE_TYPE(_nTypeId))
/// end ORIGINC_EXPLICIT_CASTS
/// ML 7/6/2001 t9283 COMPLEX_TYPES
#define		LTT_IS_ANY_COMPLEX_TYPE(_nTypeId)					(LTT_ID_complex == (_nTypeId) || LTT_ID_Complex == (_nTypeId))
/// end COMPLEX_TYPES
/// ML 8/3/2001 USE_ALWAYS_MEMORY_PTR_FOR_SIMPLE_TYPES
#define		LTT_IS_TYPE_TO_FORCE_MEMORY_PTR(_nTypeId)			(LTT_IS_NUMERIC_SIMPLE_TYPE(_nTypeId) || LTT_ID_complex == (_nTypeId) || LTT_ID_VOID == (_nTypeId))
/// end USE_ALWAYS_MEMORY_PTR_FOR_SIMPLE_TYPES

// AW 05/05/02 v7.0302 QA70-1655 POINT_POINTF_POINTC_SUPPORT
#define		LTT_IS_ANY_POINT_TYPE(_nTypeId)					(LTT_ID_POINTINT <= (_nTypeId) && (_nTypeId) <= LTT_ID_POINT3D )
// END  POINT_POINTF_POINTC_SUPPORT

/// ML 2/23/2001 VECTOR_TYPING_ETC
#define		LTT_ID_BIT_VECTOR					0x00010000UL
/// end VECTOR_TYPING_ETC
/// ML 3/28/2001 OVECTOR_WORK
#define		LTT_ID_BIT_OVECTOR					0x00020000UL
/// end OVECTOR_WORK
/// TD 6-18-01	CURVES_AS_TEMPLATE
//#define		LTT_ID_BITS_ANY_VECTOR				(LTT_ID_BIT_VECTOR | LTT_ID_BIT_OVECTOR)
#define		LTT_ID_BITS_ANY_VECTOR				(LTT_ID_BIT_VECTOR | LTT_ID_BIT_OVECTOR|LTT_ID_BIT_CURVE)
#define 	LTT_ID_BIT_CURVE					0x00100000UL
/// end	CURVES_AS_TEMPLATE
/// ML 6/6/2001 MATRIX_TYPES
#define		LTT_ID_BIT_MATRIX					0x00040000UL
#define		LTT_ID_BIT_OMATRIX					0x00080000UL

#define		LTT_ID_BITS_ANY_MATRIX				(LTT_ID_BIT_MATRIX | LTT_ID_BIT_OMATRIX)

#define		LTT_ID_BITS_ANY_TENSOR				(LTT_ID_BITS_ANY_VECTOR | LTT_ID_BITS_ANY_MATRIX)
/// end MATRIX_TYPES
/// TD 8-22-01 t9463 IMPLEMENT_BITFIELDS_SUPPORT
#define		LTT_ID_BIT_BITFIELD					0x01000000UL
/// end IMPLEMENT_BITFIELDS_SUPPORT
/// TD 9-13-01 t9514 ORIGIN_C_COLLECTION
#define     LTT_ID_BIT_COLLECTION				0x02000000UL
/// end t9514 ORIGIN_C_COLLECTION
/// ML 5/15/2001 MUST_CHECK_TARGET_TYPE_WHEN_CASTING_POINTER_TO_POINTER
/// ML 8/13/2001 t9309 IMPLEMENTING_bool_FOR_COM
//#define		IS_BASIC_ONE_BYTE_TYPE(_nTypeId)		(LTT_ID_CHAR == (_nTypeId) || LTT_ID_BYTE == (_nTypeId))
#define		IS_BASIC_ONE_BYTE_TYPE(_nTypeId)		(LTT_ID_bool == (_nTypeId) || LTT_ID_CHAR == (_nTypeId) || LTT_ID_BYTE == (_nTypeId))
/// end IMPLEMENTING_bool_FOR_COM
#define		IS_BASIC_TWO_BYTE_TYPE(_nTypeId)		(LTT_ID_SHORT == (_nTypeId) || LTT_ID_WORD == (_nTypeId))
#define		IS_BASIC_FOUR_BYTE_TYPE(_nTypeId)		(LTT_ID_INT == (_nTypeId) || LTT_ID_UINT == (_nTypeId))
/// end MUST_CHECK_TARGET_TYPE_WHEN_CASTING_POINTER_TO_POINTER


#endif //_OCLASS_IDS_H
