/*------------------------------------------------------------------------------*
 *	File Name: 	mocamemobj.h													*
 *	Purpose:	Memory Object classes											*
 *  Creation:	ML, 1/23/96(Version for New MOCA TD; 3/24/2000)					* 
 *  	Copyright Microcal Software Inc. 1996									* 
 *																				*
 *	Modification log															*
 *------------------------------------------------------------------------------*/
 
 
#ifndef		_MOCAMEMOBJ_H
#define		_MOCAMEMOBJ_H



#include	"okcons.h"                                                                 
#include	"mocadll.h"



#define		MOMEMOBJSIZE		MOUINT16
#define		MOMEMOBJ_NAMESIZE	WORD_SIZE


class MoMemObj : public MOCAOrigin
{
public:


	// Origin limits the size to unsigned short (64kB)
	MoMemObj(LPCSTR wksname, LPCSTR lpszMemoryObjectName, MOMEMOBJSIZE sizeinbytes);
	MoMemObj(LPCSTR wksname, LPCSTR lpszMemoryObjectName);

	~MoMemObj();

	int		Init(LPCSTR wksname, LPCSTR lpszMemoryObjectName, MOMEMOBJSIZE sizeinbytes);
	void	UnInit();
	void	StoreWksAndMemObjNames(LPCSTR wksname, LPCSTR lpszMemoryObjectName);
	BOOL	IsValid();
	BOOL	IsWksOpen();
	LPCSTR	Resize(MOMEMOBJSIZE sizeinbytes);
	LPCSTR	OpenMemObject(MOMEMOBJSIZE sizeinbytes = 0);
	void	CloseMemObject();
	LPCSTR	GetMemory();

private:

	MOMEMOBJSIZE	m_Size;
	LPSTR			m_lpMemory;
	char			m_szMemObjName[MOMEMOBJ_NAMESIZE]; 
	char			m_szWksName[WORD_SIZE];
};
typedef		MoMemObj	*MoMemObjPtr;


class	MoLayer;

class	MoMemoryObject	:	public	MOCAOrigin         
{
public:
	// Origin limits the size to unsigned short (64kB)
	MoMemoryObject(MoLayer &theLayer, 
					LPSTR lpszMemoryObjectName, 
					MOMEMOBJSIZE sizeinbytes);
	
	// Opens an existing one:
	MoMemoryObject(MoLayer &theLayer, LPSTR lpszMemoryObjectName);
	
	~MoMemoryObject();
	
	LPCSTR			GetMemory();
	LPCSTR			Resize(MOMEMOBJSIZE sizeinbytes);

protected:
	LPCSTR			Create(MoLayer &theLayer, 
								LPSTR lpszMemoryObjectName, 
								MOMEMOBJSIZE sizeinbytes, 
								BOOL bOpen = FALSE);
	LPCSTR			Open(MODATAID dwId,		// Layer Id
								LPSTR lpszMemoryObjectName, 
								MOMEMOBJSIZE sizeinbytes = 0);
	LPCSTR			Open(MoLayer &theLayer, 
								LPSTR lpszMemoryObjectName, 
								MOMEMOBJSIZE sizeinbytes = 0);
	void			Close();

private:
	LPSTR			m_lpMemory;	// pointer to memory if open
	MODATAID		m_Id;		// Id of Layer where the mem. obj. is located
	char			m_strName[MAXLINE];
};
typedef	MoMemoryObject	*MoMemoryObjectPtr;	
/// end FRAME_AND_MEMORY_OBJECT_ACCESS




////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////// End of File ////////////////////////////////////
#endif		// _MOCAMEMOBJ_H


 
 
 
 
 
 