/*------------------------------------------------------------------------------*
 *	File Name: 	MOCATXTDATASET.h												*
 *	Purpose:	Microcal Origin text dataset classes							*
 *  Creation:	ML, 12/11//95(Version for The New MOCA TD:3/30/2000)			* 
 *  	Copyright Microcal Software Inc. 1995									* 
 *																				*
 *	Modification log															*
 *------------------------------------------------------------------------------*/      

#ifndef		_MOCATXTDATASET_H
#define		_MOCATXTDATASET_H


#include	"mocadataset.h"
#include	"mocawks.h"


class	MoTextData : public MoData
{
public:

	MoTextData(MoOriginWksPtr pwks, UINT iCol);
	MoTextData(MoOriginWks &wks, UINT iCol);
	MoTextData(MoOriginWks &wks, LPSTR lpszColumnName);
	MoTextData(int type, LPSTR lpszName);

public:

	MoTextData(LPCSTR lpszDatasetName); 
	MoTextData(LPCSTR wksname, LPSTR lpColumnName); 
	MoTextData(LPCSTR name,MOINT &nCol); 

	int				SetValue(long index, LPCSTR CellValue);
	int				SetValue(long index,double value);
	MoTextData	&	MoTextData::operator=(const MoTextData & TextData);
	CString			MoTextData::operator[](long index) const;
	
private:

	void			CheckForTextual();
};
typedef		MoTextData  *MoTextDataPtr;






class MoWksCol : public MoTextData
{
	
public:
	MoWksCol(MoOriginWksPtr pwks, UINT iCol);
	MoWksCol(MoOriginWks &wks, UINT iCol);
	MoWksCol(MoOriginWks &wks, LPSTR lpszColumnName);
	MoWksCol(int type, LPSTR lpszName) ;
	MoWksCol(LPCSTR wksname, LPSTR lpColumnName);

	int		GetAsText(long index, LPSTR lpszBuffer);
	
private:

	MoOriginWksPtr	m_pwks;
};



#endif		// _MOCATXTDATASET_H