/*------------------------------------------------------------------------------*
 *	File Name: 	MoWks.h															*
 *	Purpose:	worksheet class													*
 *  Creation:	by Dr. C. P. Yang, 5/15/95(Version for New MOCA TD: 3/24/2000)	* 
 *  	Copyright Microcal Software Inc. 1995									*
 *	Modification log															*
 *	CPY v6.1033 8/22/00 TEXT_LABEL_STYLE_ADD_JUSTIFICATION						*
 * EJP 11-06-2000 v6.1057 CHANGE_READONLY_ARG_FROM_LPSTR_TO_LPCSTR				*
 *	YuI 4/16/02 QA70-1478 v7.0281 MULTIFRAME_TIFF_IMPORT						*
 *------------------------------------------------------------------------------*/

#ifndef _MOCAWKS_H
#define	_MOCAWKS_H

#include	"mocadataset.h"
#include	"mocamemobj.h"




class	MoFrame	:	public	MOCAOrigin
{
public:
	MoFrame(LPCMOSTR lpWinName, int nWinType = 0, int nLayer = -1); /// -1 for current layer
	~MoFrame() {};

protected:
	MoFrame();

	/// CPY 8/9/2000 v6.1022 t8321 LABEL_TEXT_STYLES_IN_MOFRAME_CLASS
//protected: 
public:
    BOOL GetLabelTextString(CString& strText, LPCSTR lpcszObjName);
    BOOL SetLabelTextString(LPCSTR lpcszText, LPCSTR lpcszObjName);
	//---------- CPY v6.1033 8/22/00 TEXT_LABEL_STYLE_ADD_JUSTIFICATION
	//BOOL GetLabelTextStyle(LPCTSTR lpname, DWORD &dwColor, LOGFONT* lpLogfont = NULL);
	// nJustification = TA_LEFT, TA_CENTER and TA_RIGHT
	BOOL GetLabelTextStyle(LPCTSTR lpname, DWORD &dwColor, LOGFONT* lpLogfont = NULL, LPINT lpnJustification=NULL);
	//---------- end CPY v6.1033 8/22/00 TEXT_LABEL_STYLE_ADD_JUSTIFICATION

protected:
	MODATAID			m_Id;
};


class	MoLayer	:	public	MoFrame

{
public:
	MoLayer(LPCSTR name, WORD wType, int nLayer = -1, LPCSTR*	pMemObjName = NULL);
	MoLayer(BOOL bHidden,
			LPCSTR name, 
			LPCMOSTR lpcszTemplateName = NULL, 
			LPCSTR*	pMemObjName = NULL);
	MoLayer(LPCSTR*	pMemObjName = NULL);

	/// TD 5-15-02 QA70-1662 ADD_METHOD_COPY_FROM_WKS
	MoLayer(MODATAID nID);
	/// end ADD_METHOD_COPY_FROM_WKS

	~MoLayer();
	
	virtual	BOOL	IsValid() const;
	MODATAID		GetId() const ;
	void			SetMemoryObjectName(LPCSTR strMemObjName);
	LPCSTR			OpenMemObj();
	void			CloseMemObj();
	LPCSTR			GetMemoryObj();	
	LPCSTR			ResizeMemObj(MOMEMOBJSIZE size);
	virtual	BOOL	IsMemObjValid();
	LPCSTR			CreateNewMemObj(MOMEMOBJSIZE size);
	virtual	DWORD	GetType();
	virtual	BOOL	IsType(DWORD dwType);

	virtual	MOMEMOBJSIZE	GetDefaultMemObjSize();
	
	LPCSTR			InitMemObj();
	virtual	int		SetDefaultMemObj(); // return error by default
	virtual	DWORD	ShouldBeOfType();
	BOOL			IsTypeOK();
	int				CheckMemObj();
	virtual	void	SetType(DWORD dwType);
	void			SetThisType(); 
	void			Attach(MODATAID Id);

protected:

	void		InitExisting(LPCSTR name, WORD wType, int nLayer);

protected:
	LPSTR				m_MemObjName;	// stores the memory object name
	MoMemoryObjectPtr	m_pMemObj;
};
typedef	MoLayer	*MoLayerPtr;






class MoOriginWks: public MoLayer
{

public:
	MoOriginWks(LPCSTR name, LPCSTR*	pMemObjName = NULL);
	~MoOriginWks();
	MoOriginWks(LPCSTR name, 
				BOOL bHidden, 
				LPCMOSTR lpcszTemplateName = NULL, 
				BOOL bEmpty = TRUE,
				LPCSTR*	pMemObjName = NULL);


	MoOriginWks(MODATAID nID); /// TD 5-15-02 QA70-1662 ADD_METHOD_COPY_FROM_WKS
	
	MoOriginWks();
	/// YuI 4/16/02 QA70-1478 v7.0281 MULTIFRAME_TIFF_IMPORT
	MoOriginWks(BOOL bMatrix, LPCSTR name, LPCSTR* pMemObjName);
	/// end MULTIFRAME_TIFF_IMPORT

	int	GetNumCols();/// return 0 if invalid
	int 	GetColName(UINT nCol,LPSTR lpBuffer);
	int		SetColName(UINT nCol, LPSTR lpszNewName);
	int		GetColLabel(UINT nCol, LPSTR lpszBuffer);
	virtual	BOOL	IsValid() const;
	LPCSTR	GetWksName();
	int		ClearOfData(BOOL bWarning = FALSE);
	int		SetWksRowSize(UINT rownum);
	int		RemoveColumn(UINT colnum);
	int		RemoveColumn(LPCMOSTR lpcszColName);
	int		InsertColumn(LPSTR lpszColName, UINT pos = 0, LPCMOSTR lpcszLabel = NULL);
	int		InsertTextColumn(LPSTR lpszColName, UINT pos = 0, LPCMOSTR lpcszLabel = NULL);
	int		InsertMixedColumn(LPSTR lpszColName, UINT pos = 0, LPCMOSTR lpcszLabel = NULL);
	int		SetColumnLabel(UINT colnum, LPCMOSTR lpcszLabel); 
	int		SetColumnLabel(LPCMOSTR lpcszColName, LPCMOSTR lpcszLabel); 
	int		SetColumTitle(UINT colnum, LPCMOSTR lpcszName);

	void	Destroy();
	int		GetDatasetName(LPSTR lpszBuf, UINT colnum);

	int		SetColumnAsY(UINT col);
	int		SetColumnAsY(LPCMOSTR lpcszColName);
	int		SetColumnAsX(UINT col);
	int		SetColumnAsX(LPCMOSTR lpcszColName);                       
	int		SetColumnAsNone(UINT col);
	int		SetColumnAsNone(LPCMOSTR lpcszColName);
	int		SetColumnWidth(LPCMOSTR lpcszColName, UINT width);
	int		SetColumnWidth(UINT col, UINT width);
	int		GetColumnWidth(LPCMOSTR lpcszColName);
	int		GetColumnWidth(UINT col);
	int		SetColNumDecPlaces(LPCMOSTR lpcszColName, UINT numdecplaces);
	int		SetColNumDecPlaces(UINT col, UINT numdecplaces);
	int		CreateDataAndPlot(LPCMOSTR lpcszXColName,
								LPCMOSTR lpcszYColName,
								int nPlotType,
								LPCMOSTR lpcszGraphTemplateName = NULL);
	int		CreateDataAndPlot(UINT uXColNum,
								UINT uYColNum,
								int nPlotType,	// 
								LPCMOSTR lpcszGraphTemplateName = NULL);

	int		ShowColumnLabels(BOOL bShow = TRUE);
	int		ShowColumnNames(BOOL bShow = TRUE);
	int		SetColumnHeadingHeight(UINT size);
	int		GetColLabel(LPCMOSTR lpcszColName, LPSTR lpszBuffer);
	int		GetColLabelMaxWidth(LPCMOSTR lpcszColName);                       
	int		GetColLabelMaxWidth(UINT colnum);
	int		GetColNameWidth(UINT colnum);
	int		GetLargestContentsWidth(UINT colnum);
	int		SetNiceColumnWidth(UINT col);
	int		SetColumnsToNiceWidths();
	
	MORETURN	SetValue(UINT column, long row, MOREAL value);
	MORETURN	SetValue(UINT column, long row, LPCSTR value);
	
	MORETURN	GetAsText(UINT column, long row, LPSTR lpszBuffer);
	
	/// EJP 11-06-2000 v6.1057 CHANGE_READONLY_ARG_FROM_LPSTR_TO_LPCSTR
	///int SetWksLabel(LPSTR Label);
	int SetWksLabel(LPCSTR Label);
	/// CHANGE_READONLY_ARG_FROM_LPSTR_TO_LPCSTR
	                                              
	int			SetColumnAsNumeric(UINT col); 
	int			SetColumnAsNumeric(LPCMOSTR lpcszColName);
	int			SetColumnAsTextual(UINT col) ;
	int			SetColumnAsTextual(LPCMOSTR lpcszColName);
	int			SetColumnAsMixed(UINT col);
	int			SetColumnAsMixed(LPCMOSTR lpcszColName);
	int			GetColumnType(UINT col);
	int			GetColumnType(LPCMOSTR lpcszColName);
	int			GetColumnAs(LPCMOSTR lpcszColName);
	int			GetColumnAs(UINT col);
	enum{
		AS_Y = 0,
		AS_NONE,
		AS_ERROR,
		AS_X,
		AS_L,
		AS_Z,
		AS_X_ERROR
	};
			
private:
	int			ShowLabelNameBoth(WORD	which); 
	BOOL		m_bWksDiplayAttrInitialized;//Initialized to false
public:
	int			ShowWksLabelOnly();
	int			ShowWksNameOnly();
	int			ShowWksBoth();


public:
	int		InsertColumnOfType(LPSTR lpszColName, int type, UINT pos, LPCMOSTR lpcszLabel);
	int		SetColumnOfType(UINT col, int type);
	int		SetColumnOfType(LPCMOSTR lpcszColName, int type);

	int		SetColumnAs(LPCMOSTR lpcszColName, int code);
	int		SetColumnAs(UINT col, int code);
	 
public:

	BOOL	GetWksDisplayAttributes(WCBWKSDisp&	WksDiplayAttributes);
	BOOL	SetWksDisplayAttributes(const WCBWKSDisp&	WksDiplayAttributes);


	
protected:

	char	m_wks_name[MAXLINE];
	WCBWKSDisp	m_WksDiplayAttributes; //Stores display attributes, type defined in ORGDLL.h
};





////////////////////////////////////////////////////////////////////////////////
///////////////////////////// End of File //////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
#endif //_MOCAWKS_H


