/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// you can include just this typical header file for most Origin built-in functions and classes
// and it takes a reasonable amount of time to compile, 
#include <origin.h>
#include <Tree.h>
#include "Filter_Utils.h"
// this file include most of the other header files except the NAG header, which takes longer to compile
// NAG routines
//#include <OC_nag.h> // this contains all the NAG headers, 

////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////////
// start your functions here

int ImportImage(Page &pgTarget, TreeNode &trFilter, LPCSTR lpcszFile, int nFile)
{
	if( EXIST_MATRIX != pgTarget.GetType() )
		return 1; // target page is required
	if( !trFilter || trFilter.Type.nVal != FILTER_TYPE_USERDEFINED )
		return 1; // user defined filter is required
	if( !lpcszFile )
		return 1; // source file name is required
	
	using Image = LabTalk.Image;
	
	Image.FileName$ = lpcszFile;
	
	string strPageName = pgTarget.GetName();
	if( Image.Import.Matrix(strPageName) )
		return 1; // import error
	pgTarget.LT_execute("matrix -ii"); // show matrix as image
	
	return 0;
}
