/*------------------------------------------------------------------------------*
 * File Name:InfoVarsDlg.c	 													*
 * Creation: CPY																*
 * Purpose: OriginC Source C file for Info Variables dialog						*
 * Copyright (c) Originlab Corp.	2003										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
#include <Origin.h>
//#include <Project.h>
#include <Dialog.h>
#include <vsFlexGrid.h>
#include <TreeEditor.h>
#include "ODlg.h" // resource IDs, ODlg.dll also use this file for its res ids
//#include <utilities.h>
//#include <sys_utils.h> // basic routines implemeted through Origin C, see sys_utils.c
#include <GetNBox.h>
#include <storage.h>

static Dialog 	MyDlg("InfoVars", "ODlg");
//temp

	
// open Insert Info Variables dialog and return str to insert
// *lpType = 0 if insert as is, =1 if insert as link
bool InfoVarsDlg()
{
	Page pg = Project.Pages();
	if(pg)
	{
		Window wndPage = pg.GetWindow();
		int nRet = MyDlg.DoModal(wndPage.GetSafeHwnd());
		return (IDCANCEL == nRet)? false:true;
	}
	return false;
}

///----------------------------------------------
///----------------- Message Map ----------------
///
BEGIN_EVENT_MAP
	ON_INIT(OnInitDialog) 
	ON_OK(OnOK)
	ON_BN_CLICKED(IDC_INFOVARS_ADD_SECTION, OnAddSection)
END_EVENT_MAP
///----------------------------------------------

///////////////////////////////////////////////////////
/// General utilities
///////////////////////////////////////////////////////
bool get_tree(TreeNode& trNode)
{
	string strTemp;
	
	if(!GetTempFileName(strTemp))
		return false;
	
	TreeEditor trEditor 	= MyDlg.GetItem(IDC_INFOVARS_TREE);

	trEditor.Save(strTemp);
	
	Tree trTemp(strTemp);
	trNode.Replace(trTemp);
	DeleteFile(strTemp);
	return true;
}

	
	
///////////////////////////////////////////////////////
/// Event Handlers
///////////////////////////////////////////////////////
static BOOL OnInitDialog()
{
	Page pg = Project.Pages();
	if(pg)
	{
		TreeEditor trEditor 	= MyDlg.GetItem(IDC_INFOVARS_TREE);
		Tree trPagelist;
		string strLabel = pg.Label;
		if(strLabel.IsEmpty())
			strLabel = pg.GetName();
		else
			strLabel = pg.GetName() + " - " + strLabel;
		
		if(tree_add_info(trPagelist, pg, pg.GetName(), strLabel))
			trEditor.Root = trPagelist.FirstNode;	

		//--- setup the grid
		Object flx = trEditor.GetActiveXControl();
		//flx.Editable = flexEDNone;
		flx.HighLight = flexHighlightNever;
		flx.FocusRect = flexFocusLight;
		//---
	}
	return TRUE;	
}

static BOOL OnOK()
{
	return TRUE;
}

static BOOL OnAddSection(Control cntrl)
{
	string strSection;
	try
	{
		strSection = InputBox("Please enter section name");
	}
	catch(int nErr)
	{
		out_str("user cancel");
		return TRUE;
	}
	//
	Tree trJunk;
	TreeNode tr1 = trJunk.AddNode("aa");
	get_tree(tr1);
	TreeEditor trEditor = MyDlg.GetItem(IDC_INFOVARS_TREE);
	trEditor.Root = tr1;
	
	return TRUE;
}

void junk()
{
	Page pg = Project.Pages();
	
	pg.Info.Add("User");
	pg.Info.User.AddSection("Variables");
	for(int ii = 0; ii < 10; ii++)
	{
		string strName = "Name" + ii;
		string strVal = "Val" + ii;
		
		pg.Info.User.Variables.AddString(strName, strVal);
	}
	
}
