/*------------------------------------------------------------------------------*
 * File Name: Local.h															*
 * Creation: GJL 9/14/2001														*
 * Purpose: OriginC Header containing localized constants							*
 * Copyright (c) OriginLab Corp.	2001										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:                                                            *
 *      GRD 2001.12.21 Added defines which were in FITCMP.H                     *
 *      GRD 2002.10.23 Added KaleidaGraph Error messages                        *
 *------------------------------------------------------------------------------*/

#ifndef _LOCAL_H
#define _LOCAL_H

//////////////////////////////////////////////////////////////////////////////////
// OStat common constants needing localization
//////////////////////////////////////////////////////////////////////////////////
#define OSTAT_POWER_ACTUAL				"(actual)"
#define OSTAT_FILE_NOT_FOUND_ERROR_MSG	"File not found: %s"

//////////////////////////////////////////////////////////////////////////////////
// OStat tTest constants needing localization
//////////////////////////////////////////////////////////////////////////////////
#define TT1_SUMMARY_MAIN_HDR					"One Sample t-Test"
#define TT1_DECISION_PHRASE1					"At the %s level, the population mean"
#define TT1_DECISION_PHRASE2_IS_DIFFERENT		"is significantly different than the test mean (%s)."
#define TT1_DECISION_PHRASE2_IS_LESS			"is significantly less than the test mean (%s)."
#define TT1_DECISION_PHRASE2_IS_GREATER			"is significantly greater than the test mean (%s)."
#define TT1_DECISION_PHRASE2_IS_NOT_DIFFERENT	"is not significantly different than the test mean (%s)."
#define TT1_DECISION_PHRASE2_IS_NOT_LESS		"is not significantly less than the test mean (%s)."
#define TT1_DECISION_PHRASE2_IS_NOT_GREATER		"is not significantly greater than the test mean (%s)."

#define TT2_DECISION_PHRASE1					"At the %s level, the difference of the population means"
#define TT2_DECISION_PHRASE2_IS_DIFFERENT		"is significantly different than the test difference (%s)."
#define TT2_DECISION_PHRASE2_IS_LESS			"is significantly less than the test difference (%s)."
#define TT2_DECISION_PHRASE2_IS_GREATER			"is significantly greater than the test difference (%s)."
#define TT2_DECISION_PHRASE2_IS_NOT_DIFFERENT	"is not significantly different than the test difference (%s)."
#define TT2_DECISION_PHRASE2_IS_NOT_LESS		"is not significantly less than the test difference (%s)."
#define TT2_DECISION_PHRASE2_IS_NOT_GREATER		"is not significantly greater than the test difference (%s)."
#define TT2_SAMPLE1								"1. "
#define TT2_SAMPLE2								"2. "
#define TT2_PAIRED_SUMMARY_MAIN_HDR				"Two Sample Paired t-Test"
#define TT2_INDEPENDENT_SUMMARY_MAIN_HDR		"Two Sample Independent t-Test"
#define TT2_PAIRED_SD_IS_0_MSG					"The test statistics t and P can not be computed because the sample variance of the differences between Sample1 and Sample2 is 0."
#define TT2_INDIVIDUAL							"Individual"
#define TT2_CON_INTERVAL_MAIN_HDR				"Confidence Interval for Difference of Means"
#define TT2_DIF_OF_MEANS						"Difference of Means:"

//////////////////////////////////////////////////////////////////////////////////
// OStat ANOVA (common) constants needing localization
//////////////////////////////////////////////////////////////////////////////////
#define AN_BONFERRONI_TEST			"Bonferroni"
#define AN_SCHEFFE_TEST				"Scheffe'"
#define AN_TUKEY_TEST				"Tukey"
#define AN_SIGNIFICANT_YES			"Yes"
#define AN_SIGNIFICANT_NO			"No"
#define AN_MEANS_COMP_AT_LEVEL		"at %s"

//////////////////////////////////////////////////////////////////////////////////
// OStat ANOVA1Way constants needing localization
//////////////////////////////////////////////////////////////////////////////////
#define AN1_SUMMARY_MAIN_HDR					"One-Way ANOVA"
#define AN1_DATASET								"Dataset"
#define AN1_LEVENE_HDR							"Levene's Test for Equal Variance"
#define AN1_BROWN_FORSYTHE_HDR					"Brown-Forsythe's Test for Equal Variance"
#define AN1_DECISION_PHRASE1					"At the %s level,"
#define AN1_DECISION_PHRASE2_MEANS_ARE_NOT_DIFF	"the population means are not significantly different."
#define AN1_DECISION_PHRASE2_MEANS_ARE_DIFF		"the population means are significantly different."
#define AN1_DECISION_PHRASE2_VARS_ARE_NOT_DIFF	"the population variations are not significantly different."
#define AN1_DECISION_PHRASE2_VARS_ARE_DIFF		"the population variations are significantly different."
#define AN1_MEANS_COMP_HDR1						"Means Comparison using %s Test"

//////////////////////////////////////////////////////////////////////////////////
// OStat ANOVA2Way constants needing localization
//////////////////////////////////////////////////////////////////////////////////
#define AN2_VAR_TYPE					"Variable Type"
#define AN2_DEPENDENT_VAR				"Dependent Variable"
#define AN2_FACTOR_A_VAR				"Factor A Classification Variable"
#define AN2_FACTOR_B_VAR				"Factor B Classification Variable"
#define AN2_TABLE_SOURCE_A				"A"
#define AN2_TABLE_SOURCE_B				"B"
#define AN2_TABLE_SOURCE_AxB			"A * B"
#define AN2_MEANS_COMP_HDR1				"Factor %c: Means Comparison using %s Test"
#define AN2_TOO_FEW_LEVELSA				"Factor A must have two or more levels." 
#define AN2_TOO_FEW_LEVELSB				"Factor B must have two or more levels."
#define AN2_DEPVAR_HAS_NONNUMERICS		"The Dependent Variable, %s, must not be a column of type Text and must not contain any text or missing values."
#define AN2_SELDATA_HAS_NONNUMERICS		"The Selected Dataset, %s, must not be a column of type Text and must not contain any text or missing values."
#define AN2_COMPUTATIONAL_ERROR_MSG		"OStat Error (%d): Two-Way ANOVA computational error generally caused by too few data points or 0 DoF."
#define AN2_TOO_FEW_DATA_PTS_IN_CELL	"There are too few data points in the Factor A '%s' and Factor B '%s' level combination (n >= %d)." 

//////////////////////////////////////////////////////////////////////////////
// OStat Normality Test (Shapiro-Wilk) constants needing localization
//////////////////////////////////////////////////////////////////////////////
#define NT_NOT_NORMAL_AT			"Not Normal at "
#define NT_NORMAL_AT				"Normal at "
#define NT_AT_LEVEL					" level"
#define NT_SHAPIRO_WILK_ERROR		"* Shapiro-Wilk computational error"
#define NT_TOO_FEW_DATAPTS			"* Too few data points, N must be > 2"
#define NT_TOO_MANY_DATAPTS			"* Too many data points, N must be < 2001"
#define NT_SORT_ERROR				"* Failed to sort dataset"
#define NT_GET_DATA_NAME_ERROR		"* Text column type not supported"

//////////////////////////////////////////////////////////////////////////////////
// Survival Analysis common constants needing localization
//////////////////////////////////////////////////////////////////////////////////
#define SA_FILE_NOT_FOUND_ERROR_MSG	"File not found: %s"

//////////////////////////////////////////////////////////////////////////////////
// Survival Analysis Kaplan-Meier constants needing localization
//////////////////////////////////////////////////////////////////////////////////
#define KM_MAIN_HDR					"Kaplan-Meier Estimator"
#define KM_QUARTILE_HDR2			" Confidence Interval"

//////////////////////////////////////////////////////////////////////////////////
// Survival Analysis Cox Proportional Hazards Model constants needing localization
//////////////////////////////////////////////////////////////////////////////////
#define COX_MAIN_HDR				"Cox Proportional Hazards Model"

//////////////////////////////////////////////////////////////////////////////
// Smith chart prompt constants needing localization
//////////////////////////////////////////////////////////////////////////////
#define SM_RVAL_LARGER_THAN			"R value should be larger than "
#define SM_FACTOR_NOT_EMPTY			"The factor can not be empty."
#define SM_NO_CURVE					"Should have a whorksheet to put data "
#define SM_FACTOR_EVAL_AS_ZERO		"The factor was evaluated as zero."

//////////////////////////////////////////////////////////////////////////////////
// Fit Comparison (FitCmp) constants needing localization
//////////////////////////////////////////////////////////////////////////////////
#define FC_HEADER1			"Fit Comparison of %s and %s using the %s function :"
#define FC_HEADER4			"Fit results for %s"
#define FC_HEADER5			"Parameter Value Error LCL UCL"
#define FC_HEADER5B			"F-Value = "
#define FC_HEADER6			"F-Test results from comparison of fits"
#define FC_FOOTER1			"At the %4.2f significance level the two datasets are NOT statistically different."
#define FC_FOOTER2			"At the %4.2f significance level the two datasets ARE statistically different."
#define FC_LINEARHEADER1	"t-Test results comparing the intercepts and the slopes of the linear fits:"
#define FC_LINEARHEADER2	"Confidence intervals for difference of intercepts = %f to %f."
#define FC_LINEARHEADER3	"Confidence intervals for difference of slopes = %f to %f."
#define FC_LINEARFOOTER1A	"At the %4.2f significance level the two intercepts are NOT statistically different."
#define FC_LINEARFOOTER1B	"At the %4.2f significance level the two intercepts ARE statistically different."
#define FC_LINEARFOOTER2A	"At the %4.2f significance level the two slopes are NOT statistically different."
#define FC_LINEARFOOTER2B	"At the %4.2f significance level the two slopes ARE statistically different."

//////////////////////////////////////////////////////////////////////////////
// ROI Processing constants needing localization
//////////////////////////////////////////////////////////////////////////////
#define ROI_CREATE_CROP_ON_NON_CONVERTED_MATRIX		"This operation requires %s to be converted to Gray + Data.\nWould you like to convert %s to Gray + Data now ?";
#define ROI_COPY_NON_RECT							"Copy is not supported on non-rectangular ROI"

//////////////////////////////////////////////////////////////////////////////
// KaleidaGraph import routine messages needing localization
//////////////////////////////////////////////////////////////////////////////
#define ORDKG_FILE_TOO_SMALL	"File too small. Terminating.\n"
#define ORDKG_INCONSISTENT	"Format inconsistencies. Terminating.\n"
#define	ORDKG_UNSUPPORTED_TYPE	"Unsupported Data Type. Terminating.\n"
#define	ORDKG_OPEN_FAILED	"Failed to open file %s.\n"

//////////////////////////////////////////////////////////////////////////////////
// StatisticsOn (SO) constants needing localization
//////////////////////////////////////////////////////////////////////////////////
#define SO_GENERAL_DATA_SEL_ERROR_MSG		"Invalid Data Range selection. Select a range of worksheet/workbook data and optionally select Grouping and Weighting\nfrom the same worksheet/workbook." 
#define SO_WKS_DATA_COL_SEL_ERROR_MSG		"Invalid Data Range selection. Select a range of worksheet/workbook data and click the Update Data Range button."
#define SO_WKS_DATA_ROW_SEL_ERROR_MSG		"Invalid Data Range selection. Select a contiguous range of worksheet/workbook data and click the Update Data Range button."
#define SO_WKS_GROUP_SEL_ERROR_MSG			"Invalid Grouping selection. Select a range of worksheet/workbook data and click the Update Grouping button."
#define SO_WKS_WEIGHT_SEL_ERROR_MSG			"Invalid Weighting selection. Select a one column range of worksheet/workbook data and click the Update Weighting button."

//////////////////////////////////////////////////////////////////////////////////
// General Statistics constants needing localization
//////////////////////////////////////////////////////////////////////////////////
#define GS_DEFAULT_PERCENTS             "90 95 99"
#define GS_DEFAULT_SIG_LEVEL			0.95

//////////////////////////////////////////////////////////////////////////////////
// Import Wizard constants needing localization
//////////////////////////////////////////////////////////////////////////////////
#define IW_FILTER_NONE					"<none>"
#define IW_FILE_NAME					"File Name"
#define IW_PLOT_DESIG					"Plot Designation"
#define IW_TEMPLATE						"Template"
#define IW_LAYER_NUM					"Layer#"
#define IW_FILE_SIZE					"Size"
#define IW_MODIFY_DATE					"Modify Date"
#define AIW_DEFAULT_FILTER				"<Default>"
#define BIW_DEFAULT_FILTER				"<Default>"

#define IW_COLHDR_LINE					"Line"
#define IW_COLHDR_COLUMN				"Position/Token"
#define IW_COLHDR_NAME					"Name"
#define IW_COLHDR_TYPE					"Type"
#define IW_COLHDR_LEN_DELIM				"Length/Delimeter"
#define IW_COLHDR_VALUE					"Value"

//////////////////////////////////////////////////////////////////////////////////
// Origin C constants needing localization
//////////////////////////////////////////////////////////////////////////////////
#define OC_ORIGIN_LANGUAGE			'E'

//////////////////////////////////////////////////////////////////////////////
// WAV import routine messages needing localization
//////////////////////////////////////////////////////////////////////////////
#define OCWAV_NOTWAV	"Not a WAV file.\n"
#define OCWAV_NOTGOOD	"File size and description inconsistent.\n"
#define OCWAV_PCMONLY	"Only PCM formatting supported.\n"
#define OCWAV_ONEFMT	"Duplicate fmt chunk not allowed.\n"
#define OCWAV_BITSIZE	"Unsupported bit size.\n"
#define OCWAV_FMTORDER	"fmt chunk must precede data chunk.\n"
#define	OCWAV_OPENFAIL	"Failed to open file %s.\n"

#define FILTER_LOCATION_PREFIX "Data Folder|Origin Folder|User Files Folder"

#define SHOW_EXPORT_OPTIONS "Show Export Options"



#endif // !_LOCAL_H


