/*------------------------------------------------------------------------------*
 * File Name: OMatDlgDMC.c														*
 * Creation: GJL 2/19/03														*
 * Purpose: Dialog Builder support file for the DirectMatConvert dialog.		*
 * Copyright (c) Originlab Corp.		2003, 2004, 2005, 2006, 2007			*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/

// Include system header files
#include <Origin.h>     // Includes most Origin header files
#include <Dialog.h>     // Dialog class

// Include application header files
#include "App_Utils.h"  // Application utilities like CreateWindow function
#include "Wks_Utils.h"      // Wks_Utils function prototypes and non-localized constants 
#include "OMat.h"       // OMat.c prototypes and definitions
#include "OMatDlgDMC.h" // OMatDlgDMC.c prototypes and definitions
#include "ODlg.h"       // Resources in ODlg.DLL

// Declare Dialog object
static Dialog dlgDMC(IDD_DMC, "ODlg");

// Dialog Event Map for DirectMatConvert 
BEGIN_EVENT_MAP
	ON_INIT(OnInitDMC)
	ON_TOOLBAR_BN_CLICKED(IDB_DMC_UPDATE_BTN, OnClickUpdateRange)
	ON_BN_CLICKED(IDC_DMC_CONVERT_BTN, OnClickConvert)
END_EVENT_MAP

/**
		WKS.OGS calls this function to launch modeless DirectMatConvert dialog.
	Return:
		Returns TRUE on success and FALSE on failure.
*/
BOOL OnOpenDMC()
{
	return dlgDMC.Create();
}

/**
		Dialog Builder calls this function immediately after the DirectMatConvert
		dialog is launched for initialization.
	Return:
		Returns TRUE.
*/
static BOOL OnInitDMC()
{
	// *** Declare objects on Dialog ***
	Edit ebxSelectedRange = dlgDMC.GetItem(IDC_DMC_SEL_RANGE_EBX);
	Button rbXVaries = dlgDMC.GetItem(IDC_DMC_FOR_XVARY_RB);
	Button chkbxXRow = dlgDMC.GetItem(IDC_DMC_FOR_XROW_CHKBX);
	Button chkbxYCol = dlgDMC.GetItem(IDC_DMC_FOR_YCOL_CHKBX);
	Button chkbxXCol = dlgDMC.GetItem(IDC_DMC_FOR_XCOL_CHKBX);
	Button chkbxYRow = dlgDMC.GetItem(IDC_DMC_FOR_YROW_CHKBX);

	// *** Initialize objects on Dialog ***
	ebxSelectedRange.Text = "";
	GetSelectedRange(TRUE);
	rbXVaries.Value = DMC_X_VARIES_ACROSS_ROWS;
	chkbxXRow.Check = 0;
	chkbxYCol.Check = 0;
	chkbxXCol.Check = 0;
	chkbxYRow.Check = 0;

	return TRUE;
}

/**
		Dialog Builder calls this function when the GetSelectedRange toolbar button
		is clicked.
	Return:
		Returns DMC_NO_ERROR on success and DMC_WKS_SEL_ERROR on failure.
*/
static int OnClickUpdateRange()
{
	return GetSelectedRange();
}

/**
		Get the current selection range for the DirectMatConvert dialog box. 
	Example:
		See the OnInitDMC function for sample call.
	Parameters:
		bSelectAll=Returns entire worksheet/workbook as selection range if nothing is selected, default is FALSE
	Return:
		Returns DMC_NO_ERROR on success and DMC_WKS_SEL_ERROR on failure.
*/
static int GetSelectedRange(BOOL bSelectAll) // bSelectAll=FALSE
{
	string strMsg, strSelectedRange;
	int iRet;

	iRet = wuGetContiguousWksSelection(strSelectedRange);              // Get current selection range
	
	if( iRet )                                                         // If no or bad selection...
	{
		if( bSelectAll && ( iRet == WKS_UTILS_NO_SEL_WARNING ) )       // If bSelectAll is TRUE and no selection...
			iRet = wuGetContiguousWksSelection(strSelectedRange, TRUE);// Get entire worksheet/workbook as selection range

		if( iRet )                                                     // Check again, if no or bad selection...
		{
			strMsg = _L(DMC_WKS_SEL_ERROR_MSG);                        // Output error message and return
			strMsg.Write(WRITE_MESSAGE_BOX);
			return DMC_WKS_SEL_ERROR;
		}
		else
			MessageBeep(MB_OK);                                        // Else just beep to warn
	}
                                                   
	Edit ebxSelectedRange = dlgDMC.GetItem(IDC_DMC_SEL_RANGE_EBX);
	ebxSelectedRange.Text = strSelectedRange;                          // Display selection range in dialog...
	
	return DMC_NO_ERROR;
}

/**
		Dialog Builder calls this function when the Convert push button is clicked.
	Parameters:
		ctrl=Push button control on DirectMatConvert dialog box 
	Return:
		Returns DMC_NO_ERROR on success and a DMC_ERROR code on failure.
*/
static int OnClickConvert(Control ctrl)
{
	// *** Declare objects on Dialog ***
	Edit ebxSelectedRange = dlgDMC.GetItem(IDC_DMC_SEL_RANGE_EBX);
	Button rbXVariesAcroosCols = dlgDMC.GetItem(IDC_DMC_FOR_XVARY_RB);
	Button chkbxXInRow1 = dlgDMC.GetItem(IDC_DMC_FOR_XROW_CHKBX);
	Button chkbxYInCol1 = dlgDMC.GetItem(IDC_DMC_FOR_YCOL_CHKBX);
	Button chkbxXInCol1 = dlgDMC.GetItem(IDC_DMC_FOR_XCOL_CHKBX);
	Button chkbxYInRow1 = dlgDMC.GetItem(IDC_DMC_FOR_YROW_CHKBX);

	// *** Get Settings from Dialog and store in tree ***
	Tree trDMC;
	trDMC = CreateDirectMatConvertTree();
	trDMC.SelRange.strVal = ebxSelectedRange.Text;
	trDMC.xVariesAcrossCols.nVal = rbXVariesAcroosCols.Value;
	trDMC.xInRow1.nVal = chkbxXInRow1.Check;
	trDMC.yInCol1.nVal = chkbxYInCol1.Check;
	trDMC.xInCol1.nVal = chkbxXInCol1.Check;
	trDMC.yInRow1.nVal = chkbxYInRow1.Check;
	
	return ConvertWksToMatrixDirect(trDMC);
}
