/*------------------------------------------------------------------------------*
 * File Name: OMatDlgMR.c														*
 * Creation: GJL 2/19/03														*
 * Purpose: Dialog Builder support file for the MatrixReplace dialog.			*
 * Copyright (c) Originlab Corp.		2003, 2004, 2005, 2006, 2007			*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/

// Include system header files
#include <Origin.h>     // Includes most Origin header files
#include <Dialog.h>     // Dialog class

// Include application header files
#include "App_Utils.h"  // Application utilities like CreateWindow function
#include "OMat.h"       // OMat.c prototypes and definitions
#include "OMatDlgMR.h"  // OMatDlgMR.c prototypes and definitions
#include "ODlg.h"       // Resources in ODlg.DLL

// Declare Dialog object
static Dialog dlgMR(IDD_MR, "ODlg");
static BOOL s_bBusy;

// Dialog Event Map for MatrixReplace dialog
BEGIN_EVENT_MAP
	ON_INIT(OnInitMR)
	ON_EN_CHANGE(IDC_MR_COND_VAL_EBX, DisallowNonNumericsOnEditChange)
	ON_EN_CHANGE(IDC_MR_REP_VAL_EBX, DisallowNonNumericsOnEditChange)
	ON_BN_CLICKED(IDC_MR_REPLACE_BTN, OnClickReplace)
	ON_BN_CLICKED(IDC_MR_UNDO_BTN, OnClickUndo)
	ON_CANCEL(OnClickCancel)
END_EVENT_MAP

/**
		MATRIX.OGS calls this function to launch modeless MatrixReplace dialog.
	Return:
		Returns TRUE on success and FALSE on failure.
*/
BOOL OnOpenMR()
{
	return dlgMR.DoModal();
}

/**
		Dialog Builder calls this function after the MatrixReplace dialog is
		launched.
	Return:
		Returns TRUE.
*/
static BOOL OnInitMR()
{
	// *** Declare objects on Dialog ***
	ComboBox cmbxConditionSign = dlgMR.GetItem(IDC_MR_COND_SIGN_CMBX);
	Edit ebxConditionValue = dlgMR.GetItem(IDC_MR_COND_VAL_EBX);
	Edit ebxReplaceValue = dlgMR.GetItem(IDC_MR_REP_VAL_EBX);
	Button chkbxReplaceSign = dlgMR.GetItem(IDC_MR_REP_SIGN_CHKBX);
	Button chkbxReplaceMissingValue = dlgMR.GetItem(IDC_MR_REP_MV_CHKBX);

	// *** Initialize objects on Dialog ***
	cmbxConditionSign.SetCurSel(1);
	ebxConditionValue.Text = "--";
	ebxReplaceValue.Text = "0";
	chkbxReplaceSign.Check = 0;
	chkbxReplaceMissingValue.Check = 0;

	// Edit boxes are not busy
	s_bBusy = FALSE;

	// *** Delete all Undo datasets if any exist before opening dialog box ***
	WorksheetPage wpUndo;
	wpUndo = (WorksheetPage) Project.WorksheetPages(MR_UNDO_WKS_NAME);
	if( wpUndo )
		wpUndo.Destroy();

	return TRUE;
}

/**
		Dialog Builder calls this function when an edit change is made in a
		MatrixReplace edit box. This function ensures that no non-numeric
		characters are entered.
	Parameters:
		ctrl=Edit box control on MatrixReplace dialog box 
	Return:
		Returns TRUE.
*/
static BOOL	DisallowNonNumericsOnEditChange(Control ctrl)
{
	if( s_bBusy )
   		return FALSE;
	s_bBusy = TRUE;
	
	Edit ebx(ctrl);
	string str, strText;
	int nChar;

	strText = ebx.Text;
	str = strText.SpanIncluding("0123456789eE+-" + GetDecimalChar());

	if( strText.Compare(str) )         // If strings are not same...then not all legal characters
	{
		nChar = str.GetLength();
		ebx.SetSel(nChar, nChar + 1);
		ebx.ReplaceSel("");            // Replace illegal character with ""
		MessageBeep( MB_OK );          // Beep
	}

	s_bBusy = FALSE;
	
	return TRUE;
}

/**
		Dialog Builder calls this function when the Replace push button is clicked.
	Parameters:
		ctrl=Replace push button control on MatrixReplace dialog box 
	Return:
		Returns MR_NO_ERROR on success and a MR_ERROR code on failure.
*/
static int OnClickReplace(Control ctrl)
{
	// *** Declare objects on Dialog ***
	ComboBox cmbxConditionSign = dlgMR.GetItem(IDC_MR_COND_SIGN_CMBX);
	Edit ebxConditionValue = dlgMR.GetItem(IDC_MR_COND_VAL_EBX);
	Edit ebxReplaceValue = dlgMR.GetItem(IDC_MR_REP_VAL_EBX);
	Button chkbxReplaceSign = dlgMR.GetItem(IDC_MR_REP_SIGN_CHKBX);
	Button chkbxReplaceMissingValue = dlgMR.GetItem(IDC_MR_REP_MV_CHKBX);

	// *** Get Settings from Dialog and store in tree ***
	Tree trMR;
	trMR = CreateMatrixReplaceTree();
	trMR.ConditionSign.nVal = cmbxConditionSign.GetCurSel();
	trMR.ConditionValue.dVal = atof(ebxConditionValue.Text);
	if( trMR.ConditionValue.dVal == 0 )
	{
		if( ebxConditionValue.Text.Compare("0") && ebxConditionValue.Text.Compare("0.0") )
		{
			if( ebxConditionValue.Text.Compare("--") )
			{
				MessageBox(NULL, _L(MR_COND_VAL_NOT_OK_MSG), _L(MR_TITLE), MB_OK | MB_ICONSTOP);
				return MR_INPUT_ERROR;
			}
			else
				trMR.ConditionValue.dVal = NANUM;
		}
	}
	trMR.ReplaceValue.dVal = atof(ebxReplaceValue.Text);
	if( trMR.ReplaceValue.dVal == 0 )
	{
		if( ebxReplaceValue.Text.Compare("0") && ebxReplaceValue.Text.Compare("0.0") )
		{
			if( ebxReplaceValue.Text.Compare("--") )
			{
				MessageBox(NULL, _L(MR_REPL_VAL_NOT_OK_MSG), _L(MR_TITLE), MB_OK | MB_ICONSTOP);
				return MR_INPUT_ERROR;
			}
			else
				trMR.ReplaceValue.dVal = NANUM;
		}
	}
	trMR.ReplaceSign.nVal = chkbxReplaceSign.Check;
	trMR.ReplaceMissingValue.nVal = chkbxReplaceMissingValue.Check;

	return MatrixReplace(trMR);
}

/**
		Dialog Builder calls this function when the Undo push button is clicked.
	Parameters:
		ctrl=Undo push button control on MatrixReplace dialog box 
	Return:
		Returns MR_NO_ERROR on success and a MR_ERROR code on failure.
*/
static int OnClickUndo(Control ctrl)
{
	return UndoMatrixReplace();
}

/**
		Dialog Builder calls this function when the MatrixReplace dialog box
		is closed.
	Return:
		Returns TRUE.
*/
static BOOL OnClickCancel()
{
	// *** Delete all Undo datasets if any exist before closing dialog box ***
	WorksheetPage wpUndo;
	wpUndo = (WorksheetPage) Project.WorksheetPages(MR_UNDO_WKS_NAME);
	if( wpUndo )
		wpUndo.Destroy();
	
	return TRUE
}