/*------------------------------------------------------------------------------*
 * File Name: OStat.h															*
 * Creation: GJL 7/24/2001														*
 * Purpose: Origin C Header for OStat											*
 * Copyright (c) OriginLab Corp.	2000-2002									*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/

#ifndef _OSTAT_H
#define _OSTAT_H

// Define OStat Structures
// Structure to hold a single row in the Two-Way ANOVA table
typedef struct {
	double	dDF;		// Degrees of Freedom
	double	dSS;		// Residual Sum of Squares
	double	dMS;		// Mean Squares
	double	dF;			// F Value
	double	dP;			// P Value
} ANOVA2_Row;
// End Define OStat Structures

// Declare functions in OStat.c
double osTTest_ProbT( double dt, int ddf );
int	osTTest_Table_Output_to_ResultsLog( int iTwoSampleTest, double dPairedVar, string strNullHypot,
	 string strAltHypot, double dt, int iDoF, double dP, int iAltRBChoice, double dSigLevel, double dTestVal );
int	osTTest_ConIntervals_Output_to_ResultsLog( int iTwoSampleTest, string strConLevelDataName,
		 string strLLimitDataName, string strULimitDataName );
int	osSummary_Stat_Output_to_ResultsLog( int iTest, int nData );
int osPower_Output_to_ResultsLog( int iPower, double dAlpha, int iSSType, int iActualSS,
	 double dActualPower, string strHypotSSDataName, string strHypotPowerDataName );
double osANOVA_Power( double dFval, double ddf1, double ddf2, double dnc );
int osANOVA_Compute_StdErr_MeanDiffs( int inData, double dmse, vector<int> &vNPTS, vector<double> &vC );

int	osANOVA1_Table_Output_to_ResultsLog( string strTestType, double ddf1, double dssb, double dmsb,
	 double dF, double dP, double ddf2, double dsse, double dmse, double dSigLevel );
int osANOVA1Way_Means_Comparison( int iTest, int inData, string strNPTS, double ddf2, string strMEAN,
	 double dmse, double dSigLevel );
int osANOVA1Way_Means_Comparison_Output_to_ResultsLog( string strTestName, int inData, vector<double> &vMEAN,
	 vector<double> &vCIL, vector<double> &vCIU, vector<int> &vISIG, double dSigLevel );

int osANOVA2Way( double dSigLevel, int iInteractions, int iSpecifyLevelsBy, int nData, int iPower, double dPowerAlpha,
	 string strSampleSizes, int iTest );
int osANOVA2Way_Get_Data( int iSpecifyLevelsBy, int nData, vector<string> &vDataNames, vector<int> &vFACTOR_A,
	 vector<string> &vLEVELSA, int &nLevelsA, vector<int> &vFACTOR_B, vector<string> &vLEVELSB, int &nLevelsB,
	 vector<double> &vDEP_VAR, int &iSize );
int	osANOVA2Way_Count_Values_Per_Cell( vector<int> &v1, vector<int> &v2, matrix<int> &mCount, int iThreshold, int &iRow, int &iCol );
int osANOVA2Way_Add_String_to_Vector( string strIn, vector<string> &vSTRINGS );
int osANOVA2Way_Count_Unique_Values( int nPts, Dataset &dsDATASET, int &nCount );
//---- CPY 5/4/03 
//int osANOVA2Way_Compute_ANOVA_Table( int iInteractions, vector<int> &vFACTOR_A, int nLevelsA, vector<int> &vFACTOR_B,
//	 int nLevelsB, vector<double> &vDEP_VAR, int nPts, ANOVA2_Row &arANOVA2_Table );
int osANOVA2Way_Compute_ANOVA_Table( int iInteractions, vector<int> &vFACTOR_A, int nLevelsA, vector<int> &vFACTOR_B,
	 int nLevelsB, vector<double> &vDEP_VAR, int nPts, ANOVA2_Row* parANOVA2_Table );
//----
int osANOVA2Way_Compute_Dummy_Vars( int nPts, int nLevels, vector<int> &vFACT, matrix<double> &mX );
int osANOVA2Way_Compute_FACTsAxB_Dummy_Vars( int nPts, int nLevelsA, matrix<int> &mX_FACT_A, int nLevelsB,
	 matrix<int> &mX_FACT_B, matrix<int> &mX_FACTs_AxB );
int osANOVA2Way_Copy_Matrix( int nPts, int nCols, matrix<double> &mXfrom, int nStartCol, matrix<double> &mXinto );
int osANOVA2Way_Perform_Linear_Regression( int nPts, int nTdx, matrix<double> &mX, vector<double> &vY,
	 double &dRss, double &dDf );
int osANOVA2Way_ANOVA_Table_Output_to_ResultsLog( int iSpecifyLevelsBy, int nData, vector<string> &vDataNames,
	 int iInteractions, ANOVA2_Row *arANOVA2_Table );
int osANOVA2Way_Means_Comparison( char cFactor, int iTest, vector<int> &vFACTOR, vector<string> &vLEVELS,
	 int nLevels, vector<double> &vDEP_VAR, int nPts, double dDFE, double dMSE, double dSigLevel );
int osANOVA2Way_Compute_MEANS_of_Levels( vector<int> &vFACTOR, int nLevels, vector<double> &vDEP_VAR, int nPts,
	 vector<int> &vNPTS, vector<double> &vMEANS );
int osANOVA2Way_Means_Comparison_Output_to_ResultsLog( char cFactor, string strTestName, int nLevels, vector<string> &vLEVELS,
	 vector<double> &vMEAN, vector<double> &vCIL, vector<double> &vCIU, vector<int> &vISIG, double dSigLevel );
int osANOVA2Way_Power( int iPower, int iInteractions, double dPowerAlpha, int nPts, string strSampleSizes,
	 ANOVA2_Row *arANOVA2_Table );
int osANOVA2Way_Compute_Power( int iPower, int iInteractions, double dAlpha, int nPts, int iSize,
	 ANOVA2_Row *arANOVA2_Table, int iSource, vector<double> &vSS, double &dPower, vector<double> &vSSPOW );
int osANOVA2Way_Power_Output_to_ResultsLog( int iInteractions, int iSource, double dPowerAlpha, int nPts,
	 double dPower, int iPower, vector<double> &vSS, vector<double> &vSSPOW, Worksheet &wksPowerTable );
string osANOVA2Way_Get_Localized_Var_Name( int iVarTypeCode );

int osNormalityTest( string strDataset, double dNormTestSL );
// End declare functions in OStat.c

// Define OStat constants NOT needing localization
#define OSTAT_NO_ERROR					0
#define OSTAT_CONF_INT_ERROR1			100
#define OSTAT_CONF_INT_ERROR2			101
#define OSTAT_CONF_INT_ERROR3			102
#define OSTAT_SHAPIRO_WILK_ERROR		103
#define OSTAT_TOO_FEW_DATAPTS_WARNING	104
#define OSTAT_TOO_MANY_DATAPTS_WARNING	105
#define OSTAT_DATA_SORT_ERROR1			106
#define OSTAT_ANOVA2_ERROR				107
#define OSTAT_NAG_DUMMY_VARS_ERROR		108
#define OSTAT_GET_DATA_NAME_ERROR		109
#define OSTAT_DATA_SORT_ERROR2			110
#define OSTAT_CONF_INT_ERROR4			111
#define OSTAT_CONF_INT_ERROR5			112
#define OSTAT_CONF_INT_ERROR6			113
#define OSTAT_NAG_F_DEVIATE_ERROR1		114
#define OSTAT_NAG_F_DEVIATE_ERROR2		115	
#define OSTAT_ANOVA2_POWER_ERROR1		116
#define OSTAT_ANOVA2_POWER_ERROR2		117
#define OSTAT_ANOVA2_POWER_ERROR3		118
#define OSTAT_ZERO_DOF_RESID_ERROR		119
#define OSTAT_PAIRED_SD_IS_0_ERROR		120
#define OSTAT_ANOVA2_LIN_REGR_ERROR		121
#define OSTAT_ANOVA2_PROB_F_ERROR		125
#define OSTAT_ANOVA2_DOF_ERROR			129
#define OSTAT_ANOVA2_FVALUE_ERROR		133
#define OSTAT_ANOVA2_PVALUE_ERROR		137

#define OSTAT_NEXT_ERROR				141

#define OSTAT_ABORT_NO_ERROR_MSG		999

#define AN_POWER_TOLERANCE				5e-6
#define AN_POWER_ITERATIONS				500
// SET_AN_MAX_TUKEY_RESID_DF QA70-688
#define AN_MAX_TUKEY_RESID_DF			2000.0
// END SET_AN_MAX_TUKEY_RESID_DF QA70-688

#define AN2_LINEAR_REGRESS_TOLERANCE	5e-6
#define AN2_MIN_VALUES_PER_CELL			1
#define AN2_DEP_VAR_CODE				1
#define AN2_FACTOR_A_CODE				2
#define AN2_FACTOR_B_CODE				3

#define OSTAT_ROUND_FACTOR1				10000

#define OSTAT_SEPARATOR_CHAR		'|'
#define OSTAT_STR_TOKEN				"%c%s"
#define OSTAT_EIGHT_DASHES			"--------"
#define OSTAT_TEN_DASHES			"----------"
#define OSTAT_SIG_CON_LEVEL_FORMAT	"%.4g"
#define OSTAT_MAX_DIGITS_FORMAT		"%.15g"
#define OSTAT_OGW_SUBFOLDER			"Tables"
// End Define OStat constants NOT needing localization

//// Subset of basic NAG definitions from <NAG\nag_types> needed by OStat.c 
//#ifndef _ONAG_BASIC
//#define _ONAG_BASIC
//
//#define NE_NOERROR 0
//#define NE_REAL_ARG_CONS 9
//#define NE_ZERO_DOF_RESID 426
//#define NAG_ERROR_BUF_LEN 512
//
//#define Nag_TailProbability_start 264
//#define Nag_IncludeMean_start 285
//#define Nag_DummyType_start 384
//#define Nag_IntervalType_start 389
//
//typedef enum {Nag_LowerTail=Nag_TailProbability_start, Nag_UpperTail, Nag_TwoTailSignif,
	//Nag_TwoTailConfid, Nag_TwoTail, Nag_Central} Nag_TailProbability;
//typedef enum {Nag_TukeyInterval=Nag_IntervalType_start, Nag_BonferroniInterval, Nag_DunnInterval,
	//Nag_FisherInterval, Nag_ScheffeInterval} Nag_IntervalType;
//typedef enum {Nag_Poly=Nag_DummyType_start, Nag_Helmert, Nag_FirstLevel,
	//Nag_LastLevel, Nag_AllLevels} Nag_DummyType;
//typedef enum {Nag_MeanInclude=Nag_IncludeMean_start, Nag_MeanZero} Nag_IncludeMean;
	      //
//typedef struct {
	//int	code;    // Out: Error Code
	//BOOL	print;   // In: print? yes/no, not used in Origin C 
	//char	message[NAG_ERROR_BUF_LEN];      // InOut: Error message
	//UINT	handler; //Error handling function, not used from OriginC
	//int	errnum;  // May hold useful value for some errors
//} NagError;
//
//#endif // !_ONAG_BASIC
//
//// Functions below are implemented in ONAG DLL prepared by OriginLab and are needed by OStat.c
//#pragma dll(ONAG)
//
//// From <NAG\OCN_g01.h>: g01ebc nag_prob_students_t 
//double nag_prob_students_t(
	//Nag_TailProbability tail,
	//double t,	// the value of the Student s t variate
	//double df,	// the degree of freedom
	//NagError* fail=NULL // NAG error structure
//);	// Probabilities for Student's t-distribution
//
//// From <NAG\OCN_g01.h>: g01gdc nag_prob_non_central_f_dist
//double nag_prob_non_central_f_dist(
	//double f,  // the deviate from the F-distribution, F
	//double df1,	// the degree of freedom of the numerator variance, v1
	//double df2,	 // the degree of freedom of the denominator variance, v2
	//double lambda, // the non-centrality parameter
	//double tol=5e-6,	// the required accuracy of the solution
	//int max_iter = 500, // the maximum number of iterations to be performed
	//NagError *fail=NULL	// NAG error structure
//);	// Computes probabilities for the non-central F-distribution
//
//// From <NAG\OCN_g01.h>: g01ddc nag_shapiro_wilk_test
//int nag_shapiro_wilk_test(
	//int n,	// the sample size, 3 <= n <= 2000
	//const double x[],  // the ordered sample values
	//BOOL calc_wts, // calculate weight or not
	//double a[],	// weight
	//double* w,	// the value of the statistics, W
	//double* pw	// the significance level of W
//);	// Shapiro and Wilk's W test for Normality
//
//// From <NAG\OCN_g01.h>: g01edc nag_prob_f_dist
//double nag_prob_f_dist(
	//Nag_TailProbability tail,
	//double f,	// the value of the F variate
	//double df1,	// the degree of freedom of the numerator variance, v1
	//double df2,	// the degree of freedom of the denominator variance, v2
	//NagError* fail=NULL // NAG error structure
//);	// Probabilities for F-distribution
//
//// From <NAG\OCN_g02.h>: g02dac nag_regsn_mult_linear    
//int nag_regsn_mult_linear(
    //Nag_IncludeMean mean,
    //int n, 		    // the number of observations 
    //double x[],     //the variable for which ith observation for the jth potential indepent variable.
    //int tdx, 	  	// the second dimension of the array x.
    //int m, 		  	// the total number of independent variables in the data set.
    //int sx[], 	  	// indicates which of the potential independent variables are to be included in the model.
    //int ip, 	  	// the number p of independent variables in the model, including the mean or intercept if present.
    //double y[],   	// the observations on the dependent variable.
    //double wt[],  	// an (optional) weight is specified to be used in the weighted regression. 
    //double *rss,  	// the residual sum of squares for the regression.
    //double *df,   	// the degree of freedom associated with the residual sum of squares.
    //double b[],   	// return the least-squares estimates of the parameters of the regression model.
    //double se[],  	// return the standard errors of the ip parameter estimates given in b.
    //double cov[], 	// return the variance-covariance matrix of estimated parameters in b.
    //double res[], 	// return the (weighted) residuals.
    //double h[],   	// return the diagonal elements of H.
    //double q[],   	// return the results of the QR decomposition.
    //int tdq, 	  	// the second dimension of the array q. 
    //BOOL *svd,  	// return TRUE if a singular value decomposition has been performed, otherwise FALSE
    //int *rank, 	  	// return the rank of the independent variables.
    //double p[],   	// details of the QR decomposition and SVD if used.
    //double tol,   	// the value of tol is used to decide what is the rank of the independent variables. 
    //double com_ar[] // return information which is needed by nag_regsn_mult_linear_newyvar_if svd = TRUE.
//);	//  Parameter estimates, standard errors, residuals ... 
//
//// From <NAG\OCN_g04.h>: g04dbc nag_anova_confid_interval
//int nag_anova_confid_interval(
	//Nag_IntervalType type,
	//int nt,				// the number of treatment means
	//const double tmean[], // the treatment means
	//double rdf,			// the residual degrees of freedom
	//const double c[],	// the standard errors of the differences between the means
	//int ldc,			// the second dimension of the array c
	//double clevel,		// the confidence level for the computed intervals
	//double cil[],		// lower limit to the confidence interval
	//double ciu[],		// upper limit to the confidence interval
	//int isig[]			// difference between the ith and jth means in tmean is significant.
//);	// Computes confidence intervals for differences between means computed
//
//// From <NAG\OCN_g04.h>: g04eac nag_dummy_vars
//int nag_dummy_vars(
	//Nag_DummyType type,
	//int n,	// the number of observations for which the dummy variables are to be computed.
	//int levels,	// the number of levels of the factor.
	//const int ifact[], // the n values of the factor.
	//double x[],	// the n by k matrix of dummy variables
	//int tdx,	// the second dimension of the array x
	//const double v[], // If type equal Nag_Poly, the k distinct values of the underlying variable for which 
					//// the orthogonal polynomial is to be computed.  If type not equal Nag_Poly, v is not reference.
	//double rep[]	// contains the number of replications for each level
//);	// Computes orthogonal polynomials or dummy variables for factor/classification variable.

#endif // !_OSTAT_H