/*------------------------------------------------------------------------------*
 * File Name:ThemeEditor.c	 													*
 * Creation: CPY																*
 * Purpose: OriginC Source C file for ThemeEditing Dialog						*
 * Copyright (c) Originlab Corp.	2003										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	CPY 8/21/03 EMPTY_THEME_SOMETIMES_NOT_SAVING_COMMENTS						*
 *------------------------------------------------------------------------------*/
 
#include <Origin.h>
//#include <Project.h>
//#include <sys_utils.h> // basic routines implemeted through Origin C, see sys_utils.c
#include <Dialog.h>
//#include <utilities.h>
//#include <tree_utils.h>
#include "ResizeDialog.h"
#include <TreeEditor.h>
#include <vsFlexGrid.h>
#include "GridControl.h"
#include "ODlg.h" // resource IDs, ODlg.dll also use this file for its res ids
#include "HelpID.h"
#include "theme_utils.h"

bool ThemeEditor(LPCSTR lpcszThemeFilename, HWND hWndParent)//= NULL)
{
	ThemeEditorDlg	ThemeEditor;
	if(!ThemeEditor.Init(lpcszThemeFilename))
		return false;
	int nRet = ThemeEditor.DoModalEx(hWndParent);

	return (IDCANCEL == nRet)? false:true;
}

class ThemeEditorDlg : public ResizeDialog
{
private:
	TempThemeFile	m_tempThemeFile;
	string			m_strThemeFilename;
	string			m_strComments;
	bool			m_bReadOnly;
	ThemeTreeControl 		m_treeCntrl;
	Control			m_cFilename;
	Control			m_cReadOnly;
	Control			m_cModified;
	Edit 			m_editComments;
	Button			m_btnShowEmpty;
	Button			m_btnShowCollection;
	
public:
	ThemeEditorDlg() : ResizeDialog(IDD_STYLSHT_EDITOR, "ODlg")
	{
		
	}
	bool Init(LPCSTR lpcszThemeFilename)
	{
		m_strThemeFilename = lpcszThemeFilename;
		if(!m_strThemeFilename.IsFile())
			return false;
		if(m_tempThemeFile.Init(lpcszThemeFilename))
		{
			DWORD	dwAttributes = GetFileAttributes(lpcszThemeFilename);
			m_bReadOnly = (dwAttributes & FILE_ATTRIBUTE_READONLY)? true:false; // will need to add testing for folder readonly later
			return true;
		}
		return false;
	}
	int DoModalEx(HWND hWndParent = NULL)
	{
		InitMsgMap();// will be called from internal later
		int nRet = DoModal(hWndParent);
		
		return nRet;
	}
protected:
	///----------------- Message Map ----------------
	EVENTS_BEGIN
		ON_INIT(OnInitDialog) 
		ON_OK(OnOK)
		
		ON_USER_MSG(WM_USER_ON_CONTROL_CHANGE, OnTreeChanged)
		
		ON_BN_CLICKED(IDC_STYLSHT_LIST_VIEW, OnListViewCheck)
		ON_BN_CLICKED(IDC_STYLSHT_FILTER, OnThemeFilter)
		ON_BN_CLICKED(IDC_STYLSHT_SHOW_EMPTY, OnShowCheck)
		ON_BN_CLICKED(IDC_STYLSHT_SHOW_COLLECTION, OnShowCheck)
		
		ON_SIZE(OnDlgResize)
		ON_DESTROY(OnDestroy)
	EVENTS_END
	///----------------------------------------------
	///////////////////////////////////////////////////////
	/// Initialization
	///////////////////////////////////////////////////////
	BOOL OnInitDialog()
	{
		waitCursor junk;
		ResizeDialog::OnInitDialog();
		m_treeCntrl.Init(IDC_STYLSHT_TREE, *this);
		// load from s_strTempFilename
		m_cFilename = GetItem(IDC_STYLSHT_FILENAME);
		m_cFilename.Text = m_strThemeFilename;
		//m_treeEditor.Load(m_tempThemeFile.GetFileName());
		m_treeCntrl.Load(m_tempThemeFile.GetFileName());
		
		m_btnShowEmpty = GetItem(IDC_STYLSHT_SHOW_EMPTY);
		m_btnShowCollection = GetItem(IDC_STYLSHT_SHOW_COLLECTION);
		
		updateViewTree();
		theme_update_size(*this, m_tempThemeFile.GetFileName(), IDC_STYLSHT_COUNT);
				// use this text to get basic edge
		RECT r1;
		if(GetControlClientRect(IDC_STYLSHT_READONLY, r1, &m_cReadOnly))
			SetControlGap(r1.left);
		m_cReadOnly.Visible = m_bReadOnly;
		
		m_cModified = GetItem(IDC_STYLSHT_DATE);
		m_cModified.Text = GetFileModificationDate(m_strThemeFilename);
		
		m_strComments.Empty();
		
		Tree trTemp(m_tempThemeFile.GetFileName());
		
		m_editComments = GetItem(IDC_STYLSHT_COMMENT);
		m_editComments.Enable = m_bReadOnly? false:true;
		
		if(trTemp.GetAttribute(STR_THEME_COMMENT_ATTRIB, m_strComments))
			m_editComments.Text = m_strComments;
	
		return TRUE;	
	}

	BOOL OnOK()
	{
		if(!m_bReadOnly)
		{
			//m_treeEditor.Save(m_strThemeFilename);
			//---- CPY 8/21/03 EMPTY_THEME_SOMETIMES_NOT_SAVING_COMMENTS
			/*
			m_treeCntrl.Save(m_strThemeFilename);
			string strComments = m_editComments.Text;
			if(strComments.CompareNoCase(m_strComments) != 0)
			{
				Tree trTemp(m_strThemeFilename);
				trTemp.SetAttribute(STR_THEME_COMMENT_ATTRIB, strComments);
				trTemp.Save(m_strThemeFilename);
			}
			*/
			Tree trTemp;			
			m_treeCntrl.GetTree(trTemp);
			string strComments = m_editComments.Text;
			trTemp.SetAttribute(STR_THEME_COMMENT_ATTRIB, strComments);
			
			//---- CPY 10/21/03 QA70-4680 v7.5727 TREE_BRANCHESOPEN_CLOSE_REMEMBERED
			/*
			vector<byte> vn;
			if(m_treeCntrl.GetCollapsed(vn) > 1)
			{
				BitsHex temp;
				string	strTemp;
				temp.BitsToHexStr(vn, strTemp);
				trTemp.SetAttribute(STR_ATTRIB_COLLAPSE, strTemp);
			}
			*/
			//---- end TREE_BRANCHESOPEN_CLOSE_REMEMBERED

			trTemp.Save(m_strThemeFilename);
			//---- end EMPTY_THEME_SOMETIMES_NOT_SAVING_COMMENTS
		}
		return TRUE;
	}
	BOOL OnTreeChanged(uint wParam, uint lParam)
	{
		theme_update_size(*this, m_tempThemeFile.GetFileName(), IDC_STYLSHT_COUNT, IDC_STYLSHT_TREE);
		return TRUE;
	}
	BOOL OnThemeFilter(Control oCntrl)
	{
		if(theme_filter_dialog(*this, IDC_STYLSHT_LIST_VIEW, IDC_STYLSHT_TREE))
			theme_update_size(*this, m_tempThemeFile.GetFileName(), IDC_STYLSHT_COUNT, IDC_STYLSHT_TREE);
			
		return TRUE;
	}	
	BOOL OnDestroy(void)
	{
		return TRUE;
	}
	BOOL OnListViewCheck(Control oCntrl)
	{
		Button btnListView = oCntrl;
		if(btnListView.Check)
		{
			m_btnShowEmpty.Enable = false;
			m_btnShowCollection.Enable = false;
		}
		else
		{
			m_btnShowEmpty.Enable = true;
			m_btnShowCollection.Enable = true;
		}
			
		updateViewTree();
		return TRUE;
	}
	BOOL OnShowCheck(Control oCntrl)
	{
		updateViewTree();
		return TRUE;
	}
	BOOL OnDlgResize(int nType, int cx, int cy)
	{
		uint nBtnIds[] = {
			IDOK,
			IDCANCEL,
			IDC_STYLSHT_FILTER,
			IDC_STYLSHT_LIST_VIEW,IDC_STYLSHT_SHOW_EMPTY,IDC_STYLSHT_SHOW_COLLECTION, 0};
			
		ResizeMoveControlsRightBottom(IDC_STYLSHT_TREE, nBtnIds, NULL, cx, cy);
		return TRUE;
	}
private:
	void updateViewTree()
	{
		theme_update_tree_list_view(*this, IDC_STYLSHT_LIST_VIEW, IDC_STYLSHT_TREE, m_btnShowEmpty.Check, m_btnShowCollection.Check);
	}

};



 





