/* KGRAPH Header file
 * GRD 2002.08.09
 */
 
#ifndef _KGRAPH_H
#define _KGRAPH_H

#define	SIZE_OF_FLOAT	4
#define	SIZE_OF_DOUBLE	8

// 1,2,4,8, default is 8
#pragma pack(push,1)

typedef struct tagExtra
{
	char	ColWidth;	// Column Width
	char	NumFormat;	// Numeric Format
	char	DateFormat;	// Date Format (Just use 2 - Windows Long)
	char	TimeFormat;	// Time Format (Just use 4 - hh:mm:ss.##)
	char	NumDigits;	// Number of Digits
	char	Unk1;		// 
	char	Unk2;		// 
	char	BitFlags;	// 0:?TrailZero/Off?, 1:?Commas/Off?, 2:Time/Date, 3:Euro/Amer, 4-7:??
} Extra;

#pragma pack(pop)

// Prototypes
int readkgraph(string filename, string worksheetname);
int kgraph_read_float_data(file &fid, Worksheet TheWorksheet, uint TheColumn, uint NumRows);
int kgraph_read_double_data(file &fid, Worksheet TheWorksheet, uint TheColumn, uint NumRows);
int kgraph_read_long_data(file &fid, Worksheet TheWorksheet, uint TheColumn, uint NumRows);
int kgraph_read_date_data(file &fid, Worksheet TheWorksheet, uint TheColumn, uint NumRows);
int kgraph_read_text_data(file &fid, Worksheet TheWorksheet, uint TheColumn, uint NumRows);
void kgraph_read_mask(file &fid, string TheWorksheetName, uint TheColumn, uint NumRows);
void kgraph_read_extra(file &fid, string TheWorksheetName, uint TheColumn, uint NumRows);
void kgraph_read_name(file &fid, string TheWorksheetName, uint TheColumn, uint NumRows);
int ImportKaleidaGraph(Page& pgTarget, TreeNode& trFilter, LPCSTR lpcszFile, int nFile);

#endif // _KGRAPH_H
