#ifndef _OCWAV_H
#define _OCWAV_H

// Function prototypes in ocwav.c
int	ocWAVReadFile(string strFileName, string strWorksheetName);
int	ocWAVWriteFile(string strFilename, string strWorksheetName, int iColL, int iColR, double dFreqMult, double dAmpMult);
void	ocWAVPlayFile(string strFileName, int iMethod);
void	ocWAVPlayData(string strDatasetName, double dFreqMult, double AmpMult);
int	ocWAVAnalyzeData(string strDasetName1, string strDatasetName2);
int	ImportWAV(Page& pgTarget, TreeNode& trFilter, LPCSTR lpcszFile, int nFile);

// "fmt " chunk - This changes based on Codex. This is the 'PCM' format
struct FORMATCHUNK
{
	unsigned short	iWAVFormat;			// { 0001=PCM | 0101=MULAW | 0102=ALAW | 0103=ADP }
	unsigned short	iWAVChannels;		// { 1 | 2 }
	unsigned int	iWAVFrequency;		// { 44100 | 22050 | 11025 | 8000 | ??? }
	unsigned int	iWAVBytesPerSecond;
	unsigned short	iWAVAlign;			// { 1 | 2 | 4 }
	unsigned short	iWAVBitsPerSample;	// { 8 | 16 }
};

#pragma dll(winmm, system)
#define mciSendString mciSendStringA

int WINAPI mciSendString(string strCommand, string strReturn, int iRetLen, int iCallBack);

#endif // _OCWAV_H

