#ifndef _DIALOG_H
#define _DIALOG_H

#ifdef	 ORIGIN_COM_SUPPORT
#include <Control.h>
#include <MsgMap.h>
#endif// ORIGIN_COM_SUPPORT


/** >User Interface Controls
	This class is only available to OriginPro users. 
*/
class WndContainer : public Window
{
	
public:
	
	/**
	*/
	WndContainer();
};
	
/** >User Interface Controls
	This class is only available to OriginPro users.
*/
class Dialog : public WndContainer
{
public:
	
	/**
	*/
	Dialog(LPCTSTR DlgName, LPCTSTR DllName);

	/**
	*/	
	Dialog(UINT nDlgID, LPCTSTR DllName);
	
	/**
	*/
	BOOL 	Attach(LPCTSTR DlgName, LPCTSTR DllName);

	/**
	*/	
	BOOL 	Attach(UINT nDlgID, LPCTSTR DllName);
	
	/**
			Call this member function to invoke the modal dialog box and return the dialog-box result when done.	
		Example:
			MyDlg.DoModal(GetWindow());
			
		Return:
			The ID of the button click to close the dialog box, or -1 if the dialog cannot be loaded for whatever reason.
		
		Parameters:
			hWndParent = Specifies the parent window, or NULL to use the active window
			dwOptions = flags to control the dialog. Including,
			DLG_OPTIONS_SHIFT_SHOW_DEFAULT_TRUE
			 This flag is for dialogs that contains a check box for Show-only-if-shift-key-is-down, 
			If this flag is on,  the default value for this check box will be true. Please note that once the dialog is open and closed normally, 
			this setting (ShiftShow) will be saved into Origin.ini, so this parameter is used only when the dialog is opened the first time.
			DLG_OPTIONS_USE_OPS
			This flag can be used to turn on the recording mechanism in Dialog Builder. Please note that only controls that have a string table entry will participate in recording.
	*/
	int  	DoModal(HWND hWndParent=NULL, DWORD dwOptions = 0, LPCSTR OpsName = NULL);

	/**
		Call this member function to invoke the modalless dialog box.	
	Example:
		MyDlg.Create(GetWindow()); //MyDlg is a dialog object
	Return:
		Returns TRUE if Successful else return FALSE.	
	SeeAlso:
		Dialog::DoModal
	*/
	BOOL	Create(HWND hWndParent=NULL, DWORD dwOptions = 0, LPCSTR OpsName = NULL);

	/**
	*/	
	BOOL	IsShiftShow(BOOL bDefault=FALSE);
	
	/**
			This function installs a system timer.
		Example:
			SetTimer(1001,300);
			
		Return:
			The timer identifier of the new timer if the function is successful. 
			An application passes this value to the KillTimer member function to kill the timer. 
			Nonzero if successful; otherwise 0.

		Parameters:
			nIDEvent = Specifies a nonzero timer identifier.
			nElapse	= Specifies the time-out value, in milliseconds.

		Remarks:
			Every time a time-out occurs, the dialog will receive a WM_TIMER message. 
	*/
	int SetTimer( int nIDEvent, uint nElapse);

	/**
			This function kills a system timer.
		Example:
			KillTimer(1001);
			
		Return:
			Specifies the outcome of the function. The value is nonzero if the event was killed. It is 0 if the KillTimer function could not find the specified timer event.

		Parameters:
			nIDEvent = The value of the timer event passed to SetTimer.

		Remarks:
			Kills the timer event identified by nIDEvent from the earlier call to SetTimer. 
			Any pending WM_TIMER messages associated with the timer are removed from the message queue.
	*/
	BOOL KillTimer( int nIDEvent );

	/**
	*/
	void Close(int nModalRet = -1);

	/**
	*/
	Window	GetWindow();

	/**
		This function instantiates OLE drag drop to Origin workspace
		Example:
			class CDragDrop : public Dialog
			{
				
			public:
				
				
			EVENTS_BEGIN
				ON_GRID_START_DRAG(IDC_VSFLEXGRIDL_DDS, OnStartDrag)
				ON_GRID_DRAG_DROP(IDC_VSFLEXGRIDL_DDT, OnDragDrop)
				ON_DROP_ORG_WORKSAPCE(IDC_VSFLEXGRIDL_DDS, OnDropOrigin)
			EVENTS_END

				CDragDrop():Dialog(IDD_DIALOG_DD, "<DragDropTest.dll>"){}

				int	CreateEx(HWND hParent)
				{
					InitMsgMap();// will be called from internal later
					return  Create(hParent);
				}
				
				BOOL OnDropOrigin(Control ctrlSrc, PageBase  pbTarget, int x, int y)
				{
					//Handle writing data from ctrlSrc to pbTarget
					return TRUE;
				}

				void OnStartDrag(Control cntrl, _VARIANT & vtDispatch, int *pInt)
				{
					int nn = 0;
					SetAsDragInducer(IDC_VSFLEXGRIDL_DDS);
				}
			};
			
		Return:
		Returns non-zero if Successful	else return 0.


		Parameters:
			nID		= The Control ID of the Drag Source
			bSet	= If true, Set the control to recieve OC_NOTIFICATION_OLE_DROP notification, false will reset


	*/
	BOOL    SetAsDragInducer(uint nID, BOOL bSet = TRUE);
	/**
	dwStyle : Could be one of the following; RESIZE_DEPENDENCY_DOMINANT_NONE, RESIZE_DEPENDENCY_DOMINANT_PAGE, RESIZE_DEPENDENCY_DOMINANT_DIALOG,
	*/
	BOOL	SetResizingStyle(DWORD dwStyle);
	
#ifdef	 ORIGIN_COM_SUPPORT

	/**
	*/
	Control GetItem(int ID, int nPageID = 0); 

protected:

	/**
	*/
	//Msgmap	m_msgmap;
	
#endif// ORIGIN_COM_SUPPORT
};


/** >User Interface Controls
	This class is only available to OriginPro users.
*/
class PropertyPage : public WndContainer
{
	
public:

	/**
	*/
	PropertyPage(int nID = 0);

	/**
	*/	
	void	SetID(int nID);

	/**
	*/	
	int 	GetID();

	/**
	*/	
	BOOL 	Attach(int nResID, Dialog& dlgParentOwner); 

	/**
	*/	
	BOOL 	Attach(Dialog& dlgParentOwner);
	
#ifdef	 ORIGIN_COM_SUPPORT

	/**
	*/
	Control GetItem(int ID); 
#endif// ORIGIN_COM_SUPPORT
	
};



/** >User Interface Controls
	This class is only available to OriginPro users.
*/
class PropertySheet : public   WndContainer
{
public:

	/**
	*/	
	PropertySheet(int nID = 0);

	/**
	*/	
	void	SetID(int nID); 

	/**
	*/	
	int 	GetID();

	/**
	*/
	BOOL 	Attach(int nResID, Dialog& dlgParentOwner);

	/**
	Example:
	*/
	BOOL	Create(int nResID, Dialog& dlgParentOwner);

	/**
	Remarks:
		Adding pages without creating Page objects. For simpler projects
		or some pages which does not need a class, this approach may make it efficient.
		In Any case, the functions GetPage and GetActivePage can be called to recieve a 
		temporary page pointer when needed.
	*/
	BOOL	AddPage(int nID);

	/**
	Remarks:
		when nID == 0, Page is assumed to be already initialized with ID
		else, Page ID is ovewriiten by the supplied ID. Use ID if same classes
		instances are used for various pages. Otherwise, intializing ID from
		constructor can be used with default ID.
	*/
	BOOL	AddPage(PropertyPage & PropPage, int nID = 0);

	// Not implemented yet
	/**
	*/
	//BOOL	RemovePage(int nID);
	
	/**
	*/
	//BOOL	RemovePage(PropertyPage &Page);

	/**
	*/
	PropertyPage *GetPage(int nPage);

	/**
	*/	
	PropertyPage *GetActivePage();
	/**
	Remarks:
		The Functions below currently only available when the dialog is present.
		In Future versions, these should work indipendent.
	*/
	int		GetPageCount();

	/**
	*/	
	int		GetActiveIndex();

	/**
	*/	
	int		GetPageIndex(int nID);

	/**
	*/	
	int		GetPageIndex(PropertyPage &PropPage);

	/**
	*/	
	BOOL	RemovePage(int nID);

	/**
	*/	
	BOOL	RemovePage(PropertyPage &PropPage);

	/**
	*/	
	BOOL	SetActivePage(int nPage);

	/**
	*/	
	BOOL	SetActivePage(PropertyPage &PropPage);

	/**
	*/	
	BOOL	SetActivePageByID(int nID);
};

/** >User Interface Controls
	This class is only available to OriginPro users.
*/
class WizardSheet : public 	PropertySheet
{
public:

	/**
	*/	
	WizardSheet(int nID = 0);

	/**
	Remarks:
		Saves the OPS File for later use.
	*/
	BOOL	SaveSettings(LPCSTR FileName);

	/**
	*/	
	BOOL	AddPathControl(int nPercentWidth = 30);

	/**
	*/	
	BOOL	ShowPathControl(BOOL bShow);
};
#endif // _DIALOG_H