#ifndef _MSGMAP_H_
#define _MSGMAP_H_

#include <Common.h>
#include <String.h>


#ifdef	ORIGIN_COM_SUPPORT
	#include <DialogMessages.h>
#endif //ORIGIN_COM_SUPPORT

class Msgmap
{
	Msgmap();
	Msgmap(Msgmap & map);
	
	BOOL AddDlgMsg(int nMsg, Function FN, LPCSTR Prototype, DWORD ctrl = MHO_AFTER);    
	BOOL AddPageMsg(int nMsg,  uint nResID, Function FN, LPCSTR Prototype, DWORD ctrl = MHO_AFTER);    
	BOOL AddOGSWndMsg(int nMsg, uint nResID, Function FN, LPCSTR Prototype, DWORD ctrl = MHO_AFTER);  
	BOOL AddDirectWndMsg(int nMsg, uint nResID, Function FN, LPCSTR Prototype, DWORD ctrl = MHO_BEFORE);
	BOOL AddEventMsg(int nMsg, uint nResID, Function FN, LPCSTR Prototype, DWORD ctrl = MHO_AFTER);
	BOOL AddOriginMsg(int nMsg, Function FN, LPCSTR Prototype, DWORD ctrl = MHO_NONE);
	
};
	
/*
 * User Button Notification Codes
 *	From Windows WinUser.h
 */
#define BN_CLICKED              0

/*
 * Combo Box Notification Codes
 *	From Windows WinUser.h
 */
#define CBN_SELCHANGE       1
#define CBN_KILLFOCUS       4
#define CBN_EDITCHANGE      5


/*
 * Listbox Notification Codes
 */
#define LBN_SELCHANGE       1


/*
 * Edit Control Notification Codes
 *	From Windows WinUser.h
 */
#define EN_SETFOCUS         0x0100
#define EN_KILLFOCUS        0x0200
#define EN_CHANGE           0x0300
#define EN_UPDATE           0x0400
#define EN_ERRSPACE         0x0500
#define EN_MAXTEXT          0x0501
#define EN_HSCROLL          0x0601
#define EN_VSCROLL          0x0602

#define WM_USER                         0x0400
#define EM_SETEVENTMASK			(WM_USER + 69)

/* 
 *	Event notification masks
 */
#define ENM_NONE				0x00000000
#define ENM_CHANGE				0x00000001
#define ENM_UPDATE				0x00000002
#define ENM_SCROLL				0x00000004
#define ENM_KEYEVENTS			0x00010000
#define ENM_MOUSEEVENTS			0x00020000
#define ENM_REQUESTRESIZE		0x00040000
#define ENM_SELCHANGE			0x00080000
#define ENM_DROPFILES			0x00100000
#define ENM_PROTECTED			0x00200000
#define ENM_CORRECTTEXT			0x00400000		/* PenWin specific */
#define ENM_SCROLLEVENTS		0x00000008
#define ENM_DRAGDROPDONE		0x00000010

/*
 * New notifications 
 */
#define EN_MSGFILTER			0x0700
#define EN_REQUESTRESIZE		0x0701
#define EN_SELCHANGE			0x0702
#define EN_DROPFILES			0x0703
#define EN_PROTECTED			0x0704
#define EN_CORRECTTEXT			0x0705			/* PenWin specific */
#define EN_STOPNOUNDO			0x0706
#define EN_IMECHANGE			0x0707			/* Far East specific */
#define EN_SAVECLIPBOARD		0x0708
#define EN_OLEOPFAILED			0x0709
#define EN_OBJECTPOSITIONS		0x070a
#define EN_LINK					0x070b
#define EN_DRAGDROPDONE			0x070c

/*
 * TrackBar Control Notification Codes
 *	From Windows CommCtrl.h
 */
#define TB_LINEUP               0
#define TB_LINEDOWN             1
#define TB_PAGEUP               2
#define TB_PAGEDOWN             3
#define TB_THUMBPOSITION        4
#define TB_THUMBTRACK           5
#define TB_TOP                  6
#define TB_BOTTOM               7
#define TB_ENDTRACK             8

/*
 * Window Messages
 *	From Windows WinUser.h
 */
#define WM_DESTROY				0x0002
#define WM_SIZE					0x0005
#define WM_KEYDOWN				0x0100
#define WM_KEYUP				0x0101
#define WM_CHAR					0x0102
#define WM_TIMER				0x0113
#define WM_HSCROLL				0x0114
#define WM_VSCROLL				0x0115
#define WM_CONTEXTMENU          0x007B
#define WM_HELP                 0x0053
#define WM_GETMINMAXINFO        0x0024

#define ID_DLG					0

// event map for general event handlings

#define BEGIN_EVENT_MAP static Msgmap GenerateMsgMap() { Msgmap msgMap;
#define END_EVENT_MAP	return msgMap;}

/// RVD 3/17/2003 QA70-3855 v7.0539 SYSTEM_THEME
#define BEGIN_OK_EVENT_MAP static Msgmap _OKEventMsgMap() { static Msgmap msgMap; 
#define END_OK_EVENT_MAP	return msgMap;}
#define ON_OK_EVENT(_nMsg, _ocFunc)										msgMap.AddOriginMsg(_nMsg, _ocFunc, VTS_RORIGINOBJ);
/// end SYSTEM_THEME

//---- CPY 5/8/03 msg map for class
#define EVENTS_BEGIN	BOOL InitMsgMap() { Msgmap msgMap;
#define EVENTS_END		m_msgmap = msgMap; return TRUE;}
//----

#define ON_DLG_EVENT(_nMsg, _ocFunc)									msgMap.AddDlgMsg(_nMsg, _ocFunc, VTS_VOID);
#define ON_EVENT_BEFORE_UPDATE(_evt, _idCntrl, _ocHandler, _argList)	msgMap.AddDirectWndMsg(_evt, _idCntrl, _ocHandler, _argList);		  
#define ON_COMMAND_BEFORE_UPDATE(_evt, _idCntrl, _ocHandler)			msgMap.AddDirectWndMsg(_evt, _idCntrl, _ocHandler, VTS_CTRL);		  
#define ON_NOTIFY_BEFORE_UPDATE(_evt, _idCntrl, _ocHandler)				msgMap.AddDirectWndMsg(_evt, _idCntrl, _ocHandler, VTS_CTRL);		  
#define ON_EVENT(_evt, _idCntrl, _ocHandler)							msgMap.AddOGSWndMsg(_evt, _idCntrl, _ocHandler, VTS_CTRL);
#define ON_EVENT_EX(_evt, _idCntrl, _ocHandler, _argList)				msgMap.AddOGSWndMsg(_evt, _idCntrl, _ocHandler, _argList);
#define ON_ACTIVEX_EVENT(_evt, _idCntrl, _ocFunc, _argList)				msgMap.AddEventMsg(_evt, _idCntrl, _ocFunc, _argList);
#define ON_ACTIVEX_EVENT_CTRL(_evt, _idCntrl, _ocFunc)					msgMap.AddEventMsg(_evt, _idCntrl, _ocFunc, VTS_CTRL);
#define ON_ORIGIN_EVENT(_nMsg, _ocFunc)									msgMap.AddOriginMsg(_nMsg, _ocFunc, VTS_VOID);

// for _nMsg >= SN_COL_CHANGE_FORMAT 
//static BOOL OnColChange(string strWksName, string strColName, int nColNumber)
#define ON_ORIGIN_CHANGE(_nMsg, _ocFunc)							msgMap.AddOriginMsg(_nMsg, _ocFunc, VTS_STR VTS_STR VTS_I4);

// Specialized ON_DLG_EVENT's
#define ON_INIT(_fn)			ON_DLG_EVENT(SN_INIT, _fn)
	
  //static BOOL OnOK()// return TRUE to close, return FALSE will not close dialog
#define ON_OK(_fn)       		ON_DLG_EVENT(SN_OK, _fn)

#define ON_APPLY(_fn)       	ON_DLG_EVENT(SN_APPLY, _fn)
#define ON_FINISH(_fn)       	ON_DLG_EVENT(SN_FINISH, _fn)
#define ON_CANCEL(_fn)       	ON_DLG_EVENT(SN_CANCEL, _fn)
#define ON_CLICK_KEY(_fn) 		msgMap.AddDlgMsg(SN_ONKEY,_fn, VTS_I4, MHO_BEFORE);

// sample handler function BOOL OnInitSize(int &left, int &top, int &right, int  &bottom)
// return FALSE to disbale, always return false is same as DoModal(hWndParent, DLG_NO_DEFAULT_REPOSITION);
#define ON_INIT_SIZE(_fn)			msgMap.AddDlgMsg(SN_ON_INIT_RESIZE,_fn, VTS_RI4 VTS_RI4 VTS_RI4 VTS_RI4, MHO_BEFORE);
// ON_WINPROC does not interrupt processing irrespective of return value
// Prototype int WindowProc( UINT message, WPARAM wParam, LPARAM lParam ); // For special message handling
#define ON_WINPROC(_ocHandler)	msgMap.AddDlgMsg(SN_WINDOW_PROC,_ocHandler, VTS_I4 VTS_I4 VTS_I4, MHO_BEFORE);


#define ON_IDLE(_fn)				ON_ORIGIN_EVENT(SN_ONIDLE,	_fn)
#define ON_CHANGE_LAYER(_fn)		ON_ORIGIN_EVENT(SN_ACTIVE_LAYER, _fn)
#define ON_CHANGE_PAGE(_fn)			ON_ORIGIN_EVENT(SN_ACTIVE_PAGE, _fn)
#define ON_CHANGE_DATASET(_fn)		ON_ORIGIN_EVENT(SN_ACTIVE_DATASET, _fn)
#define ON_CHANGE_SELECTION(_fn)	ON_ORIGIN_EVENT(SN_ACTIVE_SELECTION, _fn)	

#define ON_PAGE_INIT(_nPgID, _fn)		msgMap.AddPageMsg(SN_INIT,  _nPgID, _fn, VTS_VOID); 
#define ON_PAGE_NEXT(_nPgID, _fn)		msgMap.AddPageMsg(SN_NEXT,  _nPgID, _fn, VTS_VOID); 
#define ON_PAGE_BACK(_nPgID, _fn)		msgMap.AddPageMsg(SN_BACK,  _nPgID, _fn, VTS_VOID); 
#define ON_PAGE_FINISH(_nPgID, _fn)		msgMap.AddPageMsg(SN_FINISH,  _nPgID, _fn, VTS_VOID);
#define ON_PAGE_ACTIVE(_nPgID, _fn) 	msgMap.AddPageMsg(SN_ACTIVE, _nPgID, _fn, VTS_VOID);
#define ON_PAGE_KILLACTIVE(_nPgID, _fn) msgMap.AddPageMsg(SN_KILLACTIVE, _nPgID, _fn, VTS_VOID);
#define ON_PAGE_OK(_nPgID, _fn) 		msgMap.AddPageMsg(SN_OK, _nPgID, _fn, VTS_VOID);
#define ON_PAGE_CANCEL(_nPgID, _fn) 	msgMap.AddPageMsg(SN_CANCEL, _nPgID, _fn, VTS_VOID);
#define ON_PAGE_RESET(_nPgID, _fn) 		msgMap.AddPageMsg(SN_RESET, _nPgID, _fn, VTS_VOID);
#define ON_PAGE_IS_SHOW(_nPgID, _fn)	msgMap.AddPageMsg(SN_IS_SHOW_PAGE, _nPgID, _fn, VTS_I4 VTS_I4);

// Event macros for tabbed dialog and wizard pages (GJL added for Tarak)
#define PAGE_ON_INIT(_fn)				msgMap.AddDlgMsg(SN_INIT, _fn, VTS_VOID); 
#define PAGE_ON_NEXT(_fn)				msgMap.AddDlgMsg(SN_NEXT, _fn, VTS_VOID); 
#define PAGE_ON_BACK(_fn)				msgMap.AddDlgMsg(SN_BACK, _fn, VTS_VOID); 
#define PAGE_ON_FINISH(_fn)				msgMap.AddDlgMsg(SN_FINISH, _fn, VTS_VOID);
#define PAGE_ON_ACTIVE(_fn) 			msgMap.AddDlgMsg(SN_ACTIVE, _fn, VTS_VOID);
#define PAGE_ON_KILLACTIVE(_fn) 		msgMap.AddDlgMsg(SN_KILLACTIVE, _fn, VTS_VOID);
#define PAGE_ON_OK(_fn) 				msgMap.AddDlgMsg(SN_OK, _fn, VTS_VOID);
#define PAGE_ON_CANCEL(_fn) 			msgMap.AddDlgMsg(SN_CANCEL, _fn, VTS_VOID);
#define PAGE_ON_RESET(_fn) 				msgMap.AddDlgMsg(SN_RESET, _fn, VTS_VOID);
#define PAGE_ON_IS_SHOW(_fn)			msgMap.AddDlgMsg(SN_IS_SHOW_PAGE, _fn, VTS_I4 VTS_I4);

/*
 * The following macros are to simplify the message map blocks and
 * to make code more compatible with MFC.
 */
// Function prototype fro Toolbar Button clicked: static BOOL OnTBBClick();
#define ON_TOOLBAR_BN_CLICKED(_idCntrl, _ocHandler)	ON_EVENT_EX(BN_CLICKED, _idCntrl, _ocHandler, VTS_VOID)

//static BOOL OnClickBTN( Control ctrl )
#define ON_BN_CLICKED(_idCntrl, _ocHandler)			ON_EVENT(BN_CLICKED, _idCntrl, _ocHandler)

#define ON_CBN_SELCHANGE(_idCntrl, _ocHandler)		ON_EVENT(CBN_SELCHANGE, _idCntrl, _ocHandler)
#define ON_CBN_KILLFOCUS(_idCntrl, _ocHandler)		ON_COMMAND_BEFORE_UPDATE(CBN_KILLFOCUS, _idCntrl, _ocHandler)
#define ON_CBN_EDITCHANGE(_idCntrl, _ocHandler)		ON_EVENT(CBN_EDITCHANGE, _idCntrl, _ocHandler)
#define ON_EN_CHANGE(_idCntrl, _ocHandler)			ON_EVENT(EN_CHANGE, _idCntrl, _ocHandler)
#define ON_EN_KILLFOCUS(_idCntrl, _ocHandler)		ON_EVENT(EN_KILLFOCUS, _idCntrl, _ocHandler)
#define ON_KEYDOWN_ENTER(_idCntrl, 	_ocHandler)		ON_EVENT(DDK_DLG_CTRL_MSG_EDITBOX_RETURN, _idCntrl, _ocHandler)
#define ON_LBN_SELCHANGE(_idCntrl, 	_ocHandler) 	ON_EVENT(LBN_SELCHANGE, _idCntrl, _ocHandler)


//return FALSE if not handled, and continue to be processed by standard windows processing of keyboard message
//return TRUE will stop default processing, so message will not be dispatched
// _ocHandler shouldbe prototyped as
//static BOOL OnKeyCmdWindow(Control oCntrl, uint msg, uint wParam, uint lParam)
#define ON_KEY(_idCntrl, 	_ocHandler)				ON_EVENT_BEFORE_UPDATE(OC_NOTIFICATION_KEY, _idCntrl, _ocHandler, VTS_CTRL VTS_I4 VTS_I4 VTS_I4)
//
//Changes  TD 1-3-03
//#define ON_EN_SELCHANGE(_idCntrl, _ocHandler)		ON_EVENT_BEFORE_UPDATE(EN_SELCHANGE, _idCntrl, _ocHandler, VTS_CTRL VTS_I4)
//#define ON_EN_VSCROLL(_idCntrl, _ocHandler)			ON_EVENT_BEFORE_UPDATE(EN_VSCROLL, _idCntrl, _ocHandler, VTS_CTRL VTS_I4)
//#define ON_EN_HSCROLL(_idCntrl, _ocHandler)			ON_EVENT_BEFORE_UPDATE(EN_HSCROLL, _idCntrl, _ocHandler, VTS_CTRL VTS_I4)



#define ON_EN_SELCHANGE(_idCntrl, _ocHandler)		ON_NOTIFY_BEFORE_UPDATE(EN_SELCHANGE, _idCntrl, _ocHandler)
#define ON_EN_VSCROLL(_idCntrl, _ocHandler)			ON_COMMAND_BEFORE_UPDATE(EN_VSCROLL, _idCntrl, _ocHandler)
#define ON_EN_HSCROLL(_idCntrl, _ocHandler)			ON_COMMAND_BEFORE_UPDATE(EN_HSCROLL, _idCntrl, _ocHandler)

// static BOOL OnVHScroll(Control cntrl, uint nScrollCode, uint nPos)
#define ON_WM_HSCROLL_BEFORE(_idCntrl, _ocHandler)			ON_EVENT_BEFORE_UPDATE(WM_HSCROLL, _idCntrl, _ocHandler, VTS_CTRL VTS_I4 VTS_I4)
#define ON_WM_VSCROLL_BEFORE(_idCntrl, _ocHandler)			ON_EVENT_BEFORE_UPDATE(WM_VSCROLL, _idCntrl, _ocHandler, VTS_CTRL VTS_I4 VTS_I4)
// static void OnVHScroll(Control cntrl, uint nScrollCode, uint nPos)
#define ON_WM_HSCROLL(_idCntrl, _ocHandler)					ON_EVENT_EX(WM_HSCROLL, _idCntrl, _ocHandler, VTS_CTRL VTS_I4 VTS_I4)
#define ON_WM_VSCROLL(_idCntrl, _ocHandler)					ON_EVENT_EX(WM_VSCROLL, _idCntrl, _ocHandler, VTS_CTRL VTS_I4 VTS_I4)
// BOOL OnDropOrigin(Control ctrlSrc, PageBase  pbTarget, int x, int y)
// x, and y are the cursor position when dropped in origin Workspace
#define ON_DROP_ORG_WORKSAPCE(_idCntrl, _ocHandler)			ON_EVENT_BEFORE_UPDATE(OC_NOTIFICATION_OLE_DROP, _idCntrl, _ocHandler, VTS_CTRL VTS_ORIGINOBJ VTS_I4 VTS_I4)


// Events for worksheet control
//WKSCTRL_EVENT_TYPE_CHANGE
//WKSCTRL_EVENT_DESI_CHANGE
#define ON_WKSCTRL_EVENT(_event, _ocHandler)		msgMap.AddDirectWndMsg(_event, ID_DLG, _ocHandler, VTS_I4 VTS_I4, MHO_BEFORE);
#define ON_WKSCTRL_CHANGE_COL_TYPE(_ocHandler)		msgMap.AddDirectWndMsg(WKSCTRL_EVENT_TYPE_CHANGE, ID_DLG, _ocHandler, VTS_I4 VTS_I4, MHO_BEFORE);
#define ON_WKSCTRL_CHANGE_COL_DESIG(_ocHandler)		msgMap.AddDirectWndMsg(WKSCTRL_EVENT_DESI_CHANGE, ID_DLG, _ocHandler, VTS_I4 VTS_I4, MHO_BEFORE);

//#define ON_SLIDER_SCROLL(_idCntrl, _ocHandler)		ON_EVENT(WM_HSCROLL, _idCntrl, _ocHandler)
//#define ON_SLIDE(_idCntrl, _ocHandler)				ON_EVENT(WM_HSCROLL, _idCntrl, _ocHandler)
#define ON_SLIDE_BEFORE(_idCntrl, _ocHandler)		ON_WM_HSCROLL_BEFORE(_idCntrl, _ocHandler)
#define ON_SLIDE(_idCntrl, _ocHandler)				ON_WM_HSCROLL(_idCntrl, _ocHandler)
#define ON_SIZE(_fn)								msgMap.AddDirectWndMsg(WM_SIZE, ID_DLG, _fn, VTS_I4 VTS_I4 VTS_I4, MHO_BEFORE);
#define ON_DESTROY(_fn)								msgMap.AddDirectWndMsg(WM_DESTROY, ID_DLG, _fn, VTS_VOID, MHO_BEFORE);
#define ON_TIMER(_fn)								msgMap.AddDirectWndMsg(WM_TIMER, ID_DLG, _fn, VTS_I4, MHO_BEFORE);
// WM_CONTEXTMENU handler Proptotype:  BOOL Fn(UINT nResIDCtrl, int x/*screen*/, int y/*screen*/);
#define ON_CONTEXTMENU(_fn)							msgMap.AddDirectWndMsg(WM_CONTEXTMENU, ID_DLG, _fn, VTS_I4 VTS_I4 VTS_I4,MHO_BEFORE);
// WM_HELP handler Proptotype:  BOOL Fn(int &nHelpID, int nIdCtrlFocus);
// return FALSE if no need for help, of help handled by OC code, return TRUE if default help handling
#define ON_HELPINFO(_fn)							msgMap.AddDirectWndMsg(WM_HELP, ID_DLG, _fn, VTS_RI4 VTS_I4, MHO_BEFORE);
// WM_GETMINMAXINFO handler Proptotype:  BOOL Fn(int &nMinTrackX, int &nMinTrackY);
#define ON_GETMINMAXINFO(_fn)						msgMap.AddDirectWndMsg(WM_GETMINMAXINFO, ID_DLG, _fn, VTS_RI4 VTS_RI4, MHO_BEFORE);

//static BOOL OnUserMsg(uint wParam, uint lParam);
#define ON_USER_MSG(_msg, _fn)						msgMap.AddDirectWndMsg(_msg, ID_DLG, _fn, VTS_I4 VTS_I4, MHO_BEFORE);						

// The following is a macro for the arguments sent to a function that
// handles a notifciation message.
#define NOTIFY_ARGS						Control ctrl
//#define EVENT_BEFORE_UPDATE_ARGS		Control ctrl, DWORD lParam


bool	do_new_operation(const TreeNode& trNode, LPCSTR lpcszName, BOOL bTry = FALSE);



#endif //_MSGMAP_H_