/*------------------------------------------------------------------------------*
 * File Name: nag_types.h														*
 * Creation: SDB 5/22/2001														*
 * Purpose: Origin C Header for NAG functions enum types						*
 * Copyright (c) OriginLab Corp.	2001										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/

#ifndef _O_NAG_TYPES_H
#define _O_NAG_TYPES_H

// Subset of basic NAG definitions needed by Origin 
//---------- TZ 8/28/01 NAG uses int for Boolean
#define Boolean BOOL
//----------

#ifndef _ONAG_BASIC
#define _ONAG_BASIC

#define NE_NOERROR 0
#define NE_REAL_ARG_CONS 9
#define NE_ZERO_DOF_RESID 426
#define NAG_ERROR_BUF_LEN 512

#define Nag_TailProbability_start 264
#define Nag_IncludeMean_start 285
#define Nag_DummyType_start 384
#define Nag_IntervalType_start 389

typedef enum {Nag_LowerTail=Nag_TailProbability_start, Nag_UpperTail, Nag_TwoTailSignif,
	Nag_TwoTailConfid, Nag_TwoTail, Nag_Central} Nag_TailProbability;
typedef enum {Nag_TukeyInterval=Nag_IntervalType_start, Nag_BonferroniInterval, Nag_DunnInterval,
	Nag_FisherInterval, Nag_ScheffeInterval} Nag_IntervalType;
typedef enum {Nag_Poly=Nag_DummyType_start, Nag_Helmert, Nag_FirstLevel,
	Nag_LastLevel, Nag_AllLevels} Nag_DummyType;
typedef enum {Nag_MeanInclude=Nag_IncludeMean_start, Nag_MeanZero} Nag_IncludeMean;
	      
typedef struct {
	int	code;    // Out: Error Code
	BOOL	print;   // In: print? yes/no, not used in Origin C 
	char	message[NAG_ERROR_BUF_LEN];      // InOut: Error message
	UINT	handler; //Error handling function, not used from OriginC
	int	errnum;  // May hold useful value for some errors
} NagError;

#endif // !_ONAG_BASIC

#define Nag_Blocks_start 381
#define Nag_Distributions_start 402
#define Nag_ParaEstimates_start 411
#define Nag_TestStatistics_start 413
#define Nag_Ties_start 276
#define Nag_ClassBoundary_start 281
#define Nag_Scores_start 270
#define Nag_DerivType_start 63
#define Nag_Start_start 65
#define Nag_IncludeWeight_start 283
#define Nag_SumSquare_start 289
#define Nag_UpdateObserv_start 287
#define Nag_Link_start 293
#define Nag_RegType_start 301
#define Nag_PsiFun_start 305
#define Nag_SigmaEst_start 311
#define Nag_CovMatrixEst_start 315
#define NE_NVAR_NOT_IND 431
#define NE_RANK_EQ_IP 440
#define NE_THETA_ITER_EXCEEDED 480
#define NE_LSQ_FAIL_CONV 481
#define NE_MAT_SINGULAR 377
#define NE_WT_LSQ_NOT_FULL_RANK 482
#define NE_REG_MAT_SINGULAR 483
#define NE_VAR_THETA_LEQ_ZERO 485
#define NE_ERR_DOF_LEQ_ZERO 486
#define NE_ESTIM_SIGMA_ZERO 487
#define NE_COV_MAT_FACTOR_ZERO 484
#define NE_LSQ_ITER_NOT_CONV 463
#define NE_RANK_CHANGED 464
#define NE_ZERO_DOF_ERROR 465
#define NE_SVD_NOT_CONV 427
#define Nag_VectorOp_start 27
#define Nag_TransformDirection_start 29
#define Nag_TableStats_start 430
#define Nag_TableUpdate_start 436
#define Nag_TabulateVar_start 438
#define Nag_Weightstype_start 328
#define Nag_PrinCompMat_start 320
#define Nag_PrinCompScores_start 324
#define Nag_RotationLoading_start 332
#define Nag_TransNorm_start 334
#define Nag_RotationScale_start 340
#define Nag_FacMat_start 342
#define Nag_FacScoreMethod_start 345
#define Nag_FacRotation_start 347
#define Nag_GroupCovars_start 349
#define Nag_MahalDist_start 351
#define Nag_DiscrimMethod_start 353
#define Nag_PriorProbability_start 355
#define Nag_MatUpdate_start 358
#define Nag_DistanceType_start 360
#define Nag_VarScaleType_start 363
#define Nag_ClusterMethod_start 367
#define Nag_DendOrient_start 373
#define Nag_Eigenvalues_start 377
#define Nag_ScaleCriterion_start 379
#define Nag_WhereElements_start 208
#define MatrixTranspose_start 1
#define MatrixTriangle_start 4
#define MatrixUnitTriangular_start 6
#define OperationSide_start 8
#define PivotType_start 10
#define SequenceDirection_start 14
#define NormType_start 16
#define MatrixType_start 20
#define Nag_Select_Eigenvalues_start 212
#define Nag_SolveSystem_start 214
#define Nag_2d_Scat_Method_start 61
#define Nag_IncSignZeros_start 400
#define Nag_CallTypes_start 416
#define Nag_CompProb_start 394



#ifdef NAG_VOID_STAR
typedef void * Pointer;          // Generic pointer 
#else
typedef char * Pointer;
#endif

typedef enum {Nag_NoBlocks=Nag_Blocks_start, Nag_SerialBlocks, Nag_ParallelBlocks} Nag_Blocks;
typedef enum {Nag_Uniform=Nag_Distributions_start, Nag_Normal, Nag_Gamma,
	      Nag_Beta, Nag_ChiSquare, Nag_Binomial, Nag_Exponential,
	      Nag_Poisson, Nag_UserProb} Nag_Distributions;
typedef enum {Nag_ParaSupplied=Nag_ParaEstimates_start, Nag_ParaEstimated}
Nag_ParaEstimates;
typedef enum {Nag_TestStatisticsDAbs=Nag_TestStatistics_start, Nag_TestStatisticsDPos,
	      Nag_TestStatisticsDNeg} Nag_TestStatistics;
typedef enum { Nag_AverageTies=Nag_Ties_start, Nag_LowestTies, Nag_HighestTies,
Nag_RandomTies, Nag_IgnoreTies} Nag_Ties;
typedef enum {Nag_ClassBoundaryUser=Nag_ClassBoundary_start, Nag_ClassBoundaryComp}
Nag_ClassBoundary;
typedef enum {Nag_RankScores=Nag_Scores_start, Nag_NormalScores, Nag_BlomScores,
Nag_TukeyScores, Nag_WaerdenScores, Nag_SavageScores}
Nag_Scores;
typedef enum { Nag_LeftDerivs=Nag_DerivType_start, Nag_RightDerivs} Nag_DerivType;
typedef enum { Nag_StartNotSet=Nag_Start_start  , Nag_Cold, Nag_Warm, Nag_Hot,
	       Nag_NewStart, Nag_ReStart, Nag_Continue } Nag_Start;
typedef enum {Nag_AboutMean=Nag_SumSquare_start, Nag_AboutZero} Nag_SumSquare;
typedef enum {Nag_ObservAdd=Nag_UpdateObserv_start, Nag_ObservDel} Nag_UpdateObserv;
typedef enum {Nag_Expo=Nag_Link_start, Nag_Iden, Nag_Log, Nag_Sqrt, Nag_Reci, 
	      Nag_Logistic, Nag_Probit, Nag_Compl } Nag_Link;
typedef enum {Nag_RegNotSet=Nag_RegType_start  , Nag_HuberReg, Nag_MallowsReg, Nag_SchweppeReg}
              Nag_RegType;
typedef enum {Nag_PsiNotSet=Nag_PsiFun_start  , Nag_Lsq, Nag_HuberFun, Nag_HampelFun, Nag_AndrewFun, 
              Nag_TukeyFun} Nag_PsiFun;
typedef enum {Nag_SigmaNotSet=Nag_SigmaEst_start  , Nag_SigmaRes, Nag_SigmaConst, Nag_SigmaChi}
              Nag_SigmaEst;
typedef enum {Nag_CovNotSet=Nag_CovMatrixEst_start  , Nag_CovMatAve, Nag_CovMatObs} Nag_CovMatrixEst;
typedef enum {Nag_Convolution=Nag_VectorOp_start, Nag_Correlation} Nag_VectorOp;/*used in c06ekc*/
typedef enum {Nag_ForwardTransform=Nag_TransformDirection_start, Nag_BackwardTransform
} Nag_TransformDirection;
typedef enum {Nag_TableStatsNObs=Nag_TableStats_start, Nag_TableStatsTotal,
	      Nag_TableStatsAv, Nag_TableStatsVar, Nag_TableStatsLarge,
	      Nag_TableStatsSmall} Nag_TableStats;

typedef enum {Nag_TableUpdateU=Nag_TableUpdate_start, Nag_TableUpdateI}
Nag_TableUpdate;

typedef enum {Nag_TabulateVarDiscr=Nag_TabulateVar_start, Nag_TabulateVarCont}
Nag_TabulateVar;
typedef enum {Nag_NoWeights=Nag_Weightstype_start, Nag_Weights, Nag_Weightsfreq, Nag_Weightsvar} Nag_Weightstype;





typedef enum {Nag_MatCorrelation=Nag_PrinCompMat_start, Nag_MatStandardised, Nag_MatSumSq,
		Nag_MatVarCovar} Nag_PrinCompMat;
typedef enum {Nag_ScoresStand=Nag_PrinCompScores_start, Nag_ScoresNotStand, Nag_ScoresUnitVar,
		Nag_ScoresEigenval} Nag_PrinCompScores;
typedef enum {Nag_RoLoadStand=Nag_RotationLoading_start, Nag_RoLoadNotStand} Nag_RotationLoading;
typedef enum {Nag_NoTransNorm=Nag_TransNorm_start, Nag_Orig, Nag_OrigCentroid, 
		Nag_Norm, Nag_OrigNorm, Nag_OrigNormCentroid}
Nag_TransNorm;
typedef enum {Nag_LsqScale=Nag_RotationScale_start, Nag_NotLsqScale} Nag_RotationScale;
typedef enum {Nag_DataCorr=Nag_FacMat_start, Nag_DataCovar, Nag_MatCorr_Covar} Nag_FacMat;
typedef enum {Nag_FacScoreRegsn=Nag_FacScoreMethod_start, Nag_FacScoreBart} Nag_FacScoreMethod;
typedef enum {Nag_FacRotate=Nag_FacRotation_start, Nag_FacNoRotate} Nag_FacRotation;
typedef enum {Nag_EqualCovar=Nag_GroupCovars_start, Nag_NotEqualCovar} Nag_GroupCovars;
typedef enum {Nag_SamplePoints=Nag_MahalDist_start, Nag_GroupMeans} Nag_MahalDist;
typedef enum {Nag_DiscrimEstimate=Nag_DiscrimMethod_start, Nag_DiscrimPredict} Nag_DiscrimMethod;
typedef enum {Nag_EqualPrior=Nag_PriorProbability_start, Nag_GroupSizePrior, Nag_UserPrior} Nag_PriorProbability;
typedef enum {Nag_MatUp=Nag_MatUpdate_start, Nag_NoMatUp} Nag_MatUpdate;
typedef enum {Nag_DistAbs=Nag_DistanceType_start, Nag_DistEuclid, Nag_DistSquared} Nag_DistanceType;
typedef enum {Nag_VarScaleStd=Nag_VarScaleType_start, Nag_VarScaleRange, Nag_VarScaleUser, Nag_NoVarScale} Nag_VarScaleType;


typedef enum {Nag_SingleLink=Nag_ClusterMethod_start, Nag_CompleteLink, Nag_GroupAverage,
	              Nag_Centroid, Nag_Median, Nag_MinVariance} Nag_ClusterMethod;

typedef enum {Nag_DendNorth=Nag_DendOrient_start, Nag_DendSouth,
                    Nag_DendEast, Nag_DendWest} Nag_DendOrient;

typedef enum {Nag_AllEigVals=Nag_Eigenvalues_start, Nag_LargeEigVals} Nag_Eigenvalues;

typedef enum {Nag_Stress=Nag_ScaleCriterion_start, Nag_SStress} Nag_ScaleCriterion;
typedef enum { Nag_ElementsIn=Nag_WhereElements_start, Nag_ElementsSeparate } Nag_WhereElements;
typedef enum { NoTranspose=MatrixTranspose_start, Transpose, ConjugateTranspose } MatrixTranspose;
typedef enum {Nag_Select_Modulus=Nag_Select_Eigenvalues_start, Nag_Select_RealPart} Nag_Select_Eigenvalues;
typedef enum { UpperTriangle=MatrixTriangle_start, LowerTriangle } MatrixTriangle;
typedef enum { UnitTriangular=MatrixUnitTriangular_start, NotUnitTriangular } MatrixUnitTriangular;
typedef enum { LeftSide=OperationSide_start, RightSide } OperationSide;
typedef enum { BottomPivot=PivotType_start, TopPivot, VariablePivot, FixedPivot } PivotType;
typedef enum { ForwardSequence=SequenceDirection_start, BackwardSequence } SequenceDirection;
typedef enum { OneNorm=NormType_start, FrobeniusNorm, MaxAbsValue, InfinityNorm} NormType;
typedef enum { General=MatrixType_start, UpperTriangular, LowerTriangular, SymmetricUpper,
	       SymmetricLower, HermitianUpper, HermitianLower } MatrixType;
typedef enum { Nag_LDLTX=Nag_SolveSystem_start, Nag_LDX, Nag_DLTX, Nag_LLTX, Nag_LX, Nag_LTX
} Nag_SolveSystem;

/* Following used by e01 functions*/    
typedef enum {Nag_RC=Nag_2d_Scat_Method_start, Nag_Shep} Nag_2d_Scat_Method;

/* Following used by g08 chapter */
typedef enum {Nag_IncSignZerosY=Nag_IncSignZeros_start, Nag_IncSignZerosN} Nag_IncSignZeros;
typedef enum {Nag_SingleCallR=Nag_CallTypes_start, Nag_FirstCallR, Nag_IntermediateCallR,
	      Nag_LastCallR} Nag_CallTypes;
typedef enum {Nag_CompProbExact=Nag_CompProb_start, Nag_CompProbApprox} Nag_CompProb;




typedef struct tagNag_Spline {
  LONG n;
  double *lamda;
  double *c;
  LONG init1;
  LONG init2;
} Nag_Spline;

typedef struct comm_struct {
LONG flag;   // user error flag set to 0 before each call to lsqfun, test
		   //for != 0 on exit 
Boolean first;  // TRUE on first call to objective (and constraint) function, FALSE after */
Boolean last;   // TRUE on last call to objective (and constraint) function, FALSE before */
LONG nf;     // output: number of function evaluations or number of times
		// residuals have been calculated. Calls to objective function 
Boolean it_prt; // Nag_Iteration print 
Boolean it_maj_prt; // Nag major iteration print (e04ucc) 
Boolean sol_sqp_prt;// Solution print (e04ucc)
Boolean sol_prt;// Solution print or, for e04ucc, major itn. sol. print 
Boolean rootnode_sol_prt; // Solution at rootnode of Branch & Bound 
Boolean node_prt; // Summary of node solution in B&B 
Boolean rootnode_prt;  // Summary of root node solution in B&B 
Boolean g_prt;  // Derivative check info. from e04ucy available 
Boolean new_lm; // New Lagrange multipliers calculated 

LONG needf;  // Added at Mark 6 to pass to the obj function in e04unc 

// User workspace pointers 
Pointer p;      // generic pointer to user workspace 
LONG *iuser; // user workspace 
double *user;   // user workspace 
 
// -- Members used internally -- 

// Nag workspace pointers 
double *nag_w;  // Nag workspace 
LONG *nag_iw;// Nag integer workspace 
Pointer nag_p;  // Nag generic workspace 

   // Following are specifically intended to provide workspace
   //   for a print function (e.g. to pass array of values, constructed 
   //   within the function, to user-defined print function).  The ptrs 
   //   should be used *only* to provide wkspace local to a print fun 
   //   & not to provide any kind of persistent data storage (nag_w, 
   //   nag_iw do not always follow this convention; hence the need 
   //   for the new members.)

double *nag_print_w;
LONG *nag_print_iw;
LONG nrealloc;  // Counter for reallocations in sparse optimizers 
} Nag_Comm;
typedef struct{
	LONG nx;
  double *lamda;
	LONG ny;
  double *mu; 
  double *c;
  LONG init1;
  LONG init2;
} Nag_2dSpline;

typedef struct{
	double re;
	double im;
	
} Nag_Complex;

/* Structures used by e01 functions */
typedef struct{
  LONG init1;  /* initialisation checks */
  LONG init2;
  LONG exit_status; /* set to magic number if non-fatal error during
			  set up */
  Nag_2d_Scat_Method method;
  LONG m;
  double  rnw;
  Boolean mem_set;
  double  *x;
  double  *y;
  double  *f;
  double  *fnodes;
  LONG *triang;
  double  *grads;
} Nag_Scat_Struct;

typedef struct{
  double  rnw;
  double  rnq;
  LONG nw;
  LONG nq;
  LONG minnq;
} Nag_E01_Opt;

#endif //!_O_NAG_TYPES_H


///////////////////////////////////
