/*------------------------------------------------------------------------------*
 * File Name: OC_types.h														*
 * Creation: CPY 6/5/2001														*
 * Purpose: Origin C typede struct for Origin internal functions				*
 * Copyright (c) OriginLab Corp.	2001										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * LY 6/25/01 Add Origin ODD file format description structure	
 * LAS, 1/31/03 commented out NLSFCntrl; C# using statement now supported: "using NLSF = LabTalk.NLSF" 
 * SY 04-25-2003 QA70-3985 SAVE_TO_SPC_FILE										*
 * JCG 06/06/03 QA70-4540 v7.0598 CENTROID_FOR_INTEGRATE						*
 *	DVT 7/9/03 QA70-4801 v7.0621 OC_GET_PAGE_SYSTEM_INFO						*
 *	CPY 8/27/03 QA70-5073 ADD_READ_ROWS_TO_ASCII_IMP_STRUCT						*
 * EJP 10-09-2003 v7.5715 QA70-5317 ADD_DATE_FORMAT_TO_ASCIMP_STRUCT			*
 *	CPY 10/23/03 v7.5729 QA70-5412	SKIP_CHARS_FOR_COL_NAME_LABEL				*
 *------------------------------------------------------------------------------*/
#ifndef _OC_TYPES_H
#define _OC_TYPES_H

#include "oc_const.h"

typedef struct tagBasicStats
{
	double	min;
	double	max;
	double	mean;
	double	sd;
	double	total; // the cumulative sum of all the values
	double	ssdm; // sum of squares of diff from mean
	int		N;	  // number of good values in the dataset
	int		Missing; // number of missing values in the dataset
	int		iMax;	 // index (0 offset) of the max value
	int		iMin;	 // index of the min value
} BasicStats;

/// JCG 06/06/03 QA70-4540 v7.0598 CENTROID_FOR_INTEGRATE
#if _OC_VER > 0x0703
	#define _INTEG_ADD_CENTROID
#endif

#ifdef _INTEG_ADD_CENTROID

typedef struct tagIntegrationResult
{
	int		i1, i2;	 // index range of integration
	double	x1, x2;	 // corresponding x range of integration
	double	xPeak, yPeak; // x y of peak position
	double	dxPeak, dyPeak; // peak width at half height and peak height from base
	double	Area;
	double	yPeakBase; // is zero if integrate from base line, otherwise the base line y at peak position
	int		idx1, idx2; // the index for halfwidth calculation that give rise to dxPeak
	int		iPeak;		// the index of the peak position

	double  xCentroid; 		
	double  yCentroid; 		

} IntegrationResult;
	
#else 

typedef struct tagIntegrationResult
{
	int		i1, i2;	 // index range of integration
	double	x1, x2;	 // corresponding x range of integration
	double	xPeak, yPeak; // x y of peak position
	double	dxPeak, dyPeak; // peak width at half height and peak height from base
	double	Area;
	double	yPeakBase; // is zero if integrate from base line, otherwise the base line y at peak position
	int		idx1, idx2; // the index for halfwidth calculation that give rise to dxPeak
	int		iPeak;		// the index of the peak position
} IntegrationResult;

#endif //#if _OC_VER > 0x0703
/// end CENTROID_FOR_INTEGRATE

//------- LY 6/25/01 DAQ data file description header struct
// basic structures from MS Win32
#ifndef _WINBASE_	// structures may be used both in OriginC and in Win32 environment
typedef struct _SYSTEMTIME {
    WORD wYear;
    WORD wMonth;
    WORD wDayOfWeek;
    WORD wDay;
    WORD wHour;
    WORD wMinute;
    WORD wSecond;
    WORD wMilliseconds;
} SYSTEMTIME;
#endif //_WINBASE_

#define MAX_ODAQ_COMMENT_LEN	256

typedef struct tagDAQDataHeader {
	double		dCalibrationFactor;	// calibrate factor from the device
	double		dDAQRate;			// DAQ rate, in Hz
	USHORT		usNumOfChannels;	// Number of channels
	USHORT		usDataBlockSize;	// data block size of each channel
	USHORT		usAveragePoints;	// Averaging points during daq, = 0 or 1 if no averaging
	USHORT		usDummy1;			//fill in the empty space
	DWORD		usDeviceID;			// DAQ device identification information
	DWORD		dwDummy2;			//fill in the empty space
	SYSTEMTIME	StartTime;			// Time of 1st data point
	char		szOperator[MAX_ODAQ_COMMENT_LEN];	// text string, application specific
	char		szDescription[MAX_ODAQ_COMMENT_LEN];// text string, application specific
	char		szComments[MAX_ODAQ_COMMENT_LEN]; 	// text string, application specific
} ODAQDataHeader;
//------- 6/25/01

#define ASCIMP_DELIM_UNKNOWN		0
#define ASCIMP_DELIM_COMMA			1
#define ASCIMP_DELIM_TAB			2
#define ASCIMP_DELIM_SPACE			3
#define ASCIMP_DELIM_OTHER			4

#define ASCIMP_MODE_REPLACE_DATA		0
#define ASCIMP_MODE_APPEND_COLS			1
#define ASCIMP_MODE_APPEND_ROWS			2
#define ASCIMP_MODE_DUPLICATE			3
#define IS_IMPORT_MODE(i) (ASCIMP_MODE_REPLACE_DATA <= (i) && (i) <= ASCIMP_MODE_DUPLICATE)

#define ASCIMP_DELIMITED_DELIM		1
#define	ASCIMP_DELIMITED_FIXED		0

#define ASCIMP_PARTIAL_YES			1
#define ASCIMP_PARTIAL_NO			0


// const for AscImpListCtrlMsg 
enum {
	AIC_LISTCTRL_SETNUMCOLS = 1,
	AIC_LISTCTRL_SETCELL,
	AIC_LISTCTRL_DELROW,
	AIC_LISTCTRL_INSROW,
	AIC_LISTCTRL_SET_GET_COL_TYPE
};

//#define MAX_COLUMN_WIDTH	256
#define MAX_FIXED_COL_WIDTH 256

//int AscImpReadFileStruct(LPCSTR lpcszFilename, ASCIMP* pASCIMPstruct, DWORD dwCntrl=0);
// dwCntrl 
#define AIRF_USE_ASCIMP 0x0001 // if not specified, pASCIMPstruct will be only as output

typedef struct tagASCIMP{
	int iDelimited; // 1 if delimited, 0 if Fixed format, szFixedWidth must be filled if iDelimited==0
	int iDelimiter; // used only if iDelimited==1, one of the ASCIMP_DELIM_TAB, ASCIMP_DELIM_COMMA etc
	char cChar;	// used only if iDelimited==1 && iDelimiter==ASCIMP_DELIM_OTHER, char to be used as delimiter
	char szFixedWidth[MAX_FIXED_COL_WIDTH];// for iDelimited==0, comma separated string for each col width
	int iHeaderLines; //file header, before those header that can be used as column headings
	int iSubHeaderLines;//subheader block, after iHeaderLines, the number of lines to be used in column labels and names
	int iAutoSubHeaderLines; //=1 ignore iSubHeaderLines, auto determine, =0 to use iSubHeaderLines
	int iAutoColTypes;//to change column type according to detection, 0=diable, 1=use detection, 2=detect but not to change if text column
	int iTestLines;	// Number of lines used for structure testing that must be consistent
	int iMode;//ASCIMP_MODE_REPLACE_DATA, ASCIMP_MODE_APPEND_COLS etc
	int iNumColumns;//num cols found from auto detection
	int iPartial; // =1 to specify partial import, =0 if whole file imported, ignore iPartialC1, iPartialC2, iPartialR1, R2
	int	iPartialC1;
	int iPartialC2;
	int iPartialR1;
	int iPartialR2;
	int iRenameWks; //=1 to rename worksheet, =0 to keep current name
	int iApplyRange;// not used anymore,
	int iRenameCols;//=0 to keep column names, =1 to rename columns using 1st line above detected data, =2 use 2nd line etc
	int iLabels;//=0 to keep current column labels, =1,2 etc as 1st, 2nd line from top of sub header block to rename labels
	int iMaxLabels;//number of lines in subheader block to be used in column label rename
	int iLeadingZeroes;//=1 to consider 0123 as numbers, =0 if 0123 is considered as text
	int iNonnumeric; // this has to do with what to do when none-numeric is found in numeric column 
	int	iMaxTestLines;	// related to iTestLines, scan upto this number of lines for consistent structure
	int	iSkipRows; //allow skip rows, =0 if no skipping of rows
	int iReadRows; // used only if iSkipRows > 0, and must not be 0. import will read iReadRows, then skip iSkipRows, then read iReadRows again
	char szDateFormat[MAX_SIZE_CUSTOM_FORMAT]; /// EJP 10-09-2003 v7.5715 QA70-5317 ADD_DATE_FORMAT_TO_ASCIMP_STRUCT
	int iLabelSkipChars; ////CPY 10/23/03 v7.5729 QA70-5412	SKIP_CHARS_FOR_COL_NAME_LABEL
} ASCIMP;

//CPY 5/6/03, rename to be iRenameWKS to iRenameWks to be more consistent with other codes, case did not matter in Origin 7 for struct members
//CPY 8/27/03 QA70-5073 ADD_READ_ROWS_TO_ASCII_IMP_STRUCT, added iReadRows and also swap iMaxTestLines with iSkipRows so iSkipRows and iReadRows are next to each other

//typedef struct tagNLSFCntrl {
//	
//	char 	szYdataName[NAME_SIZE]; 		// nlsf.fitData$
//	char 	szFuncName[NLSF_FUNCTION_NAME_SIZE]; // nlsf.func$
//	char 	szWtDataName[NAME_SIZE]; 		// nlsf.w$
	//char	szFuncXDataName[MAX_NAME_SIZE];	// nlsf.funcX$
	//char	szFuncYDataName[MAX_NAME_SIZE];	// nlsf.funcCol$
//	double 	ChisqDoF; 						// nlsf.chiSqr
//	double 	SSR; 							// nlsf.ssr
//	double 	Correlation; 					// nlsf.cor
//	double 	COD; 							// nlsf.cod
//	double 	MuFinal; 						// nlsf.muMin
//	double 	Mu; 							// nlsf.mu
//	double 	DerivStep; 						// nlsf.derivStep
//	double 	Tolerance; 						// nlsf.tolerance
//	double 	Confidence; 					// nlsf.conf
//	double 	Prediction; 					// nlsf.pred
//	int		inPara;							// nlsf.nPara	
//	int    	inParaVary; 					// nlsf.nParaVary
//	int    	imaxIter; 						// nlsf.maxIter
//	int    	idataBegin; 					// nlsf.dataBegin
//	int    	idataEnd; 						// nlsf.dataEnd
//	int    	idataStep; 						// nlsf.dataStep
//	int    	inPoints; 						// nlsf.nPoints		
//	//int		ixBegin;						// nlsf.xBegin
	//int		ixEnd;							// nlsf.xEnd;
	//int		ixPoints						// nlsf.xPoints;
//	int    	iDOF; 							// nlsf.dof
//	int    	inConstr; 						// nlsf.nConstr
//	int    	inConstrEff; 					// nlsf.nConstrEff
//	int		iwType; 						// nlsf.wType 0=none, 1=inst, 2=stat, 3=arb, 4=direct
//	double 	Par[NLSF_MAX_PARAM]; 			// nlsf.Pn or nlsf.Vn
//	double 	Err[NLSF_MAX_PARAM]; 			// nlsf.En
//	double 	ConfIntv[NLSF_MAX_PARAM]; 		// nlsf.Cn
//	double 	Dep[NLSF_MAX_PARAM]; 			// nlsf.Dn
//	BOOL	openGraph;						// doesn't need an associated nlsf object property/method
//	BOOL 	createCurve; 					// use nlsf.end(13) for false and nlsf.end(12) for true
//	BOOL 	confBands; 						// use nlsf.createCurves(C) when true
//	BOOL 	predBands; 						// use nlsf.createCurves(P) when true
//	BOOL 	createWks; 						// use nlsf.paramWKS(wksName); when true
//	BOOL 	pasteToPlot; 					// use nlsf.pasteParams(plot); when true
//	BOOL 	pasteToResults; 				// use nlsf.pasteParams(results); when true
//	//BOOL 	sameXasData;					// nlsf.xmode=0 for true(sameX) or nlsf.xmode=4 for false(uniformX)
	
//} NLSFCntrl;  // NLSFControl is reserved already for internal use


//LY 1/28/02 QA70-460 ORIGIN_C_SPC_INFO_ACCESS
// OSPCMAINHEADER and OSPCSUBHEADER mostly are copy from SPCHDR and SUBHDR in SPC.h
// at here just save the field can be accessed by gspciolib.dll function

typedef struct OSPCMAINHEADER {
	/// SY 04-25-2003 QA70-3985 SAVE_TO_SPC_FILE
	BYTE		ftflgs;		 //	Used to save spcFileType: spcFileTypeEven = 0, spcFileTypeXYY = 1, spcFileTypeXYXY = 2
							 // This is needed for creating SPC file.
	/// end SAVE_TO_SPC_FILE
    BYTE		fexper;      // Instrument technique code 
    DWORD		fnpts;       // Integer number of points 
    double		ffirst;      // Floating X coordinate of first point 
    double		flast;       // Floating X coordinate of last point 
    DWORD		fnsub;       // Integer number of subfiles (1 if not TMULTI) 
    BYTE		fxtype;      // Type of X axis units 
    BYTE		fytype;      // Type of Y axis units
    BYTE		fztype;      // Type of Z axis units 
    SYSTEMTIME  fdate;       // Date/Time 
    char		fres[9];     // Resolution description text (null terminated)
    char		fsource[9];  // Source instrument description text (null terminated) 
    WORD		fpeakpt;     // Peak point number for interferograms (0=not known) 
    float		fspare[8];   // Used for Array Basic storage 
    char		fcmnt[130];  // Null terminated comment ASCII text string 
    char		fcatxt[30];  // X axis label strings 
    char		fcatyt[30];  // Y axis label strings 
    char		fcatzt[30];  // Z axis label strings 
    DWORD		fmods;       // File Modification Flags (see below: 1=A,2=B,4=C,8=D..) 
    char		fmethod[48]; // Method/program/data filename w/extensions comma list 
    float		fzinc;       // Z subfile increment (0 = use 1st subnext-subfirst) 
    DWORD		fwplanes;    // Number of planes for 4D with W dimension (0=normal) 
    float		fwinc;       // W plane increment (only if fwplanes is not 0) 
    BYTE		fwtype;      // Type of W axis units (see definitions below) 
}OSPCMAINHeader;

typedef struct OSPCSUBHEADER {
    WORD		subindex;      // Integer index number of trace subfile (0=first)
	char		colname[NAME_SIZE];	// this field tell the subfile saved in which column, this is our info, not spc data file.
	float		fZstart;
	float		fZend;
    DWORD		subnpts;      // Integer number of subfile points for TXYXYS type
    DWORD		subscan;      // Integer number of co-added scans or 0 (for collect)
    float		subwlevel;    // Floating W axis value (if fwplanes non-zero)
}OSPCSUBHeader;  
//end QA70-460 ORIGIN_C_SPC_INFO_ACCESS

///	DVT 7/9/03 QA70-4801 v7.0621 OC_GET_PAGE_SYSTEM_INFO
typedef struct tagPageSystemInfo
{
	double dCreated;
	double dModified;
	int nSize;
	int nDependents;
} PageSystemInfo;
///	end OC_GET_PAGE_SYSTEM_INFO

#endif // _OC_TYPES_H
